"""
Distribution protocol constants.

Based on Erlang/OTP distribution specification.
"""

# EPMD (Erlang Port Mapper Daemon) protocol
EPMD_PORT = 4369
EPMD_ALIVE2_REQ = 120
EPMD_ALIVE2_RESP = 121
EPMD_PORT2_REQ = 122
EPMD_PORT2_RESP = 119

DISTRIBUTION_VERSION = 5

# Distribution flags (from OTP dist.hrl)
DFLAG_PUBLISHED = 0x01
DFLAG_ATOM_CACHE = 0x02
DFLAG_EXTENDED_REFERENCES = 0x04
DFLAG_DIST_MONITOR = 0x08
DFLAG_FUN_TAGS = 0x10
DFLAG_DIST_MONITOR_NAME = 0x20
DFLAG_HIDDEN_ATOM_CACHE = 0x40
DFLAG_NEW_FUN_TAGS = 0x80
DFLAG_EXTENDED_PIDS_PORTS = 0x100
DFLAG_EXPORT_PTR_TAG = 0x200
DFLAG_BIT_BINARIES = 0x400
DFLAG_NEW_FLOATS = 0x800
DFLAG_UNICODE_IO = 0x1000
DFLAG_DIST_HDR_ATOM_CACHE = 0x2000
DFLAG_SMALL_ATOM_TAGS = 0x4000
DFLAG_UTF8_ATOMS = 0x10000
DFLAG_MAP_TAG = 0x20000
DFLAG_BIG_CREATION = 0x40000
DFLAG_SEND_SENDER = 0x80000
DFLAG_BIG_SEQTRACE_LABELS = 0x100000
DFLAG_EXIT_PAYLOAD = 0x400000
DFLAG_FRAGMENTS = 0x800000
DFLAG_HANDSHAKE_23 = 0x1000000
DFLAG_UNLINK_ID = 0x2000000
DFLAG_MANDATORY_25_DIGEST = 0x4000000

# Flags above bit 32 (new in OTP 23+)
DFLAG_SPAWN = 0x100000000        # (1 << 32)
DFLAG_NAME_ME = 0x200000000      # (2 << 32)
DFLAG_V4_NC = 0x400000000        # (4 << 32) - Bit 34, mandatory in OTP 26+
DFLAG_ALIAS = 0x800000000        # (8 << 32)

# Required flags for modern Erlang/OTP 27
# Based on DFLAG_DIST_MANDATORY from OTP source
DEFAULT_FLAGS = (
    # OTP 25 mandatory flags
    DFLAG_EXTENDED_REFERENCES |
    DFLAG_FUN_TAGS |
    DFLAG_EXTENDED_PIDS_PORTS |
    DFLAG_UTF8_ATOMS |
    DFLAG_NEW_FUN_TAGS |
    DFLAG_BIG_CREATION |
    DFLAG_NEW_FLOATS |
    DFLAG_MAP_TAG |
    DFLAG_EXPORT_PTR_TAG |
    DFLAG_BIT_BINARIES |
    DFLAG_HANDSHAKE_23 |
    # OTP 26 mandatory flags
    DFLAG_V4_NC |              # Bit 34: 0x400000000 - mandatory in OTP 26+
    DFLAG_UNLINK_ID |
    # Additional recommended flags
    DFLAG_DIST_HDR_ATOM_CACHE |
    DFLAG_SMALL_ATOM_TAGS |
    DFLAG_FRAGMENTS |
    DFLAG_EXIT_PAYLOAD
)

# Control message types
CTRL_LINK = 1
CTRL_SEND = 2
CTRL_EXIT = 3
CTRL_UNLINK = 4
CTRL_REG_SEND = 6
CTRL_GROUP_LEADER = 7
CTRL_EXIT2 = 8
CTRL_SEND_TT = 12
CTRL_EXIT_TT = 13
CTRL_REG_SEND_TT = 16
CTRL_MONITOR_P = 19
CTRL_DEMONITOR_P = 20
CTRL_MONITOR_P_EXIT = 21