# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_workflow_event_request import CreateWorkflowEventRequest
from ...types.event_create_response import EventCreateResponse
from .raw_client import AsyncRawEventsClient, RawEventsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EventsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEventsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawEventsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEventsClient
        """
        return self._raw_client

    def create(
        self, *, request: CreateWorkflowEventRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> EventCreateResponse:
        """
        Accept an event or list of events and publish them to ClickHouse for analytics processing.

        Parameters
        ----------
        request : CreateWorkflowEventRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventCreateResponse


        Examples
        --------
        import datetime

        from vellum import (
            NodeExecutionInitiatedBody,
            NodeExecutionInitiatedEvent,
            Vellum,
            VellumCodeResourceDefinition,
        )

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.events.create(
            request=[
                NodeExecutionInitiatedEvent(
                    body=NodeExecutionInitiatedBody(
                        node_definition=VellumCodeResourceDefinition(
                            name="name",
                            module=["module", "module"],
                            id="id",
                        ),
                        inputs={"inputs": {"key": "value"}},
                    ),
                    id="id",
                    timestamp=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    trace_id="trace_id",
                    span_id="span_id",
                ),
                NodeExecutionInitiatedEvent(
                    body=NodeExecutionInitiatedBody(
                        node_definition=VellumCodeResourceDefinition(
                            name="name",
                            module=["module", "module"],
                            id="id",
                        ),
                        inputs={"inputs": {"key": "value"}},
                    ),
                    id="id",
                    timestamp=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    trace_id="trace_id",
                    span_id="span_id",
                ),
            ],
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data


class AsyncEventsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEventsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEventsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEventsClient
        """
        return self._raw_client

    async def create(
        self, *, request: CreateWorkflowEventRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> EventCreateResponse:
        """
        Accept an event or list of events and publish them to ClickHouse for analytics processing.

        Parameters
        ----------
        request : CreateWorkflowEventRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventCreateResponse


        Examples
        --------
        import asyncio
        import datetime

        from vellum import (
            AsyncVellum,
            NodeExecutionInitiatedBody,
            NodeExecutionInitiatedEvent,
            VellumCodeResourceDefinition,
        )

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.events.create(
                request=[
                    NodeExecutionInitiatedEvent(
                        body=NodeExecutionInitiatedBody(
                            node_definition=VellumCodeResourceDefinition(
                                name="name",
                                module=["module", "module"],
                                id="id",
                            ),
                            inputs={"inputs": {"key": "value"}},
                        ),
                        id="id",
                        timestamp=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        trace_id="trace_id",
                        span_id="span_id",
                    ),
                    NodeExecutionInitiatedEvent(
                        body=NodeExecutionInitiatedBody(
                            node_definition=VellumCodeResourceDefinition(
                                name="name",
                                module=["module", "module"],
                                id="id",
                            ),
                            inputs={"inputs": {"key": "value"}},
                        ),
                        id="id",
                        timestamp=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        trace_id="trace_id",
                        span_id="span_id",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data
