# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.paginated_slim_integration_auth_config_read_list import PaginatedSlimIntegrationAuthConfigReadList
from .raw_client import AsyncRawIntegrationAuthConfigsClient, RawIntegrationAuthConfigsClient


class IntegrationAuthConfigsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIntegrationAuthConfigsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawIntegrationAuthConfigsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIntegrationAuthConfigsClient
        """
        return self._raw_client

    def list_integration_auth_configs(
        self,
        *,
        expand: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        integration_name: typing.Optional[str] = None,
        integration_provider: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimIntegrationAuthConfigReadList:
        """
        List Integration Auth Configs

        Parameters
        ----------
        expand : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The response fields to expand for more information.
            - 'integration_credentials' expands the list of integration credentials that the authenticated entity has access to for the auth config.

        integration_name : typing.Optional[str]

        integration_provider : typing.Optional[str]

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        search : typing.Optional[str]
            A search term.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimIntegrationAuthConfigReadList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.integration_auth_configs.list_integration_auth_configs()
        """
        _response = self._raw_client.list_integration_auth_configs(
            expand=expand,
            integration_name=integration_name,
            integration_provider=integration_provider,
            limit=limit,
            offset=offset,
            ordering=ordering,
            search=search,
            request_options=request_options,
        )
        return _response.data


class AsyncIntegrationAuthConfigsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIntegrationAuthConfigsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIntegrationAuthConfigsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIntegrationAuthConfigsClient
        """
        return self._raw_client

    async def list_integration_auth_configs(
        self,
        *,
        expand: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        integration_name: typing.Optional[str] = None,
        integration_provider: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimIntegrationAuthConfigReadList:
        """
        List Integration Auth Configs

        Parameters
        ----------
        expand : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The response fields to expand for more information.
            - 'integration_credentials' expands the list of integration credentials that the authenticated entity has access to for the auth config.

        integration_name : typing.Optional[str]

        integration_provider : typing.Optional[str]

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        search : typing.Optional[str]
            A search term.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimIntegrationAuthConfigReadList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.integration_auth_configs.list_integration_auth_configs()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_integration_auth_configs(
            expand=expand,
            integration_name=integration_name,
            integration_provider=integration_provider,
            limit=limit,
            offset=offset,
            ordering=ordering,
            search=search,
            request_options=request_options,
        )
        return _response.data
