# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.paginated_slim_workflow_deployment_list import PaginatedSlimWorkflowDeploymentList
from ...types.paginated_workflow_deployment_release_list import PaginatedWorkflowDeploymentReleaseList
from ...types.paginated_workflow_release_tag_read_list import PaginatedWorkflowReleaseTagReadList
from ...types.workflow_deployment_event_executions_response import WorkflowDeploymentEventExecutionsResponse
from ...types.workflow_deployment_history_item import WorkflowDeploymentHistoryItem
from ...types.workflow_deployment_read import WorkflowDeploymentRead
from ...types.workflow_deployment_release import WorkflowDeploymentRelease
from ...types.workflow_event_execution_read import WorkflowEventExecutionRead
from ...types.workflow_release_tag_read import WorkflowReleaseTagRead
from .raw_client import AsyncRawWorkflowDeploymentsClient, RawWorkflowDeploymentsClient
from .types.list_workflow_release_tags_request_source import ListWorkflowReleaseTagsRequestSource
from .types.workflow_deployments_list_request_status import WorkflowDeploymentsListRequestStatus

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowDeploymentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowDeploymentsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawWorkflowDeploymentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowDeploymentsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        status: typing.Optional[WorkflowDeploymentsListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimWorkflowDeploymentList:
        """
        Used to list all Workflow Deployments.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        status : typing.Optional[WorkflowDeploymentsListRequestStatus]
            status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimWorkflowDeploymentList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.list()
        """
        _response = self._raw_client.list(
            limit=limit, offset=offset, ordering=ordering, status=status, request_options=request_options
        )
        return _response.data

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> WorkflowDeploymentRead:
        """
        Used to retrieve a workflow deployment given its ID or name.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    def list_workflow_deployment_event_executions(
        self,
        id: str,
        *,
        filters: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowDeploymentEventExecutionsResponse:
        """
        Parameters
        ----------
        id : str

        filters : typing.Optional[str]

        limit : typing.Optional[int]
            Number of executions to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the executions.

        ordering : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentEventExecutionsResponse


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.list_workflow_deployment_event_executions(
            id="id",
        )
        """
        _response = self._raw_client.list_workflow_deployment_event_executions(
            id, filters=filters, limit=limit, offset=offset, ordering=ordering, request_options=request_options
        )
        return _response.data

    def workflow_deployment_event_execution(
        self, execution_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowEventExecutionRead:
        """
        Parameters
        ----------
        execution_id : str

        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowEventExecutionRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.workflow_deployment_event_execution(
            execution_id="execution_id",
            id="id",
        )
        """
        _response = self._raw_client.workflow_deployment_event_execution(
            execution_id, id, request_options=request_options
        )
        return _response.data

    def workflow_deployment_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowDeploymentHistoryItem:
        """
        DEPRECATED: This endpoint is deprecated and will be removed in a future release. Please use the
        `retrieve_workflow_deployment_release` endpoint instead.

        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Workflow Deployment History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Workflow Deployment History Item you'd like to retrieve.

        id : str
            Either the Workflow Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentHistoryItem


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.workflow_deployment_history_item_retrieve(
            history_id_or_release_tag="history_id_or_release_tag",
            id="id",
        )
        """
        _response = self._raw_client.workflow_deployment_history_item_retrieve(
            history_id_or_release_tag, id, request_options=request_options
        )
        return _response.data

    def list_workflow_release_tags(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        source: typing.Optional[ListWorkflowReleaseTagsRequestSource] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedWorkflowReleaseTagReadList:
        """
        List Release Tags associated with the specified Workflow Deployment

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        source : typing.Optional[ListWorkflowReleaseTagsRequestSource]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedWorkflowReleaseTagReadList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.list_workflow_release_tags(
            id="id",
        )
        """
        _response = self._raw_client.list_workflow_release_tags(
            id, limit=limit, offset=offset, ordering=ordering, source=source, request_options=request_options
        )
        return _response.data

    def retrieve_workflow_release_tag(
        self, id: str, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowReleaseTagRead:
        """
        Retrieve a Workflow Release Tag by tag name, associated with a specified Workflow Deployment.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Workflow Deployment that you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowReleaseTagRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.retrieve_workflow_release_tag(
            id="id",
            name="name",
        )
        """
        _response = self._raw_client.retrieve_workflow_release_tag(id, name, request_options=request_options)
        return _response.data

    def update_workflow_release_tag(
        self,
        id: str,
        name: str,
        *,
        history_item_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowReleaseTagRead:
        """
        Updates an existing Release Tag associated with the specified Workflow Deployment.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Workflow Deployment that you'd like to update.

        history_item_id : typing.Optional[str]
            The ID of the Workflow Deployment History Item to tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowReleaseTagRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.update_workflow_release_tag(
            id="id",
            name="name",
        )
        """
        _response = self._raw_client.update_workflow_release_tag(
            id, name, history_item_id=history_item_id, request_options=request_options
        )
        return _response.data

    def list_workflow_deployment_releases(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedWorkflowDeploymentReleaseList:
        """
        List the Releases of the specified Workflow Deployment for the current Environment.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedWorkflowDeploymentReleaseList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.list_workflow_deployment_releases(
            id="id",
        )
        """
        _response = self._raw_client.list_workflow_deployment_releases(
            id, limit=limit, offset=offset, ordering=ordering, request_options=request_options
        )
        return _response.data

    def retrieve_workflow_deployment_release(
        self, id: str, release_id_or_release_tag: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowDeploymentRelease:
        """
        Retrieve a specific Workflow Deployment Release by either its UUID or the name of a Release Tag that points to it.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        release_id_or_release_tag : str
            Either the UUID of Workflow Deployment Release you'd like to retrieve, or the name of a Release Tag that's pointing to the Workflow Deployment Release you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentRelease


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_deployments.retrieve_workflow_deployment_release(
            id="id",
            release_id_or_release_tag="release_id_or_release_tag",
        )
        """
        _response = self._raw_client.retrieve_workflow_deployment_release(
            id, release_id_or_release_tag, request_options=request_options
        )
        return _response.data


class AsyncWorkflowDeploymentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowDeploymentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowDeploymentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowDeploymentsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        status: typing.Optional[WorkflowDeploymentsListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimWorkflowDeploymentList:
        """
        Used to list all Workflow Deployments.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        status : typing.Optional[WorkflowDeploymentsListRequestStatus]
            status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimWorkflowDeploymentList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            limit=limit, offset=offset, ordering=ordering, status=status, request_options=request_options
        )
        return _response.data

    async def retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowDeploymentRead:
        """
        Used to retrieve a workflow deployment given its ID or name.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    async def list_workflow_deployment_event_executions(
        self,
        id: str,
        *,
        filters: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowDeploymentEventExecutionsResponse:
        """
        Parameters
        ----------
        id : str

        filters : typing.Optional[str]

        limit : typing.Optional[int]
            Number of executions to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the executions.

        ordering : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentEventExecutionsResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.list_workflow_deployment_event_executions(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_workflow_deployment_event_executions(
            id, filters=filters, limit=limit, offset=offset, ordering=ordering, request_options=request_options
        )
        return _response.data

    async def workflow_deployment_event_execution(
        self, execution_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowEventExecutionRead:
        """
        Parameters
        ----------
        execution_id : str

        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowEventExecutionRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.workflow_deployment_event_execution(
                execution_id="execution_id",
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.workflow_deployment_event_execution(
            execution_id, id, request_options=request_options
        )
        return _response.data

    async def workflow_deployment_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowDeploymentHistoryItem:
        """
        DEPRECATED: This endpoint is deprecated and will be removed in a future release. Please use the
        `retrieve_workflow_deployment_release` endpoint instead.

        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Workflow Deployment History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Workflow Deployment History Item you'd like to retrieve.

        id : str
            Either the Workflow Deployment's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentHistoryItem


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.workflow_deployment_history_item_retrieve(
                history_id_or_release_tag="history_id_or_release_tag",
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.workflow_deployment_history_item_retrieve(
            history_id_or_release_tag, id, request_options=request_options
        )
        return _response.data

    async def list_workflow_release_tags(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        source: typing.Optional[ListWorkflowReleaseTagsRequestSource] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedWorkflowReleaseTagReadList:
        """
        List Release Tags associated with the specified Workflow Deployment

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        source : typing.Optional[ListWorkflowReleaseTagsRequestSource]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedWorkflowReleaseTagReadList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.list_workflow_release_tags(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_workflow_release_tags(
            id, limit=limit, offset=offset, ordering=ordering, source=source, request_options=request_options
        )
        return _response.data

    async def retrieve_workflow_release_tag(
        self, id: str, name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowReleaseTagRead:
        """
        Retrieve a Workflow Release Tag by tag name, associated with a specified Workflow Deployment.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Workflow Deployment that you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowReleaseTagRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.retrieve_workflow_release_tag(
                id="id",
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_workflow_release_tag(id, name, request_options=request_options)
        return _response.data

    async def update_workflow_release_tag(
        self,
        id: str,
        name: str,
        *,
        history_item_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowReleaseTagRead:
        """
        Updates an existing Release Tag associated with the specified Workflow Deployment.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        name : str
            The name of the Release Tag associated with this Workflow Deployment that you'd like to update.

        history_item_id : typing.Optional[str]
            The ID of the Workflow Deployment History Item to tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowReleaseTagRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.update_workflow_release_tag(
                id="id",
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_workflow_release_tag(
            id, name, history_item_id=history_item_id, request_options=request_options
        )
        return _response.data

    async def list_workflow_deployment_releases(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedWorkflowDeploymentReleaseList:
        """
        List the Releases of the specified Workflow Deployment for the current Environment.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedWorkflowDeploymentReleaseList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.list_workflow_deployment_releases(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_workflow_deployment_releases(
            id, limit=limit, offset=offset, ordering=ordering, request_options=request_options
        )
        return _response.data

    async def retrieve_workflow_deployment_release(
        self, id: str, release_id_or_release_tag: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowDeploymentRelease:
        """
        Retrieve a specific Workflow Deployment Release by either its UUID or the name of a Release Tag that points to it.

        Parameters
        ----------
        id : str
            Either the Workflow Deployment's ID or its unique name

        release_id_or_release_tag : str
            Either the UUID of Workflow Deployment Release you'd like to retrieve, or the name of a Release Tag that's pointing to the Workflow Deployment Release you'd like to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowDeploymentRelease


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_deployments.retrieve_workflow_deployment_release(
                id="id",
                release_id_or_release_tag="release_id_or_release_tag",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_workflow_deployment_release(
            id, release_id_or_release_tag, request_options=request_options
        )
        return _response.data
