# This file was auto-generated by Fern from our API Definition.

import typing

from ... import core
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.dataset_row_push_request import DatasetRowPushRequest
from ...types.workflow_push_deployment_config_request import WorkflowPushDeploymentConfigRequest
from ...types.workflow_push_exec_config import WorkflowPushExecConfig
from ...types.workflow_push_response import WorkflowPushResponse
from ...types.workflow_resolved_state import WorkflowResolvedState
from .raw_client import AsyncRawWorkflowsClient, RawWorkflowsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawWorkflowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowsClient
        """
        return self._raw_client

    def pull(
        self,
        id: str,
        *,
        exclude_code: typing.Optional[bool] = None,
        exclude_display: typing.Optional[bool] = None,
        include_json: typing.Optional[bool] = None,
        include_sandbox: typing.Optional[bool] = None,
        release_tag: typing.Optional[str] = None,
        strict: typing.Optional[bool] = None,
        version: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Parameters
        ----------
        id : str
            The ID of the Workflow to pull from

        exclude_code : typing.Optional[bool]

        exclude_display : typing.Optional[bool]

        include_json : typing.Optional[bool]

        include_sandbox : typing.Optional[bool]

        release_tag : typing.Optional[str]
            Release tag to use when pulling from deployment (implies deployment-only lookup)

        strict : typing.Optional[bool]

        version : typing.Optional[str]
            Semantic version range to validate against the Workflow SDK version (e.g., '>=1.0.0,<1.2.3')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]

        """
        with self._raw_client.pull(
            id,
            exclude_code=exclude_code,
            exclude_display=exclude_display,
            include_json=include_json,
            include_sandbox=include_sandbox,
            release_tag=release_tag,
            strict=strict,
            version=version,
            request_options=request_options,
        ) as r:
            yield from r.data

    def retrieve_state(
        self, span_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowResolvedState:
        """
        Retrieve the current state of a workflow execution.

        **Note:** Uses a base url of `https://predict.vellum.ai`.

        Parameters
        ----------
        span_id : str
            The span ID of the workflow execution to retrieve state for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResolvedState


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflows.retrieve_state(
            span_id="span_id",
        )
        """
        _response = self._raw_client.retrieve_state(span_id, request_options=request_options)
        return _response.data

    def push(
        self,
        *,
        exec_config: WorkflowPushExecConfig,
        workflow_sandbox_id: typing.Optional[str] = OMIT,
        deployment_config: typing.Optional[WorkflowPushDeploymentConfigRequest] = OMIT,
        artifact: typing.Optional[core.File] = OMIT,
        dataset: typing.Optional[typing.List[DatasetRowPushRequest]] = OMIT,
        dry_run: typing.Optional[bool] = OMIT,
        strict: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowPushResponse:
        """
        Parameters
        ----------
        exec_config : WorkflowPushExecConfig
            The execution configuration of the workflow.

        workflow_sandbox_id : typing.Optional[str]

        deployment_config : typing.Optional[WorkflowPushDeploymentConfigRequest]

        artifact : typing.Optional[core.File]
            See core.File for more documentation

        dataset : typing.Optional[typing.List[DatasetRowPushRequest]]
            List of dataset rows with inputs for scenarios.

        dry_run : typing.Optional[bool]

        strict : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowPushResponse

        """
        _response = self._raw_client.push(
            exec_config=exec_config,
            workflow_sandbox_id=workflow_sandbox_id,
            deployment_config=deployment_config,
            artifact=artifact,
            dataset=dataset,
            dry_run=dry_run,
            strict=strict,
            request_options=request_options,
        )
        return _response.data

    def serialize_workflow_files(
        self,
        *,
        files: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Serialize files

        Parameters
        ----------
        files : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflows.serialize_workflow_files(
            files={"files": {"key": "value"}},
        )
        """
        _response = self._raw_client.serialize_workflow_files(files=files, request_options=request_options)
        return _response.data


class AsyncWorkflowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowsClient
        """
        return self._raw_client

    async def pull(
        self,
        id: str,
        *,
        exclude_code: typing.Optional[bool] = None,
        exclude_display: typing.Optional[bool] = None,
        include_json: typing.Optional[bool] = None,
        include_sandbox: typing.Optional[bool] = None,
        release_tag: typing.Optional[str] = None,
        strict: typing.Optional[bool] = None,
        version: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Parameters
        ----------
        id : str
            The ID of the Workflow to pull from

        exclude_code : typing.Optional[bool]

        exclude_display : typing.Optional[bool]

        include_json : typing.Optional[bool]

        include_sandbox : typing.Optional[bool]

        release_tag : typing.Optional[str]
            Release tag to use when pulling from deployment (implies deployment-only lookup)

        strict : typing.Optional[bool]

        version : typing.Optional[str]
            Semantic version range to validate against the Workflow SDK version (e.g., '>=1.0.0,<1.2.3')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]

        """
        async with self._raw_client.pull(
            id,
            exclude_code=exclude_code,
            exclude_display=exclude_display,
            include_json=include_json,
            include_sandbox=include_sandbox,
            release_tag=release_tag,
            strict=strict,
            version=version,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def retrieve_state(
        self, span_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowResolvedState:
        """
        Retrieve the current state of a workflow execution.

        **Note:** Uses a base url of `https://predict.vellum.ai`.

        Parameters
        ----------
        span_id : str
            The span ID of the workflow execution to retrieve state for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowResolvedState


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.retrieve_state(
                span_id="span_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_state(span_id, request_options=request_options)
        return _response.data

    async def push(
        self,
        *,
        exec_config: WorkflowPushExecConfig,
        workflow_sandbox_id: typing.Optional[str] = OMIT,
        deployment_config: typing.Optional[WorkflowPushDeploymentConfigRequest] = OMIT,
        artifact: typing.Optional[core.File] = OMIT,
        dataset: typing.Optional[typing.List[DatasetRowPushRequest]] = OMIT,
        dry_run: typing.Optional[bool] = OMIT,
        strict: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowPushResponse:
        """
        Parameters
        ----------
        exec_config : WorkflowPushExecConfig
            The execution configuration of the workflow.

        workflow_sandbox_id : typing.Optional[str]

        deployment_config : typing.Optional[WorkflowPushDeploymentConfigRequest]

        artifact : typing.Optional[core.File]
            See core.File for more documentation

        dataset : typing.Optional[typing.List[DatasetRowPushRequest]]
            List of dataset rows with inputs for scenarios.

        dry_run : typing.Optional[bool]

        strict : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowPushResponse

        """
        _response = await self._raw_client.push(
            exec_config=exec_config,
            workflow_sandbox_id=workflow_sandbox_id,
            deployment_config=deployment_config,
            artifact=artifact,
            dataset=dataset,
            dry_run=dry_run,
            strict=strict,
            request_options=request_options,
        )
        return _response.data

    async def serialize_workflow_files(
        self,
        *,
        files: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Serialize files

        Parameters
        ----------
        files : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.serialize_workflow_files(
                files={"files": {"key": "value"}},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.serialize_workflow_files(files=files, request_options=request_options)
        return _response.data
