# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .search_filters_request import SearchFiltersRequest
from .search_result_merging_request import SearchResultMergingRequest
from .search_weights_request import SearchWeightsRequest


class SearchRequestOptionsRequest(UniversalBaseModel):
    limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of results to return.
    """

    weights: typing.Optional[SearchWeightsRequest] = pydantic.Field(default=None)
    """
    The weights to use for the search. Must add up to 1.0.
    """

    result_merging: typing.Optional[SearchResultMergingRequest] = pydantic.Field(default=None)
    """
    The configuration for merging results.
    """

    filters: typing.Optional[SearchFiltersRequest] = pydantic.Field(default=None)
    """
    The filters to apply to the search.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value_request import ArrayVellumValueRequest  # noqa: E402, F401, I001
from .metadata_filter_rule_request import MetadataFilterRuleRequest  # noqa: E402, F401, I001
from .vellum_value_logical_condition_group_request import VellumValueLogicalConditionGroupRequest  # noqa: E402, F401, I001

update_forward_refs(SearchRequestOptionsRequest)
