# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .execution_vellum_value import ExecutionVellumValue
from .workflow_error import WorkflowError
from .workflow_execution_actual import WorkflowExecutionActual
from .workflow_execution_usage_result import WorkflowExecutionUsageResult
from .workflow_execution_view_online_eval_metric_result import WorkflowExecutionViewOnlineEvalMetricResult


class SlimWorkflowExecutionRead(UniversalBaseModel):
    span_id: str
    start: dt.datetime
    end: typing.Optional[dt.datetime] = None
    inputs: typing.List[ExecutionVellumValue]
    outputs: typing.List[ExecutionVellumValue]
    error: typing.Optional[WorkflowError] = None
    usage_results: typing.Optional[typing.List[WorkflowExecutionUsageResult]] = None
    parent_context: typing.Optional["WorkflowDeploymentParentContext"] = None
    latest_actual: typing.Optional[WorkflowExecutionActual] = None
    metric_results: typing.List[WorkflowExecutionViewOnlineEvalMetricResult]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value import ArrayVellumValue  # noqa: E402, F401, I001
from .api_request_parent_context import ApiRequestParentContext  # noqa: E402, F401, I001
from .external_parent_context import ExternalParentContext  # noqa: E402, F401, I001
from .node_parent_context import NodeParentContext  # noqa: E402, F401, I001
from .prompt_deployment_parent_context import PromptDeploymentParentContext  # noqa: E402, F401, I001
from .span_link import SpanLink  # noqa: E402, F401, I001
from .workflow_deployment_parent_context import WorkflowDeploymentParentContext  # noqa: E402, F401, I001
from .workflow_parent_context import WorkflowParentContext  # noqa: E402, F401, I001
from .workflow_sandbox_parent_context import WorkflowSandboxParentContext  # noqa: E402, F401, I001

update_forward_refs(SlimWorkflowExecutionRead)
