<!-- markdownlint-disable MD013 -->
<!-- markdownlint-disable MD033 MD036 -->

<div align="center">

# 🚀 Git Auto Commit (gac)

[![PyPI version](https://img.shields.io/pypi/v/gac.svg)](https://pypi.org/project/gac/)
[![Python](https://img.shields.io/badge/python-3.10%20|%203.11%20|%203.12%20|%203.13%20|%203.14-blue.svg)](https://www.python.org/downloads/)
[![Build Status](https://github.com/cellwebb/gac/actions/workflows/ci.yml/badge.svg)](https://github.com/cellwebb/gac/actions)
[![codecov](https://codecov.io/gh/cellwebb/gac/branch/main/graph/badge.svg)](https://app.codecov.io/gh/cellwebb/gac)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff)
[![mypy](https://img.shields.io/badge/mypy-checked-blue.svg)](https://mypy-lang.org/)
[![Contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg)](docs/en/CONTRIBUTING.md)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)

**English** | [简体中文](docs/zh-CN/README.md) | [繁體中文](docs/zh-TW/README.md) | [日本語](docs/ja/README.md) | [한국어](docs/ko/README.md) | [हिन्दी](docs/hi/README.md) | [Tiếng Việt](docs/vi/README.md) | [Français](docs/fr/README.md) | [Русский](docs/ru/README.md) | [Español](docs/es/README.md) | [Português](docs/pt/README.md) | [Norsk](docs/no/README.md) | [Svenska](docs/sv/README.md) | [Deutsch](docs/de/README.md) | [Nederlands](docs/nl/README.md) | [Italiano](docs/it/README.md)

**LLM-powered commit messages that understand your code!**

**Automate your commits!** Replace `git commit -m "..."` with `gac` for contextual, well-formatted commit messages generated by large language models!

---

## What You Get

Intelligent, contextual messages that explain the **why** behind your changes:

![GAC generating a contextual commit message](assets/gac-simple-usage.png)

---

</div>

<!-- markdownlint-enable MD033 MD036 -->

## Quick Start

### Use gac without installing

```bash
uvx gac init   # Configure your provider, model, and language
uvx gac  # Generate and commit with LLM
```

That's it! Review the generated message and confirm with `y`.

### Install and use gac

```bash
uv tool install gac
gac init
gac
```

### Upgrade installed gac

```bash
uv tool upgrade gac
```

---

## Key Features

### 🌐 **Supported Providers**

- **Anthropic** • **Cerebras** • **Chutes.ai** • **Claude Code**
- **DeepSeek** • **Fireworks** • **Gemini** • **Groq** • **LM Studio**
- **MiniMax** • **Mistral** • **Ollama** • **OpenAI** • **OpenRouter**
- **Replicate** • **Streamlake** • **Synthetic.new** • **Together AI**
- **Z.AI** • **Z.AI Coding** • **Custom Endpoints (Anthropic/OpenAI)**

### 🧠 **Smart LLM Analysis**

- **Understands intent**: Analyzes code structure, logic, and patterns to understand the "why" behind your changes, not just what changed
- **Semantic awareness**: Recognizes refactoring, bug fixes, features, and breaking changes to generate contextually appropriate messages
- **Intelligent filtering**: Prioritizes meaningful changes while ignoring generated files, dependencies, and artifacts
- **Intelligent commit grouping** - Automatically group related changes into multiple logical commits with `--group`

### 📝 **Multiple Message Formats**

- **One-liner** (-o flag): Single-line commit message following conventional commit format
- **Standard** (default): Summary with bullet points explaining implementation details
- **Verbose** (-v flag): Comprehensive explanations including motivation, technical approach, and impact analysis

### 🌍 **Multilingual Support**

- **25+ languages**: Generate commit messages in English, Chinese, Japanese, Korean, Spanish, French, German, and 20+ more languages
- **Flexible translation**: Choose to keep conventional commit prefixes in English for tool compatibility, or fully translate them
- **Multiple workflows**: Set a default language with `gac language`, or use `-l <language>` flag for one-time overrides
- **Native script support**: Full support for non-Latin scripts including CJK, Cyrillic, Thai, and more

### 💻 **Developer Experience**

- **Interactive feedback**: Type `r` to reroll, `e` to edit in-place with vi/emacs keybindings, or directly type your feedback like `make it shorter` or `focus on the bug fix`
- **One-command workflows**: Complete workflows with flags like `gac -ayp` (stage all, auto-confirm, push)
- **Git integration**: Respects pre-commit and lefthook hooks, running them before expensive LLM operations

### 🛡️ **Built-in Security**

- **Automatic secret detection**: Scans for API keys, passwords, and tokens before committing
- **Interactive protection**: Prompts before committing potentially sensitive data with clear remediation options
- **Smart filtering**: Ignores example files, template files, and placeholder text to reduce false positives

---

## Usage Examples

### Basic Workflow

```bash
# Stage your changes
git add .

# Generate and commit with LLM
gac

# Review → y (commit) | n (cancel) | r (reroll) | e (edit) | or type feedback
```

### Common Commands

| Command         | Description                                                             |
| --------------- | ----------------------------------------------------------------------- |
| `gac`           | Generate commit message                                                 |
| `gac -y`        | Auto-confirm (no review needed)                                         |
| `gac -a`        | Stage all before generating commit message                              |
| `gac -o`        | One-line message for trivial changes                                    |
| `gac -v`        | Verbose format with Motivation, Technical Approach, and Impact Analysis |
| `gac -h "hint"` | Add context for LLM (e.g., `gac -h "bug fix"`)                          |
| `gac -s`        | Include scope (e.g., feat(auth):)                                       |
| `gac -p`        | Commit and push                                                         |

### Power User Examples

```bash
# Complete workflow in one command
gac -ayp -h "release preparation"

# Detailed explanation with scope
gac -v -s

# Quick one-liner for small changes
gac -o

# Group changes into logically related commits
gac -ag

# Debug what the LLM sees
gac --show-prompt

# Skip security scan (use carefully)
gac --skip-secret-scan
```

### Interactive Feedback System

Not happy with the result? You have several options:

```bash
# Simple reroll (no feedback)
r

# Edit in-place with rich terminal editing
e
# Uses prompt_toolkit for multi-line editing with vi/emacs keybindings
# Press Esc+Enter or Ctrl+S to submit, Ctrl+C to cancel

# Or just type your feedback directly!
make it shorter and focus on the performance improvement
use conventional commit format with scope
explain the security implications

# Press Enter on empty input to see the prompt again
```

The edit feature (`e`) provides rich in-place terminal editing, allowing you to:

- **Edit naturally**: Multi-line editing with familiar vi/emacs key bindings
- **Make quick fixes**: Correct typos, adjust wording, or refine formatting
- **Add details**: Include information the LLM might have missed
- **Restructure**: Reorganize bullet points or change the message structure

---

## Configuration

Run `gac init` to configure your provider interactively, or set environment variables:

Need to change providers or models later without touching language settings? Use `gac model` for a streamlined flow that skips the language prompts.

```bash
# Example configuration
GAC_MODEL=anthropic:your-model-name
OPENAI_API_KEY=your_key_here
ANTHROPIC_API_KEY=your_key_here
```

See `.gac.env.example` for all available options.

**Want commit messages in another language?** Run `gac language` to select from 25+ languages including Español, Français, 日本語, and more.

**Want to customize commit message style?** See [docs/CUSTOM_SYSTEM_PROMPTS.md](docs/en/CUSTOM_SYSTEM_PROMPTS.md) for guidance on writing custom system prompts.

---

## Project Analytics

📊 **[View live usage analytics and statistics →](https://clickpy.clickhouse.com/dashboard/gac)**

Track real-time installation metrics and package download statistics.

---

## Getting Help

- **Full documentation**: [docs/USAGE.md](docs/en/USAGE.md) - Complete CLI reference
- **Custom prompts**: [docs/CUSTOM_SYSTEM_PROMPTS.md](docs/en/CUSTOM_SYSTEM_PROMPTS.md) - Customize commit message style
- **Troubleshooting**: [docs/TROUBLESHOOTING.md](docs/en/TROUBLESHOOTING.md) - Common issues and solutions
- **Contributing**: [docs/CONTRIBUTING.md](docs/en/CONTRIBUTING.md) - Development setup and guidelines

---

<!-- markdownlint-disable MD033 MD036 -->

<div align="center">

Made with ❤️ for developers who want better commit messages

[⭐ Star us on GitHub](https://github.com/cellwebb/gac) • [🐛 Report issues](https://github.com/cellwebb/gac/issues) • [📖 Full docs](docs/en/USAGE.md)

</div>

<!-- markdownlint-enable MD033 MD036 -->
