# 🎉 Version 0.4.0 Deployment Complete! 🎉

## Deployment Summary - November 21, 2025

### ✅ Successfully Deployed Version 0.4.0!

**Package**: `parallel-llm`  
**Version**: 0.4.0  
**PyPI URL**: https://pypi.org/project/parallel-llm/0.4.0/  
**Deployment Time**: November 21, 2025, 11:55 AM IST

---

## 📦 What's New in v0.4.0

### 📚 Comprehensive Examples
Added a new `examples/` directory included in the package distribution, featuring:

1.  **`train_unimodal.py`**:
    *   Complete training pipeline for text-only models.
    *   Demonstrates FSDP, custom data loading, and diffusion loss.
    *   Uses `parallel_llm.core`, `parallel_llm.training`, and `parallel_llm.utils`.

2.  **`train_multimodal.py`**:
    *   Training pipeline for text+image models.
    *   Shows how to configure `MultimodalConfig` and `MultimodalDataset`.
    *   Demonstrates integration with vision encoders (ViT).

3.  **`inference_unimodal.py`**:
    *   High-speed parallel token generation example.
    *   Shows `ParallelGenerator` setup and usage.

4.  **`inference_multimodal.py`**:
    *   Image-to-text generation (captioning) example.
    *   Demonstrates handling pixel values and text prompts together.

### 🛠️ Package Updates
- **Manifest Update**: `examples/` directory is now included in the source distribution (`.tar.gz`).
- **Version Bump**: Updated to 0.4.0 in `pyproject.toml` and `__init__.py`.

---

## 🚀 How to Use the Examples

After installing the package:

```bash
pip install parallel-llm==0.4.0
```

You can find the examples in the source distribution or copy them from the repository.

### Running Unimodal Training
```bash
# Single GPU/CPU
python examples/train_unimodal.py

# Distributed (4 GPUs)
torchrun --nproc_per_node=4 examples/train_unimodal.py
```

### Running Multimodal Training
```bash
python examples/train_multimodal.py
```

### Running Inference
```bash
python examples/inference_unimodal.py
python examples/inference_multimodal.py
```

---

## 🔗 Links
- **PyPI**: https://pypi.org/project/parallel-llm/
- **GitHub**: https://github.com/furqan-y-khan/parallel-llm

---

*Deployment completed successfully by Antigravity*
