"""Testing for all the classes in meta_transformers."""

import numpy as np
from numpy.testing import assert_almost_equal

from giotto.meta_transformers import EntropyGenerator, BettiCurveGenerator
from giotto.meta_transformers import LandscapeGenerator


def test_EntropyGenerator_transform():
    """Test the EntropyGenerator."""
    X = np.asarray(
        [[[1, 1.1, 0], [1, 0.9, 0.5], [0.9, 1, 0.2], [0.9, -1, 0.2]]])
    ent = EntropyGenerator()
    X_tr = ent.fit_transform(X)
    assert_almost_equal(X_tr, np.asarray([[0.69682883, -0.]]))


def test_BettiCurveGenerator_transform():
    """Test the BettiCurveGenerator."""
    X = np.asarray(
        [[[1, 1.1, 0], [1, 0.9, 0.5], [0.9, 1, 0.2], [0.9, -1, 0.2]]])
    bc = BettiCurveGenerator()
    X_tr = bc.fit_transform(X)
    assert_almost_equal(X_tr, np.asarray(
        [[[3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1,
           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]]]))


def test_LandscapeGenerator_transform():
    """Test the LandscapeGenerator."""
    X = np.asarray(
        [[[1, 1.1, 0], [1, 0.9, 0.5], [0.9, 1, 0.2], [0.9, -1, 0.2]]])
    ls = LandscapeGenerator()
    X_tr = ls.fit_transform(X)
    assert_almost_equal(X_tr,
                        np.asarray([[[[0., 0.01428499, 0.02856997, 0.04285496,
                                       0.05713994,
                                       0.07142493, 0.08570991, 0.0999949,
                                       0.11427988, 0.12856487,
                                       0.14284985, 0.15713484, 0.17141983,
                                       0.18570481, 0.1999898,
                                       0.21427478, 0.22855977, 0.24284475,
                                       0.25712974, 0.27141472,
                                       0.28569971, 0.2999847, 0.31426968,
                                       0.32855467, 0.34283965,
                                       0.35712464, 0.37140962, 0.38569461,
                                       0.39997959, 0.41426458,
                                       0.42854956, 0.44283455, 0.45711954,
                                       0.47140452, 0.48568951,
                                       0.49997449, 0.51425948, 0.52854446,
                                       0.54282945, 0.55711443,
                                       0.57139942, 0.5856844, 0.59996939,
                                       0.61425438, 0.62853936,
                                       0.64282435, 0.65710933, 0.67139432,
                                       0.6856793, 0.69996429,
                                       0.69996429, 0.6856793, 0.67139432,
                                       0.65710933, 0.64282435,
                                       0.62853936, 0.61425438, 0.59996939,
                                       0.5856844, 0.57139942,
                                       0.55711443, 0.54282945, 0.52854446,
                                       0.51425948, 0.49997449,
                                       0.48568951, 0.47140452, 0.45711954,
                                       0.44283455, 0.42854956,
                                       0.41426458, 0.39997959, 0.38569461,
                                       0.37140962, 0.35712464,
                                       0.34283965, 0.32855467, 0.31426968,
                                       0.2999847, 0.28569971,
                                       0.27141472, 0.25712974, 0.24284475,
                                       0.22855977, 0.21427478,
                                       0.1999898, 0.18570481, 0.17141983,
                                       0.15713484, 0.14284985,
                                       0.12856487, 0.11427988, 0.0999949,
                                       0.08570991, 0.07142493,
                                       0.05713994, 0.04285496, 0.02856997,
                                       0.01428499, 0.]],

                                     [[0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.,
                                       0., 0., 0., 0., 0.]]]]))
