# Generated by Django 3.2.7 on 2021-12-16 22:13

import django.db.models.deletion
import parler.fields
import parler.models
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="AboutContactPages",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "verbose_name": "About & Contact Pages",
                "verbose_name_plural": "About & Contact Pages",
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="HistoryLink",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("time", models.DateTimeField(auto_now_add=True)),
                ("link_id", models.SmallIntegerField(blank=True, null=True)),
                ("link", models.CharField(max_length=2000, null=True)),
                ("description", models.TextField(max_length=100000, null=True)),
                (
                    "type",
                    models.CharField(
                        blank=True,
                        choices=[("new", "N"), ("update", "U"), ("remove", "R")],
                        max_length=6,
                    ),
                ),
            ],
            options={
                "verbose_name": "History of Links",
                "verbose_name_plural": "History of Links",
            },
        ),
        migrations.CreateModel(
            name="HistoryTag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("time", models.DateTimeField(auto_now_add=True)),
                ("tag_id", models.SmallIntegerField(blank=True, null=True)),
                ("tag", models.CharField(max_length=2000, null=True)),
                ("description", models.TextField(max_length=100000, null=True)),
                (
                    "type",
                    models.CharField(
                        blank=True,
                        choices=[("new", "N"), ("update", "U"), ("remove", "R")],
                        max_length=6,
                    ),
                ),
            ],
            options={
                "verbose_name": "History of Tags",
                "verbose_name_plural": "History of Tags",
            },
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "highlight",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text='Tag will be displayed with a special color, and will appear in the "highlighted" sort option.',
                    ),
                ),
                ("date_added", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "verbose_name": "Tag",
                "verbose_name_plural": "Tags",
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Link",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "link",
                    models.CharField(max_length=2000, unique=True, verbose_name="Link"),
                ),
                (
                    "highlight",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text='Link will be displayed with a special color, and will appear in the "highlighted" sort option.',
                    ),
                ),
                ("date_added", models.DateTimeField(auto_now_add=True)),
                (
                    "file",
                    models.FileField(
                        blank=True,
                        help_text="Upload pdf or screenshot of the page. If this field is empty and USE_WEASYPRINT is set to True (currently set to False), then the pdf will be auto-generated using weasyprint.",
                        null=True,
                        upload_to="pdfs/",
                    ),
                ),
                (
                    "save_file",
                    models.BooleanField(
                        default=True,
                        help_text="Uncheck this box if you don't want the file to be auto-generated.",
                    ),
                ),
                (
                    "tags",
                    models.ManyToManyField(
                        blank=True, related_name="links", to="share_links.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "Link",
                "verbose_name_plural": "Links",
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="TagTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                ("tag", models.CharField(max_length=2000, verbose_name="Tag")),
                (
                    "slug",
                    models.SlugField(
                        editable=False,
                        max_length=2000,
                        unique=True,
                        verbose_name="Slug",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="You can use markdown here.",
                        null=True,
                        verbose_name="Description",
                    ),
                ),
                (
                    "master",
                    parler.fields.TranslationsForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="share_links.tag",
                    ),
                ),
            ],
            options={
                "verbose_name": "Tag Translation",
                "db_table": "share_links_tag_translation",
                "db_tablespace": "",
                "managed": True,
                "default_permissions": (),
                "unique_together": {("language_code", "master")},
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="LinkTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="You can use markdown here.",
                        null=True,
                        verbose_name="Description",
                    ),
                ),
                (
                    "master",
                    parler.fields.TranslationsForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="share_links.link",
                    ),
                ),
            ],
            options={
                "verbose_name": "Link Translation",
                "db_table": "share_links_link_translation",
                "db_tablespace": "",
                "managed": True,
                "default_permissions": (),
                "unique_together": {("language_code", "master")},
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AboutContactPagesTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                (
                    "page_title",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="Title"
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="You can use markdown here.",
                        null=True,
                        verbose_name="Description",
                    ),
                ),
                (
                    "master",
                    parler.fields.TranslationsForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="share_links.aboutcontactpages",
                    ),
                ),
            ],
            options={
                "verbose_name": "About & Contact Pages Translation",
                "db_table": "share_links_aboutcontactpages_translation",
                "db_tablespace": "",
                "managed": True,
                "default_permissions": (),
                "unique_together": {("language_code", "master")},
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
    ]
