# SuperTokenTracker (Python)

Google Gemini token tracker that automatically logs prompts, responses, and token usage.

**Drop-in replacement for `google-genai` - just change your import!**

## Installation

```bash
pip install supertokentracker
```

## Quick Start

```python
from supertokentracker import genai

client = genai.Client(api_key="YOUR_API_KEY")

response = client.models.generate_content(
    model="gemini-2.0-flash-exp",
    contents="Why is the sky blue?"
)

print(response.text)

requests = client.get_tracked_requests()
print(f"Total tokens used: {requests[0]['usage']['totalTokens']}")
```

### Migration from `google-genai`

Simply replace:
```python
from google import genai  # Before
```

With:
```python
from supertokentracker import genai  # After
```

Everything else stays the same!

## Features

- **Drop-in replacement** for `google-genai` package
- Automatic token tracking for all Gemini API calls
- Local JSON file storage or remote tracking
- Tracks errors, metadata, and response times
- Zero-config setup

## Configuration

### Local Storage (default)

```python
from supertokentracker import genai

client = genai.Client(
    api_key="YOUR_API_KEY",
    local_storage={
        "file_path": "./custom-logs.json",
        "auto_save": True
    }
)
```

### Remote Storage

```python
from supertokentracker import genai

client = genai.Client(
    api_key="YOUR_GEMINI_API_KEY",
    storage="remote",
    remote_storage={
        "api_key": "YOUR_AITRACKER_API_KEY",
        "project_name": "my-project"
    }
)
```

View tracked requests at [tokentracker.dev](https://tokentracker.dev)

## License

MIT
