from typing import Any, Optional, Dict, TypedDict, Literal
from datetime import datetime


class UsageMetadata(TypedDict, total=False):
    promptTokens: Optional[int]
    completionTokens: Optional[int]
    totalTokens: Optional[int]


class TrackedRequest(TypedDict, total=False):
    id: str
    project_name: Optional[str]
    timestamp: datetime
    response_time: Optional[float]
    model: str
    prompt: Any
    response: Any
    usage: Optional[UsageMetadata]
    error: Optional[Any]
    search_grounding: Optional[bool]
    received_search_grounded_response: Optional[bool]
    metadata: Optional[Dict[str, Any]]


class StorageOptions(TypedDict, total=False):
    file_path: Optional[str]
    auto_save: Optional[bool]


class RemoteStorageOptions(TypedDict, total=False):
    endpoint: str
    api_key: str
    project_name: Optional[str]
    timeout: Optional[int]
    retries: Optional[int]
    retry_delay: Optional[int]


StorageMode = Literal["local", "remote"]


class TrackerOptions(TypedDict, total=False):
    api_key: Optional[str]
    vertexai: Optional[bool]
    project: Optional[str]
    location: Optional[str]
    storage: Optional[StorageMode]
    local_storage: Optional[StorageOptions]
    remote_storage: Optional[RemoteStorageOptions]
