# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabasePostgresqlConfigArgs', 'DatabasePostgresqlConfig']

@pulumi.input_type
class DatabasePostgresqlConfigArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_freeze_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 jit: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_autovacuum_min_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 log_error_verbosity: Optional[pulumi.Input[_builtins.str]] = None,
                 log_line_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 log_min_duration_statement: Optional[pulumi.Input[_builtins.int]] = None,
                 max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
                 max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 max_prepared_transactions: Optional[pulumi.Input[_builtins.int]] = None,
                 max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
                 max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
                 max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
                 pgbouncers: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigPgbouncerArgs']]]] = None,
                 shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 timescaledbs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigTimescaledbArgs']]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
                 track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 track_functions: Optional[pulumi.Input[_builtins.str]] = None,
                 track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
                 wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 work_mem: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a DatabasePostgresqlConfig resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target PostgreSQL cluster.
        :param pulumi.Input[_builtins.float] autovacuum_analyze_scale_factor: Specifies a fraction, in a decimal value, of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size).
        :param pulumi.Input[_builtins.int] autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated, or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] autovacuum_freeze_max_age: Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. Note that the system will launch autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. This parameter will cause the server to be restarted.
        :param pulumi.Input[_builtins.int] autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        :param pulumi.Input[_builtins.int] autovacuum_naptime: Specifies the minimum delay, in seconds, between autovacuum runs on any given database. The default is one minute.
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_cost_delay: Specifies the cost delay value, in milliseconds, that will be used in automatic VACUUM operations. If -1, uses the regular vacuum_cost_delay value, which is 20 milliseconds.
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        :param pulumi.Input[_builtins.float] autovacuum_vacuum_scale_factor: Specifies a fraction, in a decimal value, of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size).
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] backup_hour: The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] backup_minute: The minute of the backup hour when backup for the service starts. New backup is only started if previous backup has already completed.
        :param pulumi.Input[_builtins.int] bgwriter_delay: Specifies the delay, in milliseconds, between activity rounds for the background writer. Default is 200 ms.
        :param pulumi.Input[_builtins.int] bgwriter_flush_after: The amount of kilobytes that need to be written by the background writer before attempting to force the OS to issue these writes to underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        :param pulumi.Input[_builtins.int] bgwriter_lru_maxpages: The maximum number of buffers that the background writer can write. Setting this to zero disables background writing. Default is 100.
        :param pulumi.Input[_builtins.float] bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        :param pulumi.Input[_builtins.int] deadlock_timeout: The amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        :param pulumi.Input[_builtins.str] default_toast_compression: Specifies the default TOAST compression method for values of compressible columns (the default is lz4). Supported values are: `lz4`, `pglz`.
        :param pulumi.Input[_builtins.int] idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds
        :param pulumi.Input[_builtins.bool] jit: Activates, in a boolean, the system-wide use of Just-in-Time Compilation (JIT).
        :param pulumi.Input[_builtins.int] log_autovacuum_min_duration: Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one (the default) disables logging autovacuum actions.
        :param pulumi.Input[_builtins.str] log_error_verbosity: Controls the amount of detail written in the server log for each message that is logged. Supported values are: `TERSE`, `DEFAULT`, `VERBOSE`.
        :param pulumi.Input[_builtins.str] log_line_prefix: Selects one of the available log-formats. These can support popular log analyzers like pgbadger, pganalyze, etc. Supported values are: `pid=%p,user=%u,db=%d,app=%a,client=%h`, `%m [%p] %q[user=%u,db=%d,app=%a]`, `%t [%p]: [%l-1] user=%u,db=%d,app=%a,client=%h`.
        :param pulumi.Input[_builtins.int] log_min_duration_statement: Log statements that take more than this number of milliseconds to run. If -1, disables.
        :param pulumi.Input[_builtins.int] max_files_per_process: PostgreSQL maximum number of files that can be open per process.
        :param pulumi.Input[_builtins.int] max_locks_per_transaction: PostgreSQL maximum locks per transaction. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        :param pulumi.Input[_builtins.int] max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries.
        :param pulumi.Input[_builtins.int] max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        :param pulumi.Input[_builtins.int] max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction.
        :param pulumi.Input[_builtins.int] max_prepared_transactions: PostgreSQL maximum prepared transactions. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_replication_slots: PostgreSQL maximum replication slots.
        :param pulumi.Input[_builtins.int] max_stack_depth: Maximum depth of the stack in bytes.
        :param pulumi.Input[_builtins.int] max_standby_archive_delay: Max standby archive delay in milliseconds.
        :param pulumi.Input[_builtins.int] max_standby_streaming_delay: Max standby streaming delay in milliseconds.
        :param pulumi.Input[_builtins.int] max_wal_senders: PostgreSQL maximum WAL senders. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_worker_processes: Sets the maximum number of background processes that the system can support. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] pg_partman_bgw_interval: Sets the time interval to run pg_partman's scheduled tasks.
        :param pulumi.Input[_builtins.str] pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks. Must consist of alpha-numeric characters, dots, underscores, or dashes. May not start with dash or dot. Maximum of 64 characters.
        :param pulumi.Input[_builtins.str] pg_stat_statements_track: Controls which statements are counted. Specify 'top' to track top-level statements (those issued directly by clients), 'all' to also track nested statements (such as statements invoked within functions), or 'none' to disable statement statistics collection. The default value is top. Supported values are: `all`, `top`, `none`.
        :param pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigPgbouncerArgs']]] pgbouncers: PGBouncer connection pooling settings
        :param pulumi.Input[_builtins.float] shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        :param pulumi.Input[_builtins.int] temp_file_limit: PostgreSQL temporary file limit in KiB. If -1, sets to unlimited.
        :param pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigTimescaledbArgs']]] timescaledbs: TimescaleDB extension configuration values
        :param pulumi.Input[_builtins.str] timezone: PostgreSQL service timezone
        :param pulumi.Input[_builtins.int] track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session.
        :param pulumi.Input[_builtins.str] track_commit_timestamp: Record commit time of transactions. The default value is top. Supported values are: `off`, `on`.
        :param pulumi.Input[_builtins.str] track_functions: Enables tracking of function call counts and time used. The default value is top. Supported values are: `all`, `pl`, `none`.
        :param pulumi.Input[_builtins.str] track_io_timing: Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms. The default value is top. Supported values are: `off`, `on`.
        :param pulumi.Input[_builtins.int] wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout. Must be either 0 or between 5000 and 10800000.
        :param pulumi.Input[_builtins.int] wal_writer_delay: WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance
        :param pulumi.Input[_builtins.int] work_mem: The maximum amount of memory, in MB, used by a query operation (such as a sort or hash table) before writing to temporary disk files. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if autovacuum_analyze_scale_factor is not None:
            pulumi.set(__self__, "autovacuum_analyze_scale_factor", autovacuum_analyze_scale_factor)
        if autovacuum_analyze_threshold is not None:
            pulumi.set(__self__, "autovacuum_analyze_threshold", autovacuum_analyze_threshold)
        if autovacuum_freeze_max_age is not None:
            pulumi.set(__self__, "autovacuum_freeze_max_age", autovacuum_freeze_max_age)
        if autovacuum_max_workers is not None:
            pulumi.set(__self__, "autovacuum_max_workers", autovacuum_max_workers)
        if autovacuum_naptime is not None:
            pulumi.set(__self__, "autovacuum_naptime", autovacuum_naptime)
        if autovacuum_vacuum_cost_delay is not None:
            pulumi.set(__self__, "autovacuum_vacuum_cost_delay", autovacuum_vacuum_cost_delay)
        if autovacuum_vacuum_cost_limit is not None:
            pulumi.set(__self__, "autovacuum_vacuum_cost_limit", autovacuum_vacuum_cost_limit)
        if autovacuum_vacuum_scale_factor is not None:
            pulumi.set(__self__, "autovacuum_vacuum_scale_factor", autovacuum_vacuum_scale_factor)
        if autovacuum_vacuum_threshold is not None:
            pulumi.set(__self__, "autovacuum_vacuum_threshold", autovacuum_vacuum_threshold)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if bgwriter_delay is not None:
            pulumi.set(__self__, "bgwriter_delay", bgwriter_delay)
        if bgwriter_flush_after is not None:
            pulumi.set(__self__, "bgwriter_flush_after", bgwriter_flush_after)
        if bgwriter_lru_maxpages is not None:
            pulumi.set(__self__, "bgwriter_lru_maxpages", bgwriter_lru_maxpages)
        if bgwriter_lru_multiplier is not None:
            pulumi.set(__self__, "bgwriter_lru_multiplier", bgwriter_lru_multiplier)
        if deadlock_timeout is not None:
            pulumi.set(__self__, "deadlock_timeout", deadlock_timeout)
        if default_toast_compression is not None:
            pulumi.set(__self__, "default_toast_compression", default_toast_compression)
        if idle_in_transaction_session_timeout is not None:
            pulumi.set(__self__, "idle_in_transaction_session_timeout", idle_in_transaction_session_timeout)
        if jit is not None:
            pulumi.set(__self__, "jit", jit)
        if log_autovacuum_min_duration is not None:
            pulumi.set(__self__, "log_autovacuum_min_duration", log_autovacuum_min_duration)
        if log_error_verbosity is not None:
            pulumi.set(__self__, "log_error_verbosity", log_error_verbosity)
        if log_line_prefix is not None:
            pulumi.set(__self__, "log_line_prefix", log_line_prefix)
        if log_min_duration_statement is not None:
            pulumi.set(__self__, "log_min_duration_statement", log_min_duration_statement)
        if max_files_per_process is not None:
            pulumi.set(__self__, "max_files_per_process", max_files_per_process)
        if max_locks_per_transaction is not None:
            pulumi.set(__self__, "max_locks_per_transaction", max_locks_per_transaction)
        if max_logical_replication_workers is not None:
            pulumi.set(__self__, "max_logical_replication_workers", max_logical_replication_workers)
        if max_parallel_workers is not None:
            pulumi.set(__self__, "max_parallel_workers", max_parallel_workers)
        if max_parallel_workers_per_gather is not None:
            pulumi.set(__self__, "max_parallel_workers_per_gather", max_parallel_workers_per_gather)
        if max_pred_locks_per_transaction is not None:
            pulumi.set(__self__, "max_pred_locks_per_transaction", max_pred_locks_per_transaction)
        if max_prepared_transactions is not None:
            pulumi.set(__self__, "max_prepared_transactions", max_prepared_transactions)
        if max_replication_slots is not None:
            pulumi.set(__self__, "max_replication_slots", max_replication_slots)
        if max_stack_depth is not None:
            pulumi.set(__self__, "max_stack_depth", max_stack_depth)
        if max_standby_archive_delay is not None:
            pulumi.set(__self__, "max_standby_archive_delay", max_standby_archive_delay)
        if max_standby_streaming_delay is not None:
            pulumi.set(__self__, "max_standby_streaming_delay", max_standby_streaming_delay)
        if max_wal_senders is not None:
            pulumi.set(__self__, "max_wal_senders", max_wal_senders)
        if max_worker_processes is not None:
            pulumi.set(__self__, "max_worker_processes", max_worker_processes)
        if pg_partman_bgw_interval is not None:
            pulumi.set(__self__, "pg_partman_bgw_interval", pg_partman_bgw_interval)
        if pg_partman_bgw_role is not None:
            pulumi.set(__self__, "pg_partman_bgw_role", pg_partman_bgw_role)
        if pg_stat_statements_track is not None:
            pulumi.set(__self__, "pg_stat_statements_track", pg_stat_statements_track)
        if pgbouncers is not None:
            pulumi.set(__self__, "pgbouncers", pgbouncers)
        if shared_buffers_percentage is not None:
            pulumi.set(__self__, "shared_buffers_percentage", shared_buffers_percentage)
        if temp_file_limit is not None:
            pulumi.set(__self__, "temp_file_limit", temp_file_limit)
        if timescaledbs is not None:
            pulumi.set(__self__, "timescaledbs", timescaledbs)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if track_activity_query_size is not None:
            pulumi.set(__self__, "track_activity_query_size", track_activity_query_size)
        if track_commit_timestamp is not None:
            pulumi.set(__self__, "track_commit_timestamp", track_commit_timestamp)
        if track_functions is not None:
            pulumi.set(__self__, "track_functions", track_functions)
        if track_io_timing is not None:
            pulumi.set(__self__, "track_io_timing", track_io_timing)
        if wal_sender_timeout is not None:
            pulumi.set(__self__, "wal_sender_timeout", wal_sender_timeout)
        if wal_writer_delay is not None:
            pulumi.set(__self__, "wal_writer_delay", wal_writer_delay)
        if work_mem is not None:
            pulumi.set(__self__, "work_mem", work_mem)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the target PostgreSQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumAnalyzeScaleFactor")
    def autovacuum_analyze_scale_factor(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies a fraction, in a decimal value, of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size).
        """
        return pulumi.get(self, "autovacuum_analyze_scale_factor")

    @autovacuum_analyze_scale_factor.setter
    def autovacuum_analyze_scale_factor(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "autovacuum_analyze_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumAnalyzeThreshold")
    def autovacuum_analyze_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of inserted, updated, or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "autovacuum_analyze_threshold")

    @autovacuum_analyze_threshold.setter
    def autovacuum_analyze_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_analyze_threshold", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumFreezeMaxAge")
    def autovacuum_freeze_max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. Note that the system will launch autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. This parameter will cause the server to be restarted.
        """
        return pulumi.get(self, "autovacuum_freeze_max_age")

    @autovacuum_freeze_max_age.setter
    def autovacuum_freeze_max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_freeze_max_age", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumMaxWorkers")
    def autovacuum_max_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        """
        return pulumi.get(self, "autovacuum_max_workers")

    @autovacuum_max_workers.setter
    def autovacuum_max_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_max_workers", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumNaptime")
    def autovacuum_naptime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum delay, in seconds, between autovacuum runs on any given database. The default is one minute.
        """
        return pulumi.get(self, "autovacuum_naptime")

    @autovacuum_naptime.setter
    def autovacuum_naptime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_naptime", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumCostDelay")
    def autovacuum_vacuum_cost_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cost delay value, in milliseconds, that will be used in automatic VACUUM operations. If -1, uses the regular vacuum_cost_delay value, which is 20 milliseconds.
        """
        return pulumi.get(self, "autovacuum_vacuum_cost_delay")

    @autovacuum_vacuum_cost_delay.setter
    def autovacuum_vacuum_cost_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_vacuum_cost_delay", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumCostLimit")
    def autovacuum_vacuum_cost_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        """
        return pulumi.get(self, "autovacuum_vacuum_cost_limit")

    @autovacuum_vacuum_cost_limit.setter
    def autovacuum_vacuum_cost_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_vacuum_cost_limit", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumScaleFactor")
    def autovacuum_vacuum_scale_factor(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies a fraction, in a decimal value, of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size).
        """
        return pulumi.get(self, "autovacuum_vacuum_scale_factor")

    @autovacuum_vacuum_scale_factor.setter
    def autovacuum_vacuum_scale_factor(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "autovacuum_vacuum_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumThreshold")
    def autovacuum_vacuum_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "autovacuum_vacuum_threshold")

    @autovacuum_vacuum_threshold.setter
    def autovacuum_vacuum_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_vacuum_threshold", value)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minute of the backup hour when backup for the service starts. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="bgwriterDelay")
    def bgwriter_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the delay, in milliseconds, between activity rounds for the background writer. Default is 200 ms.
        """
        return pulumi.get(self, "bgwriter_delay")

    @bgwriter_delay.setter
    def bgwriter_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bgwriter_delay", value)

    @_builtins.property
    @pulumi.getter(name="bgwriterFlushAfter")
    def bgwriter_flush_after(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of kilobytes that need to be written by the background writer before attempting to force the OS to issue these writes to underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        """
        return pulumi.get(self, "bgwriter_flush_after")

    @bgwriter_flush_after.setter
    def bgwriter_flush_after(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bgwriter_flush_after", value)

    @_builtins.property
    @pulumi.getter(name="bgwriterLruMaxpages")
    def bgwriter_lru_maxpages(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of buffers that the background writer can write. Setting this to zero disables background writing. Default is 100.
        """
        return pulumi.get(self, "bgwriter_lru_maxpages")

    @bgwriter_lru_maxpages.setter
    def bgwriter_lru_maxpages(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bgwriter_lru_maxpages", value)

    @_builtins.property
    @pulumi.getter(name="bgwriterLruMultiplier")
    def bgwriter_lru_multiplier(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        """
        return pulumi.get(self, "bgwriter_lru_multiplier")

    @bgwriter_lru_multiplier.setter
    def bgwriter_lru_multiplier(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "bgwriter_lru_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="deadlockTimeout")
    def deadlock_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        """
        return pulumi.get(self, "deadlock_timeout")

    @deadlock_timeout.setter
    def deadlock_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deadlock_timeout", value)

    @_builtins.property
    @pulumi.getter(name="defaultToastCompression")
    def default_toast_compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default TOAST compression method for values of compressible columns (the default is lz4). Supported values are: `lz4`, `pglz`.
        """
        return pulumi.get(self, "default_toast_compression")

    @default_toast_compression.setter
    def default_toast_compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_toast_compression", value)

    @_builtins.property
    @pulumi.getter(name="idleInTransactionSessionTimeout")
    def idle_in_transaction_session_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time out sessions with open transactions after this number of milliseconds
        """
        return pulumi.get(self, "idle_in_transaction_session_timeout")

    @idle_in_transaction_session_timeout.setter
    def idle_in_transaction_session_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_in_transaction_session_timeout", value)

    @_builtins.property
    @pulumi.getter
    def jit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activates, in a boolean, the system-wide use of Just-in-Time Compilation (JIT).
        """
        return pulumi.get(self, "jit")

    @jit.setter
    def jit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "jit", value)

    @_builtins.property
    @pulumi.getter(name="logAutovacuumMinDuration")
    def log_autovacuum_min_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one (the default) disables logging autovacuum actions.
        """
        return pulumi.get(self, "log_autovacuum_min_duration")

    @log_autovacuum_min_duration.setter
    def log_autovacuum_min_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_autovacuum_min_duration", value)

    @_builtins.property
    @pulumi.getter(name="logErrorVerbosity")
    def log_error_verbosity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the amount of detail written in the server log for each message that is logged. Supported values are: `TERSE`, `DEFAULT`, `VERBOSE`.
        """
        return pulumi.get(self, "log_error_verbosity")

    @log_error_verbosity.setter
    def log_error_verbosity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_error_verbosity", value)

    @_builtins.property
    @pulumi.getter(name="logLinePrefix")
    def log_line_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Selects one of the available log-formats. These can support popular log analyzers like pgbadger, pganalyze, etc. Supported values are: `pid=%p,user=%u,db=%d,app=%a,client=%h`, `%m [%p] %q[user=%u,db=%d,app=%a]`, `%t [%p]: [%l-1] user=%u,db=%d,app=%a,client=%h`.
        """
        return pulumi.get(self, "log_line_prefix")

    @log_line_prefix.setter
    def log_line_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_line_prefix", value)

    @_builtins.property
    @pulumi.getter(name="logMinDurationStatement")
    def log_min_duration_statement(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Log statements that take more than this number of milliseconds to run. If -1, disables.
        """
        return pulumi.get(self, "log_min_duration_statement")

    @log_min_duration_statement.setter
    def log_min_duration_statement(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_min_duration_statement", value)

    @_builtins.property
    @pulumi.getter(name="maxFilesPerProcess")
    def max_files_per_process(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum number of files that can be open per process.
        """
        return pulumi.get(self, "max_files_per_process")

    @max_files_per_process.setter
    def max_files_per_process(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_files_per_process", value)

    @_builtins.property
    @pulumi.getter(name="maxLocksPerTransaction")
    def max_locks_per_transaction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum locks per transaction. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_locks_per_transaction")

    @max_locks_per_transaction.setter
    def max_locks_per_transaction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_locks_per_transaction", value)

    @_builtins.property
    @pulumi.getter(name="maxLogicalReplicationWorkers")
    def max_logical_replication_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        """
        return pulumi.get(self, "max_logical_replication_workers")

    @max_logical_replication_workers.setter
    def max_logical_replication_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_logical_replication_workers", value)

    @_builtins.property
    @pulumi.getter(name="maxParallelWorkers")
    def max_parallel_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of workers that the system can support for parallel queries.
        """
        return pulumi.get(self, "max_parallel_workers")

    @max_parallel_workers.setter
    def max_parallel_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_parallel_workers", value)

    @_builtins.property
    @pulumi.getter(name="maxParallelWorkersPerGather")
    def max_parallel_workers_per_gather(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        """
        return pulumi.get(self, "max_parallel_workers_per_gather")

    @max_parallel_workers_per_gather.setter
    def max_parallel_workers_per_gather(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_parallel_workers_per_gather", value)

    @_builtins.property
    @pulumi.getter(name="maxPredLocksPerTransaction")
    def max_pred_locks_per_transaction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum predicate locks per transaction.
        """
        return pulumi.get(self, "max_pred_locks_per_transaction")

    @max_pred_locks_per_transaction.setter
    def max_pred_locks_per_transaction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_pred_locks_per_transaction", value)

    @_builtins.property
    @pulumi.getter(name="maxPreparedTransactions")
    def max_prepared_transactions(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum prepared transactions. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_prepared_transactions")

    @max_prepared_transactions.setter
    def max_prepared_transactions(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_prepared_transactions", value)

    @_builtins.property
    @pulumi.getter(name="maxReplicationSlots")
    def max_replication_slots(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum replication slots.
        """
        return pulumi.get(self, "max_replication_slots")

    @max_replication_slots.setter
    def max_replication_slots(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_replication_slots", value)

    @_builtins.property
    @pulumi.getter(name="maxStackDepth")
    def max_stack_depth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum depth of the stack in bytes.
        """
        return pulumi.get(self, "max_stack_depth")

    @max_stack_depth.setter
    def max_stack_depth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_stack_depth", value)

    @_builtins.property
    @pulumi.getter(name="maxStandbyArchiveDelay")
    def max_standby_archive_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Max standby archive delay in milliseconds.
        """
        return pulumi.get(self, "max_standby_archive_delay")

    @max_standby_archive_delay.setter
    def max_standby_archive_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_standby_archive_delay", value)

    @_builtins.property
    @pulumi.getter(name="maxStandbyStreamingDelay")
    def max_standby_streaming_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Max standby streaming delay in milliseconds.
        """
        return pulumi.get(self, "max_standby_streaming_delay")

    @max_standby_streaming_delay.setter
    def max_standby_streaming_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_standby_streaming_delay", value)

    @_builtins.property
    @pulumi.getter(name="maxWalSenders")
    def max_wal_senders(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum WAL senders. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_wal_senders")

    @max_wal_senders.setter
    def max_wal_senders(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_wal_senders", value)

    @_builtins.property
    @pulumi.getter(name="maxWorkerProcesses")
    def max_worker_processes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of background processes that the system can support. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_worker_processes")

    @max_worker_processes.setter
    def max_worker_processes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_worker_processes", value)

    @_builtins.property
    @pulumi.getter(name="pgPartmanBgwInterval")
    def pg_partman_bgw_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the time interval to run pg_partman's scheduled tasks.
        """
        return pulumi.get(self, "pg_partman_bgw_interval")

    @pg_partman_bgw_interval.setter
    def pg_partman_bgw_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pg_partman_bgw_interval", value)

    @_builtins.property
    @pulumi.getter(name="pgPartmanBgwRole")
    def pg_partman_bgw_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls which role to use for pg_partman's scheduled background tasks. Must consist of alpha-numeric characters, dots, underscores, or dashes. May not start with dash or dot. Maximum of 64 characters.
        """
        return pulumi.get(self, "pg_partman_bgw_role")

    @pg_partman_bgw_role.setter
    def pg_partman_bgw_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pg_partman_bgw_role", value)

    @_builtins.property
    @pulumi.getter(name="pgStatStatementsTrack")
    def pg_stat_statements_track(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls which statements are counted. Specify 'top' to track top-level statements (those issued directly by clients), 'all' to also track nested statements (such as statements invoked within functions), or 'none' to disable statement statistics collection. The default value is top. Supported values are: `all`, `top`, `none`.
        """
        return pulumi.get(self, "pg_stat_statements_track")

    @pg_stat_statements_track.setter
    def pg_stat_statements_track(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pg_stat_statements_track", value)

    @_builtins.property
    @pulumi.getter
    def pgbouncers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigPgbouncerArgs']]]]:
        """
        PGBouncer connection pooling settings
        """
        return pulumi.get(self, "pgbouncers")

    @pgbouncers.setter
    def pgbouncers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigPgbouncerArgs']]]]):
        pulumi.set(self, "pgbouncers", value)

    @_builtins.property
    @pulumi.getter(name="sharedBuffersPercentage")
    def shared_buffers_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        """
        return pulumi.get(self, "shared_buffers_percentage")

    @shared_buffers_percentage.setter
    def shared_buffers_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "shared_buffers_percentage", value)

    @_builtins.property
    @pulumi.getter(name="tempFileLimit")
    def temp_file_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL temporary file limit in KiB. If -1, sets to unlimited.
        """
        return pulumi.get(self, "temp_file_limit")

    @temp_file_limit.setter
    def temp_file_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "temp_file_limit", value)

    @_builtins.property
    @pulumi.getter
    def timescaledbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigTimescaledbArgs']]]]:
        """
        TimescaleDB extension configuration values
        """
        return pulumi.get(self, "timescaledbs")

    @timescaledbs.setter
    def timescaledbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigTimescaledbArgs']]]]):
        pulumi.set(self, "timescaledbs", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PostgreSQL service timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="trackActivityQuerySize")
    def track_activity_query_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of bytes reserved to track the currently executing command for each active session.
        """
        return pulumi.get(self, "track_activity_query_size")

    @track_activity_query_size.setter
    def track_activity_query_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "track_activity_query_size", value)

    @_builtins.property
    @pulumi.getter(name="trackCommitTimestamp")
    def track_commit_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record commit time of transactions. The default value is top. Supported values are: `off`, `on`.
        """
        return pulumi.get(self, "track_commit_timestamp")

    @track_commit_timestamp.setter
    def track_commit_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "track_commit_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="trackFunctions")
    def track_functions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables tracking of function call counts and time used. The default value is top. Supported values are: `all`, `pl`, `none`.
        """
        return pulumi.get(self, "track_functions")

    @track_functions.setter
    def track_functions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "track_functions", value)

    @_builtins.property
    @pulumi.getter(name="trackIoTiming")
    def track_io_timing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms. The default value is top. Supported values are: `off`, `on`.
        """
        return pulumi.get(self, "track_io_timing")

    @track_io_timing.setter
    def track_io_timing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "track_io_timing", value)

    @_builtins.property
    @pulumi.getter(name="walSenderTimeout")
    def wal_sender_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout. Must be either 0 or between 5000 and 10800000.
        """
        return pulumi.get(self, "wal_sender_timeout")

    @wal_sender_timeout.setter
    def wal_sender_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wal_sender_timeout", value)

    @_builtins.property
    @pulumi.getter(name="walWriterDelay")
    def wal_writer_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance
        """
        return pulumi.get(self, "wal_writer_delay")

    @wal_writer_delay.setter
    def wal_writer_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wal_writer_delay", value)

    @_builtins.property
    @pulumi.getter(name="workMem")
    def work_mem(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of memory, in MB, used by a query operation (such as a sort or hash table) before writing to temporary disk files. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        return pulumi.get(self, "work_mem")

    @work_mem.setter
    def work_mem(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "work_mem", value)


@pulumi.input_type
class _DatabasePostgresqlConfigState:
    def __init__(__self__, *,
                 autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_freeze_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 jit: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_autovacuum_min_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 log_error_verbosity: Optional[pulumi.Input[_builtins.str]] = None,
                 log_line_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 log_min_duration_statement: Optional[pulumi.Input[_builtins.int]] = None,
                 max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
                 max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 max_prepared_transactions: Optional[pulumi.Input[_builtins.int]] = None,
                 max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
                 max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
                 max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
                 pgbouncers: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigPgbouncerArgs']]]] = None,
                 shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 timescaledbs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigTimescaledbArgs']]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
                 track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 track_functions: Optional[pulumi.Input[_builtins.str]] = None,
                 track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
                 wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 work_mem: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DatabasePostgresqlConfig resources.
        :param pulumi.Input[_builtins.float] autovacuum_analyze_scale_factor: Specifies a fraction, in a decimal value, of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size).
        :param pulumi.Input[_builtins.int] autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated, or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] autovacuum_freeze_max_age: Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. Note that the system will launch autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. This parameter will cause the server to be restarted.
        :param pulumi.Input[_builtins.int] autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        :param pulumi.Input[_builtins.int] autovacuum_naptime: Specifies the minimum delay, in seconds, between autovacuum runs on any given database. The default is one minute.
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_cost_delay: Specifies the cost delay value, in milliseconds, that will be used in automatic VACUUM operations. If -1, uses the regular vacuum_cost_delay value, which is 20 milliseconds.
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        :param pulumi.Input[_builtins.float] autovacuum_vacuum_scale_factor: Specifies a fraction, in a decimal value, of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size).
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] backup_hour: The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] backup_minute: The minute of the backup hour when backup for the service starts. New backup is only started if previous backup has already completed.
        :param pulumi.Input[_builtins.int] bgwriter_delay: Specifies the delay, in milliseconds, between activity rounds for the background writer. Default is 200 ms.
        :param pulumi.Input[_builtins.int] bgwriter_flush_after: The amount of kilobytes that need to be written by the background writer before attempting to force the OS to issue these writes to underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        :param pulumi.Input[_builtins.int] bgwriter_lru_maxpages: The maximum number of buffers that the background writer can write. Setting this to zero disables background writing. Default is 100.
        :param pulumi.Input[_builtins.float] bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target PostgreSQL cluster.
        :param pulumi.Input[_builtins.int] deadlock_timeout: The amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        :param pulumi.Input[_builtins.str] default_toast_compression: Specifies the default TOAST compression method for values of compressible columns (the default is lz4). Supported values are: `lz4`, `pglz`.
        :param pulumi.Input[_builtins.int] idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds
        :param pulumi.Input[_builtins.bool] jit: Activates, in a boolean, the system-wide use of Just-in-Time Compilation (JIT).
        :param pulumi.Input[_builtins.int] log_autovacuum_min_duration: Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one (the default) disables logging autovacuum actions.
        :param pulumi.Input[_builtins.str] log_error_verbosity: Controls the amount of detail written in the server log for each message that is logged. Supported values are: `TERSE`, `DEFAULT`, `VERBOSE`.
        :param pulumi.Input[_builtins.str] log_line_prefix: Selects one of the available log-formats. These can support popular log analyzers like pgbadger, pganalyze, etc. Supported values are: `pid=%p,user=%u,db=%d,app=%a,client=%h`, `%m [%p] %q[user=%u,db=%d,app=%a]`, `%t [%p]: [%l-1] user=%u,db=%d,app=%a,client=%h`.
        :param pulumi.Input[_builtins.int] log_min_duration_statement: Log statements that take more than this number of milliseconds to run. If -1, disables.
        :param pulumi.Input[_builtins.int] max_files_per_process: PostgreSQL maximum number of files that can be open per process.
        :param pulumi.Input[_builtins.int] max_locks_per_transaction: PostgreSQL maximum locks per transaction. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        :param pulumi.Input[_builtins.int] max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries.
        :param pulumi.Input[_builtins.int] max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        :param pulumi.Input[_builtins.int] max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction.
        :param pulumi.Input[_builtins.int] max_prepared_transactions: PostgreSQL maximum prepared transactions. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_replication_slots: PostgreSQL maximum replication slots.
        :param pulumi.Input[_builtins.int] max_stack_depth: Maximum depth of the stack in bytes.
        :param pulumi.Input[_builtins.int] max_standby_archive_delay: Max standby archive delay in milliseconds.
        :param pulumi.Input[_builtins.int] max_standby_streaming_delay: Max standby streaming delay in milliseconds.
        :param pulumi.Input[_builtins.int] max_wal_senders: PostgreSQL maximum WAL senders. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_worker_processes: Sets the maximum number of background processes that the system can support. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] pg_partman_bgw_interval: Sets the time interval to run pg_partman's scheduled tasks.
        :param pulumi.Input[_builtins.str] pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks. Must consist of alpha-numeric characters, dots, underscores, or dashes. May not start with dash or dot. Maximum of 64 characters.
        :param pulumi.Input[_builtins.str] pg_stat_statements_track: Controls which statements are counted. Specify 'top' to track top-level statements (those issued directly by clients), 'all' to also track nested statements (such as statements invoked within functions), or 'none' to disable statement statistics collection. The default value is top. Supported values are: `all`, `top`, `none`.
        :param pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigPgbouncerArgs']]] pgbouncers: PGBouncer connection pooling settings
        :param pulumi.Input[_builtins.float] shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        :param pulumi.Input[_builtins.int] temp_file_limit: PostgreSQL temporary file limit in KiB. If -1, sets to unlimited.
        :param pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigTimescaledbArgs']]] timescaledbs: TimescaleDB extension configuration values
        :param pulumi.Input[_builtins.str] timezone: PostgreSQL service timezone
        :param pulumi.Input[_builtins.int] track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session.
        :param pulumi.Input[_builtins.str] track_commit_timestamp: Record commit time of transactions. The default value is top. Supported values are: `off`, `on`.
        :param pulumi.Input[_builtins.str] track_functions: Enables tracking of function call counts and time used. The default value is top. Supported values are: `all`, `pl`, `none`.
        :param pulumi.Input[_builtins.str] track_io_timing: Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms. The default value is top. Supported values are: `off`, `on`.
        :param pulumi.Input[_builtins.int] wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout. Must be either 0 or between 5000 and 10800000.
        :param pulumi.Input[_builtins.int] wal_writer_delay: WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance
        :param pulumi.Input[_builtins.int] work_mem: The maximum amount of memory, in MB, used by a query operation (such as a sort or hash table) before writing to temporary disk files. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        if autovacuum_analyze_scale_factor is not None:
            pulumi.set(__self__, "autovacuum_analyze_scale_factor", autovacuum_analyze_scale_factor)
        if autovacuum_analyze_threshold is not None:
            pulumi.set(__self__, "autovacuum_analyze_threshold", autovacuum_analyze_threshold)
        if autovacuum_freeze_max_age is not None:
            pulumi.set(__self__, "autovacuum_freeze_max_age", autovacuum_freeze_max_age)
        if autovacuum_max_workers is not None:
            pulumi.set(__self__, "autovacuum_max_workers", autovacuum_max_workers)
        if autovacuum_naptime is not None:
            pulumi.set(__self__, "autovacuum_naptime", autovacuum_naptime)
        if autovacuum_vacuum_cost_delay is not None:
            pulumi.set(__self__, "autovacuum_vacuum_cost_delay", autovacuum_vacuum_cost_delay)
        if autovacuum_vacuum_cost_limit is not None:
            pulumi.set(__self__, "autovacuum_vacuum_cost_limit", autovacuum_vacuum_cost_limit)
        if autovacuum_vacuum_scale_factor is not None:
            pulumi.set(__self__, "autovacuum_vacuum_scale_factor", autovacuum_vacuum_scale_factor)
        if autovacuum_vacuum_threshold is not None:
            pulumi.set(__self__, "autovacuum_vacuum_threshold", autovacuum_vacuum_threshold)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if bgwriter_delay is not None:
            pulumi.set(__self__, "bgwriter_delay", bgwriter_delay)
        if bgwriter_flush_after is not None:
            pulumi.set(__self__, "bgwriter_flush_after", bgwriter_flush_after)
        if bgwriter_lru_maxpages is not None:
            pulumi.set(__self__, "bgwriter_lru_maxpages", bgwriter_lru_maxpages)
        if bgwriter_lru_multiplier is not None:
            pulumi.set(__self__, "bgwriter_lru_multiplier", bgwriter_lru_multiplier)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if deadlock_timeout is not None:
            pulumi.set(__self__, "deadlock_timeout", deadlock_timeout)
        if default_toast_compression is not None:
            pulumi.set(__self__, "default_toast_compression", default_toast_compression)
        if idle_in_transaction_session_timeout is not None:
            pulumi.set(__self__, "idle_in_transaction_session_timeout", idle_in_transaction_session_timeout)
        if jit is not None:
            pulumi.set(__self__, "jit", jit)
        if log_autovacuum_min_duration is not None:
            pulumi.set(__self__, "log_autovacuum_min_duration", log_autovacuum_min_duration)
        if log_error_verbosity is not None:
            pulumi.set(__self__, "log_error_verbosity", log_error_verbosity)
        if log_line_prefix is not None:
            pulumi.set(__self__, "log_line_prefix", log_line_prefix)
        if log_min_duration_statement is not None:
            pulumi.set(__self__, "log_min_duration_statement", log_min_duration_statement)
        if max_files_per_process is not None:
            pulumi.set(__self__, "max_files_per_process", max_files_per_process)
        if max_locks_per_transaction is not None:
            pulumi.set(__self__, "max_locks_per_transaction", max_locks_per_transaction)
        if max_logical_replication_workers is not None:
            pulumi.set(__self__, "max_logical_replication_workers", max_logical_replication_workers)
        if max_parallel_workers is not None:
            pulumi.set(__self__, "max_parallel_workers", max_parallel_workers)
        if max_parallel_workers_per_gather is not None:
            pulumi.set(__self__, "max_parallel_workers_per_gather", max_parallel_workers_per_gather)
        if max_pred_locks_per_transaction is not None:
            pulumi.set(__self__, "max_pred_locks_per_transaction", max_pred_locks_per_transaction)
        if max_prepared_transactions is not None:
            pulumi.set(__self__, "max_prepared_transactions", max_prepared_transactions)
        if max_replication_slots is not None:
            pulumi.set(__self__, "max_replication_slots", max_replication_slots)
        if max_stack_depth is not None:
            pulumi.set(__self__, "max_stack_depth", max_stack_depth)
        if max_standby_archive_delay is not None:
            pulumi.set(__self__, "max_standby_archive_delay", max_standby_archive_delay)
        if max_standby_streaming_delay is not None:
            pulumi.set(__self__, "max_standby_streaming_delay", max_standby_streaming_delay)
        if max_wal_senders is not None:
            pulumi.set(__self__, "max_wal_senders", max_wal_senders)
        if max_worker_processes is not None:
            pulumi.set(__self__, "max_worker_processes", max_worker_processes)
        if pg_partman_bgw_interval is not None:
            pulumi.set(__self__, "pg_partman_bgw_interval", pg_partman_bgw_interval)
        if pg_partman_bgw_role is not None:
            pulumi.set(__self__, "pg_partman_bgw_role", pg_partman_bgw_role)
        if pg_stat_statements_track is not None:
            pulumi.set(__self__, "pg_stat_statements_track", pg_stat_statements_track)
        if pgbouncers is not None:
            pulumi.set(__self__, "pgbouncers", pgbouncers)
        if shared_buffers_percentage is not None:
            pulumi.set(__self__, "shared_buffers_percentage", shared_buffers_percentage)
        if temp_file_limit is not None:
            pulumi.set(__self__, "temp_file_limit", temp_file_limit)
        if timescaledbs is not None:
            pulumi.set(__self__, "timescaledbs", timescaledbs)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if track_activity_query_size is not None:
            pulumi.set(__self__, "track_activity_query_size", track_activity_query_size)
        if track_commit_timestamp is not None:
            pulumi.set(__self__, "track_commit_timestamp", track_commit_timestamp)
        if track_functions is not None:
            pulumi.set(__self__, "track_functions", track_functions)
        if track_io_timing is not None:
            pulumi.set(__self__, "track_io_timing", track_io_timing)
        if wal_sender_timeout is not None:
            pulumi.set(__self__, "wal_sender_timeout", wal_sender_timeout)
        if wal_writer_delay is not None:
            pulumi.set(__self__, "wal_writer_delay", wal_writer_delay)
        if work_mem is not None:
            pulumi.set(__self__, "work_mem", work_mem)

    @_builtins.property
    @pulumi.getter(name="autovacuumAnalyzeScaleFactor")
    def autovacuum_analyze_scale_factor(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies a fraction, in a decimal value, of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size).
        """
        return pulumi.get(self, "autovacuum_analyze_scale_factor")

    @autovacuum_analyze_scale_factor.setter
    def autovacuum_analyze_scale_factor(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "autovacuum_analyze_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumAnalyzeThreshold")
    def autovacuum_analyze_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of inserted, updated, or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "autovacuum_analyze_threshold")

    @autovacuum_analyze_threshold.setter
    def autovacuum_analyze_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_analyze_threshold", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumFreezeMaxAge")
    def autovacuum_freeze_max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. Note that the system will launch autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. This parameter will cause the server to be restarted.
        """
        return pulumi.get(self, "autovacuum_freeze_max_age")

    @autovacuum_freeze_max_age.setter
    def autovacuum_freeze_max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_freeze_max_age", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumMaxWorkers")
    def autovacuum_max_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        """
        return pulumi.get(self, "autovacuum_max_workers")

    @autovacuum_max_workers.setter
    def autovacuum_max_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_max_workers", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumNaptime")
    def autovacuum_naptime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum delay, in seconds, between autovacuum runs on any given database. The default is one minute.
        """
        return pulumi.get(self, "autovacuum_naptime")

    @autovacuum_naptime.setter
    def autovacuum_naptime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_naptime", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumCostDelay")
    def autovacuum_vacuum_cost_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cost delay value, in milliseconds, that will be used in automatic VACUUM operations. If -1, uses the regular vacuum_cost_delay value, which is 20 milliseconds.
        """
        return pulumi.get(self, "autovacuum_vacuum_cost_delay")

    @autovacuum_vacuum_cost_delay.setter
    def autovacuum_vacuum_cost_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_vacuum_cost_delay", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumCostLimit")
    def autovacuum_vacuum_cost_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        """
        return pulumi.get(self, "autovacuum_vacuum_cost_limit")

    @autovacuum_vacuum_cost_limit.setter
    def autovacuum_vacuum_cost_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_vacuum_cost_limit", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumScaleFactor")
    def autovacuum_vacuum_scale_factor(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies a fraction, in a decimal value, of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size).
        """
        return pulumi.get(self, "autovacuum_vacuum_scale_factor")

    @autovacuum_vacuum_scale_factor.setter
    def autovacuum_vacuum_scale_factor(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "autovacuum_vacuum_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumThreshold")
    def autovacuum_vacuum_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "autovacuum_vacuum_threshold")

    @autovacuum_vacuum_threshold.setter
    def autovacuum_vacuum_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autovacuum_vacuum_threshold", value)

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_hour", value)

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minute of the backup hour when backup for the service starts. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @backup_minute.setter
    def backup_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_minute", value)

    @_builtins.property
    @pulumi.getter(name="bgwriterDelay")
    def bgwriter_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the delay, in milliseconds, between activity rounds for the background writer. Default is 200 ms.
        """
        return pulumi.get(self, "bgwriter_delay")

    @bgwriter_delay.setter
    def bgwriter_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bgwriter_delay", value)

    @_builtins.property
    @pulumi.getter(name="bgwriterFlushAfter")
    def bgwriter_flush_after(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of kilobytes that need to be written by the background writer before attempting to force the OS to issue these writes to underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        """
        return pulumi.get(self, "bgwriter_flush_after")

    @bgwriter_flush_after.setter
    def bgwriter_flush_after(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bgwriter_flush_after", value)

    @_builtins.property
    @pulumi.getter(name="bgwriterLruMaxpages")
    def bgwriter_lru_maxpages(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of buffers that the background writer can write. Setting this to zero disables background writing. Default is 100.
        """
        return pulumi.get(self, "bgwriter_lru_maxpages")

    @bgwriter_lru_maxpages.setter
    def bgwriter_lru_maxpages(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bgwriter_lru_maxpages", value)

    @_builtins.property
    @pulumi.getter(name="bgwriterLruMultiplier")
    def bgwriter_lru_multiplier(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        """
        return pulumi.get(self, "bgwriter_lru_multiplier")

    @bgwriter_lru_multiplier.setter
    def bgwriter_lru_multiplier(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "bgwriter_lru_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the target PostgreSQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="deadlockTimeout")
    def deadlock_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        """
        return pulumi.get(self, "deadlock_timeout")

    @deadlock_timeout.setter
    def deadlock_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deadlock_timeout", value)

    @_builtins.property
    @pulumi.getter(name="defaultToastCompression")
    def default_toast_compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default TOAST compression method for values of compressible columns (the default is lz4). Supported values are: `lz4`, `pglz`.
        """
        return pulumi.get(self, "default_toast_compression")

    @default_toast_compression.setter
    def default_toast_compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_toast_compression", value)

    @_builtins.property
    @pulumi.getter(name="idleInTransactionSessionTimeout")
    def idle_in_transaction_session_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time out sessions with open transactions after this number of milliseconds
        """
        return pulumi.get(self, "idle_in_transaction_session_timeout")

    @idle_in_transaction_session_timeout.setter
    def idle_in_transaction_session_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_in_transaction_session_timeout", value)

    @_builtins.property
    @pulumi.getter
    def jit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activates, in a boolean, the system-wide use of Just-in-Time Compilation (JIT).
        """
        return pulumi.get(self, "jit")

    @jit.setter
    def jit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "jit", value)

    @_builtins.property
    @pulumi.getter(name="logAutovacuumMinDuration")
    def log_autovacuum_min_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one (the default) disables logging autovacuum actions.
        """
        return pulumi.get(self, "log_autovacuum_min_duration")

    @log_autovacuum_min_duration.setter
    def log_autovacuum_min_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_autovacuum_min_duration", value)

    @_builtins.property
    @pulumi.getter(name="logErrorVerbosity")
    def log_error_verbosity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the amount of detail written in the server log for each message that is logged. Supported values are: `TERSE`, `DEFAULT`, `VERBOSE`.
        """
        return pulumi.get(self, "log_error_verbosity")

    @log_error_verbosity.setter
    def log_error_verbosity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_error_verbosity", value)

    @_builtins.property
    @pulumi.getter(name="logLinePrefix")
    def log_line_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Selects one of the available log-formats. These can support popular log analyzers like pgbadger, pganalyze, etc. Supported values are: `pid=%p,user=%u,db=%d,app=%a,client=%h`, `%m [%p] %q[user=%u,db=%d,app=%a]`, `%t [%p]: [%l-1] user=%u,db=%d,app=%a,client=%h`.
        """
        return pulumi.get(self, "log_line_prefix")

    @log_line_prefix.setter
    def log_line_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_line_prefix", value)

    @_builtins.property
    @pulumi.getter(name="logMinDurationStatement")
    def log_min_duration_statement(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Log statements that take more than this number of milliseconds to run. If -1, disables.
        """
        return pulumi.get(self, "log_min_duration_statement")

    @log_min_duration_statement.setter
    def log_min_duration_statement(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_min_duration_statement", value)

    @_builtins.property
    @pulumi.getter(name="maxFilesPerProcess")
    def max_files_per_process(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum number of files that can be open per process.
        """
        return pulumi.get(self, "max_files_per_process")

    @max_files_per_process.setter
    def max_files_per_process(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_files_per_process", value)

    @_builtins.property
    @pulumi.getter(name="maxLocksPerTransaction")
    def max_locks_per_transaction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum locks per transaction. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_locks_per_transaction")

    @max_locks_per_transaction.setter
    def max_locks_per_transaction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_locks_per_transaction", value)

    @_builtins.property
    @pulumi.getter(name="maxLogicalReplicationWorkers")
    def max_logical_replication_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        """
        return pulumi.get(self, "max_logical_replication_workers")

    @max_logical_replication_workers.setter
    def max_logical_replication_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_logical_replication_workers", value)

    @_builtins.property
    @pulumi.getter(name="maxParallelWorkers")
    def max_parallel_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of workers that the system can support for parallel queries.
        """
        return pulumi.get(self, "max_parallel_workers")

    @max_parallel_workers.setter
    def max_parallel_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_parallel_workers", value)

    @_builtins.property
    @pulumi.getter(name="maxParallelWorkersPerGather")
    def max_parallel_workers_per_gather(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        """
        return pulumi.get(self, "max_parallel_workers_per_gather")

    @max_parallel_workers_per_gather.setter
    def max_parallel_workers_per_gather(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_parallel_workers_per_gather", value)

    @_builtins.property
    @pulumi.getter(name="maxPredLocksPerTransaction")
    def max_pred_locks_per_transaction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum predicate locks per transaction.
        """
        return pulumi.get(self, "max_pred_locks_per_transaction")

    @max_pred_locks_per_transaction.setter
    def max_pred_locks_per_transaction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_pred_locks_per_transaction", value)

    @_builtins.property
    @pulumi.getter(name="maxPreparedTransactions")
    def max_prepared_transactions(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum prepared transactions. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_prepared_transactions")

    @max_prepared_transactions.setter
    def max_prepared_transactions(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_prepared_transactions", value)

    @_builtins.property
    @pulumi.getter(name="maxReplicationSlots")
    def max_replication_slots(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum replication slots.
        """
        return pulumi.get(self, "max_replication_slots")

    @max_replication_slots.setter
    def max_replication_slots(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_replication_slots", value)

    @_builtins.property
    @pulumi.getter(name="maxStackDepth")
    def max_stack_depth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum depth of the stack in bytes.
        """
        return pulumi.get(self, "max_stack_depth")

    @max_stack_depth.setter
    def max_stack_depth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_stack_depth", value)

    @_builtins.property
    @pulumi.getter(name="maxStandbyArchiveDelay")
    def max_standby_archive_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Max standby archive delay in milliseconds.
        """
        return pulumi.get(self, "max_standby_archive_delay")

    @max_standby_archive_delay.setter
    def max_standby_archive_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_standby_archive_delay", value)

    @_builtins.property
    @pulumi.getter(name="maxStandbyStreamingDelay")
    def max_standby_streaming_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Max standby streaming delay in milliseconds.
        """
        return pulumi.get(self, "max_standby_streaming_delay")

    @max_standby_streaming_delay.setter
    def max_standby_streaming_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_standby_streaming_delay", value)

    @_builtins.property
    @pulumi.getter(name="maxWalSenders")
    def max_wal_senders(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum WAL senders. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_wal_senders")

    @max_wal_senders.setter
    def max_wal_senders(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_wal_senders", value)

    @_builtins.property
    @pulumi.getter(name="maxWorkerProcesses")
    def max_worker_processes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of background processes that the system can support. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_worker_processes")

    @max_worker_processes.setter
    def max_worker_processes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_worker_processes", value)

    @_builtins.property
    @pulumi.getter(name="pgPartmanBgwInterval")
    def pg_partman_bgw_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the time interval to run pg_partman's scheduled tasks.
        """
        return pulumi.get(self, "pg_partman_bgw_interval")

    @pg_partman_bgw_interval.setter
    def pg_partman_bgw_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pg_partman_bgw_interval", value)

    @_builtins.property
    @pulumi.getter(name="pgPartmanBgwRole")
    def pg_partman_bgw_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls which role to use for pg_partman's scheduled background tasks. Must consist of alpha-numeric characters, dots, underscores, or dashes. May not start with dash or dot. Maximum of 64 characters.
        """
        return pulumi.get(self, "pg_partman_bgw_role")

    @pg_partman_bgw_role.setter
    def pg_partman_bgw_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pg_partman_bgw_role", value)

    @_builtins.property
    @pulumi.getter(name="pgStatStatementsTrack")
    def pg_stat_statements_track(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls which statements are counted. Specify 'top' to track top-level statements (those issued directly by clients), 'all' to also track nested statements (such as statements invoked within functions), or 'none' to disable statement statistics collection. The default value is top. Supported values are: `all`, `top`, `none`.
        """
        return pulumi.get(self, "pg_stat_statements_track")

    @pg_stat_statements_track.setter
    def pg_stat_statements_track(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pg_stat_statements_track", value)

    @_builtins.property
    @pulumi.getter
    def pgbouncers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigPgbouncerArgs']]]]:
        """
        PGBouncer connection pooling settings
        """
        return pulumi.get(self, "pgbouncers")

    @pgbouncers.setter
    def pgbouncers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigPgbouncerArgs']]]]):
        pulumi.set(self, "pgbouncers", value)

    @_builtins.property
    @pulumi.getter(name="sharedBuffersPercentage")
    def shared_buffers_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        """
        return pulumi.get(self, "shared_buffers_percentage")

    @shared_buffers_percentage.setter
    def shared_buffers_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "shared_buffers_percentage", value)

    @_builtins.property
    @pulumi.getter(name="tempFileLimit")
    def temp_file_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL temporary file limit in KiB. If -1, sets to unlimited.
        """
        return pulumi.get(self, "temp_file_limit")

    @temp_file_limit.setter
    def temp_file_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "temp_file_limit", value)

    @_builtins.property
    @pulumi.getter
    def timescaledbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigTimescaledbArgs']]]]:
        """
        TimescaleDB extension configuration values
        """
        return pulumi.get(self, "timescaledbs")

    @timescaledbs.setter
    def timescaledbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlConfigTimescaledbArgs']]]]):
        pulumi.set(self, "timescaledbs", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PostgreSQL service timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="trackActivityQuerySize")
    def track_activity_query_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of bytes reserved to track the currently executing command for each active session.
        """
        return pulumi.get(self, "track_activity_query_size")

    @track_activity_query_size.setter
    def track_activity_query_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "track_activity_query_size", value)

    @_builtins.property
    @pulumi.getter(name="trackCommitTimestamp")
    def track_commit_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record commit time of transactions. The default value is top. Supported values are: `off`, `on`.
        """
        return pulumi.get(self, "track_commit_timestamp")

    @track_commit_timestamp.setter
    def track_commit_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "track_commit_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="trackFunctions")
    def track_functions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables tracking of function call counts and time used. The default value is top. Supported values are: `all`, `pl`, `none`.
        """
        return pulumi.get(self, "track_functions")

    @track_functions.setter
    def track_functions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "track_functions", value)

    @_builtins.property
    @pulumi.getter(name="trackIoTiming")
    def track_io_timing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms. The default value is top. Supported values are: `off`, `on`.
        """
        return pulumi.get(self, "track_io_timing")

    @track_io_timing.setter
    def track_io_timing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "track_io_timing", value)

    @_builtins.property
    @pulumi.getter(name="walSenderTimeout")
    def wal_sender_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout. Must be either 0 or between 5000 and 10800000.
        """
        return pulumi.get(self, "wal_sender_timeout")

    @wal_sender_timeout.setter
    def wal_sender_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wal_sender_timeout", value)

    @_builtins.property
    @pulumi.getter(name="walWriterDelay")
    def wal_writer_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance
        """
        return pulumi.get(self, "wal_writer_delay")

    @wal_writer_delay.setter
    def wal_writer_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wal_writer_delay", value)

    @_builtins.property
    @pulumi.getter(name="workMem")
    def work_mem(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of memory, in MB, used by a query operation (such as a sort or hash table) before writing to temporary disk files. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        return pulumi.get(self, "work_mem")

    @work_mem.setter
    def work_mem(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "work_mem", value)


@pulumi.type_token("digitalocean:index/databasePostgresqlConfig:DatabasePostgresqlConfig")
class DatabasePostgresqlConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_freeze_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 jit: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_autovacuum_min_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 log_error_verbosity: Optional[pulumi.Input[_builtins.str]] = None,
                 log_line_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 log_min_duration_statement: Optional[pulumi.Input[_builtins.int]] = None,
                 max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
                 max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 max_prepared_transactions: Optional[pulumi.Input[_builtins.int]] = None,
                 max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
                 max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
                 max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
                 pgbouncers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigPgbouncerArgs', 'DatabasePostgresqlConfigPgbouncerArgsDict']]]]] = None,
                 shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 timescaledbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigTimescaledbArgs', 'DatabasePostgresqlConfigTimescaledbArgsDict']]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
                 track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 track_functions: Optional[pulumi.Input[_builtins.str]] = None,
                 track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
                 wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 work_mem: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a virtual resource that can be used to change advanced configuration
        options for a DigitalOcean managed PostgreSQL database cluster.

        > **Note** PostgreSQL configurations are only removed from state when destroyed. The remote configuration is not unset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example_database_cluster = digitalocean.DatabaseCluster("example",
            name="example-postgresql-cluster",
            engine="pg",
            version="15",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        example = digitalocean.DatabasePostgresqlConfig("example",
            cluster_id=example_database_cluster.id,
            timezone="UTC",
            work_mem=16)
        ```

        ## Import

        A PostgreSQL database cluster's configuration can be imported using the `id` the parent cluster, e.g.

        bash

        ```sh
        $ pulumi import digitalocean:index/databasePostgresqlConfig:DatabasePostgresqlConfig example 52556c07-788e-4d41-b8a7-c796432197d1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] autovacuum_analyze_scale_factor: Specifies a fraction, in a decimal value, of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size).
        :param pulumi.Input[_builtins.int] autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated, or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] autovacuum_freeze_max_age: Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. Note that the system will launch autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. This parameter will cause the server to be restarted.
        :param pulumi.Input[_builtins.int] autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        :param pulumi.Input[_builtins.int] autovacuum_naptime: Specifies the minimum delay, in seconds, between autovacuum runs on any given database. The default is one minute.
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_cost_delay: Specifies the cost delay value, in milliseconds, that will be used in automatic VACUUM operations. If -1, uses the regular vacuum_cost_delay value, which is 20 milliseconds.
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        :param pulumi.Input[_builtins.float] autovacuum_vacuum_scale_factor: Specifies a fraction, in a decimal value, of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size).
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] backup_hour: The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] backup_minute: The minute of the backup hour when backup for the service starts. New backup is only started if previous backup has already completed.
        :param pulumi.Input[_builtins.int] bgwriter_delay: Specifies the delay, in milliseconds, between activity rounds for the background writer. Default is 200 ms.
        :param pulumi.Input[_builtins.int] bgwriter_flush_after: The amount of kilobytes that need to be written by the background writer before attempting to force the OS to issue these writes to underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        :param pulumi.Input[_builtins.int] bgwriter_lru_maxpages: The maximum number of buffers that the background writer can write. Setting this to zero disables background writing. Default is 100.
        :param pulumi.Input[_builtins.float] bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target PostgreSQL cluster.
        :param pulumi.Input[_builtins.int] deadlock_timeout: The amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        :param pulumi.Input[_builtins.str] default_toast_compression: Specifies the default TOAST compression method for values of compressible columns (the default is lz4). Supported values are: `lz4`, `pglz`.
        :param pulumi.Input[_builtins.int] idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds
        :param pulumi.Input[_builtins.bool] jit: Activates, in a boolean, the system-wide use of Just-in-Time Compilation (JIT).
        :param pulumi.Input[_builtins.int] log_autovacuum_min_duration: Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one (the default) disables logging autovacuum actions.
        :param pulumi.Input[_builtins.str] log_error_verbosity: Controls the amount of detail written in the server log for each message that is logged. Supported values are: `TERSE`, `DEFAULT`, `VERBOSE`.
        :param pulumi.Input[_builtins.str] log_line_prefix: Selects one of the available log-formats. These can support popular log analyzers like pgbadger, pganalyze, etc. Supported values are: `pid=%p,user=%u,db=%d,app=%a,client=%h`, `%m [%p] %q[user=%u,db=%d,app=%a]`, `%t [%p]: [%l-1] user=%u,db=%d,app=%a,client=%h`.
        :param pulumi.Input[_builtins.int] log_min_duration_statement: Log statements that take more than this number of milliseconds to run. If -1, disables.
        :param pulumi.Input[_builtins.int] max_files_per_process: PostgreSQL maximum number of files that can be open per process.
        :param pulumi.Input[_builtins.int] max_locks_per_transaction: PostgreSQL maximum locks per transaction. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        :param pulumi.Input[_builtins.int] max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries.
        :param pulumi.Input[_builtins.int] max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        :param pulumi.Input[_builtins.int] max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction.
        :param pulumi.Input[_builtins.int] max_prepared_transactions: PostgreSQL maximum prepared transactions. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_replication_slots: PostgreSQL maximum replication slots.
        :param pulumi.Input[_builtins.int] max_stack_depth: Maximum depth of the stack in bytes.
        :param pulumi.Input[_builtins.int] max_standby_archive_delay: Max standby archive delay in milliseconds.
        :param pulumi.Input[_builtins.int] max_standby_streaming_delay: Max standby streaming delay in milliseconds.
        :param pulumi.Input[_builtins.int] max_wal_senders: PostgreSQL maximum WAL senders. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_worker_processes: Sets the maximum number of background processes that the system can support. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] pg_partman_bgw_interval: Sets the time interval to run pg_partman's scheduled tasks.
        :param pulumi.Input[_builtins.str] pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks. Must consist of alpha-numeric characters, dots, underscores, or dashes. May not start with dash or dot. Maximum of 64 characters.
        :param pulumi.Input[_builtins.str] pg_stat_statements_track: Controls which statements are counted. Specify 'top' to track top-level statements (those issued directly by clients), 'all' to also track nested statements (such as statements invoked within functions), or 'none' to disable statement statistics collection. The default value is top. Supported values are: `all`, `top`, `none`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigPgbouncerArgs', 'DatabasePostgresqlConfigPgbouncerArgsDict']]]] pgbouncers: PGBouncer connection pooling settings
        :param pulumi.Input[_builtins.float] shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        :param pulumi.Input[_builtins.int] temp_file_limit: PostgreSQL temporary file limit in KiB. If -1, sets to unlimited.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigTimescaledbArgs', 'DatabasePostgresqlConfigTimescaledbArgsDict']]]] timescaledbs: TimescaleDB extension configuration values
        :param pulumi.Input[_builtins.str] timezone: PostgreSQL service timezone
        :param pulumi.Input[_builtins.int] track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session.
        :param pulumi.Input[_builtins.str] track_commit_timestamp: Record commit time of transactions. The default value is top. Supported values are: `off`, `on`.
        :param pulumi.Input[_builtins.str] track_functions: Enables tracking of function call counts and time used. The default value is top. Supported values are: `all`, `pl`, `none`.
        :param pulumi.Input[_builtins.str] track_io_timing: Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms. The default value is top. Supported values are: `off`, `on`.
        :param pulumi.Input[_builtins.int] wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout. Must be either 0 or between 5000 and 10800000.
        :param pulumi.Input[_builtins.int] wal_writer_delay: WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance
        :param pulumi.Input[_builtins.int] work_mem: The maximum amount of memory, in MB, used by a query operation (such as a sort or hash table) before writing to temporary disk files. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabasePostgresqlConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a virtual resource that can be used to change advanced configuration
        options for a DigitalOcean managed PostgreSQL database cluster.

        > **Note** PostgreSQL configurations are only removed from state when destroyed. The remote configuration is not unset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example_database_cluster = digitalocean.DatabaseCluster("example",
            name="example-postgresql-cluster",
            engine="pg",
            version="15",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC1,
            node_count=1)
        example = digitalocean.DatabasePostgresqlConfig("example",
            cluster_id=example_database_cluster.id,
            timezone="UTC",
            work_mem=16)
        ```

        ## Import

        A PostgreSQL database cluster's configuration can be imported using the `id` the parent cluster, e.g.

        bash

        ```sh
        $ pulumi import digitalocean:index/databasePostgresqlConfig:DatabasePostgresqlConfig example 52556c07-788e-4d41-b8a7-c796432197d1
        ```

        :param str resource_name: The name of the resource.
        :param DatabasePostgresqlConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabasePostgresqlConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_freeze_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
                 bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 jit: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_autovacuum_min_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 log_error_verbosity: Optional[pulumi.Input[_builtins.str]] = None,
                 log_line_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 log_min_duration_statement: Optional[pulumi.Input[_builtins.int]] = None,
                 max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
                 max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 max_prepared_transactions: Optional[pulumi.Input[_builtins.int]] = None,
                 max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
                 max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
                 max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
                 pgbouncers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigPgbouncerArgs', 'DatabasePostgresqlConfigPgbouncerArgsDict']]]]] = None,
                 shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 timescaledbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigTimescaledbArgs', 'DatabasePostgresqlConfigTimescaledbArgsDict']]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
                 track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 track_functions: Optional[pulumi.Input[_builtins.str]] = None,
                 track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
                 wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 work_mem: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabasePostgresqlConfigArgs.__new__(DatabasePostgresqlConfigArgs)

            __props__.__dict__["autovacuum_analyze_scale_factor"] = autovacuum_analyze_scale_factor
            __props__.__dict__["autovacuum_analyze_threshold"] = autovacuum_analyze_threshold
            __props__.__dict__["autovacuum_freeze_max_age"] = autovacuum_freeze_max_age
            __props__.__dict__["autovacuum_max_workers"] = autovacuum_max_workers
            __props__.__dict__["autovacuum_naptime"] = autovacuum_naptime
            __props__.__dict__["autovacuum_vacuum_cost_delay"] = autovacuum_vacuum_cost_delay
            __props__.__dict__["autovacuum_vacuum_cost_limit"] = autovacuum_vacuum_cost_limit
            __props__.__dict__["autovacuum_vacuum_scale_factor"] = autovacuum_vacuum_scale_factor
            __props__.__dict__["autovacuum_vacuum_threshold"] = autovacuum_vacuum_threshold
            __props__.__dict__["backup_hour"] = backup_hour
            __props__.__dict__["backup_minute"] = backup_minute
            __props__.__dict__["bgwriter_delay"] = bgwriter_delay
            __props__.__dict__["bgwriter_flush_after"] = bgwriter_flush_after
            __props__.__dict__["bgwriter_lru_maxpages"] = bgwriter_lru_maxpages
            __props__.__dict__["bgwriter_lru_multiplier"] = bgwriter_lru_multiplier
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["deadlock_timeout"] = deadlock_timeout
            __props__.__dict__["default_toast_compression"] = default_toast_compression
            __props__.__dict__["idle_in_transaction_session_timeout"] = idle_in_transaction_session_timeout
            __props__.__dict__["jit"] = jit
            __props__.__dict__["log_autovacuum_min_duration"] = log_autovacuum_min_duration
            __props__.__dict__["log_error_verbosity"] = log_error_verbosity
            __props__.__dict__["log_line_prefix"] = log_line_prefix
            __props__.__dict__["log_min_duration_statement"] = log_min_duration_statement
            __props__.__dict__["max_files_per_process"] = max_files_per_process
            __props__.__dict__["max_locks_per_transaction"] = max_locks_per_transaction
            __props__.__dict__["max_logical_replication_workers"] = max_logical_replication_workers
            __props__.__dict__["max_parallel_workers"] = max_parallel_workers
            __props__.__dict__["max_parallel_workers_per_gather"] = max_parallel_workers_per_gather
            __props__.__dict__["max_pred_locks_per_transaction"] = max_pred_locks_per_transaction
            __props__.__dict__["max_prepared_transactions"] = max_prepared_transactions
            __props__.__dict__["max_replication_slots"] = max_replication_slots
            __props__.__dict__["max_stack_depth"] = max_stack_depth
            __props__.__dict__["max_standby_archive_delay"] = max_standby_archive_delay
            __props__.__dict__["max_standby_streaming_delay"] = max_standby_streaming_delay
            __props__.__dict__["max_wal_senders"] = max_wal_senders
            __props__.__dict__["max_worker_processes"] = max_worker_processes
            __props__.__dict__["pg_partman_bgw_interval"] = pg_partman_bgw_interval
            __props__.__dict__["pg_partman_bgw_role"] = pg_partman_bgw_role
            __props__.__dict__["pg_stat_statements_track"] = pg_stat_statements_track
            __props__.__dict__["pgbouncers"] = pgbouncers
            __props__.__dict__["shared_buffers_percentage"] = shared_buffers_percentage
            __props__.__dict__["temp_file_limit"] = temp_file_limit
            __props__.__dict__["timescaledbs"] = timescaledbs
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["track_activity_query_size"] = track_activity_query_size
            __props__.__dict__["track_commit_timestamp"] = track_commit_timestamp
            __props__.__dict__["track_functions"] = track_functions
            __props__.__dict__["track_io_timing"] = track_io_timing
            __props__.__dict__["wal_sender_timeout"] = wal_sender_timeout
            __props__.__dict__["wal_writer_delay"] = wal_writer_delay
            __props__.__dict__["work_mem"] = work_mem
        super(DatabasePostgresqlConfig, __self__).__init__(
            'digitalocean:index/databasePostgresqlConfig:DatabasePostgresqlConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
            autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            autovacuum_freeze_max_age: Optional[pulumi.Input[_builtins.int]] = None,
            autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
            autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
            autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
            autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
            autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
            autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            backup_hour: Optional[pulumi.Input[_builtins.int]] = None,
            backup_minute: Optional[pulumi.Input[_builtins.int]] = None,
            bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
            bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
            bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
            bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
            idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            jit: Optional[pulumi.Input[_builtins.bool]] = None,
            log_autovacuum_min_duration: Optional[pulumi.Input[_builtins.int]] = None,
            log_error_verbosity: Optional[pulumi.Input[_builtins.str]] = None,
            log_line_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            log_min_duration_statement: Optional[pulumi.Input[_builtins.int]] = None,
            max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
            max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
            max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
            max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
            max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
            max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
            max_prepared_transactions: Optional[pulumi.Input[_builtins.int]] = None,
            max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
            max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
            max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
            max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
            max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
            max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
            pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
            pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
            pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
            pgbouncers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigPgbouncerArgs', 'DatabasePostgresqlConfigPgbouncerArgsDict']]]]] = None,
            shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
            timescaledbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigTimescaledbArgs', 'DatabasePostgresqlConfigTimescaledbArgsDict']]]]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
            track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            track_functions: Optional[pulumi.Input[_builtins.str]] = None,
            track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
            wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
            work_mem: Optional[pulumi.Input[_builtins.int]] = None) -> 'DatabasePostgresqlConfig':
        """
        Get an existing DatabasePostgresqlConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] autovacuum_analyze_scale_factor: Specifies a fraction, in a decimal value, of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size).
        :param pulumi.Input[_builtins.int] autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated, or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] autovacuum_freeze_max_age: Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. Note that the system will launch autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. This parameter will cause the server to be restarted.
        :param pulumi.Input[_builtins.int] autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        :param pulumi.Input[_builtins.int] autovacuum_naptime: Specifies the minimum delay, in seconds, between autovacuum runs on any given database. The default is one minute.
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_cost_delay: Specifies the cost delay value, in milliseconds, that will be used in automatic VACUUM operations. If -1, uses the regular vacuum_cost_delay value, which is 20 milliseconds.
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        :param pulumi.Input[_builtins.float] autovacuum_vacuum_scale_factor: Specifies a fraction, in a decimal value, of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size).
        :param pulumi.Input[_builtins.int] autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] backup_hour: The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        :param pulumi.Input[_builtins.int] backup_minute: The minute of the backup hour when backup for the service starts. New backup is only started if previous backup has already completed.
        :param pulumi.Input[_builtins.int] bgwriter_delay: Specifies the delay, in milliseconds, between activity rounds for the background writer. Default is 200 ms.
        :param pulumi.Input[_builtins.int] bgwriter_flush_after: The amount of kilobytes that need to be written by the background writer before attempting to force the OS to issue these writes to underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        :param pulumi.Input[_builtins.int] bgwriter_lru_maxpages: The maximum number of buffers that the background writer can write. Setting this to zero disables background writing. Default is 100.
        :param pulumi.Input[_builtins.float] bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target PostgreSQL cluster.
        :param pulumi.Input[_builtins.int] deadlock_timeout: The amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        :param pulumi.Input[_builtins.str] default_toast_compression: Specifies the default TOAST compression method for values of compressible columns (the default is lz4). Supported values are: `lz4`, `pglz`.
        :param pulumi.Input[_builtins.int] idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds
        :param pulumi.Input[_builtins.bool] jit: Activates, in a boolean, the system-wide use of Just-in-Time Compilation (JIT).
        :param pulumi.Input[_builtins.int] log_autovacuum_min_duration: Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one (the default) disables logging autovacuum actions.
        :param pulumi.Input[_builtins.str] log_error_verbosity: Controls the amount of detail written in the server log for each message that is logged. Supported values are: `TERSE`, `DEFAULT`, `VERBOSE`.
        :param pulumi.Input[_builtins.str] log_line_prefix: Selects one of the available log-formats. These can support popular log analyzers like pgbadger, pganalyze, etc. Supported values are: `pid=%p,user=%u,db=%d,app=%a,client=%h`, `%m [%p] %q[user=%u,db=%d,app=%a]`, `%t [%p]: [%l-1] user=%u,db=%d,app=%a,client=%h`.
        :param pulumi.Input[_builtins.int] log_min_duration_statement: Log statements that take more than this number of milliseconds to run. If -1, disables.
        :param pulumi.Input[_builtins.int] max_files_per_process: PostgreSQL maximum number of files that can be open per process.
        :param pulumi.Input[_builtins.int] max_locks_per_transaction: PostgreSQL maximum locks per transaction. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        :param pulumi.Input[_builtins.int] max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries.
        :param pulumi.Input[_builtins.int] max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        :param pulumi.Input[_builtins.int] max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction.
        :param pulumi.Input[_builtins.int] max_prepared_transactions: PostgreSQL maximum prepared transactions. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_replication_slots: PostgreSQL maximum replication slots.
        :param pulumi.Input[_builtins.int] max_stack_depth: Maximum depth of the stack in bytes.
        :param pulumi.Input[_builtins.int] max_standby_archive_delay: Max standby archive delay in milliseconds.
        :param pulumi.Input[_builtins.int] max_standby_streaming_delay: Max standby streaming delay in milliseconds.
        :param pulumi.Input[_builtins.int] max_wal_senders: PostgreSQL maximum WAL senders. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] max_worker_processes: Sets the maximum number of background processes that the system can support. Once increased, this parameter cannot be lowered from its set value.
        :param pulumi.Input[_builtins.int] pg_partman_bgw_interval: Sets the time interval to run pg_partman's scheduled tasks.
        :param pulumi.Input[_builtins.str] pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks. Must consist of alpha-numeric characters, dots, underscores, or dashes. May not start with dash or dot. Maximum of 64 characters.
        :param pulumi.Input[_builtins.str] pg_stat_statements_track: Controls which statements are counted. Specify 'top' to track top-level statements (those issued directly by clients), 'all' to also track nested statements (such as statements invoked within functions), or 'none' to disable statement statistics collection. The default value is top. Supported values are: `all`, `top`, `none`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigPgbouncerArgs', 'DatabasePostgresqlConfigPgbouncerArgsDict']]]] pgbouncers: PGBouncer connection pooling settings
        :param pulumi.Input[_builtins.float] shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        :param pulumi.Input[_builtins.int] temp_file_limit: PostgreSQL temporary file limit in KiB. If -1, sets to unlimited.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlConfigTimescaledbArgs', 'DatabasePostgresqlConfigTimescaledbArgsDict']]]] timescaledbs: TimescaleDB extension configuration values
        :param pulumi.Input[_builtins.str] timezone: PostgreSQL service timezone
        :param pulumi.Input[_builtins.int] track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session.
        :param pulumi.Input[_builtins.str] track_commit_timestamp: Record commit time of transactions. The default value is top. Supported values are: `off`, `on`.
        :param pulumi.Input[_builtins.str] track_functions: Enables tracking of function call counts and time used. The default value is top. Supported values are: `all`, `pl`, `none`.
        :param pulumi.Input[_builtins.str] track_io_timing: Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms. The default value is top. Supported values are: `off`, `on`.
        :param pulumi.Input[_builtins.int] wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout. Must be either 0 or between 5000 and 10800000.
        :param pulumi.Input[_builtins.int] wal_writer_delay: WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance
        :param pulumi.Input[_builtins.int] work_mem: The maximum amount of memory, in MB, used by a query operation (such as a sort or hash table) before writing to temporary disk files. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabasePostgresqlConfigState.__new__(_DatabasePostgresqlConfigState)

        __props__.__dict__["autovacuum_analyze_scale_factor"] = autovacuum_analyze_scale_factor
        __props__.__dict__["autovacuum_analyze_threshold"] = autovacuum_analyze_threshold
        __props__.__dict__["autovacuum_freeze_max_age"] = autovacuum_freeze_max_age
        __props__.__dict__["autovacuum_max_workers"] = autovacuum_max_workers
        __props__.__dict__["autovacuum_naptime"] = autovacuum_naptime
        __props__.__dict__["autovacuum_vacuum_cost_delay"] = autovacuum_vacuum_cost_delay
        __props__.__dict__["autovacuum_vacuum_cost_limit"] = autovacuum_vacuum_cost_limit
        __props__.__dict__["autovacuum_vacuum_scale_factor"] = autovacuum_vacuum_scale_factor
        __props__.__dict__["autovacuum_vacuum_threshold"] = autovacuum_vacuum_threshold
        __props__.__dict__["backup_hour"] = backup_hour
        __props__.__dict__["backup_minute"] = backup_minute
        __props__.__dict__["bgwriter_delay"] = bgwriter_delay
        __props__.__dict__["bgwriter_flush_after"] = bgwriter_flush_after
        __props__.__dict__["bgwriter_lru_maxpages"] = bgwriter_lru_maxpages
        __props__.__dict__["bgwriter_lru_multiplier"] = bgwriter_lru_multiplier
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["deadlock_timeout"] = deadlock_timeout
        __props__.__dict__["default_toast_compression"] = default_toast_compression
        __props__.__dict__["idle_in_transaction_session_timeout"] = idle_in_transaction_session_timeout
        __props__.__dict__["jit"] = jit
        __props__.__dict__["log_autovacuum_min_duration"] = log_autovacuum_min_duration
        __props__.__dict__["log_error_verbosity"] = log_error_verbosity
        __props__.__dict__["log_line_prefix"] = log_line_prefix
        __props__.__dict__["log_min_duration_statement"] = log_min_duration_statement
        __props__.__dict__["max_files_per_process"] = max_files_per_process
        __props__.__dict__["max_locks_per_transaction"] = max_locks_per_transaction
        __props__.__dict__["max_logical_replication_workers"] = max_logical_replication_workers
        __props__.__dict__["max_parallel_workers"] = max_parallel_workers
        __props__.__dict__["max_parallel_workers_per_gather"] = max_parallel_workers_per_gather
        __props__.__dict__["max_pred_locks_per_transaction"] = max_pred_locks_per_transaction
        __props__.__dict__["max_prepared_transactions"] = max_prepared_transactions
        __props__.__dict__["max_replication_slots"] = max_replication_slots
        __props__.__dict__["max_stack_depth"] = max_stack_depth
        __props__.__dict__["max_standby_archive_delay"] = max_standby_archive_delay
        __props__.__dict__["max_standby_streaming_delay"] = max_standby_streaming_delay
        __props__.__dict__["max_wal_senders"] = max_wal_senders
        __props__.__dict__["max_worker_processes"] = max_worker_processes
        __props__.__dict__["pg_partman_bgw_interval"] = pg_partman_bgw_interval
        __props__.__dict__["pg_partman_bgw_role"] = pg_partman_bgw_role
        __props__.__dict__["pg_stat_statements_track"] = pg_stat_statements_track
        __props__.__dict__["pgbouncers"] = pgbouncers
        __props__.__dict__["shared_buffers_percentage"] = shared_buffers_percentage
        __props__.__dict__["temp_file_limit"] = temp_file_limit
        __props__.__dict__["timescaledbs"] = timescaledbs
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["track_activity_query_size"] = track_activity_query_size
        __props__.__dict__["track_commit_timestamp"] = track_commit_timestamp
        __props__.__dict__["track_functions"] = track_functions
        __props__.__dict__["track_io_timing"] = track_io_timing
        __props__.__dict__["wal_sender_timeout"] = wal_sender_timeout
        __props__.__dict__["wal_writer_delay"] = wal_writer_delay
        __props__.__dict__["work_mem"] = work_mem
        return DatabasePostgresqlConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autovacuumAnalyzeScaleFactor")
    def autovacuum_analyze_scale_factor(self) -> pulumi.Output[_builtins.float]:
        """
        Specifies a fraction, in a decimal value, of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size).
        """
        return pulumi.get(self, "autovacuum_analyze_scale_factor")

    @_builtins.property
    @pulumi.getter(name="autovacuumAnalyzeThreshold")
    def autovacuum_analyze_threshold(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the minimum number of inserted, updated, or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "autovacuum_analyze_threshold")

    @_builtins.property
    @pulumi.getter(name="autovacuumFreezeMaxAge")
    def autovacuum_freeze_max_age(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. Note that the system will launch autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. This parameter will cause the server to be restarted.
        """
        return pulumi.get(self, "autovacuum_freeze_max_age")

    @_builtins.property
    @pulumi.getter(name="autovacuumMaxWorkers")
    def autovacuum_max_workers(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        """
        return pulumi.get(self, "autovacuum_max_workers")

    @_builtins.property
    @pulumi.getter(name="autovacuumNaptime")
    def autovacuum_naptime(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the minimum delay, in seconds, between autovacuum runs on any given database. The default is one minute.
        """
        return pulumi.get(self, "autovacuum_naptime")

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumCostDelay")
    def autovacuum_vacuum_cost_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the cost delay value, in milliseconds, that will be used in automatic VACUUM operations. If -1, uses the regular vacuum_cost_delay value, which is 20 milliseconds.
        """
        return pulumi.get(self, "autovacuum_vacuum_cost_delay")

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumCostLimit")
    def autovacuum_vacuum_cost_limit(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        """
        return pulumi.get(self, "autovacuum_vacuum_cost_limit")

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumScaleFactor")
    def autovacuum_vacuum_scale_factor(self) -> pulumi.Output[_builtins.float]:
        """
        Specifies a fraction, in a decimal value, of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size).
        """
        return pulumi.get(self, "autovacuum_vacuum_scale_factor")

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumThreshold")
    def autovacuum_vacuum_threshold(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "autovacuum_vacuum_threshold")

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> pulumi.Output[_builtins.int]:
        """
        The hour of day (in UTC) when backup for the service starts. New backup only starts if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> pulumi.Output[_builtins.int]:
        """
        The minute of the backup hour when backup for the service starts. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="bgwriterDelay")
    def bgwriter_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the delay, in milliseconds, between activity rounds for the background writer. Default is 200 ms.
        """
        return pulumi.get(self, "bgwriter_delay")

    @_builtins.property
    @pulumi.getter(name="bgwriterFlushAfter")
    def bgwriter_flush_after(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of kilobytes that need to be written by the background writer before attempting to force the OS to issue these writes to underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        """
        return pulumi.get(self, "bgwriter_flush_after")

    @_builtins.property
    @pulumi.getter(name="bgwriterLruMaxpages")
    def bgwriter_lru_maxpages(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of buffers that the background writer can write. Setting this to zero disables background writing. Default is 100.
        """
        return pulumi.get(self, "bgwriter_lru_maxpages")

    @_builtins.property
    @pulumi.getter(name="bgwriterLruMultiplier")
    def bgwriter_lru_multiplier(self) -> pulumi.Output[_builtins.float]:
        """
        The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        """
        return pulumi.get(self, "bgwriter_lru_multiplier")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the target PostgreSQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="deadlockTimeout")
    def deadlock_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        """
        return pulumi.get(self, "deadlock_timeout")

    @_builtins.property
    @pulumi.getter(name="defaultToastCompression")
    def default_toast_compression(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default TOAST compression method for values of compressible columns (the default is lz4). Supported values are: `lz4`, `pglz`.
        """
        return pulumi.get(self, "default_toast_compression")

    @_builtins.property
    @pulumi.getter(name="idleInTransactionSessionTimeout")
    def idle_in_transaction_session_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Time out sessions with open transactions after this number of milliseconds
        """
        return pulumi.get(self, "idle_in_transaction_session_timeout")

    @_builtins.property
    @pulumi.getter
    def jit(self) -> pulumi.Output[_builtins.bool]:
        """
        Activates, in a boolean, the system-wide use of Just-in-Time Compilation (JIT).
        """
        return pulumi.get(self, "jit")

    @_builtins.property
    @pulumi.getter(name="logAutovacuumMinDuration")
    def log_autovacuum_min_duration(self) -> pulumi.Output[_builtins.int]:
        """
        Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one (the default) disables logging autovacuum actions.
        """
        return pulumi.get(self, "log_autovacuum_min_duration")

    @_builtins.property
    @pulumi.getter(name="logErrorVerbosity")
    def log_error_verbosity(self) -> pulumi.Output[_builtins.str]:
        """
        Controls the amount of detail written in the server log for each message that is logged. Supported values are: `TERSE`, `DEFAULT`, `VERBOSE`.
        """
        return pulumi.get(self, "log_error_verbosity")

    @_builtins.property
    @pulumi.getter(name="logLinePrefix")
    def log_line_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Selects one of the available log-formats. These can support popular log analyzers like pgbadger, pganalyze, etc. Supported values are: `pid=%p,user=%u,db=%d,app=%a,client=%h`, `%m [%p] %q[user=%u,db=%d,app=%a]`, `%t [%p]: [%l-1] user=%u,db=%d,app=%a,client=%h`.
        """
        return pulumi.get(self, "log_line_prefix")

    @_builtins.property
    @pulumi.getter(name="logMinDurationStatement")
    def log_min_duration_statement(self) -> pulumi.Output[_builtins.int]:
        """
        Log statements that take more than this number of milliseconds to run. If -1, disables.
        """
        return pulumi.get(self, "log_min_duration_statement")

    @_builtins.property
    @pulumi.getter(name="maxFilesPerProcess")
    def max_files_per_process(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum number of files that can be open per process.
        """
        return pulumi.get(self, "max_files_per_process")

    @_builtins.property
    @pulumi.getter(name="maxLocksPerTransaction")
    def max_locks_per_transaction(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum locks per transaction. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_locks_per_transaction")

    @_builtins.property
    @pulumi.getter(name="maxLogicalReplicationWorkers")
    def max_logical_replication_workers(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        """
        return pulumi.get(self, "max_logical_replication_workers")

    @_builtins.property
    @pulumi.getter(name="maxParallelWorkers")
    def max_parallel_workers(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the maximum number of workers that the system can support for parallel queries.
        """
        return pulumi.get(self, "max_parallel_workers")

    @_builtins.property
    @pulumi.getter(name="maxParallelWorkersPerGather")
    def max_parallel_workers_per_gather(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        """
        return pulumi.get(self, "max_parallel_workers_per_gather")

    @_builtins.property
    @pulumi.getter(name="maxPredLocksPerTransaction")
    def max_pred_locks_per_transaction(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum predicate locks per transaction.
        """
        return pulumi.get(self, "max_pred_locks_per_transaction")

    @_builtins.property
    @pulumi.getter(name="maxPreparedTransactions")
    def max_prepared_transactions(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum prepared transactions. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_prepared_transactions")

    @_builtins.property
    @pulumi.getter(name="maxReplicationSlots")
    def max_replication_slots(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum replication slots.
        """
        return pulumi.get(self, "max_replication_slots")

    @_builtins.property
    @pulumi.getter(name="maxStackDepth")
    def max_stack_depth(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum depth of the stack in bytes.
        """
        return pulumi.get(self, "max_stack_depth")

    @_builtins.property
    @pulumi.getter(name="maxStandbyArchiveDelay")
    def max_standby_archive_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Max standby archive delay in milliseconds.
        """
        return pulumi.get(self, "max_standby_archive_delay")

    @_builtins.property
    @pulumi.getter(name="maxStandbyStreamingDelay")
    def max_standby_streaming_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Max standby streaming delay in milliseconds.
        """
        return pulumi.get(self, "max_standby_streaming_delay")

    @_builtins.property
    @pulumi.getter(name="maxWalSenders")
    def max_wal_senders(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum WAL senders. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_wal_senders")

    @_builtins.property
    @pulumi.getter(name="maxWorkerProcesses")
    def max_worker_processes(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the maximum number of background processes that the system can support. Once increased, this parameter cannot be lowered from its set value.
        """
        return pulumi.get(self, "max_worker_processes")

    @_builtins.property
    @pulumi.getter(name="pgPartmanBgwInterval")
    def pg_partman_bgw_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the time interval to run pg_partman's scheduled tasks.
        """
        return pulumi.get(self, "pg_partman_bgw_interval")

    @_builtins.property
    @pulumi.getter(name="pgPartmanBgwRole")
    def pg_partman_bgw_role(self) -> pulumi.Output[_builtins.str]:
        """
        Controls which role to use for pg_partman's scheduled background tasks. Must consist of alpha-numeric characters, dots, underscores, or dashes. May not start with dash or dot. Maximum of 64 characters.
        """
        return pulumi.get(self, "pg_partman_bgw_role")

    @_builtins.property
    @pulumi.getter(name="pgStatStatementsTrack")
    def pg_stat_statements_track(self) -> pulumi.Output[_builtins.str]:
        """
        Controls which statements are counted. Specify 'top' to track top-level statements (those issued directly by clients), 'all' to also track nested statements (such as statements invoked within functions), or 'none' to disable statement statistics collection. The default value is top. Supported values are: `all`, `top`, `none`.
        """
        return pulumi.get(self, "pg_stat_statements_track")

    @_builtins.property
    @pulumi.getter
    def pgbouncers(self) -> pulumi.Output[Sequence['outputs.DatabasePostgresqlConfigPgbouncer']]:
        """
        PGBouncer connection pooling settings
        """
        return pulumi.get(self, "pgbouncers")

    @_builtins.property
    @pulumi.getter(name="sharedBuffersPercentage")
    def shared_buffers_percentage(self) -> pulumi.Output[_builtins.float]:
        """
        Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        """
        return pulumi.get(self, "shared_buffers_percentage")

    @_builtins.property
    @pulumi.getter(name="tempFileLimit")
    def temp_file_limit(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL temporary file limit in KiB. If -1, sets to unlimited.
        """
        return pulumi.get(self, "temp_file_limit")

    @_builtins.property
    @pulumi.getter
    def timescaledbs(self) -> pulumi.Output[Sequence['outputs.DatabasePostgresqlConfigTimescaledb']]:
        """
        TimescaleDB extension configuration values
        """
        return pulumi.get(self, "timescaledbs")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        PostgreSQL service timezone
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="trackActivityQuerySize")
    def track_activity_query_size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of bytes reserved to track the currently executing command for each active session.
        """
        return pulumi.get(self, "track_activity_query_size")

    @_builtins.property
    @pulumi.getter(name="trackCommitTimestamp")
    def track_commit_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Record commit time of transactions. The default value is top. Supported values are: `off`, `on`.
        """
        return pulumi.get(self, "track_commit_timestamp")

    @_builtins.property
    @pulumi.getter(name="trackFunctions")
    def track_functions(self) -> pulumi.Output[_builtins.str]:
        """
        Enables tracking of function call counts and time used. The default value is top. Supported values are: `all`, `pl`, `none`.
        """
        return pulumi.get(self, "track_functions")

    @_builtins.property
    @pulumi.getter(name="trackIoTiming")
    def track_io_timing(self) -> pulumi.Output[_builtins.str]:
        """
        Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms. The default value is top. Supported values are: `off`, `on`.
        """
        return pulumi.get(self, "track_io_timing")

    @_builtins.property
    @pulumi.getter(name="walSenderTimeout")
    def wal_sender_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout. Must be either 0 or between 5000 and 10800000.
        """
        return pulumi.get(self, "wal_sender_timeout")

    @_builtins.property
    @pulumi.getter(name="walWriterDelay")
    def wal_writer_delay(self) -> pulumi.Output[_builtins.int]:
        """
        WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance
        """
        return pulumi.get(self, "wal_writer_delay")

    @_builtins.property
    @pulumi.getter(name="workMem")
    def work_mem(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum amount of memory, in MB, used by a query operation (such as a sort or hash table) before writing to temporary disk files. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        return pulumi.get(self, "work_mem")

