# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GenaiAgentKnowledgeBaseAttachmentArgs', 'GenaiAgentKnowledgeBaseAttachment']

@pulumi.input_type
class GenaiAgentKnowledgeBaseAttachmentArgs:
    def __init__(__self__, *,
                 agent_uuid: pulumi.Input[_builtins.str],
                 knowledge_base_uuid: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a GenaiAgentKnowledgeBaseAttachment resource.
        :param pulumi.Input[_builtins.str] agent_uuid: A unique identifier for an agent.
        :param pulumi.Input[_builtins.str] knowledge_base_uuid: A unique identifier for a knowledge base.
        """
        pulumi.set(__self__, "agent_uuid", agent_uuid)
        pulumi.set(__self__, "knowledge_base_uuid", knowledge_base_uuid)

    @_builtins.property
    @pulumi.getter(name="agentUuid")
    def agent_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        A unique identifier for an agent.
        """
        return pulumi.get(self, "agent_uuid")

    @agent_uuid.setter
    def agent_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_uuid", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuid")
    def knowledge_base_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        A unique identifier for a knowledge base.
        """
        return pulumi.get(self, "knowledge_base_uuid")

    @knowledge_base_uuid.setter
    def knowledge_base_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "knowledge_base_uuid", value)


@pulumi.input_type
class _GenaiAgentKnowledgeBaseAttachmentState:
    def __init__(__self__, *,
                 agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 knowledge_base_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GenaiAgentKnowledgeBaseAttachment resources.
        :param pulumi.Input[_builtins.str] agent_uuid: A unique identifier for an agent.
        :param pulumi.Input[_builtins.str] knowledge_base_uuid: A unique identifier for a knowledge base.
        """
        if agent_uuid is not None:
            pulumi.set(__self__, "agent_uuid", agent_uuid)
        if knowledge_base_uuid is not None:
            pulumi.set(__self__, "knowledge_base_uuid", knowledge_base_uuid)

    @_builtins.property
    @pulumi.getter(name="agentUuid")
    def agent_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for an agent.
        """
        return pulumi.get(self, "agent_uuid")

    @agent_uuid.setter
    def agent_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_uuid", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuid")
    def knowledge_base_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for a knowledge base.
        """
        return pulumi.get(self, "knowledge_base_uuid")

    @knowledge_base_uuid.setter
    def knowledge_base_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "knowledge_base_uuid", value)


@pulumi.type_token("digitalocean:index/genaiAgentKnowledgeBaseAttachment:GenaiAgentKnowledgeBaseAttachment")
class GenaiAgentKnowledgeBaseAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 knowledge_base_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a GenaiAgentKnowledgeBaseAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_uuid: A unique identifier for an agent.
        :param pulumi.Input[_builtins.str] knowledge_base_uuid: A unique identifier for a knowledge base.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GenaiAgentKnowledgeBaseAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GenaiAgentKnowledgeBaseAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GenaiAgentKnowledgeBaseAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GenaiAgentKnowledgeBaseAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 knowledge_base_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GenaiAgentKnowledgeBaseAttachmentArgs.__new__(GenaiAgentKnowledgeBaseAttachmentArgs)

            if agent_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'agent_uuid'")
            __props__.__dict__["agent_uuid"] = agent_uuid
            if knowledge_base_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'knowledge_base_uuid'")
            __props__.__dict__["knowledge_base_uuid"] = knowledge_base_uuid
        super(GenaiAgentKnowledgeBaseAttachment, __self__).__init__(
            'digitalocean:index/genaiAgentKnowledgeBaseAttachment:GenaiAgentKnowledgeBaseAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            knowledge_base_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'GenaiAgentKnowledgeBaseAttachment':
        """
        Get an existing GenaiAgentKnowledgeBaseAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_uuid: A unique identifier for an agent.
        :param pulumi.Input[_builtins.str] knowledge_base_uuid: A unique identifier for a knowledge base.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GenaiAgentKnowledgeBaseAttachmentState.__new__(_GenaiAgentKnowledgeBaseAttachmentState)

        __props__.__dict__["agent_uuid"] = agent_uuid
        __props__.__dict__["knowledge_base_uuid"] = knowledge_base_uuid
        return GenaiAgentKnowledgeBaseAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentUuid")
    def agent_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for an agent.
        """
        return pulumi.get(self, "agent_uuid")

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuid")
    def knowledge_base_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for a knowledge base.
        """
        return pulumi.get(self, "knowledge_base_uuid")

