# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GenaiAgentRouteArgs', 'GenaiAgentRoute']

@pulumi.input_type
class GenaiAgentRouteArgs:
    def __init__(__self__, *,
                 child_agent_uuid: pulumi.Input[_builtins.str],
                 parent_agent_uuid: pulumi.Input[_builtins.str],
                 if_case: Optional[pulumi.Input[_builtins.str]] = None,
                 rollback: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GenaiAgentRoute resource.
        :param pulumi.Input[_builtins.str] child_agent_uuid: The UUID of the child agent.
        :param pulumi.Input[_builtins.str] parent_agent_uuid: The UUID of the parent agent.
        :param pulumi.Input[_builtins.str] if_case: if-case condition for the route.
        :param pulumi.Input[_builtins.str] route_name: A name for the route.
        """
        pulumi.set(__self__, "child_agent_uuid", child_agent_uuid)
        pulumi.set(__self__, "parent_agent_uuid", parent_agent_uuid)
        if if_case is not None:
            pulumi.set(__self__, "if_case", if_case)
        if rollback is not None:
            pulumi.set(__self__, "rollback", rollback)
        if route_name is not None:
            pulumi.set(__self__, "route_name", route_name)

    @_builtins.property
    @pulumi.getter(name="childAgentUuid")
    def child_agent_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        The UUID of the child agent.
        """
        return pulumi.get(self, "child_agent_uuid")

    @child_agent_uuid.setter
    def child_agent_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "child_agent_uuid", value)

    @_builtins.property
    @pulumi.getter(name="parentAgentUuid")
    def parent_agent_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        The UUID of the parent agent.
        """
        return pulumi.get(self, "parent_agent_uuid")

    @parent_agent_uuid.setter
    def parent_agent_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent_agent_uuid", value)

    @_builtins.property
    @pulumi.getter(name="ifCase")
    def if_case(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        if-case condition for the route.
        """
        return pulumi.get(self, "if_case")

    @if_case.setter
    def if_case(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "if_case", value)

    @_builtins.property
    @pulumi.getter
    def rollback(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "rollback")

    @rollback.setter
    def rollback(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rollback", value)

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the route.
        """
        return pulumi.get(self, "route_name")

    @route_name.setter
    def route_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_name", value)


@pulumi.input_type
class _GenaiAgentRouteState:
    def __init__(__self__, *,
                 child_agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 if_case: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 rollback: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GenaiAgentRoute resources.
        :param pulumi.Input[_builtins.str] child_agent_uuid: The UUID of the child agent.
        :param pulumi.Input[_builtins.str] if_case: if-case condition for the route.
        :param pulumi.Input[_builtins.str] parent_agent_uuid: The UUID of the parent agent.
        :param pulumi.Input[_builtins.str] route_name: A name for the route.
        :param pulumi.Input[_builtins.str] uuid: The UUID of the linkage
        """
        if child_agent_uuid is not None:
            pulumi.set(__self__, "child_agent_uuid", child_agent_uuid)
        if if_case is not None:
            pulumi.set(__self__, "if_case", if_case)
        if parent_agent_uuid is not None:
            pulumi.set(__self__, "parent_agent_uuid", parent_agent_uuid)
        if rollback is not None:
            pulumi.set(__self__, "rollback", rollback)
        if route_name is not None:
            pulumi.set(__self__, "route_name", route_name)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="childAgentUuid")
    def child_agent_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the child agent.
        """
        return pulumi.get(self, "child_agent_uuid")

    @child_agent_uuid.setter
    def child_agent_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "child_agent_uuid", value)

    @_builtins.property
    @pulumi.getter(name="ifCase")
    def if_case(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        if-case condition for the route.
        """
        return pulumi.get(self, "if_case")

    @if_case.setter
    def if_case(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "if_case", value)

    @_builtins.property
    @pulumi.getter(name="parentAgentUuid")
    def parent_agent_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the parent agent.
        """
        return pulumi.get(self, "parent_agent_uuid")

    @parent_agent_uuid.setter
    def parent_agent_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_agent_uuid", value)

    @_builtins.property
    @pulumi.getter
    def rollback(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "rollback")

    @rollback.setter
    def rollback(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rollback", value)

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the route.
        """
        return pulumi.get(self, "route_name")

    @route_name.setter
    def route_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_name", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the linkage
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.type_token("digitalocean:index/genaiAgentRoute:GenaiAgentRoute")
class GenaiAgentRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child_agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 if_case: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 rollback: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a GenaiAgentRoute resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] child_agent_uuid: The UUID of the child agent.
        :param pulumi.Input[_builtins.str] if_case: if-case condition for the route.
        :param pulumi.Input[_builtins.str] parent_agent_uuid: The UUID of the parent agent.
        :param pulumi.Input[_builtins.str] route_name: A name for the route.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GenaiAgentRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GenaiAgentRoute resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GenaiAgentRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GenaiAgentRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child_agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 if_case: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 rollback: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GenaiAgentRouteArgs.__new__(GenaiAgentRouteArgs)

            if child_agent_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'child_agent_uuid'")
            __props__.__dict__["child_agent_uuid"] = child_agent_uuid
            __props__.__dict__["if_case"] = if_case
            if parent_agent_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'parent_agent_uuid'")
            __props__.__dict__["parent_agent_uuid"] = parent_agent_uuid
            __props__.__dict__["rollback"] = rollback
            __props__.__dict__["route_name"] = route_name
            __props__.__dict__["uuid"] = None
        super(GenaiAgentRoute, __self__).__init__(
            'digitalocean:index/genaiAgentRoute:GenaiAgentRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            child_agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            if_case: Optional[pulumi.Input[_builtins.str]] = None,
            parent_agent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            rollback: Optional[pulumi.Input[_builtins.bool]] = None,
            route_name: Optional[pulumi.Input[_builtins.str]] = None,
            uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'GenaiAgentRoute':
        """
        Get an existing GenaiAgentRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] child_agent_uuid: The UUID of the child agent.
        :param pulumi.Input[_builtins.str] if_case: if-case condition for the route.
        :param pulumi.Input[_builtins.str] parent_agent_uuid: The UUID of the parent agent.
        :param pulumi.Input[_builtins.str] route_name: A name for the route.
        :param pulumi.Input[_builtins.str] uuid: The UUID of the linkage
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GenaiAgentRouteState.__new__(_GenaiAgentRouteState)

        __props__.__dict__["child_agent_uuid"] = child_agent_uuid
        __props__.__dict__["if_case"] = if_case
        __props__.__dict__["parent_agent_uuid"] = parent_agent_uuid
        __props__.__dict__["rollback"] = rollback
        __props__.__dict__["route_name"] = route_name
        __props__.__dict__["uuid"] = uuid
        return GenaiAgentRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="childAgentUuid")
    def child_agent_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the child agent.
        """
        return pulumi.get(self, "child_agent_uuid")

    @_builtins.property
    @pulumi.getter(name="ifCase")
    def if_case(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        if-case condition for the route.
        """
        return pulumi.get(self, "if_case")

    @_builtins.property
    @pulumi.getter(name="parentAgentUuid")
    def parent_agent_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the parent agent.
        """
        return pulumi.get(self, "parent_agent_uuid")

    @_builtins.property
    @pulumi.getter
    def rollback(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "rollback")

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A name for the route.
        """
        return pulumi.get(self, "route_name")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the linkage
        """
        return pulumi.get(self, "uuid")

