# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GenaiOpenaiApiKeyArgs', 'GenaiOpenaiApiKey']

@pulumi.input_type
class GenaiOpenaiApiKeyArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[_builtins.str],
                 models: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiOpenaiApiKeyModelArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GenaiOpenaiApiKey resource.
        :param pulumi.Input[_builtins.str] api_key: The OpenAI API key.
        :param pulumi.Input[Sequence[pulumi.Input['GenaiOpenaiApiKeyModelArgs']]] models: Models associated with the OpenAI API key
        :param pulumi.Input[_builtins.str] name: A name for the API key.
        """
        pulumi.set(__self__, "api_key", api_key)
        if models is not None:
            pulumi.set(__self__, "models", models)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[_builtins.str]:
        """
        The OpenAI API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter
    def models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiOpenaiApiKeyModelArgs']]]]:
        """
        Models associated with the OpenAI API key
        """
        return pulumi.get(self, "models")

    @models.setter
    def models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiOpenaiApiKeyModelArgs']]]]):
        pulumi.set(self, "models", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the API key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GenaiOpenaiApiKeyState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 deleted_at: Optional[pulumi.Input[_builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiOpenaiApiKeyModelArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GenaiOpenaiApiKey resources.
        :param pulumi.Input[_builtins.str] api_key: The OpenAI API key.
        :param pulumi.Input[_builtins.str] created_at: When the API key was created.
        :param pulumi.Input[_builtins.str] created_by: Who created the API key.
        :param pulumi.Input[_builtins.str] deleted_at: When the API key was deleted.
        :param pulumi.Input[Sequence[pulumi.Input['GenaiOpenaiApiKeyModelArgs']]] models: Models associated with the OpenAI API key
        :param pulumi.Input[_builtins.str] name: A name for the API key.
        :param pulumi.Input[_builtins.str] updated_at: When the API key was last updated.
        :param pulumi.Input[_builtins.str] uuid: The UUID of the API key.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if deleted_at is not None:
            pulumi.set(__self__, "deleted_at", deleted_at)
        if models is not None:
            pulumi.set(__self__, "models", models)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OpenAI API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the API key was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Who created the API key.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the API key was deleted.
        """
        return pulumi.get(self, "deleted_at")

    @deleted_at.setter
    def deleted_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deleted_at", value)

    @_builtins.property
    @pulumi.getter
    def models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiOpenaiApiKeyModelArgs']]]]:
        """
        Models associated with the OpenAI API key
        """
        return pulumi.get(self, "models")

    @models.setter
    def models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiOpenaiApiKeyModelArgs']]]]):
        pulumi.set(self, "models", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the API key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the API key was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the API key.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.type_token("digitalocean:index/genaiOpenaiApiKey:GenaiOpenaiApiKey")
class GenaiOpenaiApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiOpenaiApiKeyModelArgs', 'GenaiOpenaiApiKeyModelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a GenaiOpenaiApiKey resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: The OpenAI API key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiOpenaiApiKeyModelArgs', 'GenaiOpenaiApiKeyModelArgsDict']]]] models: Models associated with the OpenAI API key
        :param pulumi.Input[_builtins.str] name: A name for the API key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GenaiOpenaiApiKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GenaiOpenaiApiKey resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GenaiOpenaiApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GenaiOpenaiApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiOpenaiApiKeyModelArgs', 'GenaiOpenaiApiKeyModelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GenaiOpenaiApiKeyArgs.__new__(GenaiOpenaiApiKeyArgs)

            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = api_key
            __props__.__dict__["models"] = models
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["deleted_at"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["uuid"] = None
        super(GenaiOpenaiApiKey, __self__).__init__(
            'digitalocean:index/genaiOpenaiApiKey:GenaiOpenaiApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            deleted_at: Optional[pulumi.Input[_builtins.str]] = None,
            models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiOpenaiApiKeyModelArgs', 'GenaiOpenaiApiKeyModelArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'GenaiOpenaiApiKey':
        """
        Get an existing GenaiOpenaiApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: The OpenAI API key.
        :param pulumi.Input[_builtins.str] created_at: When the API key was created.
        :param pulumi.Input[_builtins.str] created_by: Who created the API key.
        :param pulumi.Input[_builtins.str] deleted_at: When the API key was deleted.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiOpenaiApiKeyModelArgs', 'GenaiOpenaiApiKeyModelArgsDict']]]] models: Models associated with the OpenAI API key
        :param pulumi.Input[_builtins.str] name: A name for the API key.
        :param pulumi.Input[_builtins.str] updated_at: When the API key was last updated.
        :param pulumi.Input[_builtins.str] uuid: The UUID of the API key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GenaiOpenaiApiKeyState.__new__(_GenaiOpenaiApiKeyState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["deleted_at"] = deleted_at
        __props__.__dict__["models"] = models
        __props__.__dict__["name"] = name
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["uuid"] = uuid
        return GenaiOpenaiApiKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[_builtins.str]:
        """
        The OpenAI API key.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        When the API key was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        Who created the API key.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> pulumi.Output[_builtins.str]:
        """
        When the API key was deleted.
        """
        return pulumi.get(self, "deleted_at")

    @_builtins.property
    @pulumi.getter
    def models(self) -> pulumi.Output[Sequence['outputs.GenaiOpenaiApiKeyModel']]:
        """
        Models associated with the OpenAI API key
        """
        return pulumi.get(self, "models")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the API key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        When the API key was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the API key.
        """
        return pulumi.get(self, "uuid")

