# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSpacesBucketsResult',
    'AwaitableGetSpacesBucketsResult',
    'get_spaces_buckets',
    'get_spaces_buckets_output',
]

@pulumi.output_type
class GetSpacesBucketsResult:
    """
    A collection of values returned by getSpacesBuckets.
    """
    def __init__(__self__, buckets=None, filters=None, id=None, sorts=None):
        if buckets and not isinstance(buckets, list):
            raise TypeError("Expected argument 'buckets' to be a list")
        pulumi.set(__self__, "buckets", buckets)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sorts and not isinstance(sorts, list):
            raise TypeError("Expected argument 'sorts' to be a list")
        pulumi.set(__self__, "sorts", sorts)

    @_builtins.property
    @pulumi.getter
    def buckets(self) -> Sequence['outputs.GetSpacesBucketsBucketResult']:
        """
        A list of Spaces buckets satisfying any `filter` and `sort` criteria. Each bucket has the following attributes:
        """
        return pulumi.get(self, "buckets")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSpacesBucketsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def sorts(self) -> Optional[Sequence['outputs.GetSpacesBucketsSortResult']]:
        return pulumi.get(self, "sorts")


class AwaitableGetSpacesBucketsResult(GetSpacesBucketsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpacesBucketsResult(
            buckets=self.buckets,
            filters=self.filters,
            id=self.id,
            sorts=self.sorts)


def get_spaces_buckets(filters: Optional[Sequence[Union['GetSpacesBucketsFilterArgs', 'GetSpacesBucketsFilterArgsDict']]] = None,
                       sorts: Optional[Sequence[Union['GetSpacesBucketsSortArgs', 'GetSpacesBucketsSortArgsDict']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpacesBucketsResult:
    """
    Get information on Spaces buckets for use in other resources, with the ability to filter and sort the results.
    If no filters are specified, all Spaces buckets will be returned.

    Note: You can use the `SpacesBucket` data source to
    obtain metadata about a single bucket if you already know its `name` and `region`.

    ## Example Usage

    Use the `filter` block with a `key` string and `values` list to filter buckets.

    Get all buckets in a region:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    nyc3 = digitalocean.get_spaces_buckets(filters=[{
        "key": "region",
        "values": ["nyc3"],
    }])
    ```
    You can sort the results as well:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    nyc3 = digitalocean.get_spaces_buckets(filters=[{
            "key": "region",
            "values": ["nyc3"],
        }],
        sorts=[{
            "key": "name",
            "direction": "desc",
        }])
    ```


    :param Sequence[Union['GetSpacesBucketsFilterArgs', 'GetSpacesBucketsFilterArgsDict']] filters: Filter the results.
           The `filter` block is documented below.
    :param Sequence[Union['GetSpacesBucketsSortArgs', 'GetSpacesBucketsSortArgsDict']] sorts: Sort the results.
           The `sort` block is documented below.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['sorts'] = sorts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getSpacesBuckets:getSpacesBuckets', __args__, opts=opts, typ=GetSpacesBucketsResult).value

    return AwaitableGetSpacesBucketsResult(
        buckets=pulumi.get(__ret__, 'buckets'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        sorts=pulumi.get(__ret__, 'sorts'))
def get_spaces_buckets_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSpacesBucketsFilterArgs', 'GetSpacesBucketsFilterArgsDict']]]]] = None,
                              sorts: Optional[pulumi.Input[Optional[Sequence[Union['GetSpacesBucketsSortArgs', 'GetSpacesBucketsSortArgsDict']]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSpacesBucketsResult]:
    """
    Get information on Spaces buckets for use in other resources, with the ability to filter and sort the results.
    If no filters are specified, all Spaces buckets will be returned.

    Note: You can use the `SpacesBucket` data source to
    obtain metadata about a single bucket if you already know its `name` and `region`.

    ## Example Usage

    Use the `filter` block with a `key` string and `values` list to filter buckets.

    Get all buckets in a region:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    nyc3 = digitalocean.get_spaces_buckets(filters=[{
        "key": "region",
        "values": ["nyc3"],
    }])
    ```
    You can sort the results as well:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    nyc3 = digitalocean.get_spaces_buckets(filters=[{
            "key": "region",
            "values": ["nyc3"],
        }],
        sorts=[{
            "key": "name",
            "direction": "desc",
        }])
    ```


    :param Sequence[Union['GetSpacesBucketsFilterArgs', 'GetSpacesBucketsFilterArgsDict']] filters: Filter the results.
           The `filter` block is documented below.
    :param Sequence[Union['GetSpacesBucketsSortArgs', 'GetSpacesBucketsSortArgsDict']] sorts: Sort the results.
           The `sort` block is documented below.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['sorts'] = sorts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('digitalocean:index/getSpacesBuckets:getSpacesBuckets', __args__, opts=opts, typ=GetSpacesBucketsResult)
    return __ret__.apply(lambda __response__: GetSpacesBucketsResult(
        buckets=pulumi.get(__response__, 'buckets'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        sorts=pulumi.get(__response__, 'sorts')))
