# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SpacesBucketLoggingArgs', 'SpacesBucketLogging']

@pulumi.input_type
class SpacesBucketLoggingArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 target_bucket: pulumi.Input[_builtins.str],
                 target_prefix: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SpacesBucketLogging resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket which will be logged.
        :param pulumi.Input[_builtins.str] region: The region where the bucket resides.
        :param pulumi.Input[_builtins.str] target_bucket: The name of the bucket which will store the logs.
        :param pulumi.Input[_builtins.str] target_prefix: The prefix for the log files.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "target_bucket", target_bucket)
        pulumi.set(__self__, "target_prefix", target_prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket which will be logged.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region where the bucket resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket which will store the logs.
        """
        return pulumi.get(self, "target_bucket")

    @target_bucket.setter
    def target_bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_bucket", value)

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The prefix for the log files.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_prefix", value)


@pulumi.input_type
class _SpacesBucketLoggingState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpacesBucketLogging resources.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket which will be logged.
        :param pulumi.Input[_builtins.str] region: The region where the bucket resides.
        :param pulumi.Input[_builtins.str] target_bucket: The name of the bucket which will store the logs.
        :param pulumi.Input[_builtins.str] target_prefix: The prefix for the log files.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_bucket is not None:
            pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket which will be logged.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the bucket resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket which will store the logs.
        """
        return pulumi.get(self, "target_bucket")

    @target_bucket.setter
    def target_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_bucket", value)

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix for the log files.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_prefix", value)


@pulumi.type_token("digitalocean:index/spacesBucketLogging:SpacesBucketLogging")
class SpacesBucketLogging(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        assets = digitalocean.SpacesBucket("assets",
            name="assets",
            region=digitalocean.Region.NYC3)
        logs = digitalocean.SpacesBucket("logs",
            name="logs",
            region=digitalocean.Region.NYC3)
        example = digitalocean.SpacesBucketLogging("example",
            region="%s",
            bucket=assets.id,
            target_bucket=logs.id,
            target_prefix="access-logs/")
        ```

        ## Import

        Spaces bucket logging can be imported using the `region` and `bucket` attributes (delimited by a comma):

        ```sh
        $ pulumi import digitalocean:index/spacesBucketLogging:SpacesBucketLogging example `region`,`bucket`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket which will be logged.
        :param pulumi.Input[_builtins.str] region: The region where the bucket resides.
        :param pulumi.Input[_builtins.str] target_bucket: The name of the bucket which will store the logs.
        :param pulumi.Input[_builtins.str] target_prefix: The prefix for the log files.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpacesBucketLoggingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        assets = digitalocean.SpacesBucket("assets",
            name="assets",
            region=digitalocean.Region.NYC3)
        logs = digitalocean.SpacesBucket("logs",
            name="logs",
            region=digitalocean.Region.NYC3)
        example = digitalocean.SpacesBucketLogging("example",
            region="%s",
            bucket=assets.id,
            target_bucket=logs.id,
            target_prefix="access-logs/")
        ```

        ## Import

        Spaces bucket logging can be imported using the `region` and `bucket` attributes (delimited by a comma):

        ```sh
        $ pulumi import digitalocean:index/spacesBucketLogging:SpacesBucketLogging example `region`,`bucket`
        ```

        :param str resource_name: The name of the resource.
        :param SpacesBucketLoggingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpacesBucketLoggingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpacesBucketLoggingArgs.__new__(SpacesBucketLoggingArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if target_bucket is None and not opts.urn:
                raise TypeError("Missing required property 'target_bucket'")
            __props__.__dict__["target_bucket"] = target_bucket
            if target_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'target_prefix'")
            __props__.__dict__["target_prefix"] = target_prefix
        super(SpacesBucketLogging, __self__).__init__(
            'digitalocean:index/spacesBucketLogging:SpacesBucketLogging',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            target_prefix: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpacesBucketLogging':
        """
        Get an existing SpacesBucketLogging resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket which will be logged.
        :param pulumi.Input[_builtins.str] region: The region where the bucket resides.
        :param pulumi.Input[_builtins.str] target_bucket: The name of the bucket which will store the logs.
        :param pulumi.Input[_builtins.str] target_prefix: The prefix for the log files.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpacesBucketLoggingState.__new__(_SpacesBucketLoggingState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["region"] = region
        __props__.__dict__["target_bucket"] = target_bucket
        __props__.__dict__["target_prefix"] = target_prefix
        return SpacesBucketLogging(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket which will be logged.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the bucket resides.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket which will store the logs.
        """
        return pulumi.get(self, "target_bucket")

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The prefix for the log files.
        """
        return pulumi.get(self, "target_prefix")

