# Build iDynTree from source

iDynTree is a fairly classical C++ project build with CMake, so it should be quite easy to build if you are already familiar with how you build C++ projects with CMake. 
If you are not familiar with the use of CMake, you can check some documentation on https://cmake.org/runningcmake/ or https://cgold.readthedocs.io .

## C++ Dependencies

Before building iDynTree, you need to install the dependencies of iDynTree. Not all dependenies are strictly required, some of them can be enabled or disabled. 
In case they are disabled, tipically some functionality of iDynTree is not provided or disabled.

| Name | Strictly required? | Option to enable/disable | Enabled in conda-forge builds?  |  Enabled in robotology-superbuild builds?  | 
|:-----:|:-----------------:|:------------------------:|:-------------------------------:|:------------------------------------------:|
| [Eigen](http://eigen.tuxfamily.org) | **Yes** |  n.a. | ✔️ | ✔️ |
| [Libxml2](http://xmlsoft.org/) | **Yes** |  n.a.      | ✔️ | ✔️ |
| [Assimp](http://www.assimp.org/) | No|  `IDYNTREE_USES_ASSIMP` | ❌ |  ❌ | 
| [IPOPT](https://projects.coin-or.org/Ipopt) | No |  `IDYNTREE_USES_IPOPT` | ✔️ | ✔️ |
| [irrlicht](http://irrlicht.sourceforge.net/) | No | `IDYNTREE_USES_IRRLICHT` | ✔️ | ✔️ |
| [osqp-eigen](https://github.com/robotology/osqp-eigen) | No | `IDYNTREE_USES_OSQPEIGEN` | ✔️ | ✔️ |


### Install dependencies with conda-forge

If you are using conda, the dependencies of iDynTree can be installed with:
~~~
conda install -c conda-forge cmake compilers  make ninja pkg-config eigen libxml2 assimp ipopt irrlicht osqp-eigen swig python
~~~

### Install dependencies with apt

If you are using an apt-based distribution such as Ubuntu and you want to use apt, the dependencies can be installed via:
~~~
sudo apt-get install build-essential libeigen3-dev libxml2-dev coinor-libipopt-dev libassimp-dev libirrlicht-dev
~~~


## Build
Once you installed the necessary dependencies, the iDynTree library can be compiled as any CMake based project. In the following instructions, we indicate with `<additional_platform_specific_options>` where
you should add the platform specific options, as the use of `-DCMAKE_TOOLCHAIN_FILE=[path to vcpkg]/scripts/buildsystems/vcpkg.cmake` if you are using [vcpkg](https://github.com/Microsoft/vcpkg).

With `make` facilities:
```bash
$ git clone https://github.com/robotology/idyntree
$ cd idyntree
$ mkdir build && cd build
$ cmake -DCMAKE_INSTALL_PREFIX=<prefix> <additional_platform_specific_options> ..
$ make
$ make install
```

With IDE build tool facilities, such as Visual Studio or Xcode
```bash
$ git clone https://github.com/robotology/idyntree
$ cd idyntree
$ mkdir build && cd build
$ cmake -DCMAKE_INSTALL_PREFIX=<prefix> <additional_platform_specific_options> ..
$ cmake --build . --target ALL_BUILD --config Release
$ cmake --build . --target INSTALL --config Release
```


If you need more help on how to build CMake-based projects, please check [CGold's First step](https://cgold.readthedocs.io/en/latest/first-step.html) section.

In this documentation, `<prefix>` will indicate the installation prefix in which you installed iDynTree, i.e. the value that you passed as [`CMAKE_INSTALL_PREFIX`](https://cmake.org/cmake/help/latest/variable/CMAKE_INSTALL_PREFIX.html) during the CMake configuration.

Depending on the location in which you installed `iDynTree`, you may need to add `<prefix>/bin` to the `PATH` env variable and `<prefix>` to the `CMAKE_PREFIX_PATH` env variable.

### Bindings
To compile bindings to iDynTree in several scriping languages, you should enable them using the `IDYNTREE_USES_PYTHON`, `IDYNTREE_USES_LUA`, `IDYNTREE_USES_MATLAB`, `IDYNTREE_USES_OCTAVE` CMake options.

Then, properly accessing bindings to iDynTree can require some additional steps.

#### Python
You should add to the `PYTHONPATH` enviromental variable the install path of the `iDynTree.py` file.
~~~
export PYTHONPATH=$PYTHONPATH:<prefix>/lib/python<majorPythonVersion>.<minorPythonVersion>./dist-packages/
~~~

#### Python (pybind11)
To compile the python bindings based on [pybind11](https://github.com/pybind/pybind11) set to `TRUE` the `IDYNTREE_USES_PYTHON_PYBIND11` option.

**NOTE**: the generated bindings are not compatible with the bindings generated by SWIG. Do not expect your Python code to use either of the two without modifications.

##### Use
Modify your `PYTHONPATH` environment variable to point to the bindings installation directory:

```sh
export PYTHONPATH=${PYTHONPATH}:<prefix>/<python_package_path>
```

where `<prefix>` corresponds to the value specified in `CMAKE_INSTALL_PREFIX` and `<python_package_path>` is the Python installation prefix, as returned by

```python
disutils.sysconfig.get_python_lib(1,0,prefix='')
```

for example: `lib/python3.8/site-packages`.

Finally to use the bindings in your Python code, simply import the package:

```python
import idyntree.pybind as iDynTree

```

#### MATLAB
You should add to Matlab path the `<prefix>/mex` directory.
You can modify the relative location for Matlab bindings files in the installation prefix using the `IDYNTREE_INSTALL_MATLAB_LIBDIR` and `IDYNTREE_INSTALL_MATLAB_MFILESDIR` CMake options.

#### Octave
You should add to Octave path the `<prefix>/octave` directory.
You can modify the relative location for Matlab bindings files in the installation prefix using the`IDYNTREE_INSTALL_OCTAVE_LIBDIR` and `IDYNTREE_INSTALL_OCTAVE_MFILESDIR` CMake options.


##### MATLAB/Octave bindings modifications
All the other bindings (Python,Lua, ...) are generated by SWIG and compiled on the fly by the user,
by enabling the `IDYNTREE_USES_<LANGUAGE>` option. The Matlab and Octave bindings are an exception because they
rely on an experimental version of Swig, developed for providing Matlab bindings for the [casadi](https://github.com/casadi/casadi/wiki) project. For this reason, usually the Matlab bindigs
are not generated by the users, but by iDynTree developers that have a special experimental Swig
version installed. The bindings code is then committed to the repository, and the `IDYNTREE_USES_MATLAB`
option simply enables *compilation* of the bindings. If you want to regenerate the Matlab bindings,
for example because you modified some iDynTree classes, you can install the experimental
version of Swig with Matlab support from https://github.com/robotology-dependencies/swig/ (branch `matlab`) and then enable Matlab bindings generation with the `IDYNTREE_GENERATE_MATLAB` options.
For more info on how to modify the matlab bindings, see https://github.com/robotology/idyntree/blob/master/doc/dev/faqs.md#how-to-add-wrap-a-new-class-or-function-with-swig .

##### MATLAB/Octave high level wrappers
They are a collection of Matlab/Octave functions that wraps the functionalities of (mainly) the iDyntree class `KinDynComputations` into functions with a typical Matlab/Octave interface. The purpose of the high-level wrappers is to provide a simpler and easy-to-use interface for Matlab/Octave users who want to use iDyntree inside Matlab/Octave, also helping in designing code which is less error-prone and easier to debug (e.g. in case the interface of an iDyntree function will change in the future). More details and a complete list of the wrappers can be found in the [wrappers README](/bindings/matlab/+iDynTreeWrappers/README.md).

**Usage**: the wrappers package is installed together with the iDyntree bindings when compiling iDyntree with option `IDYNTREE_USES_MATLAB` or `IDYNTREE_USES_OCTAVE` set to `ON`. The functions can be called from Matlab/Octave using the namespace `iDynTreeWrappers`, i.e. `iDynTreeWrappers.name_of_the_corresponding_iDynTree_method`.
