<TeXmacs|2.1.1>

<style|generic>

<\body>
  <\wide-tabular>
    <tformat|<cwith|1|1|1|1|cell-halign|c>|<table|<row|<\cell>
      <\with|font-series|bold>
        FoKL-GPy Example - Pyomo Maximize
      </with>
    </cell>>>>
  </wide-tabular>

  <hrule>

  Known (i.e., toy problem):

  <\eqnarray*>
    <tformat|<table|<row|<cell|>|<cell|<around*|\<nobracket\>|<around*|\<nobracket\>|t\<in\>|[>0,1|]>>|<cell|>>|<row|<cell|>|<cell|>|<cell|>>|<row|<cell|>|<cell|<around*|{|<tabular|<tformat|<table|<row|<cell|x<rsub|0>=sin<around*|(|3*\<pi\>*t|)>>>|<row|<cell|x<rsub|1>=cos<around*|(|3*\<pi\>*t|)>>>>>>|\<nobracket\>>>|<cell|>>|<row|<cell|>|<cell|>|<cell|>>|<row|<cell|>|<cell|y=-sin<around*|(|\<pi\>*t|)>*<around*|(|\<cal-B\><rsub|1><around*|(|x<rsub|0>|)>+\<cal-B\><rsub|2><around*|(|x<rsub|1>|)>+\<cal-B\><rsub|2><around*|(|x<rsub|0>|)>*\<cal-B\><rsub|3><around*|(|x<rsub|1>|)>|)>+noise>|<cell|>>>>
  </eqnarray*>

  <\wide-tabular>
    <tformat|<cwith|1|1|1|1|cell-hyphen|t>|<cwith|1|1|1|1|cell-halign|c>|<table|<row|<\cell>
      where <math|\<cal-B\>\<equiv\>>orthonormal Bernoulli polynomial scaled
      by BSS-ANOVA eigen-decomposition
    </cell>>>>
  </wide-tabular>

  -<hrule>

  Goal:

  <\wide-tabular>
    <tformat|<cwith|1|1|1|1|cell-halign|c>|<table|<row|<\cell>
      Find <math|t> for <math|y=y<rsub|max>>.
    </cell>>>>
  </wide-tabular>

  <hrule>

  Method:

  <\itemize-dot>
    <item>A FoKL model was trained to find
    <math|y=f<around*|(|x<rsub|0>,x<rsub|1>|)>>.

    <item>The FoKL model was converted to Pyomo.

    <item>Pyomo constraints were added for <math|x<rsub|0>=f<around*|(|t|)>>
    and <math|x<rsub|1>=f<around*|(|t|)>>.

    <item>The multistart sovler was used to run IPOPT at various initial
    points to find a global solution.
  </itemize-dot>

  <hrule>

  <assign|page-the-page|<macro|<value|page-nr>>>Results:

  <\big-figure|<image|<tuple|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|pyomo_example.png>|200pt|150pt||>>
    FoKL model 'coverage3' plot
  </big-figure>

  <\big-figure|<image|<tuple|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|png>|155.5pt|76pt||>>
    Pyomo solution via multistart solver using IPOPT as local solver
  </big-figure>
</body>

<\initial>
  <\collection>
    <associate|page-even-footer|<htab|5mm>>
    <associate|page-even-header|>
    <associate|page-height|auto>
    <associate|page-medium|paper>
    <associate|page-odd-footer|<htab|5mm>>
    <\associate|page-odd-header>
      Energy Systems and Materials Simulation
    </associate>
    <associate|page-screen-margin|false>
    <associate|page-type|letter>
    <associate|page-width|auto>
    <associate|page-width-margin|false>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|auto-1|<tuple|1|1>>
    <associate|auto-2|<tuple|2|1>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|figure>
      <tuple|normal|<\surround|<hidden-binding|<tuple>|1>|>
        FoKL model 'coverage3' plot
      </surround>|<pageref|auto-1>>

      <tuple|normal|<\surround|<hidden-binding|<tuple>|2>|>
        Pyomo solution via IPOPT solver
      </surround>|<pageref|auto-2>>
    </associate>
  </collection>
</auxiliary>