# ruff: noqa: D101, D102, D107
from collections.abc import Buffer
from enum import Enum
from typing import Any


class SteteServerCoreBase:
    def __init__(
        self, port: int, ip_addr: tuple[int, int, int, int] | None = None, handshake: list[int] | None = None
    ) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def is_running(self) -> bool: ...
    def is_connected(self) -> bool: ...
    def disconnect_client(self) -> None: ...
    def update(self, duration: float | None = None) -> None: ...

    # values ----------------------------------------------------------------------
    def value_set(self, value_id: int, value: Any, set_signal: bool, update: bool) -> None: ...
    def value_get(self, value_id: int) -> Any: ...

    # static ----------------------------------------------------------------------
    def static_set(self, value_id: int, value: Any, update: bool) -> None: ...
    def static_get(self, value_id: int) -> Any: ...

    # signals ---------------------------------------------------------------------
    def value_get_signal(self, thread_id) -> tuple[int, tuple[Any, ...]]: ...
    def value_set_register(self, value_id: int, register: bool) -> None: ...
    def signal_set(self, value_id: int, value: Any) -> None: ...

    # image -----------------------------------------------------------------------
    def image_set(
        self, value_id: int, image: Buffer, update: bool, origin: list[int] | tuple[int, int] | None = None
    ) -> None: ...
    def image_get(self, value_id: int) -> tuple[bytearray, tuple[int, int]]: ...
    def image_size(self, value_id: int) -> tuple[int, int]: ...

    # dict ------------------------------------------------------------------------
    def dict_set(self, value_id: int, value: dict[Any, Any], update: bool) -> None: ...
    def dict_get(self, value_id: int) -> dict[Any, Any]: ...
    def dict_item_set(self, value_id: int, key: Any, value: Any, update: bool) -> None: ...
    def dict_item_get(self, value_id: int, key: Any) -> Any: ...
    def dict_item_del(self, value_id: int, key: Any, update: bool) -> None: ...
    def dict_len(self, value_id: int) -> int: ...

    # list ------------------------------------------------------------------------
    def list_set(self, value_id: int, value: list[Any], update: bool) -> None: ...
    def list_get(self, value_id: int) -> list[Any]: ...
    def list_item_set(self, value_id: int, idx: int, value: Any, update: bool) -> None: ...
    def list_item_get(self, value_id: int, idx: int) -> Any: ...
    def list_item_del(self, value_id: int, idx: int, update: bool) -> None: ...
    def list_item_add(self, value_id: int, value: Any, update: bool) -> None: ...
    def list_len(self, value_id: int) -> int: ...

    # graphs ----------------------------------------------------------------------
    def graphs_set(self, value_id: int, idx: int, graph: Buffer, update: bool) -> None: ...
    def graphs_get(self, value_id: int, idx: int) -> tuple[bytearray, tuple[int, ...]]: ...
    def graphs_add_points(
        self,
        value_id: int,
        idx: int,
        points: Buffer,
        update: bool,
    ) -> None: ...
    def graphs_len(self, value_id: int, idx: int) -> int: ...
    def graphs_remove(self, value_id: int, idx: int, update: bool) -> None: ...
    def graphs_count(self, value_id: int) -> int: ...
    def graphs_is_linear(self, value_id: int, idx: int) -> bool: ...
    def graphs_clear(self, value_id: int, update: bool) -> None: ...


class PySyncEnum(Enum):
    def __init__(self, value: int | str) -> None: ...
    @property
    def value(self) -> int: ...
    @property
    def name(self) -> str: ...
