# Generated by Django 2.1.2 on 2018-10-22 11:42

from django.db import migrations, models
import django.db.models.deletion
import mptt.fields
import smart_selects.db_fields
import system.utils.storage
import simditor.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='标题')),
                ('summery', models.TextField(blank=True, null=True, verbose_name='摘要')),
                ('content', simditor.fields.RichTextField(blank=True, null=True, verbose_name='内容')),
                ('keywords', models.CharField(blank=True, max_length=255, null=True, verbose_name='关键词')),
                ('recommend_type', models.IntegerField(choices=[(0, '不推荐'), (1, '幻灯'), (2, '焦点'), (3, '一级'), (4, '二级'), (5, '三级')], default=0, verbose_name='推荐类别')),
                ('thumbnail', models.ImageField(blank=True, storage=system.utils.storage.ImageStorage(), upload_to='thumbnail/%Y/%m/%d', verbose_name='缩略图')),
                ('visits', models.IntegerField(blank=True, default=1, verbose_name='访问数')),
                ('clear_link', models.BooleanField(choices=[(True, '是'), (False, '否')], default=True, verbose_name='清理链接')),
                ('save_img', models.BooleanField(choices=[(True, '是'), (False, '否')], default=True, verbose_name='保存图片')),
                ('status', models.BooleanField(choices=[(True, '显示'), (False, '隐藏')], default=True, verbose_name='是否显示')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
            ],
            options={
                'verbose_name': '文章',
                'verbose_name_plural': '文章管理',
                'db_table': 'at_article',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='名称')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
            ],
            options={
                'verbose_name': '作者',
                'verbose_name_plural': '作者管理',
                'db_table': 'at_author',
            },
        ),
        migrations.CreateModel(
            name='AutoTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=128, verbose_name='任务名称')),
                ('crontab', models.CharField(blank=True, help_text='分 时 天 月 周', max_length=64, null=True, verbose_name='定时任务')),
                ('url', models.CharField(blank=True, max_length=255, null=True, verbose_name='抓取页面')),
                ('list_selector', models.CharField(blank=True, max_length=255, verbose_name='列表规则')),
                ('page_selector', models.CharField(blank=True, max_length=255, verbose_name='分页规则')),
                ('title_selector', models.CharField(blank=True, max_length=128, verbose_name='标题规则')),
                ('title_replace', models.TextField(blank=True, help_text='以JSON数组,类似[("eee","ffff"),(444, "opt")]', verbose_name='标题替换')),
                ('content_selector', models.CharField(blank=True, max_length=128, verbose_name='内容规则')),
                ('content_replace', models.TextField(blank=True, help_text='以JSON数组,类似[("eee","ffff"),(444, "opt")]', verbose_name='内容替换')),
                ('content_except', models.CharField(blank=True, default='[]', help_text='以json格式', max_length=255, null=True, verbose_name='内容排除')),
                ('lazy_photo', models.CharField(blank=True, default='', help_text='有延时图片时,不取src值,使用图片其它属性', max_length=128, null=True, verbose_name='图片SRC属性')),
                ('source', models.CharField(blank=True, max_length=128, verbose_name='来源设定')),
                ('enable', models.BooleanField(choices=[(True, '激活'), (False, '禁用')], default=True, verbose_name='是否可用')),
                ('crontab_key', models.CharField(blank=True, max_length=62, null=True, verbose_name='定时任务KEY')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='autopost.Author', verbose_name='作者')),
            ],
            options={
                'verbose_name': '自动抓取',
                'verbose_name_plural': '自动抓取',
                'db_table': 'at_auto_task',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='名称')),
                ('desc', models.TextField(blank=True, null=True, verbose_name='描述')),
                ('status', models.IntegerField(choices=[(2, '主菜单'), (0, '隐藏'), (1, '显示')], default=1, verbose_name='状态')),
                ('slug', models.CharField(max_length=128, verbose_name='标识')),
                ('url', models.CharField(blank=True, max_length=255, verbose_name='地址')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='autopost.Category', verbose_name='上级菜单')),
                ('site', models.ForeignKey(default=1, on_delete=django.db.models.deletion.DO_NOTHING, to='sites.Site', verbose_name='所属站点')),
            ],
            options={
                'verbose_name': '分类',
                'verbose_name_plural': '分类管理',
                'db_table': 'at_category',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='CrawlLogs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='文章标题')),
                ('url', models.CharField(max_length=255, verbose_name='文章URL')),
                ('site_url', models.CharField(blank=True, max_length=128, null=True, verbose_name='站点URL')),
                ('status', models.IntegerField(choices=[(1, '新增'), (2, '已抓取'), (3, '已修改')], default=1, verbose_name='状态')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('site', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='sites.Site', verbose_name='所属站点')),
            ],
            options={
                'verbose_name': '抓取记录',
                'verbose_name_plural': '抓取记录管理',
                'db_table': 'at_crawl_logs',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='RemoteImages',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_name', models.CharField(max_length=255, verbose_name='文件名称')),
                ('origin_src', models.CharField(max_length=255, verbose_name='原始地址')),
                ('local_src', models.CharField(blank=True, max_length=255, null=True, verbose_name='本地地址')),
                ('remote_src', models.CharField(blank=True, max_length=255, null=True, verbose_name='远程地址')),
                ('schema', models.IntegerField(choices=[(1, 'HTTPS'), (2, 'HTTP')], default=1, verbose_name='URL类型')),
                ('upload_from', models.IntegerField(choices=[(1, '自动抓取'), (2, '手动添加')], default=1, verbose_name='添加来源')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
            ],
            options={
                'verbose_name': '远程图片',
                'verbose_name_plural': '远程图片',
                'db_table': 'at_remote_images',
                'ordering': ['-id'],
            },
        ),
        migrations.AddField(
            model_name='autotask',
            name='category',
            field=smart_selects.db_fields.ChainedForeignKey(auto_choose=True, chained_field='site', chained_model_field='site', on_delete=django.db.models.deletion.CASCADE, to='autopost.Category', verbose_name='所属分类'),
        ),
        migrations.AddField(
            model_name='autotask',
            name='site',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='sites.Site', verbose_name='所属站点'),
        ),
        migrations.AddField(
            model_name='article',
            name='author',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.DO_NOTHING, to='autopost.Author', verbose_name='作者'),
        ),
        migrations.AddField(
            model_name='article',
            name='category',
            field=smart_selects.db_fields.ChainedForeignKey(auto_choose=True, chained_field='site', chained_model_field='site', on_delete=django.db.models.deletion.CASCADE, to='autopost.Category', verbose_name='所属分类'),
        ),
        migrations.AddField(
            model_name='article',
            name='site',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='sites.Site', verbose_name='所属站点'),
        ),
    ]
