# Generated by Django 2.1.2 on 2018-10-14 02:52

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import system.utils.storage
import simditor.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('auth', '0009_alter_user_last_name_max_length'),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='GroupProperty',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('summery', models.TextField(blank=True, null=True, verbose_name='简介')),
                ('duration', models.IntegerField(default=30, help_text='单位为天', verbose_name='会员时长')),
                ('price', models.IntegerField(blank=True, default=98, help_text='单位为元', verbose_name='价格')),
                ('content', simditor.fields.RichTextField(blank=True, null=True, verbose_name='内容')),
                ('recommend', models.BooleanField(default=False, verbose_name='推荐')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='注册时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('group', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='auth.Group')),
            ],
            options={
                'verbose_name': '会员属性',
                'verbose_name_plural': '会员属性',
                'db_table': 'group_property',
            },
        ),
        migrations.CreateModel(
            name='Orders',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order_sn', models.CharField(max_length=128, unique=True, verbose_name='订单号')),
                ('goods', models.IntegerField(verbose_name='商品ID')),
                ('type', models.IntegerField(choices=[(1, '会员'), (2, '楼凤'), (3, '预定'), (4, '充值')], verbose_name='购买类别')),
                ('amount', models.FloatField(verbose_name='金额')),
                ('status', models.IntegerField(choices=[(1, '待付款'), (2, '已付款'), (3, '已作废')], default=1, verbose_name='状态')),
                ('pay_type', models.CharField(default='支付宝', max_length=32, verbose_name='支付方式')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='购买时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('site', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='sites.Site', verbose_name='所属站点')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '订单',
                'verbose_name_plural': '订单管理',
                'db_table': 'orders',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='QtUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.CharField(max_length=32, verbose_name='手机号')),
                ('qq', models.CharField(blank=True, max_length=16, verbose_name='QQ')),
                ('nickname', models.CharField(blank=True, max_length=128, null=True, verbose_name='昵称')),
                ('real_name', models.CharField(blank=True, max_length=32, verbose_name='真实姓名')),
                ('alipay', models.CharField(blank=True, max_length=64, verbose_name='支付宝')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='邮箱')),
                ('idcard', models.CharField(blank=True, max_length=64, null=True, verbose_name='身份证')),
                ('type', models.IntegerField(choices=[(1, '广告主'), (2, '媒体主')], default=1, verbose_name='类别')),
                ('avatar', models.ImageField(blank=True, null=True, storage=system.utils.storage.ImageStorage(), upload_to='avatar', verbose_name='头像')),
                ('vip_expire', models.DateTimeField(blank=True, null=True, verbose_name='VIP过期时间')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='注册时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('recommend', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='recommend_user', to=settings.AUTH_USER_MODEL, verbose_name='推荐人')),
                ('site', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='sites.Site')),
                ('user', models.OneToOneField(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='qtuser', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '用户',
                'verbose_name_plural': '用户管理',
                'db_table': 'qt_user',
            },
        ),
        migrations.CreateModel(
            name='VipLogs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('paid', models.FloatField(verbose_name='购买金额')),
                ('buy_type', models.IntegerField(choices=[(1, '充值'), (2, '余额'), (3, '积分')], verbose_name='购买类型')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='购买时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='auth.Group')),
                ('order', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='usercenter.Orders')),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='sites.Site')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'VIP购买记录',
                'verbose_name_plural': 'VIP购买记录管理',
                'db_table': 'vip_logs',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Wallet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('money', models.FloatField(default=0.0, verbose_name='余额')),
                ('pay_password', models.CharField(blank=True, max_length=128, null=True, verbose_name='支付密码')),
                ('name', models.CharField(blank=True, max_length=64, null=True, verbose_name='真实名称')),
                ('idcard', models.CharField(blank=True, max_length=64, null=True, verbose_name='身份证')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='注册时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='wallet', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '用户钱包',
                'verbose_name_plural': '用户钱包',
                'db_table': 'wallet',
            },
        ),
        migrations.CreateModel(
            name='WalletLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('record_sn', models.CharField(max_length=62, verbose_name='交易流水号')),
                ('order_sn', models.CharField(blank=True, max_length=63, null=True, verbose_name='订单号')),
                ('change_money', models.FloatField(default=0.0, verbose_name='金额变动')),
                ('remain', models.FloatField(default=0.0, verbose_name='余额')),
                ('remark', models.CharField(blank=True, max_length=128, null=True, verbose_name='备注')),
                ('type', models.IntegerField(choices=[(1, '预充值'), (2, '购买会员'), (3, '预定外围'), (4, '提现')], default=1, verbose_name='变更类别')),
                ('pay_type', models.CharField(blank=True, default='', max_length=32, null=True, verbose_name='支付类别')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='注册时间')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='wallet_log', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '钱包记录',
                'verbose_name_plural': '钱包记录',
                'db_table': 'wallet_log',
                'ordering': ['-id'],
            },
        ),
    ]
