# Ariadne Documentation

Comprehensive documentation for the Ariadne Intelligent Quantum Router.

## 📖 Table of Contents

### Getting Started
- [Getting Started Guide](GETTING_STARTED.md) — comprehensive introduction with step-by-step examples.
- [Quick Start](quickstart.md) — run your first routed simulation in minutes.
- [Installation Summary](installation_summary.md) — environment-specific copy/paste commands.
- [Comprehensive Installation](comprehensive_installation.md) — detailed platform coverage and optional extras.
- [Installation Guide](installation.md) — system requirements and verification steps.
- [Configuration Options](options.md) — tune routing strategies, logging, and backend preferences.
- [Troubleshooting](troubleshooting.md) — unblock common installation or runtime issues quickly.

### Audience Guides
- [For Instructors](getting-started/for-instructors.md) — classroom setups, grading workflows, and student tooling.
- [For Researchers](getting-started/for-researchers.md) — reproducible benchmarks, analysis tooling, and data exports.
- [For DevOps](getting-started/for-devops.md) — deployment patterns, observability, and CI/CD integration.

### Learn the Router
- [Routing Decisions](router_decisions.md) — deep dive into the prioritized filter chain and scoring engine.
- [Capability Matrix](capability_matrix.md) — feature comparison for every bundled backend.
- [Performance Guide](PERFORMANCE_GUIDE.md) — tips for squeezing the most out of each simulator.
- [Quantum Computing Primer](quantum_computing_primer.md) — refresher on the algorithms Ariadne targets.
- [Algorithms Catalog](algorithms.md) — 15+ curated algorithms with links to runnable examples.

### Examples & Assets
- [Examples Gallery](../examples/README.md) — notebooks and scripts for education, benchmarking, and production.
- [Docker Guide](DOCKER.md) — containerized workflows with optional “quantum full” builds.
- [Apple Silicon Notes](apple_silicon.md) — Metal acceleration setup and known limitations.

### Developer & Process Docs
- [Developer Guide](guides/developer_guide.md) — architecture overview and contributor workflow.
- [CI Expansion Roadmap](guides/ci_expansion.md) — planned automation improvements.
- [Documentation Enhancements](guides/documentation_enhancements.md) — doc-specific backlog and standards.
- [Release Notes](project/RELEASE_NOTES_v0.4.1.md) — highlights for the latest version.
- [Release Management](project/RELEASE_MANAGEMENT.md) — versioning and branching strategy.
- [CONTRIBUTING](project/CONTRIBUTING.md) — how to submit issues and pull requests.
- [GOVERNANCE](project/GOVERNANCE.md) — decision making process.
- [SECURITY](project/SECURITY.md) — vulnerability disclosure policy.

### API Reference
- [Sphinx API Docs](source/index.rst) — auto-generated reference for the public Python API.
- [Advanced Backends & Routing](source/advanced_backends_routing.rst) — MPS heuristics, filter chain details, and examples.
- [Routing Rules](source/routing_rules.md) — formal definition of the scoring heuristics.
- [Modules Index](source/modules.rst) — jump-off point for module-by-module exploration.

---

## Mission Statement

Ariadne's mission is to **take agency back from the agents** in quantum computing. We provide intelligent quantum circuit routing using deterministic algorithms and mathematical analysis to automatically select the optimal quantum computing backend for your circuits.

## 📋 Documentation Standards

All documentation follows these principles:
- **Clarity**: Clear, concise explanations accessible to both beginners and experts.
- **Completeness**: Comprehensive coverage of features and use cases.
- **Accuracy**: Technically accurate and up-to-date information.
- **Examples**: Practical code examples and real-world use cases.
- **Performance**: Honest benchmarks and performance characteristics.

## 🤝 Contributing to Documentation

We welcome contributions to improve our documentation! Please see our [Contributing Guide](project/CONTRIBUTING.md) for details on how to help.

---

*Ariadne: Intelligent Quantum Routing*
