"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.audit_destination import AuditDestination
from agilicus_api.model.audit_webhook_bulk_event import AuditWebhookBulkEvent
from agilicus_api.model.audit_webhook_events_processed import AuditWebhookEventsProcessed
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_audit_destinations_response import ListAuditDestinationsResponse
from agilicus_api.model.list_audits_response import ListAuditsResponse
from agilicus_api.model.list_auth_audits_response import ListAuthAuditsResponse


class AuditsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __bulk_create_events(
            self,
            audit_webhook_bulk_event,
            **kwargs
        ):
            """Process an AuditWebhookBulkEvent  # noqa: E501

            Processes an AuditWebhookBulkEvent by putting it into the audit event pipeline. Agilicus audit agents expect webhook destinations to obey the semantics of this API, though the URL at which to post AuditWebhookEvents may differ from this. That is, this API specification may be used to develop your own webhook for processing events. If the webhook wants to implement fine-grained processing of events, it should respond with the AuditWebhookEventProcessed response. Otherwise, the audit agent should assume that the response applies to all entries.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bulk_create_events(audit_webhook_bulk_event, async_req=True)
            >>> result = thread.get()

            Args:
                audit_webhook_bulk_event (AuditWebhookBulkEvent):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuditWebhookEventsProcessed
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['audit_webhook_bulk_event'] = \
                audit_webhook_bulk_event
            return self.call_with_http_info(**kwargs)

        if self.bulk_create_events is None:
            self.bulk_create_events = _Endpoint(
                settings={
                    'response_type': (AuditWebhookEventsProcessed,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/bulk_audit_events',
                    'operation_id': 'bulk_create_events',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'audit_webhook_bulk_event',
                    ],
                    'required': [
                        'audit_webhook_bulk_event',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'audit_webhook_bulk_event':
                            (AuditWebhookBulkEvent,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'audit_webhook_bulk_event': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__bulk_create_events
            )

        def __create_audit_destination(
            self,
            audit_destination,
            **kwargs
        ):
            """Create an AuditDestination  # noqa: E501

            Creating a new AuditDestination allows administrators to connect their sources of audit events to somewhere they can be stored.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_audit_destination(audit_destination, async_req=True)
            >>> result = thread.get()

            Args:
                audit_destination (AuditDestination):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuditDestination
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['audit_destination'] = \
                audit_destination
            return self.call_with_http_info(**kwargs)

        if self.create_audit_destination is None:
            self.create_audit_destination = _Endpoint(
                settings={
                    'response_type': (AuditDestination,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/audit_destinations',
                    'operation_id': 'create_audit_destination',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'audit_destination',
                    ],
                    'required': [
                        'audit_destination',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'audit_destination':
                            (AuditDestination,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'audit_destination': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_audit_destination
            )

        def __delete_audit_destination(
            self,
            destination_id,
            **kwargs
        ):
            """Remove an AuditDestination  # noqa: E501

            Remove an AuditDestination. After removal, the system will stop sending events to the destination.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_audit_destination(destination_id, async_req=True)
            >>> result = thread.get()

            Args:
                destination_id (str): destinaton id in path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['destination_id'] = \
                destination_id
            return self.call_with_http_info(**kwargs)

        if self.delete_audit_destination is None:
            self.delete_audit_destination = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/audit_destinations/{destination_id}',
                    'operation_id': 'delete_audit_destination',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'destination_id',
                        'org_id',
                    ],
                    'required': [
                        'destination_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'destination_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'destination_id': 'destination_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'destination_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_audit_destination
            )

        def __get_audit_destination(
            self,
            destination_id,
            **kwargs
        ):
            """Get a single AuditDestination  # noqa: E501

            Get the details of a single AuditDestination. Specify the id of the organisation which owns this resource to ensure you have permission.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_audit_destination(destination_id, async_req=True)
            >>> result = thread.get()

            Args:
                destination_id (str): destinaton id in path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuditDestination
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['destination_id'] = \
                destination_id
            return self.call_with_http_info(**kwargs)

        if self.get_audit_destination is None:
            self.get_audit_destination = _Endpoint(
                settings={
                    'response_type': (AuditDestination,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/audit_destinations/{destination_id}',
                    'operation_id': 'get_audit_destination',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'destination_id',
                        'org_id',
                    ],
                    'required': [
                        'destination_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'destination_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'destination_id': 'destination_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'destination_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_audit_destination
            )

        def __list_audit_destinations(
            self,
            **kwargs
        ):
            """View audit destinations  # noqa: E501

            View configured audit destinations  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_audit_destinations(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                destination_type (str): Destinaton_type in query. Filters AuditDestinations based on their type. . [optional]
                name (str): Filters based on whether or not the items in the collection have the given name. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAuditDestinationsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_audit_destinations is None:
            self.list_audit_destinations = _Endpoint(
                settings={
                    'response_type': (ListAuditDestinationsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/audit_destinations',
                    'operation_id': 'list_audit_destinations',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'destination_type',
                        'name',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'destination_type':
                            (str,),
                        'name':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'destination_type': 'destination_type',
                        'name': 'name',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'destination_type': 'query',
                        'name': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_audit_destinations
            )

        def __list_audits(
            self,
            **kwargs
        ):
            """View audit records  # noqa: E501

            View audit records for any API.  The attribute_type, attribute_id and attribute_org_id query provides the ability to query attributes for an audit record across all possible attributes thay maybe associated with a record, as audit records may have multiple multiple attributes (AuditAttribute) per record.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_audits(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                dt_from (str): Search criteria from when the query happened. * Inclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". . [optional] if omitted the server will use the default value of ""
                dt_to (str): Search criteria until when the query happened. * Exclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". . [optional] if omitted the server will use the default value of ""
                action (str): the type of action which caused the log. [optional] if omitted the server will use the default value of ""
                target_id (str): The identifier for the target of the log (e.g. the jti of a created token). . [optional] if omitted the server will use the default value of ""
                token_id (str): The id of the bearer token for which to find records.. [optional]
                api_name (str): The name of the API which generated the audit logs. [optional] if omitted the server will use the default value of ""
                target_resource_type (str): Filters the type of resource associated with the audit records.. [optional] if omitted the server will use the default value of ""
                org_id (str): Organisation Unique identifier. [optional]
                attribute_type (str): Filters the attribute_type associated with an audit record.. [optional]
                attribute_id (str): Filters the attribute_id associated with an audit record.. [optional]
                attribute_org_id (str): Filters the attribute_org_id associated with an audit record.. [optional]
                resources_behind_connector_id (str): search audit records for all resources behind a connector. [optional]
                attribute_type_list ([str]): a list of attribute_types for searching audit records.. [optional]
                attribute_id_list ([str]): a list of attribute_ids for searching audit records.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAuditsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_audits is None:
            self.list_audits = _Endpoint(
                settings={
                    'response_type': (ListAuditsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/audits',
                    'operation_id': 'list_audits',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                        'dt_from',
                        'dt_to',
                        'action',
                        'target_id',
                        'token_id',
                        'api_name',
                        'target_resource_type',
                        'org_id',
                        'attribute_type',
                        'attribute_id',
                        'attribute_org_id',
                        'resources_behind_connector_id',
                        'attribute_type_list',
                        'attribute_id_list',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'dt_from':
                            (str,),
                        'dt_to':
                            (str,),
                        'action':
                            (str,),
                        'target_id':
                            (str,),
                        'token_id':
                            (str,),
                        'api_name':
                            (str,),
                        'target_resource_type':
                            (str,),
                        'org_id':
                            (str,),
                        'attribute_type':
                            (str,),
                        'attribute_id':
                            (str,),
                        'attribute_org_id':
                            (str,),
                        'resources_behind_connector_id':
                            (str,),
                        'attribute_type_list':
                            ([str],),
                        'attribute_id_list':
                            ([str],),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'dt_from': 'dt_from',
                        'dt_to': 'dt_to',
                        'action': 'action',
                        'target_id': 'target_id',
                        'token_id': 'token_id',
                        'api_name': 'api_name',
                        'target_resource_type': 'target_resource_type',
                        'org_id': 'org_id',
                        'attribute_type': 'attribute_type',
                        'attribute_id': 'attribute_id',
                        'attribute_org_id': 'attribute_org_id',
                        'resources_behind_connector_id': 'resources_behind_connector_id',
                        'attribute_type_list': 'attribute_type_list',
                        'attribute_id_list': 'attribute_id_list',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                        'dt_from': 'query',
                        'dt_to': 'query',
                        'action': 'query',
                        'target_id': 'query',
                        'token_id': 'query',
                        'api_name': 'query',
                        'target_resource_type': 'query',
                        'org_id': 'query',
                        'attribute_type': 'query',
                        'attribute_id': 'query',
                        'attribute_org_id': 'query',
                        'resources_behind_connector_id': 'query',
                        'attribute_type_list': 'query',
                        'attribute_id_list': 'query',
                    },
                    'collection_format_map': {
                        'attribute_type_list': 'multi',
                        'attribute_id_list': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_audits
            )

        def __list_auth_records(
            self,
            **kwargs
        ):
            """View authentication audit records  # noqa: E501

            View and search authentication audit records for different users and organisations in the system.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_auth_records(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                dt_from (str): Search criteria from when the query happened. * Inclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". . [optional] if omitted the server will use the default value of ""
                dt_to (str): Search criteria until when the query happened. * Exclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". . [optional] if omitted the server will use the default value of ""
                org_id (str): Organisation Unique identifier. [optional]
                session_id (str): The session formed when the user started to log in.. [optional]
                trace_id (str): The id representing the request that triggered the event. [optional]
                upstream_user_id (str): The id of the user from upstream. [optional]
                upstream_idp (str): The name of the upstream idp. [optional]
                login_org_id (str): The org id the user tried to log in to. [optional]
                source_ip (str): The source IP address of the client device logging in.. [optional]
                client_id (str): The oidc client id used to log in. [optional]
                event (str): The event which triggered the audit record. [optional]
                stage (str): The stage of a pipeline to query for. [optional]
                request_id (str): The request id associated with an audit record . [optional]
                result (str): The result of an authentication audit to query.. [optional]
                event_name (str): query the event_name in authentication audit. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAuthAuditsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_auth_records is None:
            self.list_auth_records = _Endpoint(
                settings={
                    'response_type': (ListAuthAuditsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/auth_audits',
                    'operation_id': 'list_auth_records',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                        'dt_from',
                        'dt_to',
                        'org_id',
                        'session_id',
                        'trace_id',
                        'upstream_user_id',
                        'upstream_idp',
                        'login_org_id',
                        'source_ip',
                        'client_id',
                        'event',
                        'stage',
                        'request_id',
                        'result',
                        'event_name',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'dt_from':
                            (str,),
                        'dt_to':
                            (str,),
                        'org_id':
                            (str,),
                        'session_id':
                            (str,),
                        'trace_id':
                            (str,),
                        'upstream_user_id':
                            (str,),
                        'upstream_idp':
                            (str,),
                        'login_org_id':
                            (str,),
                        'source_ip':
                            (str,),
                        'client_id':
                            (str,),
                        'event':
                            (str,),
                        'stage':
                            (str,),
                        'request_id':
                            (str,),
                        'result':
                            (str,),
                        'event_name':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'dt_from': 'dt_from',
                        'dt_to': 'dt_to',
                        'org_id': 'org_id',
                        'session_id': 'session_id',
                        'trace_id': 'trace_id',
                        'upstream_user_id': 'upstream_user_id',
                        'upstream_idp': 'upstream_idp',
                        'login_org_id': 'login_org_id',
                        'source_ip': 'source_ip',
                        'client_id': 'client_id',
                        'event': 'event',
                        'stage': 'stage',
                        'request_id': 'request_id',
                        'result': 'result',
                        'event_name': 'event_name',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                        'dt_from': 'query',
                        'dt_to': 'query',
                        'org_id': 'query',
                        'session_id': 'query',
                        'trace_id': 'query',
                        'upstream_user_id': 'query',
                        'upstream_idp': 'query',
                        'login_org_id': 'query',
                        'source_ip': 'query',
                        'client_id': 'query',
                        'event': 'query',
                        'stage': 'query',
                        'request_id': 'query',
                        'result': 'query',
                        'event_name': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_auth_records
            )

        def __replace_audit_destination(
            self,
            destination_id,
            **kwargs
        ):
            """Create or update a AuditDestination.  # noqa: E501

            Create or update a AuditDestination.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_audit_destination(destination_id, async_req=True)
            >>> result = thread.get()

            Args:
                destination_id (str): destinaton id in path

            Keyword Args:
                audit_destination (AuditDestination): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuditDestination
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['destination_id'] = \
                destination_id
            return self.call_with_http_info(**kwargs)

        if self.replace_audit_destination is None:
            self.replace_audit_destination = _Endpoint(
                settings={
                    'response_type': (AuditDestination,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/audit_destinations/{destination_id}',
                    'operation_id': 'replace_audit_destination',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'destination_id',
                        'audit_destination',
                    ],
                    'required': [
                        'destination_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'destination_id':
                            (str,),
                        'audit_destination':
                            (AuditDestination,),
                    },
                    'attribute_map': {
                        'destination_id': 'destination_id',
                    },
                    'location_map': {
                        'destination_id': 'path',
                        'audit_destination': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_audit_destination
            )

    bulk_create_events = None 
    create_audit_destination = None 
    delete_audit_destination = None 
    get_audit_destination = None 
    list_audit_destinations = None 
    list_audits = None 
    list_auth_records = None 
    replace_audit_destination = None 
