"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.list_active_users_response import ListActiveUsersResponse
from agilicus_api.model.list_top_users_response import ListTopUsersResponse
from agilicus_api.model.resource_type_enum import ResourceTypeEnum


class MetricsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __list_active_users(
            self,
            org_id,
            **kwargs
        ):
            """View number of active users  # noqa: E501

            View number of active users  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_active_users(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                dt_from (str): Search criteria from when the query happened. * Inclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". . [optional] if omitted the server will use the default value of ""
                dt_to (str): Search criteria until when the query happened. * Exclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". . [optional] if omitted the server will use the default value of ""
                app_id (str): Application unique identifier. [optional]
                sub_org_id (str): Sub Organisation Unique identifier. [optional]
                app_name (str): Application Name. [optional]
                organisation (str): Organisation Name. [optional]
                interval (int): The size of the time intervals in seconds. [optional] if omitted the server will use the default value of 60
                resource_type (ResourceTypeEnum): The type of resource to query for. [optional]
                resource_name (str): The name of the resource to query for. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListActiveUsersResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.list_active_users is None:
            self.list_active_users = _Endpoint(
                settings={
                    'response_type': (ListActiveUsersResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/metrics/{org_id}/active_users',
                    'operation_id': 'list_active_users',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'dt_from',
                        'dt_to',
                        'app_id',
                        'sub_org_id',
                        'app_name',
                        'organisation',
                        'interval',
                        'resource_type',
                        'resource_name',
                        'resource_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'app_name',
                        'interval',
                        'resource_name',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('app_name',): {
                            'max_length': 63,
                            'min_length': 1,
                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-:]+$',  # noqa: E501
                            },
                        },
                        ('interval',): {

                            'inclusive_minimum': 1,
                        },
                        ('resource_name',): {
                            'max_length': 100,
                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-_.:]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'dt_from':
                            (str,),
                        'dt_to':
                            (str,),
                        'app_id':
                            (str,),
                        'sub_org_id':
                            (str,),
                        'app_name':
                            (str,),
                        'organisation':
                            (str,),
                        'interval':
                            (int,),
                        'resource_type':
                            (ResourceTypeEnum,),
                        'resource_name':
                            (str,),
                        'resource_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'dt_from': 'dt_from',
                        'dt_to': 'dt_to',
                        'app_id': 'app_id',
                        'sub_org_id': 'sub_org_id',
                        'app_name': 'app_name',
                        'organisation': 'organisation',
                        'interval': 'interval',
                        'resource_type': 'resource_type',
                        'resource_name': 'resource_name',
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'dt_from': 'query',
                        'dt_to': 'query',
                        'app_id': 'query',
                        'sub_org_id': 'query',
                        'app_name': 'query',
                        'organisation': 'query',
                        'interval': 'query',
                        'resource_type': 'query',
                        'resource_name': 'query',
                        'resource_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_active_users
            )

        def __list_top_users(
            self,
            org_id,
            **kwargs
        ):
            """View top users  # noqa: E501

            View top users  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_top_users(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                dt_from (str): Search criteria from when the query happened. * Inclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". . [optional] if omitted the server will use the default value of ""
                dt_to (str): Search criteria until when the query happened. * Exclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". . [optional] if omitted the server will use the default value of ""
                app_id (str): Application unique identifier. [optional]
                sub_org_id (str): Sub Organisation Unique identifier. [optional]
                app_name (str): Application Name. [optional]
                organisation (str): Organisation Name. [optional]
                interval (int): The size of the time intervals in seconds. [optional] if omitted the server will use the default value of 60
                limit (int): limit the number of top users in the response. [optional] if omitted the server will use the default value of 15
                resource_type (ResourceTypeEnum): The type of resource to query for. [optional]
                resource_name (str): The name of the resource to query for. [optional]
                resource_id (str): The id of the resource to query for. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListTopUsersResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.list_top_users is None:
            self.list_top_users = _Endpoint(
                settings={
                    'response_type': (ListTopUsersResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/metrics/{org_id}/top_users',
                    'operation_id': 'list_top_users',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'dt_from',
                        'dt_to',
                        'app_id',
                        'sub_org_id',
                        'app_name',
                        'organisation',
                        'interval',
                        'limit',
                        'resource_type',
                        'resource_name',
                        'resource_id',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'app_id',
                        'app_name',
                        'interval',
                        'limit',
                        'resource_name',
                    ]
                },
                root_map={
                    'validations': {
                        ('app_id',): {

                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-]+$',  # noqa: E501
                            },
                        },
                        ('app_name',): {
                            'max_length': 63,
                            'min_length': 1,
                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-:]+$',  # noqa: E501
                            },
                        },
                        ('interval',): {

                            'inclusive_minimum': 1,
                        },
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                        ('resource_name',): {
                            'max_length': 100,
                            'regex': {
                                'pattern': r'^[a-zA-Z0-9-_.:]+$',  # noqa: E501
                            },
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'dt_from':
                            (str,),
                        'dt_to':
                            (str,),
                        'app_id':
                            (str,),
                        'sub_org_id':
                            (str,),
                        'app_name':
                            (str,),
                        'organisation':
                            (str,),
                        'interval':
                            (int,),
                        'limit':
                            (int,),
                        'resource_type':
                            (ResourceTypeEnum,),
                        'resource_name':
                            (str,),
                        'resource_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'dt_from': 'dt_from',
                        'dt_to': 'dt_to',
                        'app_id': 'app_id',
                        'sub_org_id': 'sub_org_id',
                        'app_name': 'app_name',
                        'organisation': 'organisation',
                        'interval': 'interval',
                        'limit': 'limit',
                        'resource_type': 'resource_type',
                        'resource_name': 'resource_name',
                        'resource_id': 'resource_id',
                    },
                    'location_map': {
                        'org_id': 'path',
                        'dt_from': 'query',
                        'dt_to': 'query',
                        'app_id': 'query',
                        'sub_org_id': 'query',
                        'app_name': 'query',
                        'organisation': 'query',
                        'interval': 'query',
                        'limit': 'query',
                        'resource_type': 'query',
                        'resource_name': 'query',
                        'resource_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_top_users
            )

    list_active_users = None 
    list_top_users = None 
