"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.rules_api import RulesApi  # noqa: E501


class TestRulesApi(unittest.TestCase):
    """RulesApi unit test stubs"""

    def setUp(self):
        self.api = RulesApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_cleanup_standalone_rules(self):
        """Test case for cleanup_standalone_rules

        cleanup of standalone rules  # noqa: E501
        """
        pass

    def test_create_ruleset_label(self):
        """Test case for create_ruleset_label

        Creates a StandaloneRulesetLabel  # noqa: E501
        """
        pass

    def test_create_standalone_rule(self):
        """Test case for create_standalone_rule

        Add a standalone rule  # noqa: E501
        """
        pass

    def test_create_standalone_rule_policy(self):
        """Test case for create_standalone_rule_policy

        Add a standalone rule policy  # noqa: E501
        """
        pass

    def test_create_standalone_rule_tree(self):
        """Test case for create_standalone_rule_tree

        Add a standalone rule tree  # noqa: E501
        """
        pass

    def test_create_standalone_ruleset(self):
        """Test case for create_standalone_ruleset

        Add a standalone ruleset  # noqa: E501
        """
        pass

    def test_create_standalone_ruleset_bundle(self):
        """Test case for create_standalone_ruleset_bundle

        Add a standalone ruleset bundle  # noqa: E501
        """
        pass

    def test_delete_ruleset_label(self):
        """Test case for delete_ruleset_label

        Delete a StandaloneRulesetLabel  # noqa: E501
        """
        pass

    def test_delete_standalone_rule(self):
        """Test case for delete_standalone_rule

        Delete a standalone rule  # noqa: E501
        """
        pass

    def test_delete_standalone_rule_policy(self):
        """Test case for delete_standalone_rule_policy

        Delete a standalone rule policy  # noqa: E501
        """
        pass

    def test_delete_standalone_rule_tree(self):
        """Test case for delete_standalone_rule_tree

        Delete a standalone rule tree  # noqa: E501
        """
        pass

    def test_delete_standalone_ruleset(self):
        """Test case for delete_standalone_ruleset

        Delete a standalone ruleset  # noqa: E501
        """
        pass

    def test_delete_standalone_ruleset_bundle(self):
        """Test case for delete_standalone_ruleset_bundle

        Delete a standalone ruleset_bundle  # noqa: E501
        """
        pass

    def test_get_ruleset_label(self):
        """Test case for get_ruleset_label

        Get a StandaloneRulesetLabel  # noqa: E501
        """
        pass

    def test_get_standalone_rule(self):
        """Test case for get_standalone_rule

        Get a standalone rule  # noqa: E501
        """
        pass

    def test_get_standalone_rule_policy(self):
        """Test case for get_standalone_rule_policy

        Get a standalone rule policy  # noqa: E501
        """
        pass

    def test_get_standalone_rule_tree(self):
        """Test case for get_standalone_rule_tree

        Get a standalone rule tree  # noqa: E501
        """
        pass

    def test_get_standalone_ruleset(self):
        """Test case for get_standalone_ruleset

        Get a standalone ruleset  # noqa: E501
        """
        pass

    def test_get_standalone_ruleset_bundle(self):
        """Test case for get_standalone_ruleset_bundle

        Get a standalone ruleset bundle  # noqa: E501
        """
        pass

    def test_list_ruleset_labels(self):
        """Test case for list_ruleset_labels

        list StandaloneRulesetLabel  # noqa: E501
        """
        pass

    def test_list_standalone_rule_policies(self):
        """Test case for list_standalone_rule_policies

        List all standalone rule policies  # noqa: E501
        """
        pass

    def test_list_standalone_rule_trees(self):
        """Test case for list_standalone_rule_trees

        List all standalone rule trees  # noqa: E501
        """
        pass

    def test_list_standalone_rules(self):
        """Test case for list_standalone_rules

        List all standalone rules  # noqa: E501
        """
        pass

    def test_list_standalone_ruleset_bundles(self):
        """Test case for list_standalone_ruleset_bundles

        List all standalone ruleset bundles  # noqa: E501
        """
        pass

    def test_list_standalone_rulesets(self):
        """Test case for list_standalone_rulesets

        List all standalone rulesets  # noqa: E501
        """
        pass

    def test_replace_standalone_rule(self):
        """Test case for replace_standalone_rule

        update a standalone rule  # noqa: E501
        """
        pass

    def test_replace_standalone_rule_policy(self):
        """Test case for replace_standalone_rule_policy

        update a standalone rule policy  # noqa: E501
        """
        pass

    def test_replace_standalone_rule_tree(self):
        """Test case for replace_standalone_rule_tree

        update a standalone rule tree  # noqa: E501
        """
        pass

    def test_replace_standalone_ruleset(self):
        """Test case for replace_standalone_ruleset

        update a standalone ruleset  # noqa: E501
        """
        pass

    def test_replace_standalone_ruleset_bundle(self):
        """Test case for replace_standalone_ruleset_bundle

        update a standalone ruleset bundle  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
