# pltr-cli Documentation

Welcome to the pltr-cli documentation! This CLI tool provides a command-line interface for interacting with Palantir Foundry APIs using the official `foundry-platform-sdk`.

## 📚 Documentation Structure

### User Guide
- **[Quick Start Guide](user-guide/quick-start.md)** - Get up and running in minutes
- **[Authentication Setup](user-guide/authentication.md)** - Configure token and OAuth2 authentication
- **[Command Reference](user-guide/commands.md)** - Complete reference for all 50+ commands
- **[Common Workflows](user-guide/workflows.md)** - Real-world data analysis patterns
- **[Troubleshooting](user-guide/troubleshooting.md)** - Common issues and solutions

### API Documentation
- **[API Wrapper](api/wrapper.md)** - Developer guide for extending the CLI
- **[Service Layer](api/services.md)** - Understanding the service architecture

### Examples
- **[Examples Gallery](examples/gallery.md)** - Real-world use cases and patterns
- **[Data Analysis Examples](examples/data-analysis.md)** - Complete analysis workflows
- **[Ontology Examples](examples/ontology.md)** - Working with Foundry ontologies

## 🚀 Quick Links

- **Installation**: `pip install pltr-cli`
- **First Time Setup**: [Authentication Guide](user-guide/authentication.md)
- **Common Commands**: [Command Reference](user-guide/commands.md)
- **Get Help**: `pltr --help` or `pltr <command> --help`

## 📦 What's Available

pltr-cli provides comprehensive access to Foundry APIs:

- **🔐 Authentication**: Secure token and OAuth2 support with multi-profile management
- **📊 Datasets**: Get, create, and manage Foundry datasets
- **🔍 SQL**: Execute queries, manage results, export data
- **🎯 Ontology**: Work with objects, actions, and queries
- **👥 Admin**: User and group management (admin permissions required)
- **💻 Interactive Shell**: REPL mode with tab completion and history
- **⚡ Shell Completion**: Auto-completion for bash, zsh, and fish

## 🆘 Need Help?

- Check the [Troubleshooting Guide](user-guide/troubleshooting.md)
- Use `pltr --help` for command-line help
- Run `pltr <command> --help` for specific command help
- Start the interactive shell with `pltr shell` for guided usage

---

*Built with ❤️ using the official foundry-platform-sdk*
