---
title: 'BacterialPloidyPredictor(BPP): A Machine Learning Tool for Bacterial Polyploidy Prediction from Genome Assemblies'
tags:
  - Python
  - Bacterial genomics
  - Microbial ecology
  - Microbiome
authors:
  - name: Zhenxiong Jiang
    orcid: 0000-0002-7912-1934
    equal-contrib: false
    affiliation: "1"
  - name: Xin Wang
    orcid: 0000-0002-7174-3042
    corresponding: true
    affiliation: "1"
  - name: Raquel Dias
    orcid: 0000-0002-8387-1324
    corresponding: true
    affiliation: "1"
affiliations:
 - name: Department of Microbiology and Cell Science, University of Florida, Gainesville, Florida, 32611, USA
   index: 1
date: 7 August 2025

bibliography: paper.bib

---

# Summary
BacterialPloidyPredictor (BPP) is a Python-based package that batch predicts the bacterial polyploidy based off of global genomic architecture. BacterialPloidyPredictor automates the extraction of features from complete assemblies of bacterial species, and predicts polyploidy by feeding extracted features into pre-trained machine learning models. Besides, BPP provides a series of visualizations to help comprehend the difference in global genomic architecture, and to estimate the confidence of the prediction. For instance, it visualizes the global genomic features used to predict polyploidy, the position of the sample(s) in the 3-dimensional space formed by first three principal components (PC1-PC3) generated by training data, and the Euclidean distance to the closest reference point among two distributions formed by reference points either within group or between two groups. This package serves as the first computational tool to predict polyploidy in bacteria, with the goal to explore the biological significance of polyploidy as a prevalent phenotype, and potentiates ploidy quantification in the future. 

# Statement of need
Recent predictions challenge the previous consensus that most bacteria are monoploids [@Soppa2022-kb]. If proven, this new finding could significantly change the way we analyze microbiology data. For example, microbiome-wide association study (MWAS) has been developed to find bacterial taxa associated with diseases and disorders [@Gilbert2016-cl; @Surana2017-kq]. This method is built based on the assumption that all bacteria are monoploids such that the fold change of components reflects the fluctuation of taxa population size. However, if majority of bacteria are polyploids, the normalization of bacterial abundance based on ploidy level becomes necessary to ameliorate the overrepresentation of species, and can thus help identify species with a higher significance in disease onset or development [@Soppa2017-uc]. Furthermore, it becomes clearer that polyploid bacteria co-exist with monoploid bacteria, this observation raises further questions about the biological significance of polyploidy in addition to previously proposed theories[@Van_de_Peer2017-vq]. Unfortunately, several factors hinder further investigation of this topic: First, quantification of ploidy level is a time-consuming task. The current method based on qPCR and cell direct counting is time- and labor-intensive and which necessitates a high-throughput method. Second, the number of bacteria with quantified ploidy level from previous studies is limited for the development of prediction tools that rely on big amount of data for model training; third, the dynamic nature of polyploidy makes the collection of data trickier. For example, some, if not all, monoploid bacteria such as *E.coli* can go through polyploidization during fast growing phase, which is known as mero-polyploidy. This phenomenon is believed to increases the gene dosage to support its fast growth [@Hu2025-hi], which complicates the quantification of true polyploidy as the ploidy is a dynamic range. To differentiate, polyploidy in this work is defined as the mantenance of multiple copies of chromosomes at all growing phases. As the first step to launch a thorough investigation, BPP is developed to perform a binary prediction based on global genomic architectures. Alongside the prediction, a series of statistics are provided that help to assess the confidence of the prediction.  

# Implementation
BPP samples complete genome assemblies in batch to extract the features associated with global genomic architecture, including GC skew, AT skew, and a series of other genomic features derived from the characterization of nucleotide bias [@Arakawa2007-ks; Arakawa2009-bx]. These features are then used as input for three pre-trained different machine learning models based on logistic regression, XGBoost, and k-nearest neighbors (kNN). Although optimized during development of this tool, parameters can be fine-tuned according to researcher's need. Use of default parameters can already give users a biologically meaningful prediction, allowing researchers to focus on the correlational or causational interpretation of this phenotype with minimal interference with parameters. Additionally, a series of plots visualizing the confidence of prediction and the relationships with labeled training data is given at the end. (\autoref{fig:workflow})
![Figure 1: Schematics of BPP. BPP takes all genome assemblies in fasta format (either with .fa, .fasta, or .fna suffix) in the input directory. BPP then extracts global genomic architetures including GC skew and AT skew. After standardization, these features are used as inputs for one of the three pre-trained machine learning models for the prediction of polyploidy. Optionally, users can specify the estimation of genome completeness and contamination rate as a reference statistic to assess the confidence of the prediction. Other illustrations such as interactive 3D PCA plot, and pairwise Euclidean distance are used as additional statistic to assess the prediction confidence. In general, smaller distance from sample points to the reference point reflects a better prediction. \label{fig:workflow}](figures/BacterialPloidyPredictor-flowchart.png)
In summary, BPP provides the following functions:

- **Batch automation of pre-processing and feature extraction**:
  BPP treats *.fasta/*.fna/*.fa files containing complete genome assemblies as input, and gives them an optional genome completeness estimation using CheckM2 [@Chklovski2023-gu]. Extracted features including genomic GC skew, genomic AT skew, degrees of local fluctuations, and relative distances between replication origin and replication terminus and their interaction features are used for downstream prediction.
  
- **Illustration extracted features**:
  Extracted features including GC skew and AT skew will be provided for researchers interested in visualizing any bacterial chromosome for their own studies. Given the wide diversity of bacterial genomic structures, e.g. some species such as *Borrelia sp.* have linear chromosomes while most bacterial species possess circular chromosomes, both circular and linear GC skew and AT skew will be provided.
  
- **Prediction of monoploidy/polyploidy based on extracted features**:
  Use one of the pre-trained models including logistic regression, XGBoost, or kNN (default) to predict whether a species is monoploidy or polyploidy. Based on the dataset summarized from previous works, kNN currently has the highest prediction accuracy. Table 1 below shows the performance of three models.
  
Table 1: Prediction metrics for three machine learning models
  | Model | Overall Accuracy | Monoploidy Accuracy | Monoploidy Precision | Monoploidy Recall | Monoploidy F1 score | Polyploidy Accuracy | Polyploidy Precision | Polyploidy Recall | Polyploidy F1 score |
  | :-------: | :------: | :-------: | :-------: | :-------: | :-------: | :------: | :-------: | :-------: | :-------: |
  | Logistic regression | 0.675 | 0.625 | 0.588 | 0.625 | 0.606 | 0.708 | 0.739 | 0.708 | 0.723 |
  | XGBoost | 0.725 | 0.750 | 0.632 | 0.750 | 0.686 | 0.708 | 0.810 | 0.708 | 0.756 |
  | k-nearest neighbor | 0.725 | 0.500 | 0.727 | 0.500 | 0.593 | 0.875 | 0.724 | 0.875 | 0.792 |

- **Estimation of prediction confidence**:
  If using kNN (default), the Euclidean distance in PC1-PC2-PC3 space between each individual sample point and its nearest reference point will be calculated and placed in the distribution of pairwise Euclidean distance among reference data either from the same group (within-group distance distribution) or different groups (between-group distance distribution) to calculate the quantile of the sample distance in two distributions ($q_{in}$ for within-group quantile, and $q_{btw}$ for between group quantile). We termed PED.confidence (pairwise Euclidean Distance-based confidence) as:
  
  $PED.confidence=(1-q_{in})*(1-q_{btw})$
  
  to quantify the relative confidence of the prediction. Additionally, PCA space formed by first three principal components will be visualized as well with sampling data and reference data. If using multinomial logistic regression or XGBoost, prediction confidence will be given as the output of predict.proba() function under scikit-learn package.
  
# Outputs

To demonstarte, we ran BPP using three complete genome files from species *Escherichia coli*, *Synechocystis sp. PCC 6803*, and *Citrobacter freundii*. *E.coli* and *Synechocystis sp. PCC 6803* has been revealed in previous works as monoploid and polyploid bacteria, respectively; while *C.freundii* has never been tested before. Therefore, *C.freundii* was used as a species for testing the performance of our model. We predicted it using BPP. As a demonstration, we present the outputs for three species (Table 2). Chromosome of *C.freundii* is visualized in forms of global GC skew and AT skew in circular representation (a) and linear representation (b). In panel (a), the outer ring represents global GC skew with positive and negative skew values in orange and purple colors, respecively; the inner ring represents global AT skew with positive and negative skew values in olive and grey colors, respectively. In panel (b), cumulative GC skew (blue) and AT skew (orange) are illustrated in different color. Additionally, two more plots are provided to help users assess the confidence of the prediction. (c) an interactive 3-dimentional PCA plot is generated and saved as the .html file. Figure 2(c) shows a static screenshot of the interactive PCA plot, where orange (group 1: monoploidy), green (group 2: polyploidy with similar genomic architecture with group 1), and blue (polyploidy with divergent architecture in contrast to group 1) represents three groups of reference bacterial species with known ploidy. Samples used for prediction are included in the scatter plot as black points. The sample names appears upon hovering over a point. (d) Pairwise Euclidean distance for reference samples within the same group (black) and between two different groups (blue) are enumerated which forms two distributions. The Euclidean distance between every sample for prediction and its nearest reference sample is calculated and included on the histogram to help assess the confidence of the prediction. 
(\autoref{fig:examples})![Example output plots of BPP. Due to the presence of bacterial species with linear chromosomes, both circular (a) and linear (b) presentations of global GC and AT skew are provided. For a better illustartion and assessemnt of the prediction confidence, an interactive 3D PCA plot (c) and pairwise Euclidean Distance distribution are provided. Proximity in PCA space reflects similar global genomic architecture and thus higher confidence of prediction. \label{fig:examples}](figures/example_outputs.png)

The main prediction and prediction confidence are saved in the main output file prediction.csv. Below is the example output when kNN (default) is selected as the model for prediction:

Table 2: Example of the main prediction output file in csv format
| file | polyploidy_pred | PED.confidence | completeness | contamination |
| :-------: | :------: | :-------: | :-------: |  :-------: |  
| Citrobacter_freundii_ATCC_8090.fasta | 1 | 0.9767195925928703 | 1.0| 0.0008 |
| Synechocystis_sp_PCC_6803.fasta | 1 | 1.0 | 1.0 | 0.0001 |
| Escherichia_coli.fna | 0 | 1.0 | 0.9999 | 0.001 |

# Acknowledgement
We are grateful to members from Dr. Raquel Dias lab for providing constructive feedbacks that helped refine and improve this package.
# References
