"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityPoolBasic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const iam = require("aws-cdk-lib/aws-iam");
const base_identity_pool_1 = require("./base-identity-pool");
const types_1 = require("./types");
class ActionsIdentityPoolBasic extends base_identity_pool_1.ActionsIdentityPoolBase {
    constructor(scope, id, props) {
        super(scope, id, props, true);
        this.authenticatedRole = new iam.Role(this, 'AuthenticatedRole', {
            assumedBy: this.createPrincipalForPool(props.principalClaimRequirements, types_1.AuthenticatedMethodReference.AUTHENTICATED),
            roleName: props.authenticatedRoleName,
        });
        new aws_cognito_1.CfnIdentityPoolRoleAttachment(this, 'RoleAttachment', {
            identityPoolId: this.identityPoolId,
            roles: {
                authenticated: this.authenticatedRole.roleArn,
            },
        });
    }
    get defaultAuthenticatedRole() {
        return this.authenticatedRole;
    }
}
exports.ActionsIdentityPoolBasic = ActionsIdentityPoolBasic;
_a = JSII_RTTI_SYMBOL_1;
ActionsIdentityPoolBasic[_a] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityPoolBasic", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,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