import { Constraint } from '@catnekaise/cdk-iam-utilities';
import * as cdk from 'aws-cdk-lib';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Role } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { ActionsIdentityMappedClaims, GhaClaim } from './claims';
import { ActionsIdentityPolicyUtility } from './policy-utility';
import { AuthenticatedMethodReference, EnhancedFlowRoleResolution } from './types';
export declare enum EnhancedFlowMatchType {
    EQUALS = "Equals",
    CONTAINS = "Contains",
    STARTS_WITH = "StartsWith",
    NOT_EQUALS = "NotEquals"
}
export interface ActionsIdentityPoolV2Props {
    /**
     * Mapped Claims for this Identity Pool
     */
    readonly mappedClaims: ActionsIdentityMappedClaims;
    /**
     * Constraints for the default authenticated role created in this pool
     *
     * ```ts
     * new ActionsIdentityPoolV2(this,'Pool', {
     *   authenticatedRoleConstraints: [
     *    GitHubActionsClaimConstraint.repoOwners(`catnekaise`),
     *    // additional constraints
     *   ]
     * });
     * ```
     */
    readonly authenticatedRoleConstraints: Constraint[];
    /**
     * Name of authenticated role when creating role.
     */
    readonly authenticatedRoleName?: string;
    /**
     * Provide this or attempt will be made to import OpenIdConnectProvider using defaults
     * @default Attempts to imports OIDC Provider from AWS Account
     */
    readonly openIdConnectProvider?: iam.IOpenIdConnectProvider;
    /**
     * Name of the Identity Pool
     */
    readonly identityPoolName?: string;
    /**
     * Authenticated Method Reference.
     *
     * authenticated = authenticated (default)
     *
     * host = token.actions.githubusercontent.com
     *
     * arn = arn:aws:iam::111111111111:oidc-provider/token.actions.githubusercontent.com:OIDC:*
     *
     * @default authenticated
     */
    readonly authenticatedMethodReference?: AuthenticatedMethodReference;
    /**
     * Export name for the CfnOutput containing the Identity Pool ID
     */
    readonly poolIdExportName?: string;
    /**
     * Use Enhanced (Simplified) AuthFlow instead of Basic
     * @default false
     */
    readonly useEnhancedAuthFlow?: boolean;
    /**
     * Only applicable when setting `useEnhancedFlow` to `true`
     * @default deny
     */
    readonly enhancedFlowRoleResolution?: EnhancedFlowRoleResolution;
    /**
     * Set removal policy
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
export declare class ActionsIdentityPoolV2 extends Construct {
    private readonly props;
    readonly defaultAuthenticatedRole: iam.Role;
    private readonly identityPool;
    private readonly openIdConnectProvider;
    private readonly roleAttachment;
    private rolesAttachedIndex;
    constructor(scope: Construct, id: string, props: ActionsIdentityPoolV2Props);
    get identityPoolId(): string;
    get policyUtility(): ActionsIdentityPolicyUtility;
    enhancedFlowAssignRole(role: Role, claim: GhaClaim, matchType: EnhancedFlowMatchType, value: string): this;
}
