"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityPoolV2 = exports.EnhancedFlowMatchType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const policy_utility_1 = require("./policy-utility");
const types_1 = require("./types");
var EnhancedFlowMatchType;
(function (EnhancedFlowMatchType) {
    EnhancedFlowMatchType["EQUALS"] = "Equals";
    EnhancedFlowMatchType["CONTAINS"] = "Contains";
    EnhancedFlowMatchType["STARTS_WITH"] = "StartsWith";
    EnhancedFlowMatchType["NOT_EQUALS"] = "NotEquals";
})(EnhancedFlowMatchType || (exports.EnhancedFlowMatchType = EnhancedFlowMatchType = {}));
class ActionsIdentityPoolV2 extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.rolesAttachedIndex = -1;
        if (props.authenticatedRoleConstraints.length === 0) {
            throw new Error('At least one constraint has to be defined in authenticatedRoleRequiredConstraints');
        }
        this.openIdConnectProvider = props.openIdConnectProvider ??
            iam.OpenIdConnectProvider.fromOpenIdConnectProviderArn(this, 'IdentityProvider', `arn:aws:iam::${aws_cdk_lib_1.Stack.of(this).account}:oidc-provider/token.actions.githubusercontent.com`);
        this.identityPool = new aws_cognito_1.CfnIdentityPool(this, 'Pool', {
            identityPoolName: props.identityPoolName,
            allowUnauthenticatedIdentities: false,
            allowClassicFlow: props.useEnhancedAuthFlow !== true,
            openIdConnectProviderArns: [
                this.openIdConnectProvider.openIdConnectProviderArn,
            ],
        });
        const principalTags = {};
        for (const claim of props.mappedClaims.claims) {
            principalTags[claim.tagName] = claim.name;
        }
        const principalTagging = new aws_cognito_1.CfnIdentityPoolPrincipalTag(this, 'PrincipalTags', {
            identityPoolId: this.identityPoolId,
            identityProviderName: this.openIdConnectProvider.openIdConnectProviderArn,
            principalTags,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'PoolId', {
            value: this.identityPool.ref,
            exportName: props.poolIdExportName,
        });
        const builder = this.policyUtility.newPrincipalBuilder(types_1.AuthenticatedMethodReference.AUTHENTICATED);
        props.authenticatedRoleConstraints.forEach(x => builder.add(x));
        this.defaultAuthenticatedRole = new iam.Role(this, 'AuthenticatedRole', {
            assumedBy: builder.createPrincipal(this),
            roleName: props.authenticatedRoleName,
        });
        this.roleAttachment = new aws_cognito_1.CfnIdentityPoolRoleAttachment(this, 'RoleAttachment', {
            identityPoolId: this.identityPoolId,
            roles: {
                authenticated: this.defaultAuthenticatedRole.roleArn,
            },
            roleMappings: props.useEnhancedAuthFlow === true ? {
                oidc: {
                    ambiguousRoleResolution: props?.enhancedFlowRoleResolution === types_1.EnhancedFlowRoleResolution.USE_DEFAULT_AUTHENTICATED_ROLE ? 'AuthenticatedRole' : 'Deny',
                    type: 'Rules',
                    identityProvider: this.openIdConnectProvider.openIdConnectProviderArn,
                    rulesConfiguration: {
                        rules: [],
                    },
                },
            } : undefined,
        });
        if (props.removalPolicy) {
            this.identityPool.applyRemovalPolicy(props.removalPolicy);
            principalTagging.applyRemovalPolicy(props.removalPolicy);
            this.roleAttachment.applyRemovalPolicy(props.removalPolicy);
        }
        if (!props.useEnhancedAuthFlow) {
            return;
        }
        const _this = this;
        aws_cdk_lib_1.Aspects.of(this).add({
            visit(node) {
                if (node instanceof aws_cognito_1.CfnIdentityPoolRoleAttachment && _this.rolesAttachedIndex < 0) {
                    throw new Error('Need to add at least one role assignment (pool.enhancedFlowAssignRole(...)) to create an identity pool with Enhanced AuthFlow.');
                }
            },
        });
    }
    get identityPoolId() {
        return this.identityPool.ref;
    }
    get policyUtility() {
        return policy_utility_1.ActionsIdentityPolicyUtility.create(this, {
            claimsContext: this.props.mappedClaims.toClaimsContext(),
            identityPoolId: this.identityPoolId,
            identityPoolAccountId: aws_cdk_lib_1.Stack.of(this).account,
            defaultAmr: types_1.AuthenticatedMethodReference.AUTHENTICATED,
            identityPoolUsesEnhancedFlow: this.props.useEnhancedAuthFlow,
        });
    }
    enhancedFlowAssignRole(role, claim, matchType, value) {
        if (this.props.useEnhancedAuthFlow !== true) {
            throw new Error('Roles can only be assigned when using the Enhanced (Simplified) AuthFlow.');
        }
        const roleIndex = this.rolesAttachedIndex + 1;
        if (roleIndex >= 24) {
            throw new Error('Can only attach a maximum of 25 roles');
        }
        this.roleAttachment.addOverride(`Properties.RoleMappings.oidc.RulesConfiguration.Rules.${roleIndex}`, {
            Claim: claim,
            MatchType: matchType,
            Value: value,
            RoleARN: role.roleArn,
        });
        this.rolesAttachedIndex = roleIndex;
        return this;
    }
}
exports.ActionsIdentityPoolV2 = ActionsIdentityPoolV2;
_a = JSII_RTTI_SYMBOL_1;
ActionsIdentityPoolV2[_a] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityPoolV2", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,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