import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { ActionsIdentityPoolBase, ActionsIdentityPoolBaseProps } from './base-identity-pool';
import { GhaClaim } from './claims';
import { EnhancedFlowRoleResolution } from './types';
export declare enum ActionsIdentityPoolAuthenticatedRoleBehaviour {
    CREATE = "create",
    USE_FIRST_ASSIGNED = "useFirstAssigned"
}
export interface ActionsIdentityPoolProps extends ActionsIdentityPoolBaseProps {
    /**
     * Create authenticated role or use first role assigned in role mappings
     */
    readonly authenticatedRole: ActionsIdentityPoolAuthenticatedRoleBehaviour;
    /**
     * When no rule matches, request should be denied or use default authenticated role
     */
    readonly roleResolution?: EnhancedFlowRoleResolution;
}
export declare class ActionsIdentityPool extends ActionsIdentityPoolBase {
    private readonly props;
    private authenticatedRole;
    private roleAttachment;
    private rolesAttached;
    constructor(scope: Construct, id: string, props: ActionsIdentityPoolProps);
    /**
     * When using `useFirstAssigned` authenticatedRole, this is undefined until first assignment
     */
    get defaultAuthenticatedRole(): iam.Role | undefined;
    assignRoleWhenClaimContains(role: iam.Role, claim: GhaClaim, value: string): this;
    /**
     * Assign role when claim equals value
     */
    assignRoleWhenClaimEquals(role: iam.Role, claim: GhaClaim, value: string): this;
    /**
     * Assign role when "sub" claim starts with value
     */
    assignRoleWhenClaimStartsWith(role: iam.Role, claim: GhaClaim, value: string): this;
    private assignRole;
}
