"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityPool = exports.ActionsIdentityPoolAuthenticatedRoleBehaviour = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const iam = require("aws-cdk-lib/aws-iam");
const base_identity_pool_1 = require("./base-identity-pool");
const types_1 = require("./types");
var ActionsIdentityPoolAuthenticatedRoleBehaviour;
(function (ActionsIdentityPoolAuthenticatedRoleBehaviour) {
    ActionsIdentityPoolAuthenticatedRoleBehaviour["CREATE"] = "create";
    ActionsIdentityPoolAuthenticatedRoleBehaviour["USE_FIRST_ASSIGNED"] = "useFirstAssigned";
})(ActionsIdentityPoolAuthenticatedRoleBehaviour || (exports.ActionsIdentityPoolAuthenticatedRoleBehaviour = ActionsIdentityPoolAuthenticatedRoleBehaviour = {}));
class ActionsIdentityPool extends base_identity_pool_1.ActionsIdentityPoolBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.rolesAttached = 0;
        if (props.authenticatedRole === ActionsIdentityPoolAuthenticatedRoleBehaviour.CREATE) {
            this.authenticatedRole = new iam.Role(this, 'AuthenticatedRole', {
                assumedBy: this.createPrincipalForPool(this.props.principalClaimRequirements, types_1.AuthenticatedMethodReference.AUTHENTICATED),
                roleName: this.props.authenticatedRoleName,
            });
        }
    }
    /**
     * When using `useFirstAssigned` authenticatedRole, this is undefined until first assignment
     */
    get defaultAuthenticatedRole() {
        return this.authenticatedRole;
    }
    assignRoleWhenClaimContains(role, claim, value) {
        this.assignRole(role, claim, 'Contains', value);
        return this;
    }
    /**
     * Assign role when claim equals value
     */
    assignRoleWhenClaimEquals(role, claim, value) {
        this.assignRole(role, claim, 'Equals', value);
        return this;
    }
    /**
     * Assign role when "sub" claim starts with value
     */
    assignRoleWhenClaimStartsWith(role, claim, value) {
        this.assignRole(role, claim, 'StartsWith', value);
        return this;
    }
    assignRole(role, claim, matchType, value) {
        let roleAttachment;
        if (!this.roleAttachment) {
            let authRole;
            if (this.authenticatedRole) {
                authRole = this.authenticatedRole;
            }
            else {
                authRole = role;
            }
            this.authenticatedRole = authRole;
            roleAttachment = new aws_cognito_1.CfnIdentityPoolRoleAttachment(this, 'RoleAttachment', {
                identityPoolId: this.identityPoolId,
                roles: {
                    authenticated: authRole.roleArn,
                },
                roleMappings: {
                    oidc: {
                        ambiguousRoleResolution: this.props?.roleResolution === types_1.EnhancedFlowRoleResolution.USE_DEFAULT_AUTHENTICATED_ROLE ? 'AuthenticatedRole' : 'Deny',
                        type: 'Rules',
                        identityProvider: this.openIdConnectProvider.openIdConnectProviderArn,
                        rulesConfiguration: {
                            rules: [
                                {
                                    claim,
                                    matchType,
                                    value,
                                    roleArn: role.roleArn,
                                },
                            ],
                        },
                    },
                },
            });
            this.roleAttachment = roleAttachment;
            this.rolesAttached++;
            return;
        }
        else {
            roleAttachment = this.roleAttachment;
        }
        const roleIndex = this.rolesAttached + 1;
        if (roleIndex >= 25) {
            aws_cdk_lib_1.Annotations.of(this).addError('Can only attach a maximum of 25 roles');
            return;
        }
        roleAttachment.addOverride(`Properties.RoleMappings.oidc.RulesConfiguration.Rules.${roleIndex}`, {
            Claim: claim,
            MatchType: matchType,
            Value: value,
            RoleARN: role.roleArn,
        });
        this.rolesAttached = roleIndex;
    }
}
exports.ActionsIdentityPool = ActionsIdentityPool;
_a = JSII_RTTI_SYMBOL_1;
ActionsIdentityPool[_a] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityPool", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,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