import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { ClaimMapping, MappedClaim } from './claims';
import { AuthenticatedMethodReference, PrincipalClaimRequirements } from './types';
import { ActionsIdentityChainedPrincipalBuilder, ActionsIdentityIamResourcePathBuilder } from './util';
export interface ActionsIdentityPoolBaseProps {
    /**
     * Provide this or attempt will be made to import OpenIdConnectProvider using defaults
     */
    readonly openIdConnectProvider?: iam.IOpenIdConnectProvider;
    /**
     * Name of the Identity Pool
     */
    readonly identityPoolName?: string;
    /**
     *
     */
    readonly claimMapping: ClaimMapping;
    /**
     * Name of authenticated role when creating role.
     */
    readonly authenticatedRoleName?: string;
    /**
     * Authenticated Method Reference.
     *
     * authenticated = authenticated
     *
     * host = token.actions.githubusercontent.com
     *
     * arn = arn:aws:iam::111111111111:oidc-provider/token.actions.githubusercontent.com:OIDC:*
     */
    readonly authenticatedMethodReference?: AuthenticatedMethodReference;
    /**
     * Required claims used when not passing any to this.createPrincipalForPool()
     */
    readonly principalClaimRequirements: PrincipalClaimRequirements;
    /**
     * Export name for the CfnOutput containing the Identity Pool ID
     */
    readonly poolIdExportName?: string;
}
export declare abstract class ActionsIdentityPoolBase extends Construct {
    private readonly baseProps;
    private readonly _mappedClaims;
    private readonly identityPool;
    protected readonly openIdConnectProvider: iam.IOpenIdConnectProvider;
    protected constructor(scope: Construct, id: string, baseProps: ActionsIdentityPoolBaseProps, allowClassicFlow?: true | undefined);
    get identityPoolId(): string;
    get mappedClaims(): MappedClaim[];
    get util(): ActionsIdentityPoolUtils;
    /**
     * Create Principal with default Trust Policy for this Identity Pool
     */
    createPrincipalForPool(requirements?: PrincipalClaimRequirements, amr?: AuthenticatedMethodReference): iam.IPrincipal;
}
export declare class ActionsIdentityPoolUtils {
    private readonly claimMapping;
    constructor(claimMapping: ClaimMapping);
    get chainedPrincipal(): ActionsIdentityChainedPrincipalBuilder;
    get iamResourcePath(): ActionsIdentityIamResourcePathBuilder;
}
