import { Claim, IClaimsContext, IMappedClaims, PassClaimsConstraintSettings } from '@catnekaise/cdk-iam-utilities';
export declare const GitHubActionClaims: readonly ["jti", "sub", "environment", "aud", "ref", "sha", "repository", "repository_owner", "actor_id", "repository_visibility", "repository_id", "repository_owner_id", "run_id", "run_number", "run_attempt", "runner_environment", "actor", "workflow", "head_ref", "base_ref", "event_name", "ref_type", "job_workflow_ref", "workflow_ref", "iss", "enterprise"];
export declare enum GhaClaim {
    JTI = "jti",
    SUB = "sub",
    ENVIRONMENT = "environment",
    AUD = "aud",
    REF = "ref",
    SHA = "sha",
    REPOSITORY = "repository",
    REPOSITORY_OWNER = "repository_owner",
    ACTOR_ID = "actor_id",
    REPOSITORY_VISIBILITY = "repository_visibility",
    REPOSITORY_ID = "repository_id",
    REPOSITORY_OWNER_ID = "repository_owner_id",
    RUN_ID = "run_id",
    RUN_NUMBER = "run_number",
    RUN_ATTEMPT = "run_attempt",
    RUNNER_ENVIRONMENT = "runner_environment",
    ACTOR = "actor",
    WORKFLOW = "workflow",
    HEAD_REF = "head_ref",
    BASE_REF = "base_ref",
    EVENT_NAME = "event_name",
    REF_TYPE = "ref_type",
    JOB_WORKFLOW_REF = "job_workflow_ref",
    WORKFLOW_REF = "workflow_ref",
    ISS = "iss",
    ENTERPRISE = "enterprise"
}
export declare const LibraryClaimTagNameAbbreviations: {
    [key: string]: string;
};
export interface MappedClaim {
    readonly tagName: string;
    readonly claim: GhaClaim;
}
export type PartialGhaClaims = Partial<{
    [K in typeof GitHubActionClaims[number]]: string;
}>;
export declare function createMappedClaims(claims: GhaClaim[] | PartialGhaClaims): MappedClaim[];
export declare class ClaimMapping {
    static fromDefaults(claim: GhaClaim, ...additionalClaims: GhaClaim[]): ClaimMapping;
    static fromClaimsAsTagNames(claim: GhaClaim, ...additionalClaims: GhaClaim[]): ClaimMapping;
    /**
     * Available in TypeScript only
     * @jsii ignore
     **/
    static fromClaimsWithTagName(claims: PartialGhaClaims): ClaimMapping;
    static fromCustomTagNames(claims: {
        [key: string]: string;
    }): ClaimMapping;
    private readonly _claims;
    private constructor();
    get mappedClaims(): MappedClaim[];
    get claims(): Claim[];
}
export declare class ActionsIdentityMappedClaims implements IMappedClaims {
    private readonly _claims;
    static create(claim: GhaClaim, ...additionalClaims: GhaClaim[]): ActionsIdentityMappedClaims;
    static createWithAbbreviations(claim: GhaClaim, ...additionalClaims: GhaClaim[]): ActionsIdentityMappedClaims;
    static createCustom(claims: {
        [key: string]: string;
    }): ActionsIdentityMappedClaims;
    get claims(): Claim[];
    constructor(_claims: Claim[]);
    toPassClaims(...claims: GhaClaim[]): PassClaimsConstraintSettings;
    /**
     * Use this if you want to use https://github.com/aws-actions/configure-aws-credentials for performing role chaining.
     */
    toConfigureAwsCredentialsPassClaims(): PassClaimsConstraintSettings;
    toPassClaimsCustom(claims: {
        [key: string]: string;
    }, allowAnyTags?: boolean, specificallyAllowedTags?: string[]): PassClaimsConstraintSettings;
    toClaimsContext(): IClaimsContext;
}
