"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityMappedClaims = exports.ClaimMapping = exports.createMappedClaims = exports.LibraryClaimTagNameAbbreviations = exports.GhaClaim = exports.GitHubActionClaims = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
exports.GitHubActionClaims = [
    'jti',
    'sub',
    'environment',
    'aud',
    'ref',
    'sha',
    'repository',
    'repository_owner',
    'actor_id',
    'repository_visibility',
    'repository_id',
    'repository_owner_id',
    'run_id',
    'run_number',
    'run_attempt',
    'runner_environment',
    'actor',
    'workflow',
    'head_ref',
    'base_ref',
    'event_name',
    'ref_type',
    'job_workflow_ref',
    'workflow_ref',
    'iss',
    'enterprise',
    // excluding: nbf, exp, iat
];
var GhaClaim;
(function (GhaClaim) {
    GhaClaim["JTI"] = "jti";
    GhaClaim["SUB"] = "sub";
    GhaClaim["ENVIRONMENT"] = "environment";
    GhaClaim["AUD"] = "aud";
    GhaClaim["REF"] = "ref";
    GhaClaim["SHA"] = "sha";
    GhaClaim["REPOSITORY"] = "repository";
    GhaClaim["REPOSITORY_OWNER"] = "repository_owner";
    GhaClaim["ACTOR_ID"] = "actor_id";
    GhaClaim["REPOSITORY_VISIBILITY"] = "repository_visibility";
    GhaClaim["REPOSITORY_ID"] = "repository_id";
    GhaClaim["REPOSITORY_OWNER_ID"] = "repository_owner_id";
    GhaClaim["RUN_ID"] = "run_id";
    GhaClaim["RUN_NUMBER"] = "run_number";
    GhaClaim["RUN_ATTEMPT"] = "run_attempt";
    GhaClaim["RUNNER_ENVIRONMENT"] = "runner_environment";
    GhaClaim["ACTOR"] = "actor";
    GhaClaim["WORKFLOW"] = "workflow";
    GhaClaim["HEAD_REF"] = "head_ref";
    GhaClaim["BASE_REF"] = "base_ref";
    GhaClaim["EVENT_NAME"] = "event_name";
    GhaClaim["REF_TYPE"] = "ref_type";
    GhaClaim["JOB_WORKFLOW_REF"] = "job_workflow_ref";
    GhaClaim["WORKFLOW_REF"] = "workflow_ref";
    GhaClaim["ISS"] = "iss";
    GhaClaim["ENTERPRISE"] = "enterprise";
})(GhaClaim || (exports.GhaClaim = GhaClaim = {}));
exports.LibraryClaimTagNameAbbreviations = {
    repository_owner: 'owner',
    repository: 'repo',
    runner_environment: 'runEnv',
    job_workflow_ref: 'jWorkRef',
    environment: 'env',
    enterprise: 'ent',
    run_id: 'runId',
    run_number: 'run',
    run_attempt: 'attempt',
    repository_visibility: 'repoVis',
    repository_owner_id: 'ownerId',
    repository_id: 'repoId',
    event_name: 'event',
    actor_id: 'actorId',
    workflow_ref: 'workRef',
};
function createMappedClaims(claims) {
    const mappedClaims = [];
    if (Array.isArray(claims)) {
        for (const claim of claims) {
            if (!exports.GitHubActionClaims.includes(claim)) {
                throw new Error(`${claim} is not a known GitHub Actions claim`);
            }
            mappedClaims.push({
                claim,
                tagName: exports.LibraryClaimTagNameAbbreviations[claim] ?? claim,
            });
        }
        return mappedClaims;
    }
    for (const key of Object.keys(claims)) {
        if (!exports.GitHubActionClaims.includes(key)) {
            throw new Error(`${key} is not a known GitHub Actions claim`);
        }
        const claim = key;
        mappedClaims.push({
            claim,
            tagName: claims[claim],
        });
    }
    return mappedClaims;
}
exports.createMappedClaims = createMappedClaims;
class ClaimMapping {
    static fromDefaults(claim, ...additionalClaims) {
        return new ClaimMapping(createMappedClaims([claim, ...additionalClaims]));
    }
    static fromClaimsAsTagNames(claim, ...additionalClaims) {
        return new ClaimMapping([claim, ...additionalClaims].map(x => ({
            claim: x,
            tagName: x,
        })));
    }
    /**
     * Available in TypeScript only
     * @jsii ignore
     **/
    static fromClaimsWithTagName(claims) {
        return new ClaimMapping(createMappedClaims(claims));
    }
    static fromCustomTagNames(claims) {
        return new ClaimMapping(createMappedClaims(claims));
    }
    constructor(claims) {
        this._claims = claims;
    }
    get mappedClaims() {
        return this._claims.map(x => ({ ...x }));
    }
    get claims() {
        return this._claims.map(x => ({
            name: x.claim,
            tagName: x.tagName,
        }));
    }
}
exports.ClaimMapping = ClaimMapping;
_a = JSII_RTTI_SYMBOL_1;
ClaimMapping[_a] = { fqn: "@catnekaise/actions-constructs.ClaimMapping", version: "0.2.17" };
class ActionsIdentityMappedClaims {
    static create(claim, ...additionalClaims) {
        return new ActionsIdentityMappedClaims([claim, ...additionalClaims].map(x => ({
            tagName: x,
            name: x,
        })));
    }
    static createWithAbbreviations(claim, ...additionalClaims) {
        return new ActionsIdentityMappedClaims([claim, ...additionalClaims].map(x => {
            return {
                tagName: exports.LibraryClaimTagNameAbbreviations[x] ?? x,
                name: x,
            };
        }));
    }
    static createCustom(claims) {
        for (const key of Object.keys(claims)) {
            if (!exports.GitHubActionClaims.includes(key)) {
                throw new Error(`${key} is not a known claim`);
            }
        }
        return new ActionsIdentityMappedClaims(Object.keys(claims).map(claim => ({
            name: claim,
            tagName: claims[claim],
        })));
    }
    get claims() {
        return this._claims;
    }
    constructor(_claims) {
        this._claims = _claims;
    }
    toPassClaims(...claims) {
        if (claims.length === 0) {
            claims = this.claims.map(x => x.name);
        }
        const filteredClaims = {};
        for (const claim of claims) {
            const fc = this.claims.find(x => x.name === claim);
            if (!fc) {
                throw new Error(`Cannot pass claim ${claim} as it was not mapped`);
            }
            filteredClaims[fc.tagName] = fc.tagName;
        }
        return {
            claims: filteredClaims,
            allowAnyTags: false,
        };
    }
    /**
     * Use this if you want to use https://github.com/aws-actions/configure-aws-credentials for performing role chaining.
     */
    toConfigureAwsCredentialsPassClaims() {
        return this.toPassClaimsCustom({
            repository: 'repository',
            actor: 'actor',
            ref: 'branch',
            sha: 'commit',
        }, false, ['GitHub', 'Workflow', 'Action', 'Branch', 'Repository', 'Actor', 'Commit']);
    }
    // eslint-disable-next-line max-len
    toPassClaimsCustom(claims, allowAnyTags, specificallyAllowedTags) {
        const filteredClaims = {};
        for (const claim of Object.keys(claims)) {
            const fc = this.claims.find(x => x.name === claim);
            if (!fc) {
                throw new Error(`Cannot pass claim ${claim} as it was not mapped`);
            }
            filteredClaims[fc.tagName] = claims[claim];
        }
        return {
            claims: filteredClaims,
            allowAnyTags: allowAnyTags === true,
            specificallyAllowedTags: specificallyAllowedTags,
        };
    }
    toClaimsContext() {
        return {
            mappedClaims: this,
            knownClaims: exports.GitHubActionClaims,
        };
    }
}
exports.ActionsIdentityMappedClaims = ActionsIdentityMappedClaims;
_b = JSII_RTTI_SYMBOL_1;
ActionsIdentityMappedClaims[_b] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityMappedClaims", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,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