import { ClaimConstraint, ConditionOperator, Constraint, ConstraintAssembleContext, ConstraintPolicyMutation } from '@catnekaise/cdk-iam-utilities';
import { Construct } from 'constructs';
import { GhaClaim } from './claims';
export declare class GitHubActionsClaimConstraint extends ClaimConstraint {
    static readonly SelfHosted: GitHubActionsClaimConstraint;
    static environmentEquals(...environments: string[]): GitHubActionsClaimConstraint;
    static repositoryLike(...repositories: string[]): GitHubActionsClaimConstraint;
    static actorEquals(...actors: string[]): GitHubActionsClaimConstraint;
    /**
     * Value(s) of GitHub organizations or users running GitHub Actions
     * @param owners
     */
    static repoOwners(...owners: string[]): GitHubActionsClaimConstraint;
    /**
     *
     * @param organization Name of organization or user
     * @param repositoryName Name of repository
     * @param filename Default value is '*'
     * @param ref Default value is '*'
     */
    static jobWorkflowLike(organization: string, repositoryName: string, filename?: string, ref?: string): GitHubActionsClaimConstraint;
    static claimLike(claim: GhaClaim, ...values: string[]): GitHubActionsClaimConstraint;
    static claimEquals(claim: GhaClaim, value: string, ...additionalValues: string[]): GitHubActionsClaimConstraint;
    static claimCondition(operator: ConditionOperator, claim: GhaClaim, ...values: string[]): GitHubActionsClaimConstraint;
    constructor(operator: ConditionOperator, claim: GhaClaim, values: string[]);
    assemble(scope: Construct, context: ConstraintAssembleContext): ConstraintPolicyMutation[];
}
export declare abstract class ActionsIdentityConstraints {
    protected constructor();
    protected abstract addConstraint(constraint: Constraint): void;
    environmentEquals(environment: string, ...additionalEnvironments: string[]): this;
    repositoryLike(repository: string, ...additionalRepositories: string[]): this;
    repositoryEquals(repository: string, ...additionalRepositories: string[]): this;
    approvedBy(...actors: string[]): this;
    whenSelfHosted(): this;
    claimLike(claim: GhaClaim, value: string, ...additionalValues: string[]): this;
    claimEquals(claim: GhaClaim, value: string, ...additionalValues: string[]): this;
    claimCondition(operator: ConditionOperator, claim: GhaClaim, ...values: string[]): this;
    repoOrganisations(organization: string, ...additionalOrganizations: string[]): this;
    /**
     *
     * @param organization Name of organization or user
     * @param repositoryName Name of repository
     * @param filename Default value is '*'
     * @param ref Default value is '*'
     */
    jobWorkflowLike(organization: string, repositoryName?: string, filename?: string, ref?: string): this;
    refLike(...refs: string[]): this;
}
