"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityConstraints = exports.GitHubActionsClaimConstraint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_iam_utilities_1 = require("@catnekaise/cdk-iam-utilities");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const claims_1 = require("./claims");
class GitHubActionsClaimConstraint extends cdk_iam_utilities_1.ClaimConstraint {
    static environmentEquals(...environments) {
        if (environments.length === 0) {
            throw new Error('Provide the value of at least one environment');
        }
        return new GitHubActionsClaimConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_EQUALS, claims_1.GhaClaim.ENVIRONMENT, environments);
    }
    static repositoryLike(...repositories) {
        if (repositories.length === 0) {
            throw new Error('Provide the value of at least one repository');
        }
        return new GitHubActionsClaimConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_LIKE, claims_1.GhaClaim.REPOSITORY, repositories);
    }
    static actorEquals(...actors) {
        if (actors.length === 0) {
            throw new Error('Provide the value of at least one actor (GitHub user)');
        }
        return new GitHubActionsClaimConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_EQUALS, claims_1.GhaClaim.ACTOR, actors);
    }
    /**
     * Value(s) of GitHub organizations or users running GitHub Actions
     * @param owners
     */
    static repoOwners(...owners) {
        if (!owners || owners.length === 0) {
            throw new Error('Provide the value of at least one GitHub organization or user');
        }
        return new GitHubActionsClaimConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_LIKE, claims_1.GhaClaim.REPOSITORY, owners.map(x => `${x}/*`));
    }
    /**
     *
     * @param organization Name of organization or user
     * @param repositoryName Name of repository
     * @param filename Default value is '*'
     * @param ref Default value is '*'
     */
    static jobWorkflowLike(organization, repositoryName, filename, ref) {
        filename = filename ?? '*';
        ref = ref ?? '*';
        return new GitHubActionsClaimConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_LIKE, claims_1.GhaClaim.JOB_WORKFLOW_REF, [`${organization}/${repositoryName}/.github/workflows/${filename}@${ref}`]);
    }
    static claimLike(claim, ...values) {
        if (values.length === 0) {
            throw new Error(`Provide at least one value for claim ${claim}`);
        }
        return new GitHubActionsClaimConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_LIKE, claim, values);
    }
    static claimEquals(claim, value, ...additionalValues) {
        return new GitHubActionsClaimConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_EQUALS, claim, [value, ...additionalValues]);
    }
    static claimCondition(operator, claim, ...values) {
        if (values.length === 0) {
            throw new Error('Provide at least one value');
        }
        return new GitHubActionsClaimConstraint(operator, claim, values);
    }
    constructor(operator, claim, values) {
        super(operator, claim, values);
    }
    assemble(scope, context) {
        if (['repository', 'job_workflow_ref'].includes(this.claim) && this.operator.includes('StringLike')) {
            annotateRepositoryLikeClaims(scope, this.claim, this.values);
        }
        return super.assemble(scope, context);
    }
}
exports.GitHubActionsClaimConstraint = GitHubActionsClaimConstraint;
_a = JSII_RTTI_SYMBOL_1;
GitHubActionsClaimConstraint[_a] = { fqn: "@catnekaise/actions-constructs.GitHubActionsClaimConstraint", version: "0.2.17" };
GitHubActionsClaimConstraint.SelfHosted = new GitHubActionsClaimConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_EQUALS, claims_1.GhaClaim.RUNNER_ENVIRONMENT, ['self-hosted']);
function annotateRepositoryLikeClaims(scope, claim, values) {
    if (claim === 'job_workflow_ref') {
        for (const value of values.filter(matchesAnyRepoInOrganization)) {
            aws_cdk_lib_1.Annotations.of(scope).addWarning(`Matching ${value} on claim job_workflow_ref would match a workflow in any repository of your organization.`);
        }
    }
    if (values.filter(matchesMoreThanOneOrganization).length > 0) {
        throw new Error('Matching would match more than a single GitHub organization or user.');
    }
}
function matchesAnyRepoInOrganization(value) {
    if (value.match(/^[\w-]+\/\*.*/)) {
        return true;
    }
    return false;
}
function matchesMoreThanOneOrganization(value) {
    if (value.split('/')[0].includes('*')) {
        return true;
    }
    return false;
}
class ActionsIdentityConstraints {
    constructor() {
    }
    environmentEquals(environment, ...additionalEnvironments) {
        this.addConstraint(GitHubActionsClaimConstraint.environmentEquals(environment, ...additionalEnvironments));
        return this;
    }
    repositoryLike(repository, ...additionalRepositories) {
        this.addConstraint(GitHubActionsClaimConstraint.repositoryLike(repository, ...additionalRepositories));
        return this;
    }
    repositoryEquals(repository, ...additionalRepositories) {
        this.addConstraint(GitHubActionsClaimConstraint.claimEquals(claims_1.GhaClaim.REPOSITORY, repository, ...additionalRepositories));
        return this;
    }
    approvedBy(...actors) {
        this.addConstraint(GitHubActionsClaimConstraint.actorEquals(...actors));
        return this;
    }
    whenSelfHosted() {
        this.addConstraint(GitHubActionsClaimConstraint.SelfHosted);
        return this;
    }
    claimLike(claim, value, ...additionalValues) {
        this.addConstraint(GitHubActionsClaimConstraint.claimLike(claim, value, ...additionalValues));
        return this;
    }
    claimEquals(claim, value, ...additionalValues) {
        this.addConstraint(GitHubActionsClaimConstraint.claimEquals(claim, value, ...additionalValues));
        return this;
    }
    claimCondition(operator, claim, ...values) {
        this.addConstraint(GitHubActionsClaimConstraint.claimCondition(operator, claim, ...values));
        return this;
    }
    repoOrganisations(organization, ...additionalOrganizations) {
        this.addConstraint(GitHubActionsClaimConstraint.repoOwners(organization, ...additionalOrganizations));
        return this;
    }
    /**
     *
     * @param organization Name of organization or user
     * @param repositoryName Name of repository
     * @param filename Default value is '*'
     * @param ref Default value is '*'
     */
    jobWorkflowLike(organization, repositoryName, filename, ref) {
        this.addConstraint(GitHubActionsClaimConstraint.jobWorkflowLike(organization, repositoryName ?? '*', filename, ref));
        return this;
    }
    refLike(...refs) {
        this.addConstraint(GitHubActionsClaimConstraint.claimLike(claims_1.GhaClaim.REF, ...refs));
        return this;
    }
}
exports.ActionsIdentityConstraints = ActionsIdentityConstraints;
_b = JSII_RTTI_SYMBOL_1;
ActionsIdentityConstraints[_b] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityConstraints", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,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