"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAmrValue = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const types_1 = require("./types");
function getAmrValue(scope, amr, openIdConnectProvider) {
    if (!amr) {
        return 'authenticated';
    }
    switch (amr) {
        case types_1.AuthenticatedMethodReference.HOST:
            return 'token.actions.githubusercontent.com';
        case types_1.AuthenticatedMethodReference.ARN:
            if (!openIdConnectProvider) {
                throw new Error('Cannot create ARN AMR without providing the openIdConnectProvider');
            }
            aws_cdk_lib_1.Annotations.of(scope).addWarning('In the context of this library, specifying AuthenticatedMethodReference of type `ARN` is deprecated.');
            return `${openIdConnectProvider.openIdConnectProviderArn}:OIDC:*`;
        default:
            return 'authenticated';
    }
}
exports.getAmrValue = getAmrValue;
//# sourceMappingURL=data:application/json;base64,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