import { AwsPrincipalTagConditionKey, ClaimsIamResourcePathBuilder, Constraint, IClaimsContext, IConstraintsBuilder, IMappedClaims, PassClaimsConstraintSettings, PolicyType, PolicyVariable } from '@catnekaise/cdk-iam-utilities';
import * as iam from 'aws-cdk-lib/aws-iam';
import { PrincipalPolicyFragment } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { GhaClaim } from './claims';
import { ActionsIdentityConstraints } from './constraints';
import { AuthenticatedMethodReference } from './types';
export interface ConstrainerSettings {
    readonly claimsContext: IClaimsContext;
    readonly policyType?: PolicyType;
}
export declare abstract class Constrainer extends ActionsIdentityConstraints {
    protected readonly settings: ConstrainerSettings;
    protected constructor(settings: ConstrainerSettings);
    hasResourceTagEqualToClaim(resourceTagName: string, claim: GhaClaim): this;
}
export declare class PolicyStatementConstrainer extends Constrainer {
    private readonly scope;
    private readonly policyStatement;
    static create(scope: Construct, policyStatement: iam.PolicyStatement, settings: ConstrainerSettings): PolicyStatementConstrainer;
    protected constructor(scope: Construct, policyStatement: iam.PolicyStatement, settings: ConstrainerSettings);
    protected addConstraint(constraint: Constraint): void;
    add(constraint: Constraint): this;
}
export declare class GrantConstrainer extends Constrainer {
    private readonly scope;
    private readonly grant;
    static create(scope: Construct, grant: iam.Grant, settings: ConstrainerSettings): GrantConstrainer;
    protected constructor(scope: Construct, grant: iam.Grant, settings: ConstrainerSettings);
    protected addConstraint(constraint: Constraint): void;
    add(constraint: Constraint): this;
}
export interface BuilderSettings {
    readonly claimsContext: IClaimsContext;
}
export declare abstract class ConstraintsBuilder extends ActionsIdentityConstraints implements IConstraintsBuilder {
    protected readonly settings: BuilderSettings;
    protected readonly addedConstraints: Constraint[];
    protected constructor(settings: BuilderSettings);
    get constraints(): Constraint[];
    protected applyToPolicyOfType(scope: Construct, statement: iam.PolicyStatement, policyType: PolicyType, additionalConstraints: Constraint[]): void;
}
export declare class PrincipalBuilder extends ConstraintsBuilder {
    static create(claimsContext: IClaimsContext, constraints: Constraint[]): PrincipalBuilder;
    protected addConstraint(constraint: Constraint): void;
    add(constraint: Constraint, ...additionalConstraints: Constraint[]): this;
    /**
     * @param scope Any construct will do. Is used for annotating warnings
     */
    createPrincipal(scope: Construct): iam.IPrincipal;
}
export declare class ChainedPrincipal extends iam.PrincipalBase {
    private readonly principal;
    private readonly sessionTags;
    private readonly externalIds;
    constructor(principal: iam.PrincipalWithConditions, sessionTags: boolean, externalIds: string[]);
    addToAssumeRolePolicy(doc: iam.PolicyDocument): void;
    get policyFragment(): PrincipalPolicyFragment;
    dedupeString(): string | undefined;
}
export interface ChainedPrincipalCreateOptions {
    readonly passClaims?: PassClaimsConstraintSettings;
}
export interface GrantOrgRoleChainSettings {
    /**
     * Require that roles exist under this path for sts:AssumeRole
     */
    readonly rolePath?: string;
    /**
     * Role has resource tags matching specified values.
     * If tag value matches a known GitHub Actions claim, then value is changed to `${aws:PrincipalTag/value}`
     */
    readonly roleHasResourceTags?: {
        [key: string]: GhaClaim | string;
    };
    /**
     * Prevent assuming roles in these accounts
     */
    readonly excludeAccountIds?: string[];
    /**
     * Require roles to exist under specified organization paths
     */
    readonly resourceOrgPaths?: string[];
    /**
     * Match resourcePaths using StringEquals instead of StringLike
     */
    readonly resourceOrgPathStringEquals?: boolean;
}
export declare class ChainedPrincipalBuilder extends ConstraintsBuilder {
    static create(claimsContext: IClaimsContext): ChainedPrincipalBuilder;
    private constructor();
    protected addConstraint(constraint: Constraint): void;
    add(constraint: Constraint, ...additionalConstraints: Constraint[]): this;
    createPrincipalAssumedBy(scope: Construct, principal: iam.IPrincipal, options?: ChainedPrincipalCreateOptions): iam.IPrincipal;
    private createPassClaimsConstraint;
}
export interface ActionsIdentityPolicyUtilitySettings {
    readonly claimsContext: IClaimsContext;
    readonly identityPoolId?: string;
    readonly identityPoolAccountId?: string;
    readonly defaultAmr?: AuthenticatedMethodReference;
    readonly identityPoolUsesEnhancedFlow?: boolean;
    readonly basePrincipalConstraints?: Constraint[];
}
export declare class ActionsIdentityIamResourcePathBuilderV2 extends ClaimsIamResourcePathBuilder {
    static fromMappedClaims(mappedClaims: IMappedClaims): ActionsIdentityIamResourcePathBuilderV2;
    private constructor();
    claim(claim: GhaClaim, ...additionalClaims: GhaClaim[]): ActionsIdentityIamResourcePathBuilderV2;
    value(value: GhaClaim | string, ...additionalValues: (GhaClaim | string)[]): ActionsIdentityIamResourcePathBuilderV2;
    text(value: string, ...additionalValues: string[]): ActionsIdentityIamResourcePathBuilderV2;
    policyVariable(value: PolicyVariable): ActionsIdentityIamResourcePathBuilderV2;
    asStringWithSeparator(separator: string): string;
    toString(): string;
}
export declare class ActionsIdentityPolicyUtility {
    private readonly scope;
    private readonly utilitySettings;
    static create(scope: Construct, settings: ActionsIdentityPolicyUtilitySettings): ActionsIdentityPolicyUtility;
    get claimsContext(): IClaimsContext;
    private constructor();
    /**
     * Use this to create principals that should allow assumption via a Cognito Identity Pool
     */
    newPrincipalBuilder(amr?: AuthenticatedMethodReference): PrincipalBuilder;
    /**
     * Use this to create principals that should be assumable by roles that have been assumed via a ActionsIdentityPoolV2
     */
    newChainedPrincipalBuilder(): ChainedPrincipalBuilder;
    /**
     * Append a policy with conditions contextual to GitHub Actions claims
     */
    constrain(policyStatement: iam.PolicyStatement, scope?: Construct): PolicyStatementConstrainer;
    /**
     * Append a grant with conditions contextual to GitHub Actions claims
     */
    constrainGrant(grant: iam.Grant, scope?: Construct): GrantConstrainer;
    /**
     * Build a resource path for an IAM Policy
     * @param value Mix of strings and claims
     */
    resourcePath(...value: (GhaClaim | string)[]): ActionsIdentityIamResourcePathBuilderV2;
    /**
     * Create a policy variable
     */
    policyVar(claim: GhaClaim): PolicyVariable;
    /**
     * Create a principal tag for claim
     */
    principalTagConditionKey(claim: GhaClaim): AwsPrincipalTagConditionKey;
    /**
     * Grant role permissions to assume roles in any organization account
     */
    grantOrganizationRoleChain(identity: iam.IGrantable, settings: GrantOrgRoleChainSettings): iam.Grant;
}
