"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityPolicyUtility = exports.ActionsIdentityIamResourcePathBuilderV2 = exports.ChainedPrincipalBuilder = exports.ChainedPrincipal = exports.PrincipalBuilder = exports.ConstraintsBuilder = exports.GrantConstrainer = exports.PolicyStatementConstrainer = exports.Constrainer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_iam_utilities_1 = require("@catnekaise/cdk-iam-utilities");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const claims_1 = require("./claims");
const constraints_1 = require("./constraints");
const helpers_1 = require("./helpers");
class Constrainer extends constraints_1.ActionsIdentityConstraints {
    constructor(settings) {
        super();
        this.settings = settings;
    }
    hasResourceTagEqualToClaim(resourceTagName, claim) {
        this.addConstraint(cdk_iam_utilities_1.ResourceTagConstraint.create(cdk_iam_utilities_1.StringConditionOperator.STRING_EQUALS, resourceTagName, cdk_iam_utilities_1.PolicyVariable.principalTag(cdk_iam_utilities_1.ClaimsUtility.forContext(this.settings.claimsContext).tagNameForClaim(claim)).toString()));
        return this;
    }
}
exports.Constrainer = Constrainer;
_a = JSII_RTTI_SYMBOL_1;
Constrainer[_a] = { fqn: "@catnekaise/actions-constructs.Constrainer", version: "0.2.17" };
class PolicyStatementConstrainer extends Constrainer {
    static create(scope, policyStatement, settings) {
        return new PolicyStatementConstrainer(scope, policyStatement, settings);
    }
    constructor(scope, policyStatement, settings) {
        super(settings);
        this.scope = scope;
        this.policyStatement = policyStatement;
    }
    addConstraint(constraint) {
        cdk_iam_utilities_1.ConstraintsUtility.forConstraints([constraint])
            .appendPolicy(this.scope, {
            policyType: cdk_iam_utilities_1.PolicyType.NonSpecific,
            claimsContext: this.settings.claimsContext,
        }, this.policyStatement);
    }
    add(constraint) {
        cdk_iam_utilities_1.ConstraintsUtility.forConstraints([constraint])
            .appendPolicy(this.scope, {
            policyType: cdk_iam_utilities_1.PolicyType.NonSpecific,
            claimsContext: this.settings.claimsContext,
        }, this.policyStatement);
        return this;
    }
}
exports.PolicyStatementConstrainer = PolicyStatementConstrainer;
_b = JSII_RTTI_SYMBOL_1;
PolicyStatementConstrainer[_b] = { fqn: "@catnekaise/actions-constructs.PolicyStatementConstrainer", version: "0.2.17" };
class GrantConstrainer extends Constrainer {
    static create(scope, grant, settings) {
        return new GrantConstrainer(scope, grant, settings);
    }
    constructor(scope, grant, settings) {
        super(settings);
        this.scope = scope;
        this.grant = grant;
    }
    addConstraint(constraint) {
        const util = cdk_iam_utilities_1.ConstraintsUtility.forConstraints([constraint]);
        util.appendGrant(this.scope, {
            claimsContext: this.settings.claimsContext,
            policyType: this.settings.policyType ?? cdk_iam_utilities_1.PolicyType.NonSpecific,
        }, this.grant);
    }
    add(constraint) {
        this.addConstraint(constraint);
        return this;
    }
}
exports.GrantConstrainer = GrantConstrainer;
_c = JSII_RTTI_SYMBOL_1;
GrantConstrainer[_c] = { fqn: "@catnekaise/actions-constructs.GrantConstrainer", version: "0.2.17" };
class ConstraintsBuilder extends constraints_1.ActionsIdentityConstraints {
    constructor(settings) {
        super();
        this.settings = settings;
        this.addedConstraints = [];
    }
    get constraints() {
        return this.addedConstraints;
    }
    // eslint-disable-next-line max-len
    applyToPolicyOfType(scope, statement, policyType, additionalConstraints) {
        const constraints = this.constraints;
        constraints.push(...additionalConstraints);
        cdk_iam_utilities_1.ConstraintsUtility.forConstraints(constraints).appendPolicy(scope, {
            policyType,
            claimsContext: this.settings.claimsContext,
        }, statement);
    }
}
exports.ConstraintsBuilder = ConstraintsBuilder;
_d = JSII_RTTI_SYMBOL_1;
ConstraintsBuilder[_d] = { fqn: "@catnekaise/actions-constructs.ConstraintsBuilder", version: "0.2.17" };
class PrincipalBuilder extends ConstraintsBuilder {
    static create(claimsContext, constraints) {
        const builder = new PrincipalBuilder({
            claimsContext,
        });
        constraints.forEach(x => builder.add(x));
        return builder;
    }
    addConstraint(constraint) {
        this.addedConstraints.push(constraint);
    }
    add(constraint, ...additionalConstraints) {
        this.addedConstraints.push(constraint);
        additionalConstraints.forEach(x => this.addConstraint(x));
        return this;
    }
    /**
     * @param scope Any construct will do. Is used for annotating warnings
     */
    createPrincipal(scope) {
        const stmt = new iam.PolicyStatement();
        if (this.constraints.filter(x => x instanceof constraints_1.GitHubActionsClaimConstraint).length === 0) {
            throw new Error('At least one GitHub Actions claim constraint shall be added to the trust policy');
        }
        this.applyToPolicyOfType(scope, stmt, cdk_iam_utilities_1.PolicyType.trustPolicy(cdk_iam_utilities_1.PrincipalType.Federated), []);
        const repoClaim = this.settings.claimsContext.mappedClaims.claims.find(x => x.name === claims_1.GhaClaim.REPOSITORY);
        const repoOwnerClaim = this.settings.claimsContext.mappedClaims.claims.find(x => x.name === claims_1.GhaClaim.REPOSITORY_OWNER);
        if (!repoClaim && !repoOwnerClaim) {
            aws_cdk_lib_1.Annotations.of(scope).addWarning('Not mapping either the repository claim or the repository_owner and then checking one of them in trust policy is not recommended.');
        }
        else if (repoClaim && !stmt.conditions.StringEquals?.[`aws:RequestTag/${repoClaim.tagName}`] && !stmt.conditions.StringLike?.[`aws:RequestTag/${repoClaim.tagName}`]) {
            aws_cdk_lib_1.Annotations.of(scope).addWarning('No conditions have been added to check value of the repository claim in this trust policy.');
        }
        else if (repoOwnerClaim && !stmt.conditions.StringEquals?.[`aws:RequestTag/${repoOwnerClaim.tagName}`]) {
            aws_cdk_lib_1.Annotations.of(scope).addWarning('No conditions have been added to check value of the repository_owner claim in this trust policy.');
        }
        return new iam.PrincipalWithConditions(new iam.FederatedPrincipal('cognito-identity.amazonaws.com', {}, 'sts:AssumeRoleWithWebIdentity'), stmt.conditions)
            .withSessionTags();
    }
}
exports.PrincipalBuilder = PrincipalBuilder;
_e = JSII_RTTI_SYMBOL_1;
PrincipalBuilder[_e] = { fqn: "@catnekaise/actions-constructs.PrincipalBuilder", version: "0.2.17" };
class ChainedPrincipal extends iam.PrincipalBase {
    constructor(principal, sessionTags, externalIds) {
        super();
        this.principal = principal;
        this.sessionTags = sessionTags;
        this.externalIds = externalIds;
    }
    addToAssumeRolePolicy(doc) {
        if (this.sessionTags) {
            const sessionPrincipal = new iam.SessionTagsPrincipal(this.principal);
            sessionPrincipal.addToAssumeRolePolicy(doc);
        }
        else {
            this.principal.addToAssumeRolePolicy(doc);
        }
        if (this.externalIds.length > 0) {
            doc.addStatements(new iam.PolicyStatement({
                effect: iam.Effect.DENY,
                actions: ['sts:AssumeRole'],
                conditions: {
                    StringNotEquals: {
                        'sts:ExternalId': this.externalIds.length === 1 ? this.externalIds[0] : this.externalIds,
                    },
                },
                principals: [new iam.AnyPrincipal()],
            }));
        }
    }
    get policyFragment() {
        return this.principal.policyFragment;
    }
    dedupeString() {
        return '';
    }
}
exports.ChainedPrincipal = ChainedPrincipal;
_f = JSII_RTTI_SYMBOL_1;
ChainedPrincipal[_f] = { fqn: "@catnekaise/actions-constructs.ChainedPrincipal", version: "0.2.17" };
class ChainedPrincipalBuilder extends ConstraintsBuilder {
    static create(claimsContext) {
        return new ChainedPrincipalBuilder({
            claimsContext,
        });
    }
    constructor(builderSettings) {
        super(builderSettings);
    }
    addConstraint(constraint) {
        this.addedConstraints.push(constraint);
    }
    add(constraint, ...additionalConstraints) {
        this.addedConstraints.push(constraint);
        additionalConstraints.forEach(x => this.addConstraint(x));
        return this;
    }
    createPrincipalAssumedBy(scope, principal, options) {
        const stmt = new iam.PolicyStatement();
        const constraints = this.createPassClaimsConstraint(options);
        const passesClaims = constraints.length > 0;
        const fedProvider = new cdk_iam_utilities_1.GenericConstraint(cdk_iam_utilities_1.ConditionOperator.STRING_EQUALS, cdk_iam_utilities_1.GlobalConditionKey.FederatedProvider, 'cognito-identity.amazonaws.com');
        constraints.push(fedProvider);
        this.applyToPolicyOfType(scope, stmt, cdk_iam_utilities_1.PolicyType.trustPolicy(cdk_iam_utilities_1.PrincipalType.Aws), constraints);
        const principalWithConditions = new iam.PrincipalWithConditions(principal, stmt.conditions);
        return new ChainedPrincipal(principalWithConditions, passesClaims, []);
    }
    createPassClaimsConstraint(options) {
        const claimsToBePassed = options?.passClaims;
        if (!claimsToBePassed || Object.keys(claimsToBePassed.claims).length === 0) {
            return [];
        }
        return [cdk_iam_utilities_1.PassClaimsConstraint.create(claimsToBePassed)];
    }
}
exports.ChainedPrincipalBuilder = ChainedPrincipalBuilder;
_g = JSII_RTTI_SYMBOL_1;
ChainedPrincipalBuilder[_g] = { fqn: "@catnekaise/actions-constructs.ChainedPrincipalBuilder", version: "0.2.17" };
class ActionsIdentityIamResourcePathBuilderV2 extends cdk_iam_utilities_1.ClaimsIamResourcePathBuilder {
    static fromMappedClaims(mappedClaims) {
        return new ActionsIdentityIamResourcePathBuilderV2({
            claimsContext: {
                mappedClaims,
                knownClaims: claims_1.GitHubActionClaims,
            },
        }, []);
    }
    constructor(settings, path) {
        super(settings, path);
    }
    claim(claim, ...additionalClaims) {
        return new ActionsIdentityIamResourcePathBuilderV2(this.options, this.appendClaim(claim, ...additionalClaims));
    }
    value(value, ...additionalValues) {
        const values = [value, ...additionalValues].map(x => {
            const valueLc = x.toLowerCase();
            if (claims_1.GitHubActionClaims.includes(valueLc)) {
                return valueLc;
            }
            return x;
        });
        return new ActionsIdentityIamResourcePathBuilderV2(this.options, this.appendValue(...values));
    }
    text(value, ...additionalValues) {
        return new ActionsIdentityIamResourcePathBuilderV2(this.options, this.appendText(value, ...additionalValues));
    }
    policyVariable(value) {
        return new ActionsIdentityIamResourcePathBuilderV2(this.options, this.appendPolicyVariable(value));
    }
    asStringWithSeparator(separator) {
        return this.path.join(separator);
    }
    toString() {
        return this.path.join('/');
    }
}
exports.ActionsIdentityIamResourcePathBuilderV2 = ActionsIdentityIamResourcePathBuilderV2;
_h = JSII_RTTI_SYMBOL_1;
ActionsIdentityIamResourcePathBuilderV2[_h] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityIamResourcePathBuilderV2", version: "0.2.17" };
class ActionsIdentityPolicyUtility {
    static create(scope, settings) {
        return new ActionsIdentityPolicyUtility(scope, settings);
    }
    get claimsContext() {
        return this.utilitySettings.claimsContext;
    }
    ;
    constructor(scope, utilitySettings) {
        this.scope = scope;
        this.utilitySettings = utilitySettings;
    }
    /**
     * Use this to create principals that should allow assumption via a Cognito Identity Pool
     */
    newPrincipalBuilder(amr) {
        const { identityPoolId, defaultAmr, } = this.utilitySettings;
        if (!identityPoolId) {
            throw new Error('Cannot create a principal builder without providing the identity pool id');
        }
        const useAmr = (0, helpers_1.getAmrValue)(this.scope, amr ?? defaultAmr);
        const constraints = this.utilitySettings.basePrincipalConstraints ?? [];
        constraints.push(cdk_iam_utilities_1.StsCognitoIdentityConstraint.identityPool(identityPoolId, useAmr));
        return PrincipalBuilder.create(this.claimsContext, constraints);
    }
    /**
     * Use this to create principals that should be assumable by roles that have been assumed via a ActionsIdentityPoolV2
     */
    newChainedPrincipalBuilder() {
        return ChainedPrincipalBuilder.create(this.claimsContext);
    }
    /**
     * Append a policy with conditions contextual to GitHub Actions claims
     */
    constrain(policyStatement, scope) {
        scope = scope ?? this.scope;
        return PolicyStatementConstrainer.create(scope, policyStatement, { claimsContext: this.claimsContext });
    }
    /**
     * Append a grant with conditions contextual to GitHub Actions claims
     */
    constrainGrant(grant, scope) {
        scope = scope ?? this.scope;
        return GrantConstrainer.create(scope, grant, { claimsContext: this.claimsContext });
    }
    /**
     * Build a resource path for an IAM Policy
     * @param value Mix of strings and claims
     */
    resourcePath(...value) {
        let resourcePath = ActionsIdentityIamResourcePathBuilderV2.fromMappedClaims(this.claimsContext.mappedClaims);
        if (value.length > 0) {
            for (const valueElement of value) {
                resourcePath = resourcePath.value(valueElement);
            }
        }
        return resourcePath;
    }
    /**
     * Create a policy variable
     */
    policyVar(claim) {
        return cdk_iam_utilities_1.PolicyVariable.principalTag(cdk_iam_utilities_1.ClaimsUtility.forContext(this.claimsContext).tagNameForClaim(claim));
    }
    /**
     * Create a principal tag for claim
     */
    principalTagConditionKey(claim) {
        return cdk_iam_utilities_1.AwsPrincipalTagConditionKey.tag(cdk_iam_utilities_1.ClaimsUtility.forContext(this.claimsContext).tagNameForClaim(claim));
    }
    /**
     * Grant role permissions to assume roles in any organization account
     */
    grantOrganizationRoleChain(identity, settings) {
        const rolePath = settings.rolePath ?? '/';
        const roleArns = `arn:aws:iam::*:role${rolePath}*`;
        const assumeRoleStringEquals = {
            'aws:ResourceOrgID': cdk_iam_utilities_1.PolicyVariable.principalOrgId().toString(),
        };
        const assumeRoleStringNotEquals = {};
        const roleHasResourceTags = settings.roleHasResourceTags ?? {};
        if (Object.keys(roleHasResourceTags).length > 0) {
            const util = cdk_iam_utilities_1.ClaimsUtility.forContext(this.claimsContext);
            for (const key of Object.keys(roleHasResourceTags)) {
                let value = roleHasResourceTags[key];
                if (claims_1.GitHubActionClaims.includes(value.toLowerCase())) {
                    value = cdk_iam_utilities_1.PolicyVariable.principalTag(util.tagNameForClaim(value.toLowerCase())).toString();
                }
                assumeRoleStringEquals[cdk_iam_utilities_1.GlobalConditionKey.resourceTag(key).toString()] = value;
            }
        }
        else if (rolePath === '/') {
            throw new Error('Provide a rolePath or at least one resourceTag that is required on roles that will be assuming roles.');
        }
        if (!rolePath.endsWith('/') || !rolePath.startsWith('/')) {
            throw new Error('A rolePath must begin and end with "/"');
        }
        const accountIds = [];
        if (this.utilitySettings.identityPoolAccountId) {
            accountIds.push(this.utilitySettings.identityPoolAccountId);
        }
        if (settings.excludeAccountIds && settings.excludeAccountIds.length > 0) {
            accountIds.push(...settings.excludeAccountIds);
        }
        if (accountIds.length > 0) {
            assumeRoleStringNotEquals['aws:ResourceAccount'] = accountIds.length === 1 ? accountIds[0] : accountIds;
        }
        const assumeRoleGrant = {
            grantee: identity,
            actions: [
                'sts:AssumeRole',
            ],
            resourceArns: [
                roleArns,
            ],
            conditions: {
                StringEquals: assumeRoleStringEquals,
                StringNotEquals: assumeRoleStringNotEquals,
            },
        };
        if (settings.resourceOrgPaths?.length) {
            const operator = settings.resourceOrgPathStringEquals ? 'ForAnyValue:StringEquals' : 'ForAnyValue:StringLike';
            assumeRoleGrant.conditions[operator] = {
                'aws:ResourceOrgPaths': settings.resourceOrgPaths,
            };
        }
        const tagGrant = iam.Grant.addToPrincipal({
            grantee: identity,
            actions: [
                'sts:TagSession',
            ],
            resourceArns: [
                '*',
            ],
        });
        return tagGrant.combine(iam.Grant.addToPrincipal(assumeRoleGrant));
    }
}
exports.ActionsIdentityPolicyUtility = ActionsIdentityPolicyUtility;
_j = JSII_RTTI_SYMBOL_1;
ActionsIdentityPolicyUtility[_j] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityPolicyUtility", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LXV0aWxpdHkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaWRlbnRpdHktcG9vbC9wb2xpY3ktdXRpbGl0eS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHFFQXFCdUM7QUFDdkMsNkNBQTBDO0FBQzFDLDJDQUEyQztBQUczQyxxQ0FBd0Q7QUFDeEQsK0NBQXlGO0FBQ3pGLHVDQUF3QztBQVF4QyxNQUFzQixXQUFZLFNBQVEsd0NBQTBCO0lBRWxFLFlBQXlDLFFBQTZCO1FBQ3BFLEtBQUssRUFBRSxDQUFDO1FBRCtCLGFBQVEsR0FBUixRQUFRLENBQXFCO0lBRXRFLENBQUM7SUFFRCwwQkFBMEIsQ0FBQyxlQUF1QixFQUFFLEtBQWU7UUFFakUsSUFBSSxDQUFDLGFBQWEsQ0FBQyx5Q0FBcUIsQ0FBQyxNQUFNLENBQzdDLDJDQUF1QixDQUFDLGFBQWEsRUFDckMsZUFBZSxFQUNmLGtDQUFjLENBQUMsWUFBWSxDQUFDLGlDQUFhLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsUUFBUSxFQUFFLENBQ3JILENBQUMsQ0FBQztRQUVILE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7QUFmSCxrQ0FnQkM7OztBQUdELE1BQWEsMEJBQTJCLFNBQVEsV0FBVztJQUV6RCxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQWdCLEVBQUUsZUFBb0MsRUFBRSxRQUE2QjtRQUNqRyxPQUFPLElBQUksMEJBQTBCLENBQUMsS0FBSyxFQUFFLGVBQWUsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUMxRSxDQUFDO0lBRUQsWUFDbUIsS0FBZ0IsRUFDaEIsZUFBb0MsRUFDckQsUUFBNkI7UUFFN0IsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBSkMsVUFBSyxHQUFMLEtBQUssQ0FBVztRQUNoQixvQkFBZSxHQUFmLGVBQWUsQ0FBcUI7SUFJdkQsQ0FBQztJQUVTLGFBQWEsQ0FBQyxVQUFzQjtRQUM1QyxzQ0FBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQzthQUM1QyxZQUFZLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRTtZQUN4QixVQUFVLEVBQUUsOEJBQVUsQ0FBQyxXQUFXO1lBQ2xDLGFBQWEsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWE7U0FDM0MsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUdELEdBQUcsQ0FBQyxVQUFzQjtRQUN4QixzQ0FBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsQ0FBQzthQUM1QyxZQUFZLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRTtZQUN4QixVQUFVLEVBQUUsOEJBQVUsQ0FBQyxXQUFXO1lBQ2xDLGFBQWEsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWE7U0FDM0MsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7UUFFM0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOztBQS9CSCxnRUFpQ0M7OztBQUdELE1BQWEsZ0JBQWlCLFNBQVEsV0FBVztJQUcvQyxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQWdCLEVBQUUsS0FBZ0IsRUFBRSxRQUE2QjtRQUM3RSxPQUFPLElBQUksZ0JBQWdCLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQsWUFDbUIsS0FBZ0IsRUFDaEIsS0FBZ0IsRUFDakMsUUFBNkI7UUFFN0IsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBSkMsVUFBSyxHQUFMLEtBQUssQ0FBVztRQUNoQixVQUFLLEdBQUwsS0FBSyxDQUFXO0lBSW5DLENBQUM7SUFFUyxhQUFhLENBQUMsVUFBc0I7UUFHNUMsTUFBTSxJQUFJLEdBQUcsc0NBQWtCLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztRQUU3RCxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUU7WUFDM0IsYUFBYSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYTtZQUMxQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLElBQUksOEJBQVUsQ0FBQyxXQUFXO1NBQy9ELEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBRWpCLENBQUM7SUFFRCxHQUFHLENBQUMsVUFBc0I7UUFDeEIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUMvQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7O0FBOUJILDRDQWdDQzs7O0FBTUQsTUFBc0Isa0JBQW1CLFNBQVEsd0NBQTBCO0lBSXpFLFlBQXlDLFFBQXlCO1FBQ2hFLEtBQUssRUFBRSxDQUFDO1FBRCtCLGFBQVEsR0FBUixRQUFRLENBQWlCO1FBRi9DLHFCQUFnQixHQUFpQixFQUFFLENBQUM7SUFJdkQsQ0FBQztJQUVELElBQUksV0FBVztRQUNiLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFHRCxtQ0FBbUM7SUFDekIsbUJBQW1CLENBQUMsS0FBZ0IsRUFBRSxTQUE4QixFQUFFLFVBQXNCLEVBQUUscUJBQW1DO1FBRXpJLE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDckMsV0FBVyxDQUFDLElBQUksQ0FBQyxHQUFHLHFCQUFxQixDQUFDLENBQUM7UUFFM0Msc0NBQWtCLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUU7WUFDakUsVUFBVTtZQUNWLGFBQWEsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWE7U0FDM0MsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUVoQixDQUFDOztBQXhCSCxnREF5QkM7OztBQUVELE1BQWEsZ0JBQWlCLFNBQVEsa0JBQWtCO0lBR3RELE1BQU0sQ0FBQyxNQUFNLENBQUMsYUFBNkIsRUFBRSxXQUF5QjtRQUVwRSxNQUFNLE9BQU8sR0FBRyxJQUFJLGdCQUFnQixDQUFDO1lBQ25DLGFBQWE7U0FDZCxDQUFDLENBQUM7UUFFSCxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRXpDLE9BQU8sT0FBTyxDQUFDO0lBQ2pCLENBQUM7SUFFUyxhQUFhLENBQUMsVUFBc0I7UUFDNUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQsR0FBRyxDQUFDLFVBQXNCLEVBQUUsR0FBRyxxQkFBbUM7UUFFaEUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUN2QyxxQkFBcUIsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFFMUQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7O09BRUc7SUFDSCxlQUFlLENBQUMsS0FBZ0I7UUFFOUIsTUFBTSxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsZUFBZSxFQUFFLENBQUM7UUFFdkMsSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsWUFBWSwwQ0FBNEIsQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUN6RixNQUFNLElBQUksS0FBSyxDQUFDLGlGQUFpRixDQUFDLENBQUM7UUFDckcsQ0FBQztRQUVELElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFLDhCQUFVLENBQUMsV0FBVyxDQUFDLGlDQUFhLENBQUMsU0FBUyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFM0YsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxLQUFLLGlCQUFRLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDNUcsTUFBTSxjQUFjLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxLQUFLLGlCQUFRLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUV2SCxJQUFJLENBQUMsU0FBUyxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7WUFDbEMseUJBQVcsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsVUFBVSxDQUFDLG1JQUFtSSxDQUFDLENBQUM7UUFDeEssQ0FBQzthQUFNLElBQUksU0FBUyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLEVBQUUsQ0FBQyxrQkFBa0IsU0FBUyxDQUFDLE9BQU8sRUFBRSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFVBQVUsRUFBRSxDQUFDLGtCQUFrQixTQUFTLENBQUMsT0FBTyxFQUFFLENBQUMsRUFBRSxDQUFDO1lBQ3ZLLHlCQUFXLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLFVBQVUsQ0FBQyw0RkFBNEYsQ0FBQyxDQUFDO1FBQ2pJLENBQUM7YUFBTSxJQUFJLGNBQWMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsWUFBWSxFQUFFLENBQUMsa0JBQWtCLGNBQWMsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxFQUFFLENBQUM7WUFDekcseUJBQVcsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsVUFBVSxDQUFDLGtHQUFrRyxDQUFDLENBQUM7UUFDdkksQ0FBQztRQUdELE9BQU8sSUFBSSxHQUFHLENBQUMsdUJBQXVCLENBQUMsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsZ0NBQWdDLEVBQUUsRUFBRSxFQUFFLCtCQUErQixDQUFDLEVBQ3RJLElBQUksQ0FBQyxVQUFVLENBQUM7YUFDZixlQUFlLEVBQUUsQ0FBQztJQUV2QixDQUFDOztBQXZESCw0Q0F3REM7OztBQUVELE1BQWEsZ0JBQWlCLFNBQVEsR0FBRyxDQUFDLGFBQWE7SUFDckQsWUFDbUIsU0FBc0MsRUFDdEMsV0FBb0IsRUFDcEIsV0FBcUI7UUFFdEMsS0FBSyxFQUFFLENBQUM7UUFKUyxjQUFTLEdBQVQsU0FBUyxDQUE2QjtRQUN0QyxnQkFBVyxHQUFYLFdBQVcsQ0FBUztRQUNwQixnQkFBVyxHQUFYLFdBQVcsQ0FBVTtJQUd4QyxDQUFDO0lBRU0scUJBQXFCLENBQUMsR0FBdUI7UUFFbEQsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7WUFDckIsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7WUFDdEUsZ0JBQWdCLENBQUMscUJBQXFCLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDOUMsQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsU0FBUyxDQUFDLHFCQUFxQixDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzVDLENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQ2hDLEdBQUcsQ0FBQyxhQUFhLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO2dCQUN4QyxNQUFNLEVBQUUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxJQUFJO2dCQUN2QixPQUFPLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDM0IsVUFBVSxFQUFFO29CQUNWLGVBQWUsRUFBRTt3QkFDZixnQkFBZ0IsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxXQUFXO3FCQUN6RjtpQkFDRjtnQkFDRCxVQUFVLEVBQUUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxZQUFZLEVBQUUsQ0FBQzthQUNyQyxDQUFDLENBQUMsQ0FBQztRQUNOLENBQUM7SUFFSCxDQUFDO0lBRUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUM7SUFDdkMsQ0FBQztJQUVELFlBQVk7UUFDVixPQUFPLEVBQUUsQ0FBQztJQUNaLENBQUM7O0FBdkNILDRDQXlDQzs7O0FBb0NELE1BQWEsdUJBQXdCLFNBQVEsa0JBQWtCO0lBRTdELE1BQU0sQ0FBQyxNQUFNLENBQUMsYUFBNkI7UUFFekMsT0FBTyxJQUFJLHVCQUF1QixDQUFDO1lBQ2pDLGFBQWE7U0FDZCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsWUFBb0IsZUFBZ0M7UUFDbEQsS0FBSyxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ3pCLENBQUM7SUFFUyxhQUFhLENBQUMsVUFBc0I7UUFDNUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQsR0FBRyxDQUFDLFVBQXNCLEVBQUUsR0FBRyxxQkFBbUM7UUFFaEUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUN2QyxxQkFBcUIsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFFMUQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQsd0JBQXdCLENBQUMsS0FBZ0IsRUFBRSxTQUF5QixFQUFFLE9BQXVDO1FBRTNHLE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLGVBQWUsRUFBRSxDQUFDO1FBRXZDLE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUM3RCxNQUFNLFlBQVksR0FBRyxXQUFXLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQztRQUU1QyxNQUFNLFdBQVcsR0FBRyxJQUFJLHFDQUFpQixDQUFDLHFDQUFpQixDQUFDLGFBQWEsRUFBRSxzQ0FBa0IsQ0FBQyxpQkFBaUIsRUFBRSxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ25KLFdBQVcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7UUFFOUIsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUUsOEJBQVUsQ0FBQyxXQUFXLENBQUMsaUNBQWEsQ0FBQyxHQUFHLENBQUMsRUFBRSxXQUFXLENBQUMsQ0FBQztRQUU5RixNQUFNLHVCQUF1QixHQUFHLElBQUksR0FBRyxDQUFDLHVCQUF1QixDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFNUYsT0FBTyxJQUFJLGdCQUFnQixDQUFDLHVCQUF1QixFQUFFLFlBQVksRUFBRSxFQUFFLENBQUMsQ0FBQztJQUV6RSxDQUFDO0lBRU8sMEJBQTBCLENBQUMsT0FBdUM7UUFFeEUsTUFBTSxnQkFBZ0IsR0FBRyxPQUFPLEVBQUUsVUFBVSxDQUFDO1FBRTdDLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUMzRSxPQUFPLEVBQUUsQ0FBQztRQUNaLENBQUM7UUFFRCxPQUFPLENBQUMsd0NBQW9CLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUN6RCxDQUFDOztBQXBESCwwREFzREM7OztBQVlELE1BQWEsdUNBQXdDLFNBQVEsZ0RBQTRCO0lBRXZGLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxZQUEyQjtRQUNqRCxPQUFPLElBQUksdUNBQXVDLENBQUM7WUFDakQsYUFBYSxFQUFFO2dCQUNiLFlBQVk7Z0JBQ1osV0FBVyxFQUFFLDJCQUEyQjthQUN6QztTQUNGLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFDVCxDQUFDO0lBRUQsWUFBb0IsUUFBOEMsRUFBRSxJQUFjO1FBQ2hGLEtBQUssQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFDeEIsQ0FBQztJQUVELEtBQUssQ0FBQyxLQUFlLEVBQUUsR0FBRyxnQkFBNEI7UUFDcEQsT0FBTyxJQUFJLHVDQUF1QyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsR0FBRyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDakgsQ0FBQztJQUVELEtBQUssQ0FBQyxLQUF3QixFQUFFLEdBQUcsZ0JBQXVDO1FBRXhFLE1BQU0sTUFBTSxHQUFHLENBQUMsS0FBSyxFQUFFLEdBQUcsZ0JBQWdCLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUU7WUFFbEQsTUFBTSxPQUFPLEdBQUcsQ0FBQyxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ2hDLElBQUksMkJBQWtCLENBQUMsUUFBUSxDQUFDLE9BQWdCLENBQUMsRUFBRSxDQUFDO2dCQUNsRCxPQUFPLE9BQU8sQ0FBQztZQUNqQixDQUFDO1lBRUQsT0FBTyxDQUFDLENBQUM7UUFFWCxDQUFDLENBQUMsQ0FBQztRQUVILE9BQU8sSUFBSSx1Q0FBdUMsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLENBQUM7SUFFRCxJQUFJLENBQUMsS0FBYSxFQUFFLEdBQUcsZ0JBQTBCO1FBQy9DLE9BQU8sSUFBSSx1Q0FBdUMsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLEdBQUcsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQ2hILENBQUM7SUFFRCxjQUFjLENBQUMsS0FBcUI7UUFDbEMsT0FBTyxJQUFJLHVDQUF1QyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDckcsQ0FBQztJQUVELHFCQUFxQixDQUFDLFNBQWlCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDbkMsQ0FBQztJQUVELFFBQVE7UUFDTixPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQzdCLENBQUM7O0FBakRILDBGQW1EQzs7O0FBRUQsTUFBYSw0QkFBNEI7SUFFdkMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxLQUFnQixFQUFFLFFBQThDO1FBQzVFLE9BQU8sSUFBSSw0QkFBNEIsQ0FBQyxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUVELElBQUksYUFBYTtRQUNmLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLENBQUM7SUFDNUMsQ0FBQztJQUFBLENBQUM7SUFFRixZQUFxQyxLQUFnQixFQUFtQixlQUFxRDtRQUF4RixVQUFLLEdBQUwsS0FBSyxDQUFXO1FBQW1CLG9CQUFlLEdBQWYsZUFBZSxDQUFzQztJQUM3SCxDQUFDO0lBRUQ7O09BRUc7SUFDSCxtQkFBbUIsQ0FBQyxHQUFrQztRQUVwRCxNQUFNLEVBQ0osY0FBYyxFQUNkLFVBQVUsR0FDWCxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7UUFFekIsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1lBQ3BCLE1BQU0sSUFBSSxLQUFLLENBQUMsMEVBQTBFLENBQUMsQ0FBQztRQUM5RixDQUFDO1FBRUQsTUFBTSxNQUFNLEdBQUcsSUFBQSxxQkFBVyxFQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsR0FBRyxJQUFJLFVBQVUsQ0FBQyxDQUFDO1FBRTFELE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsd0JBQXdCLElBQUksRUFBRSxDQUFDO1FBQ3hFLFdBQVcsQ0FBQyxJQUFJLENBQUMsZ0RBQTRCLENBQUMsWUFBWSxDQUFDLGNBQWMsRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBRXBGLE9BQU8sZ0JBQWdCLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsV0FBVyxDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUVEOztPQUVHO0lBQ0gsMEJBQTBCO1FBRXhCLE9BQU8sdUJBQXVCLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBRUQ7O09BRUc7SUFDSCxTQUFTLENBQUMsZUFBb0MsRUFBRSxLQUFpQjtRQUUvRCxLQUFLLEdBQUcsS0FBSyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUM7UUFFNUIsT0FBTywwQkFBMEIsQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLGVBQWUsRUFBRSxFQUFFLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUMsQ0FBQztJQUMxRyxDQUFDO0lBRUQ7O09BRUc7SUFDSCxjQUFjLENBQUMsS0FBZ0IsRUFBRSxLQUFpQjtRQUVoRCxLQUFLLEdBQUcsS0FBSyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUM7UUFFNUIsT0FBTyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUMsQ0FBQztJQUN0RixDQUFDO0lBRUQ7OztPQUdHO0lBQ0gsWUFBWSxDQUFDLEdBQUcsS0FBNEI7UUFDMUMsSUFBSSxZQUFZLEdBQUcsdUNBQXVDLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUU3RyxJQUFJLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDckIsS0FBSyxNQUFNLFlBQVksSUFBSSxLQUFLLEVBQUUsQ0FBQztnQkFDakMsWUFBWSxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUM7WUFFbEQsQ0FBQztRQUNILENBQUM7UUFFRCxPQUFPLFlBQVksQ0FBQztJQUN0QixDQUFDO0lBRUQ7O09BRUc7SUFDSCxTQUFTLENBQUMsS0FBZTtRQUN2QixPQUFPLGtDQUFjLENBQUMsWUFBWSxDQUFDLGlDQUFhLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUMxRyxDQUFDO0lBRUQ7O09BRUc7SUFDSCx3QkFBd0IsQ0FBQyxLQUFlO1FBQ3RDLE9BQU8sK0NBQTJCLENBQUMsR0FBRyxDQUFDLGlDQUFhLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUM5RyxDQUFDO0lBRUQ7O09BRUc7SUFDSCwwQkFBMEIsQ0FBQyxRQUF3QixFQUFFLFFBQW1DO1FBRXRGLE1BQU0sUUFBUSxHQUFHLFFBQVEsQ0FBQyxRQUFRLElBQUksR0FBRyxDQUFDO1FBQzFDLE1BQU0sUUFBUSxHQUFHLHNCQUFzQixRQUFRLEdBQUcsQ0FBQztRQUVuRCxNQUFNLHNCQUFzQixHQUF5QztZQUNuRSxtQkFBbUIsRUFBRSxrQ0FBYyxDQUFDLGNBQWMsRUFBRSxDQUFDLFFBQVEsRUFBRTtTQUNoRSxDQUFDO1FBQ0YsTUFBTSx5QkFBeUIsR0FBeUMsRUFBRSxDQUFDO1FBRTNFLE1BQU0sbUJBQW1CLEdBQUcsUUFBUSxDQUFDLG1CQUFtQixJQUFJLEVBQUUsQ0FBQztRQUUvRCxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFFaEQsTUFBTSxJQUFJLEdBQUcsaUNBQWEsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBRTFELEtBQUssTUFBTSxHQUFHLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxFQUFFLENBQUM7Z0JBRW5ELElBQUksS0FBSyxHQUFHLG1CQUFtQixDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUVyQyxJQUFJLDJCQUFrQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFXLENBQUMsRUFBRSxDQUFDO29CQUM5RCxLQUFLLEdBQUcsa0NBQWMsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDO2dCQUM1RixDQUFDO2dCQUVELHNCQUFzQixDQUFDLHNDQUFrQixDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxHQUFHLEtBQUssQ0FBQztZQUNqRixDQUFDO1FBQ0gsQ0FBQzthQUFNLElBQUksUUFBUSxLQUFLLEdBQUcsRUFBRSxDQUFDO1lBQzVCLE1BQU0sSUFBSSxLQUFLLENBQUMsdUdBQXVHLENBQUMsQ0FBQztRQUMzSCxDQUFDO1FBRUQsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDekQsTUFBTSxJQUFJLEtBQUssQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDO1FBQzVELENBQUM7UUFFRCxNQUFNLFVBQVUsR0FBRyxFQUFFLENBQUM7UUFFdEIsSUFBSSxJQUFJLENBQUMsZUFBZSxDQUFDLHFCQUFxQixFQUFFLENBQUM7WUFDL0MsVUFBVSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDOUQsQ0FBQztRQUVELElBQUksUUFBUSxDQUFDLGlCQUFpQixJQUFJLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDeEUsVUFBVSxDQUFDLElBQUksQ0FBQyxHQUFHLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ2pELENBQUM7UUFFRCxJQUFJLFVBQVUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDMUIseUJBQXlCLENBQUMscUJBQXFCLENBQUMsR0FBRyxVQUFVLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7UUFDMUcsQ0FBQztRQUVELE1BQU0sZUFBZSxHQUFnQztZQUNuRCxPQUFPLEVBQUUsUUFBUTtZQUNqQixPQUFPLEVBQUU7Z0JBQ1AsZ0JBQWdCO2FBQ2pCO1lBQ0QsWUFBWSxFQUFFO2dCQUNaLFFBQVE7YUFDVDtZQUNELFVBQVUsRUFBRTtnQkFDVixZQUFZLEVBQUUsc0JBQXNCO2dCQUNwQyxlQUFlLEVBQUUseUJBQXlCO2FBQzNDO1NBQ0YsQ0FBQztRQUVGLElBQUksUUFBUSxDQUFDLGdCQUFnQixFQUFFLE1BQU0sRUFBRSxDQUFDO1lBQ3RDLE1BQU0sUUFBUSxHQUFHLFFBQVEsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUMsMEJBQTBCLENBQUMsQ0FBQyxDQUFDLHdCQUF3QixDQUFDO1lBRTdHLGVBQWUsQ0FBQyxVQUFrQixDQUFDLFFBQVEsQ0FBQyxHQUFHO2dCQUM5QyxzQkFBc0IsRUFBRSxRQUFRLENBQUMsZ0JBQWdCO2FBQ2xELENBQUM7UUFDSixDQUFDO1FBR0QsTUFBTSxRQUFRLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUM7WUFDeEMsT0FBTyxFQUFFLFFBQVE7WUFDakIsT0FBTyxFQUFFO2dCQUNQLGdCQUFnQjthQUNqQjtZQUNELFlBQVksRUFBRTtnQkFDWixHQUFHO2FBQ0o7U0FDRixDQUFDLENBQUM7UUFFSCxPQUFPLFFBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUVyRSxDQUFDOztBQXBMSCxvRUFzTEMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBBd3NQcmluY2lwYWxUYWdDb25kaXRpb25LZXksXG4gIENsYWltc0lhbVJlc291cmNlUGF0aEJ1aWxkZXIsXG4gIENsYWltc0lhbVJlc291cmNlUGF0aEJ1aWxkZXJTZXR0aW5ncyxcbiAgQ2xhaW1zVXRpbGl0eSxcbiAgQ29uZGl0aW9uT3BlcmF0b3IsXG4gIENvbnN0cmFpbnQsXG4gIENvbnN0cmFpbnRzVXRpbGl0eSxcbiAgR2VuZXJpY0NvbnN0cmFpbnQsXG4gIEdsb2JhbENvbmRpdGlvbktleSxcbiAgSUNsYWltc0NvbnRleHQsXG4gIElDb25zdHJhaW50c0J1aWxkZXIsXG4gIElNYXBwZWRDbGFpbXMsXG4gIFBhc3NDbGFpbXNDb25zdHJhaW50LFxuICBQYXNzQ2xhaW1zQ29uc3RyYWludFNldHRpbmdzLFxuICBQb2xpY3lUeXBlLFxuICBQb2xpY3lWYXJpYWJsZSxcbiAgUHJpbmNpcGFsVHlwZSxcbiAgUmVzb3VyY2VUYWdDb25zdHJhaW50LFxuICBTdHJpbmdDb25kaXRpb25PcGVyYXRvcixcbiAgU3RzQ29nbml0b0lkZW50aXR5Q29uc3RyYWludCxcbn0gZnJvbSAnQGNhdG5la2Fpc2UvY2RrLWlhbS11dGlsaXRpZXMnO1xuaW1wb3J0IHsgQW5ub3RhdGlvbnMgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBQcmluY2lwYWxQb2xpY3lGcmFnbWVudCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBHaGFDbGFpbSwgR2l0SHViQWN0aW9uQ2xhaW1zIH0gZnJvbSAnLi9jbGFpbXMnO1xuaW1wb3J0IHsgQWN0aW9uc0lkZW50aXR5Q29uc3RyYWludHMsIEdpdEh1YkFjdGlvbnNDbGFpbUNvbnN0cmFpbnQgfSBmcm9tICcuL2NvbnN0cmFpbnRzJztcbmltcG9ydCB7IGdldEFtclZhbHVlIH0gZnJvbSAnLi9oZWxwZXJzJztcbmltcG9ydCB7IEF1dGhlbnRpY2F0ZWRNZXRob2RSZWZlcmVuY2UgfSBmcm9tICcuL3R5cGVzJztcblxuZXhwb3J0IGludGVyZmFjZSBDb25zdHJhaW5lclNldHRpbmdzIHtcbiAgcmVhZG9ubHkgY2xhaW1zQ29udGV4dDogSUNsYWltc0NvbnRleHQ7XG4gIHJlYWRvbmx5IHBvbGljeVR5cGU/OiBQb2xpY3lUeXBlO1xufVxuXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQ29uc3RyYWluZXIgZXh0ZW5kcyBBY3Rpb25zSWRlbnRpdHlDb25zdHJhaW50cyB7XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKHByb3RlY3RlZCByZWFkb25seSBzZXR0aW5nczogQ29uc3RyYWluZXJTZXR0aW5ncykge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBoYXNSZXNvdXJjZVRhZ0VxdWFsVG9DbGFpbShyZXNvdXJjZVRhZ05hbWU6IHN0cmluZywgY2xhaW06IEdoYUNsYWltKTogdGhpcyB7XG5cbiAgICB0aGlzLmFkZENvbnN0cmFpbnQoUmVzb3VyY2VUYWdDb25zdHJhaW50LmNyZWF0ZShcbiAgICAgIFN0cmluZ0NvbmRpdGlvbk9wZXJhdG9yLlNUUklOR19FUVVBTFMsXG4gICAgICByZXNvdXJjZVRhZ05hbWUsXG4gICAgICBQb2xpY3lWYXJpYWJsZS5wcmluY2lwYWxUYWcoQ2xhaW1zVXRpbGl0eS5mb3JDb250ZXh0KHRoaXMuc2V0dGluZ3MuY2xhaW1zQ29udGV4dCkudGFnTmFtZUZvckNsYWltKGNsYWltKSkudG9TdHJpbmcoKSxcbiAgICApKTtcblxuICAgIHJldHVybiB0aGlzO1xuICB9XG59XG5cblxuZXhwb3J0IGNsYXNzIFBvbGljeVN0YXRlbWVudENvbnN0cmFpbmVyIGV4dGVuZHMgQ29uc3RyYWluZXIge1xuXG4gIHN0YXRpYyBjcmVhdGUoc2NvcGU6IENvbnN0cnVjdCwgcG9saWN5U3RhdGVtZW50OiBpYW0uUG9saWN5U3RhdGVtZW50LCBzZXR0aW5nczogQ29uc3RyYWluZXJTZXR0aW5ncyk6IFBvbGljeVN0YXRlbWVudENvbnN0cmFpbmVyIHtcbiAgICByZXR1cm4gbmV3IFBvbGljeVN0YXRlbWVudENvbnN0cmFpbmVyKHNjb3BlLCBwb2xpY3lTdGF0ZW1lbnQsIHNldHRpbmdzKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHJlYWRvbmx5IHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgcHJpdmF0ZSByZWFkb25seSBwb2xpY3lTdGF0ZW1lbnQ6IGlhbS5Qb2xpY3lTdGF0ZW1lbnQsXG4gICAgc2V0dGluZ3M6IENvbnN0cmFpbmVyU2V0dGluZ3MsXG4gICkge1xuICAgIHN1cGVyKHNldHRpbmdzKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhZGRDb25zdHJhaW50KGNvbnN0cmFpbnQ6IENvbnN0cmFpbnQpOiB2b2lkIHtcbiAgICBDb25zdHJhaW50c1V0aWxpdHkuZm9yQ29uc3RyYWludHMoW2NvbnN0cmFpbnRdKVxuICAgICAgLmFwcGVuZFBvbGljeSh0aGlzLnNjb3BlLCB7XG4gICAgICAgIHBvbGljeVR5cGU6IFBvbGljeVR5cGUuTm9uU3BlY2lmaWMsXG4gICAgICAgIGNsYWltc0NvbnRleHQ6IHRoaXMuc2V0dGluZ3MuY2xhaW1zQ29udGV4dCxcbiAgICAgIH0sIHRoaXMucG9saWN5U3RhdGVtZW50KTtcbiAgfVxuXG5cbiAgYWRkKGNvbnN0cmFpbnQ6IENvbnN0cmFpbnQpOiB0aGlzIHtcbiAgICBDb25zdHJhaW50c1V0aWxpdHkuZm9yQ29uc3RyYWludHMoW2NvbnN0cmFpbnRdKVxuICAgICAgLmFwcGVuZFBvbGljeSh0aGlzLnNjb3BlLCB7XG4gICAgICAgIHBvbGljeVR5cGU6IFBvbGljeVR5cGUuTm9uU3BlY2lmaWMsXG4gICAgICAgIGNsYWltc0NvbnRleHQ6IHRoaXMuc2V0dGluZ3MuY2xhaW1zQ29udGV4dCxcbiAgICAgIH0sIHRoaXMucG9saWN5U3RhdGVtZW50KTtcblxuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbn1cblxuXG5leHBvcnQgY2xhc3MgR3JhbnRDb25zdHJhaW5lciBleHRlbmRzIENvbnN0cmFpbmVyIHtcblxuXG4gIHN0YXRpYyBjcmVhdGUoc2NvcGU6IENvbnN0cnVjdCwgZ3JhbnQ6IGlhbS5HcmFudCwgc2V0dGluZ3M6IENvbnN0cmFpbmVyU2V0dGluZ3MpOiBHcmFudENvbnN0cmFpbmVyIHtcbiAgICByZXR1cm4gbmV3IEdyYW50Q29uc3RyYWluZXIoc2NvcGUsIGdyYW50LCBzZXR0aW5ncyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSBzY29wZTogQ29uc3RydWN0LFxuICAgIHByaXZhdGUgcmVhZG9ubHkgZ3JhbnQ6IGlhbS5HcmFudCxcbiAgICBzZXR0aW5nczogQ29uc3RyYWluZXJTZXR0aW5ncyxcbiAgKSB7XG4gICAgc3VwZXIoc2V0dGluZ3MpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFkZENvbnN0cmFpbnQoY29uc3RyYWludDogQ29uc3RyYWludCk6IHZvaWQge1xuXG5cbiAgICBjb25zdCB1dGlsID0gQ29uc3RyYWludHNVdGlsaXR5LmZvckNvbnN0cmFpbnRzKFtjb25zdHJhaW50XSk7XG5cbiAgICB1dGlsLmFwcGVuZEdyYW50KHRoaXMuc2NvcGUsIHtcbiAgICAgIGNsYWltc0NvbnRleHQ6IHRoaXMuc2V0dGluZ3MuY2xhaW1zQ29udGV4dCxcbiAgICAgIHBvbGljeVR5cGU6IHRoaXMuc2V0dGluZ3MucG9saWN5VHlwZSA/PyBQb2xpY3lUeXBlLk5vblNwZWNpZmljLFxuICAgIH0sIHRoaXMuZ3JhbnQpO1xuXG4gIH1cblxuICBhZGQoY29uc3RyYWludDogQ29uc3RyYWludCk6IHRoaXMge1xuICAgIHRoaXMuYWRkQ29uc3RyYWludChjb25zdHJhaW50KTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQnVpbGRlclNldHRpbmdzIHtcbiAgcmVhZG9ubHkgY2xhaW1zQ29udGV4dDogSUNsYWltc0NvbnRleHQ7XG59XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBDb25zdHJhaW50c0J1aWxkZXIgZXh0ZW5kcyBBY3Rpb25zSWRlbnRpdHlDb25zdHJhaW50cyBpbXBsZW1lbnRzIElDb25zdHJhaW50c0J1aWxkZXIge1xuXG4gIHByb3RlY3RlZCByZWFkb25seSBhZGRlZENvbnN0cmFpbnRzOiBDb25zdHJhaW50W10gPSBbXTtcblxuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IocHJvdGVjdGVkIHJlYWRvbmx5IHNldHRpbmdzOiBCdWlsZGVyU2V0dGluZ3MpIHtcbiAgICBzdXBlcigpO1xuICB9XG5cbiAgZ2V0IGNvbnN0cmFpbnRzKCk6IENvbnN0cmFpbnRbXSB7XG4gICAgcmV0dXJuIHRoaXMuYWRkZWRDb25zdHJhaW50cztcbiAgfVxuXG5cbiAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG1heC1sZW5cbiAgcHJvdGVjdGVkIGFwcGx5VG9Qb2xpY3lPZlR5cGUoc2NvcGU6IENvbnN0cnVjdCwgc3RhdGVtZW50OiBpYW0uUG9saWN5U3RhdGVtZW50LCBwb2xpY3lUeXBlOiBQb2xpY3lUeXBlLCBhZGRpdGlvbmFsQ29uc3RyYWludHM6IENvbnN0cmFpbnRbXSk6IHZvaWQge1xuXG4gICAgY29uc3QgY29uc3RyYWludHMgPSB0aGlzLmNvbnN0cmFpbnRzO1xuICAgIGNvbnN0cmFpbnRzLnB1c2goLi4uYWRkaXRpb25hbENvbnN0cmFpbnRzKTtcblxuICAgIENvbnN0cmFpbnRzVXRpbGl0eS5mb3JDb25zdHJhaW50cyhjb25zdHJhaW50cykuYXBwZW5kUG9saWN5KHNjb3BlLCB7XG4gICAgICBwb2xpY3lUeXBlLFxuICAgICAgY2xhaW1zQ29udGV4dDogdGhpcy5zZXR0aW5ncy5jbGFpbXNDb250ZXh0LFxuICAgIH0sIHN0YXRlbWVudCk7XG5cbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgUHJpbmNpcGFsQnVpbGRlciBleHRlbmRzIENvbnN0cmFpbnRzQnVpbGRlciB7XG5cblxuICBzdGF0aWMgY3JlYXRlKGNsYWltc0NvbnRleHQ6IElDbGFpbXNDb250ZXh0LCBjb25zdHJhaW50czogQ29uc3RyYWludFtdKTogUHJpbmNpcGFsQnVpbGRlciB7XG5cbiAgICBjb25zdCBidWlsZGVyID0gbmV3IFByaW5jaXBhbEJ1aWxkZXIoe1xuICAgICAgY2xhaW1zQ29udGV4dCxcbiAgICB9KTtcblxuICAgIGNvbnN0cmFpbnRzLmZvckVhY2goeCA9PiBidWlsZGVyLmFkZCh4KSk7XG5cbiAgICByZXR1cm4gYnVpbGRlcjtcbiAgfVxuXG4gIHByb3RlY3RlZCBhZGRDb25zdHJhaW50KGNvbnN0cmFpbnQ6IENvbnN0cmFpbnQpOiB2b2lkIHtcbiAgICB0aGlzLmFkZGVkQ29uc3RyYWludHMucHVzaChjb25zdHJhaW50KTtcbiAgfVxuXG4gIGFkZChjb25zdHJhaW50OiBDb25zdHJhaW50LCAuLi5hZGRpdGlvbmFsQ29uc3RyYWludHM6IENvbnN0cmFpbnRbXSk6IHRoaXMge1xuXG4gICAgdGhpcy5hZGRlZENvbnN0cmFpbnRzLnB1c2goY29uc3RyYWludCk7XG4gICAgYWRkaXRpb25hbENvbnN0cmFpbnRzLmZvckVhY2goeCA9PiB0aGlzLmFkZENvbnN0cmFpbnQoeCkpO1xuXG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQHBhcmFtIHNjb3BlIEFueSBjb25zdHJ1Y3Qgd2lsbCBkby4gSXMgdXNlZCBmb3IgYW5ub3RhdGluZyB3YXJuaW5nc1xuICAgKi9cbiAgY3JlYXRlUHJpbmNpcGFsKHNjb3BlOiBDb25zdHJ1Y3QpOiBpYW0uSVByaW5jaXBhbCB7XG5cbiAgICBjb25zdCBzdG10ID0gbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoKTtcblxuICAgIGlmICh0aGlzLmNvbnN0cmFpbnRzLmZpbHRlcih4ID0+IHggaW5zdGFuY2VvZiBHaXRIdWJBY3Rpb25zQ2xhaW1Db25zdHJhaW50KS5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQXQgbGVhc3Qgb25lIEdpdEh1YiBBY3Rpb25zIGNsYWltIGNvbnN0cmFpbnQgc2hhbGwgYmUgYWRkZWQgdG8gdGhlIHRydXN0IHBvbGljeScpO1xuICAgIH1cblxuICAgIHRoaXMuYXBwbHlUb1BvbGljeU9mVHlwZShzY29wZSwgc3RtdCwgUG9saWN5VHlwZS50cnVzdFBvbGljeShQcmluY2lwYWxUeXBlLkZlZGVyYXRlZCksIFtdKTtcblxuICAgIGNvbnN0IHJlcG9DbGFpbSA9IHRoaXMuc2V0dGluZ3MuY2xhaW1zQ29udGV4dC5tYXBwZWRDbGFpbXMuY2xhaW1zLmZpbmQoeCA9PiB4Lm5hbWUgPT09IEdoYUNsYWltLlJFUE9TSVRPUlkpO1xuICAgIGNvbnN0IHJlcG9Pd25lckNsYWltID0gdGhpcy5zZXR0aW5ncy5jbGFpbXNDb250ZXh0Lm1hcHBlZENsYWltcy5jbGFpbXMuZmluZCh4ID0+IHgubmFtZSA9PT0gR2hhQ2xhaW0uUkVQT1NJVE9SWV9PV05FUik7XG5cbiAgICBpZiAoIXJlcG9DbGFpbSAmJiAhcmVwb093bmVyQ2xhaW0pIHtcbiAgICAgIEFubm90YXRpb25zLm9mKHNjb3BlKS5hZGRXYXJuaW5nKCdOb3QgbWFwcGluZyBlaXRoZXIgdGhlIHJlcG9zaXRvcnkgY2xhaW0gb3IgdGhlIHJlcG9zaXRvcnlfb3duZXIgYW5kIHRoZW4gY2hlY2tpbmcgb25lIG9mIHRoZW0gaW4gdHJ1c3QgcG9saWN5IGlzIG5vdCByZWNvbW1lbmRlZC4nKTtcbiAgICB9IGVsc2UgaWYgKHJlcG9DbGFpbSAmJiAhc3RtdC5jb25kaXRpb25zLlN0cmluZ0VxdWFscz8uW2Bhd3M6UmVxdWVzdFRhZy8ke3JlcG9DbGFpbS50YWdOYW1lfWBdICYmICFzdG10LmNvbmRpdGlvbnMuU3RyaW5nTGlrZT8uW2Bhd3M6UmVxdWVzdFRhZy8ke3JlcG9DbGFpbS50YWdOYW1lfWBdKSB7XG4gICAgICBBbm5vdGF0aW9ucy5vZihzY29wZSkuYWRkV2FybmluZygnTm8gY29uZGl0aW9ucyBoYXZlIGJlZW4gYWRkZWQgdG8gY2hlY2sgdmFsdWUgb2YgdGhlIHJlcG9zaXRvcnkgY2xhaW0gaW4gdGhpcyB0cnVzdCBwb2xpY3kuJyk7XG4gICAgfSBlbHNlIGlmIChyZXBvT3duZXJDbGFpbSAmJiAhc3RtdC5jb25kaXRpb25zLlN0cmluZ0VxdWFscz8uW2Bhd3M6UmVxdWVzdFRhZy8ke3JlcG9Pd25lckNsYWltLnRhZ05hbWV9YF0pIHtcbiAgICAgIEFubm90YXRpb25zLm9mKHNjb3BlKS5hZGRXYXJuaW5nKCdObyBjb25kaXRpb25zIGhhdmUgYmVlbiBhZGRlZCB0byBjaGVjayB2YWx1ZSBvZiB0aGUgcmVwb3NpdG9yeV9vd25lciBjbGFpbSBpbiB0aGlzIHRydXN0IHBvbGljeS4nKTtcbiAgICB9XG5cblxuICAgIHJldHVybiBuZXcgaWFtLlByaW5jaXBhbFdpdGhDb25kaXRpb25zKG5ldyBpYW0uRmVkZXJhdGVkUHJpbmNpcGFsKCdjb2duaXRvLWlkZW50aXR5LmFtYXpvbmF3cy5jb20nLCB7fSwgJ3N0czpBc3N1bWVSb2xlV2l0aFdlYklkZW50aXR5JyksXG4gICAgICBzdG10LmNvbmRpdGlvbnMpXG4gICAgICAud2l0aFNlc3Npb25UYWdzKCk7XG5cbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgQ2hhaW5lZFByaW5jaXBhbCBleHRlbmRzIGlhbS5QcmluY2lwYWxCYXNlIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSBwcmluY2lwYWw6IGlhbS5QcmluY2lwYWxXaXRoQ29uZGl0aW9ucyxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHNlc3Npb25UYWdzOiBib29sZWFuLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgZXh0ZXJuYWxJZHM6IHN0cmluZ1tdLFxuICApIHtcbiAgICBzdXBlcigpO1xuICB9XG5cbiAgcHVibGljIGFkZFRvQXNzdW1lUm9sZVBvbGljeShkb2M6IGlhbS5Qb2xpY3lEb2N1bWVudCkge1xuXG4gICAgaWYgKHRoaXMuc2Vzc2lvblRhZ3MpIHtcbiAgICAgIGNvbnN0IHNlc3Npb25QcmluY2lwYWwgPSBuZXcgaWFtLlNlc3Npb25UYWdzUHJpbmNpcGFsKHRoaXMucHJpbmNpcGFsKTtcbiAgICAgIHNlc3Npb25QcmluY2lwYWwuYWRkVG9Bc3N1bWVSb2xlUG9saWN5KGRvYyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucHJpbmNpcGFsLmFkZFRvQXNzdW1lUm9sZVBvbGljeShkb2MpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLmV4dGVybmFsSWRzLmxlbmd0aCA+IDApIHtcbiAgICAgIGRvYy5hZGRTdGF0ZW1lbnRzKG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgZWZmZWN0OiBpYW0uRWZmZWN0LkRFTlksXG4gICAgICAgIGFjdGlvbnM6IFsnc3RzOkFzc3VtZVJvbGUnXSxcbiAgICAgICAgY29uZGl0aW9uczoge1xuICAgICAgICAgIFN0cmluZ05vdEVxdWFsczoge1xuICAgICAgICAgICAgJ3N0czpFeHRlcm5hbElkJzogdGhpcy5leHRlcm5hbElkcy5sZW5ndGggPT09IDEgPyB0aGlzLmV4dGVybmFsSWRzWzBdIDogdGhpcy5leHRlcm5hbElkcyxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgICBwcmluY2lwYWxzOiBbbmV3IGlhbS5BbnlQcmluY2lwYWwoKV0sXG4gICAgICB9KSk7XG4gICAgfVxuXG4gIH1cblxuICBwdWJsaWMgZ2V0IHBvbGljeUZyYWdtZW50KCk6IFByaW5jaXBhbFBvbGljeUZyYWdtZW50IHtcbiAgICByZXR1cm4gdGhpcy5wcmluY2lwYWwucG9saWN5RnJhZ21lbnQ7XG4gIH1cblxuICBkZWR1cGVTdHJpbmcoKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gJyc7XG4gIH1cblxufVxuXG5leHBvcnQgaW50ZXJmYWNlIENoYWluZWRQcmluY2lwYWxDcmVhdGVPcHRpb25zIHtcbiAgcmVhZG9ubHkgcGFzc0NsYWltcz86IFBhc3NDbGFpbXNDb25zdHJhaW50U2V0dGluZ3M7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgR3JhbnRPcmdSb2xlQ2hhaW5TZXR0aW5ncyB7XG5cbiAgLyoqXG4gICAqIFJlcXVpcmUgdGhhdCByb2xlcyBleGlzdCB1bmRlciB0aGlzIHBhdGggZm9yIHN0czpBc3N1bWVSb2xlXG4gICAqL1xuICByZWFkb25seSByb2xlUGF0aD86IHN0cmluZztcblxuICAvKipcbiAgICogUm9sZSBoYXMgcmVzb3VyY2UgdGFncyBtYXRjaGluZyBzcGVjaWZpZWQgdmFsdWVzLlxuICAgKiBJZiB0YWcgdmFsdWUgbWF0Y2hlcyBhIGtub3duIEdpdEh1YiBBY3Rpb25zIGNsYWltLCB0aGVuIHZhbHVlIGlzIGNoYW5nZWQgdG8gYCR7YXdzOlByaW5jaXBhbFRhZy92YWx1ZX1gXG4gICAqL1xuICByZWFkb25seSByb2xlSGFzUmVzb3VyY2VUYWdzPzogeyBba2V5OiBzdHJpbmddOiBHaGFDbGFpbSB8IHN0cmluZyB9O1xuXG4gIC8qKlxuICAgKiBQcmV2ZW50IGFzc3VtaW5nIHJvbGVzIGluIHRoZXNlIGFjY291bnRzXG4gICAqL1xuICByZWFkb25seSBleGNsdWRlQWNjb3VudElkcz86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBSZXF1aXJlIHJvbGVzIHRvIGV4aXN0IHVuZGVyIHNwZWNpZmllZCBvcmdhbml6YXRpb24gcGF0aHNcbiAgICovXG4gIHJlYWRvbmx5IHJlc291cmNlT3JnUGF0aHM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogTWF0Y2ggcmVzb3VyY2VQYXRocyB1c2luZyBTdHJpbmdFcXVhbHMgaW5zdGVhZCBvZiBTdHJpbmdMaWtlXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZU9yZ1BhdGhTdHJpbmdFcXVhbHM/OiBib29sZWFuO1xufVxuXG5cbmV4cG9ydCBjbGFzcyBDaGFpbmVkUHJpbmNpcGFsQnVpbGRlciBleHRlbmRzIENvbnN0cmFpbnRzQnVpbGRlciB7XG5cbiAgc3RhdGljIGNyZWF0ZShjbGFpbXNDb250ZXh0OiBJQ2xhaW1zQ29udGV4dCk6IENoYWluZWRQcmluY2lwYWxCdWlsZGVyIHtcblxuICAgIHJldHVybiBuZXcgQ2hhaW5lZFByaW5jaXBhbEJ1aWxkZXIoe1xuICAgICAgY2xhaW1zQ29udGV4dCxcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoYnVpbGRlclNldHRpbmdzOiBCdWlsZGVyU2V0dGluZ3MpIHtcbiAgICBzdXBlcihidWlsZGVyU2V0dGluZ3MpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFkZENvbnN0cmFpbnQoY29uc3RyYWludDogQ29uc3RyYWludCk6IHZvaWQge1xuICAgIHRoaXMuYWRkZWRDb25zdHJhaW50cy5wdXNoKGNvbnN0cmFpbnQpO1xuICB9XG5cbiAgYWRkKGNvbnN0cmFpbnQ6IENvbnN0cmFpbnQsIC4uLmFkZGl0aW9uYWxDb25zdHJhaW50czogQ29uc3RyYWludFtdKTogdGhpcyB7XG5cbiAgICB0aGlzLmFkZGVkQ29uc3RyYWludHMucHVzaChjb25zdHJhaW50KTtcbiAgICBhZGRpdGlvbmFsQ29uc3RyYWludHMuZm9yRWFjaCh4ID0+IHRoaXMuYWRkQ29uc3RyYWludCh4KSk7XG5cbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGNyZWF0ZVByaW5jaXBhbEFzc3VtZWRCeShzY29wZTogQ29uc3RydWN0LCBwcmluY2lwYWw6IGlhbS5JUHJpbmNpcGFsLCBvcHRpb25zPzogQ2hhaW5lZFByaW5jaXBhbENyZWF0ZU9wdGlvbnMpOiBpYW0uSVByaW5jaXBhbCB7XG5cbiAgICBjb25zdCBzdG10ID0gbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoKTtcblxuICAgIGNvbnN0IGNvbnN0cmFpbnRzID0gdGhpcy5jcmVhdGVQYXNzQ2xhaW1zQ29uc3RyYWludChvcHRpb25zKTtcbiAgICBjb25zdCBwYXNzZXNDbGFpbXMgPSBjb25zdHJhaW50cy5sZW5ndGggPiAwO1xuXG4gICAgY29uc3QgZmVkUHJvdmlkZXIgPSBuZXcgR2VuZXJpY0NvbnN0cmFpbnQoQ29uZGl0aW9uT3BlcmF0b3IuU1RSSU5HX0VRVUFMUywgR2xvYmFsQ29uZGl0aW9uS2V5LkZlZGVyYXRlZFByb3ZpZGVyLCAnY29nbml0by1pZGVudGl0eS5hbWF6b25hd3MuY29tJyk7XG4gICAgY29uc3RyYWludHMucHVzaChmZWRQcm92aWRlcik7XG5cbiAgICB0aGlzLmFwcGx5VG9Qb2xpY3lPZlR5cGUoc2NvcGUsIHN0bXQsIFBvbGljeVR5cGUudHJ1c3RQb2xpY3koUHJpbmNpcGFsVHlwZS5Bd3MpLCBjb25zdHJhaW50cyk7XG5cbiAgICBjb25zdCBwcmluY2lwYWxXaXRoQ29uZGl0aW9ucyA9IG5ldyBpYW0uUHJpbmNpcGFsV2l0aENvbmRpdGlvbnMocHJpbmNpcGFsLCBzdG10LmNvbmRpdGlvbnMpO1xuXG4gICAgcmV0dXJuIG5ldyBDaGFpbmVkUHJpbmNpcGFsKHByaW5jaXBhbFdpdGhDb25kaXRpb25zLCBwYXNzZXNDbGFpbXMsIFtdKTtcblxuICB9XG5cbiAgcHJpdmF0ZSBjcmVhdGVQYXNzQ2xhaW1zQ29uc3RyYWludChvcHRpb25zPzogQ2hhaW5lZFByaW5jaXBhbENyZWF0ZU9wdGlvbnMpOiBDb25zdHJhaW50W10ge1xuXG4gICAgY29uc3QgY2xhaW1zVG9CZVBhc3NlZCA9IG9wdGlvbnM/LnBhc3NDbGFpbXM7XG5cbiAgICBpZiAoIWNsYWltc1RvQmVQYXNzZWQgfHwgT2JqZWN0LmtleXMoY2xhaW1zVG9CZVBhc3NlZC5jbGFpbXMpLmxlbmd0aCA9PT0gMCkge1xuICAgICAgcmV0dXJuIFtdO1xuICAgIH1cblxuICAgIHJldHVybiBbUGFzc0NsYWltc0NvbnN0cmFpbnQuY3JlYXRlKGNsYWltc1RvQmVQYXNzZWQpXTtcbiAgfVxuXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQWN0aW9uc0lkZW50aXR5UG9saWN5VXRpbGl0eVNldHRpbmdzIHtcbiAgcmVhZG9ubHkgY2xhaW1zQ29udGV4dDogSUNsYWltc0NvbnRleHQ7XG4gIC8vIFJlcXVpcmVkIHdoZW4gdXNpbmcgcHJpbmNpcGFsQnVpbGRlclxuICByZWFkb25seSBpZGVudGl0eVBvb2xJZD86IHN0cmluZztcbiAgcmVhZG9ubHkgaWRlbnRpdHlQb29sQWNjb3VudElkPzogc3RyaW5nO1xuICByZWFkb25seSBkZWZhdWx0QW1yPzogQXV0aGVudGljYXRlZE1ldGhvZFJlZmVyZW5jZTtcbiAgcmVhZG9ubHkgaWRlbnRpdHlQb29sVXNlc0VuaGFuY2VkRmxvdz86IGJvb2xlYW47XG4gIHJlYWRvbmx5IGJhc2VQcmluY2lwYWxDb25zdHJhaW50cz86IENvbnN0cmFpbnRbXTsgLy8gT3B0aW9uYWxcbn1cblxuZXhwb3J0IGNsYXNzIEFjdGlvbnNJZGVudGl0eUlhbVJlc291cmNlUGF0aEJ1aWxkZXJWMiBleHRlbmRzIENsYWltc0lhbVJlc291cmNlUGF0aEJ1aWxkZXIge1xuXG4gIHN0YXRpYyBmcm9tTWFwcGVkQ2xhaW1zKG1hcHBlZENsYWltczogSU1hcHBlZENsYWltcyk6IEFjdGlvbnNJZGVudGl0eUlhbVJlc291cmNlUGF0aEJ1aWxkZXJWMiB7XG4gICAgcmV0dXJuIG5ldyBBY3Rpb25zSWRlbnRpdHlJYW1SZXNvdXJjZVBhdGhCdWlsZGVyVjIoe1xuICAgICAgY2xhaW1zQ29udGV4dDoge1xuICAgICAgICBtYXBwZWRDbGFpbXMsXG4gICAgICAgIGtub3duQ2xhaW1zOiBHaXRIdWJBY3Rpb25DbGFpbXMgYXMgbmV2ZXIsXG4gICAgICB9LFxuICAgIH0sIFtdKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3Ioc2V0dGluZ3M6IENsYWltc0lhbVJlc291cmNlUGF0aEJ1aWxkZXJTZXR0aW5ncywgcGF0aDogc3RyaW5nW10pIHtcbiAgICBzdXBlcihzZXR0aW5ncywgcGF0aCk7XG4gIH1cblxuICBjbGFpbShjbGFpbTogR2hhQ2xhaW0sIC4uLmFkZGl0aW9uYWxDbGFpbXM6IEdoYUNsYWltW10pOiBBY3Rpb25zSWRlbnRpdHlJYW1SZXNvdXJjZVBhdGhCdWlsZGVyVjIge1xuICAgIHJldHVybiBuZXcgQWN0aW9uc0lkZW50aXR5SWFtUmVzb3VyY2VQYXRoQnVpbGRlclYyKHRoaXMub3B0aW9ucywgdGhpcy5hcHBlbmRDbGFpbShjbGFpbSwgLi4uYWRkaXRpb25hbENsYWltcykpO1xuICB9XG5cbiAgdmFsdWUodmFsdWU6IEdoYUNsYWltIHwgc3RyaW5nLCAuLi5hZGRpdGlvbmFsVmFsdWVzOiAoR2hhQ2xhaW0gfCBzdHJpbmcpW10pOiBBY3Rpb25zSWRlbnRpdHlJYW1SZXNvdXJjZVBhdGhCdWlsZGVyVjIge1xuXG4gICAgY29uc3QgdmFsdWVzID0gW3ZhbHVlLCAuLi5hZGRpdGlvbmFsVmFsdWVzXS5tYXAoeCA9PiB7XG5cbiAgICAgIGNvbnN0IHZhbHVlTGMgPSB4LnRvTG93ZXJDYXNlKCk7XG4gICAgICBpZiAoR2l0SHViQWN0aW9uQ2xhaW1zLmluY2x1ZGVzKHZhbHVlTGMgYXMgbmV2ZXIpKSB7XG4gICAgICAgIHJldHVybiB2YWx1ZUxjO1xuICAgICAgfVxuXG4gICAgICByZXR1cm4geDtcblxuICAgIH0pO1xuXG4gICAgcmV0dXJuIG5ldyBBY3Rpb25zSWRlbnRpdHlJYW1SZXNvdXJjZVBhdGhCdWlsZGVyVjIodGhpcy5vcHRpb25zLCB0aGlzLmFwcGVuZFZhbHVlKC4uLnZhbHVlcykpO1xuICB9XG5cbiAgdGV4dCh2YWx1ZTogc3RyaW5nLCAuLi5hZGRpdGlvbmFsVmFsdWVzOiBzdHJpbmdbXSk6IEFjdGlvbnNJZGVudGl0eUlhbVJlc291cmNlUGF0aEJ1aWxkZXJWMiB7XG4gICAgcmV0dXJuIG5ldyBBY3Rpb25zSWRlbnRpdHlJYW1SZXNvdXJjZVBhdGhCdWlsZGVyVjIodGhpcy5vcHRpb25zLCB0aGlzLmFwcGVuZFRleHQodmFsdWUsIC4uLmFkZGl0aW9uYWxWYWx1ZXMpKTtcbiAgfVxuXG4gIHBvbGljeVZhcmlhYmxlKHZhbHVlOiBQb2xpY3lWYXJpYWJsZSk6IEFjdGlvbnNJZGVudGl0eUlhbVJlc291cmNlUGF0aEJ1aWxkZXJWMiB7XG4gICAgcmV0dXJuIG5ldyBBY3Rpb25zSWRlbnRpdHlJYW1SZXNvdXJjZVBhdGhCdWlsZGVyVjIodGhpcy5vcHRpb25zLCB0aGlzLmFwcGVuZFBvbGljeVZhcmlhYmxlKHZhbHVlKSk7XG4gIH1cblxuICBhc1N0cmluZ1dpdGhTZXBhcmF0b3Ioc2VwYXJhdG9yOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLnBhdGguam9pbihzZXBhcmF0b3IpO1xuICB9XG5cbiAgdG9TdHJpbmcoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5wYXRoLmpvaW4oJy8nKTtcbiAgfVxuXG59XG5cbmV4cG9ydCBjbGFzcyBBY3Rpb25zSWRlbnRpdHlQb2xpY3lVdGlsaXR5IHtcblxuICBzdGF0aWMgY3JlYXRlKHNjb3BlOiBDb25zdHJ1Y3QsIHNldHRpbmdzOiBBY3Rpb25zSWRlbnRpdHlQb2xpY3lVdGlsaXR5U2V0dGluZ3MpOiBBY3Rpb25zSWRlbnRpdHlQb2xpY3lVdGlsaXR5IHtcbiAgICByZXR1cm4gbmV3IEFjdGlvbnNJZGVudGl0eVBvbGljeVV0aWxpdHkoc2NvcGUsIHNldHRpbmdzKTtcbiAgfVxuXG4gIGdldCBjbGFpbXNDb250ZXh0KCk6IElDbGFpbXNDb250ZXh0IHtcbiAgICByZXR1cm4gdGhpcy51dGlsaXR5U2V0dGluZ3MuY2xhaW1zQ29udGV4dDtcbiAgfTtcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgc2NvcGU6IENvbnN0cnVjdCwgcHJpdmF0ZSByZWFkb25seSB1dGlsaXR5U2V0dGluZ3M6IEFjdGlvbnNJZGVudGl0eVBvbGljeVV0aWxpdHlTZXR0aW5ncykge1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZSB0aGlzIHRvIGNyZWF0ZSBwcmluY2lwYWxzIHRoYXQgc2hvdWxkIGFsbG93IGFzc3VtcHRpb24gdmlhIGEgQ29nbml0byBJZGVudGl0eSBQb29sXG4gICAqL1xuICBuZXdQcmluY2lwYWxCdWlsZGVyKGFtcj86IEF1dGhlbnRpY2F0ZWRNZXRob2RSZWZlcmVuY2UpOiBQcmluY2lwYWxCdWlsZGVyIHtcblxuICAgIGNvbnN0IHtcbiAgICAgIGlkZW50aXR5UG9vbElkLFxuICAgICAgZGVmYXVsdEFtcixcbiAgICB9ID0gdGhpcy51dGlsaXR5U2V0dGluZ3M7XG5cbiAgICBpZiAoIWlkZW50aXR5UG9vbElkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0Nhbm5vdCBjcmVhdGUgYSBwcmluY2lwYWwgYnVpbGRlciB3aXRob3V0IHByb3ZpZGluZyB0aGUgaWRlbnRpdHkgcG9vbCBpZCcpO1xuICAgIH1cblxuICAgIGNvbnN0IHVzZUFtciA9IGdldEFtclZhbHVlKHRoaXMuc2NvcGUsIGFtciA/PyBkZWZhdWx0QW1yKTtcblxuICAgIGNvbnN0IGNvbnN0cmFpbnRzID0gdGhpcy51dGlsaXR5U2V0dGluZ3MuYmFzZVByaW5jaXBhbENvbnN0cmFpbnRzID8/IFtdO1xuICAgIGNvbnN0cmFpbnRzLnB1c2goU3RzQ29nbml0b0lkZW50aXR5Q29uc3RyYWludC5pZGVudGl0eVBvb2woaWRlbnRpdHlQb29sSWQsIHVzZUFtcikpO1xuXG4gICAgcmV0dXJuIFByaW5jaXBhbEJ1aWxkZXIuY3JlYXRlKHRoaXMuY2xhaW1zQ29udGV4dCwgY29uc3RyYWludHMpO1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZSB0aGlzIHRvIGNyZWF0ZSBwcmluY2lwYWxzIHRoYXQgc2hvdWxkIGJlIGFzc3VtYWJsZSBieSByb2xlcyB0aGF0IGhhdmUgYmVlbiBhc3N1bWVkIHZpYSBhIEFjdGlvbnNJZGVudGl0eVBvb2xWMlxuICAgKi9cbiAgbmV3Q2hhaW5lZFByaW5jaXBhbEJ1aWxkZXIoKTogQ2hhaW5lZFByaW5jaXBhbEJ1aWxkZXIge1xuXG4gICAgcmV0dXJuIENoYWluZWRQcmluY2lwYWxCdWlsZGVyLmNyZWF0ZSh0aGlzLmNsYWltc0NvbnRleHQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFwcGVuZCBhIHBvbGljeSB3aXRoIGNvbmRpdGlvbnMgY29udGV4dHVhbCB0byBHaXRIdWIgQWN0aW9ucyBjbGFpbXNcbiAgICovXG4gIGNvbnN0cmFpbihwb2xpY3lTdGF0ZW1lbnQ6IGlhbS5Qb2xpY3lTdGF0ZW1lbnQsIHNjb3BlPzogQ29uc3RydWN0KTogUG9saWN5U3RhdGVtZW50Q29uc3RyYWluZXIge1xuXG4gICAgc2NvcGUgPSBzY29wZSA/PyB0aGlzLnNjb3BlO1xuXG4gICAgcmV0dXJuIFBvbGljeVN0YXRlbWVudENvbnN0cmFpbmVyLmNyZWF0ZShzY29wZSwgcG9saWN5U3RhdGVtZW50LCB7IGNsYWltc0NvbnRleHQ6IHRoaXMuY2xhaW1zQ29udGV4dCB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBcHBlbmQgYSBncmFudCB3aXRoIGNvbmRpdGlvbnMgY29udGV4dHVhbCB0byBHaXRIdWIgQWN0aW9ucyBjbGFpbXNcbiAgICovXG4gIGNvbnN0cmFpbkdyYW50KGdyYW50OiBpYW0uR3JhbnQsIHNjb3BlPzogQ29uc3RydWN0KTogR3JhbnRDb25zdHJhaW5lciB7XG5cbiAgICBzY29wZSA9IHNjb3BlID8/IHRoaXMuc2NvcGU7XG5cbiAgICByZXR1cm4gR3JhbnRDb25zdHJhaW5lci5jcmVhdGUoc2NvcGUsIGdyYW50LCB7IGNsYWltc0NvbnRleHQ6IHRoaXMuY2xhaW1zQ29udGV4dCB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBCdWlsZCBhIHJlc291cmNlIHBhdGggZm9yIGFuIElBTSBQb2xpY3lcbiAgICogQHBhcmFtIHZhbHVlIE1peCBvZiBzdHJpbmdzIGFuZCBjbGFpbXNcbiAgICovXG4gIHJlc291cmNlUGF0aCguLi52YWx1ZTogKEdoYUNsYWltIHwgc3RyaW5nKVtdKTogQWN0aW9uc0lkZW50aXR5SWFtUmVzb3VyY2VQYXRoQnVpbGRlclYyIHtcbiAgICBsZXQgcmVzb3VyY2VQYXRoID0gQWN0aW9uc0lkZW50aXR5SWFtUmVzb3VyY2VQYXRoQnVpbGRlclYyLmZyb21NYXBwZWRDbGFpbXModGhpcy5jbGFpbXNDb250ZXh0Lm1hcHBlZENsYWltcyk7XG5cbiAgICBpZiAodmFsdWUubGVuZ3RoID4gMCkge1xuICAgICAgZm9yIChjb25zdCB2YWx1ZUVsZW1lbnQgb2YgdmFsdWUpIHtcbiAgICAgICAgcmVzb3VyY2VQYXRoID0gcmVzb3VyY2VQYXRoLnZhbHVlKHZhbHVlRWxlbWVudCk7XG5cbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gcmVzb3VyY2VQYXRoO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZSBhIHBvbGljeSB2YXJpYWJsZVxuICAgKi9cbiAgcG9saWN5VmFyKGNsYWltOiBHaGFDbGFpbSk6IFBvbGljeVZhcmlhYmxlIHtcbiAgICByZXR1cm4gUG9saWN5VmFyaWFibGUucHJpbmNpcGFsVGFnKENsYWltc1V0aWxpdHkuZm9yQ29udGV4dCh0aGlzLmNsYWltc0NvbnRleHQpLnRhZ05hbWVGb3JDbGFpbShjbGFpbSkpO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZSBhIHByaW5jaXBhbCB0YWcgZm9yIGNsYWltXG4gICAqL1xuICBwcmluY2lwYWxUYWdDb25kaXRpb25LZXkoY2xhaW06IEdoYUNsYWltKTogQXdzUHJpbmNpcGFsVGFnQ29uZGl0aW9uS2V5IHtcbiAgICByZXR1cm4gQXdzUHJpbmNpcGFsVGFnQ29uZGl0aW9uS2V5LnRhZyhDbGFpbXNVdGlsaXR5LmZvckNvbnRleHQodGhpcy5jbGFpbXNDb250ZXh0KS50YWdOYW1lRm9yQ2xhaW0oY2xhaW0pKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudCByb2xlIHBlcm1pc3Npb25zIHRvIGFzc3VtZSByb2xlcyBpbiBhbnkgb3JnYW5pemF0aW9uIGFjY291bnRcbiAgICovXG4gIGdyYW50T3JnYW5pemF0aW9uUm9sZUNoYWluKGlkZW50aXR5OiBpYW0uSUdyYW50YWJsZSwgc2V0dGluZ3M6IEdyYW50T3JnUm9sZUNoYWluU2V0dGluZ3MpOiBpYW0uR3JhbnQge1xuXG4gICAgY29uc3Qgcm9sZVBhdGggPSBzZXR0aW5ncy5yb2xlUGF0aCA/PyAnLyc7XG4gICAgY29uc3Qgcm9sZUFybnMgPSBgYXJuOmF3czppYW06Oio6cm9sZSR7cm9sZVBhdGh9KmA7XG5cbiAgICBjb25zdCBhc3N1bWVSb2xlU3RyaW5nRXF1YWxzOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB8IHN0cmluZ1tdIH0gPSB7XG4gICAgICAnYXdzOlJlc291cmNlT3JnSUQnOiBQb2xpY3lWYXJpYWJsZS5wcmluY2lwYWxPcmdJZCgpLnRvU3RyaW5nKCksXG4gICAgfTtcbiAgICBjb25zdCBhc3N1bWVSb2xlU3RyaW5nTm90RXF1YWxzOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB8IHN0cmluZ1tdIH0gPSB7fTtcblxuICAgIGNvbnN0IHJvbGVIYXNSZXNvdXJjZVRhZ3MgPSBzZXR0aW5ncy5yb2xlSGFzUmVzb3VyY2VUYWdzID8/IHt9O1xuXG4gICAgaWYgKE9iamVjdC5rZXlzKHJvbGVIYXNSZXNvdXJjZVRhZ3MpLmxlbmd0aCA+IDApIHtcblxuICAgICAgY29uc3QgdXRpbCA9IENsYWltc1V0aWxpdHkuZm9yQ29udGV4dCh0aGlzLmNsYWltc0NvbnRleHQpO1xuXG4gICAgICBmb3IgKGNvbnN0IGtleSBvZiBPYmplY3Qua2V5cyhyb2xlSGFzUmVzb3VyY2VUYWdzKSkge1xuXG4gICAgICAgIGxldCB2YWx1ZSA9IHJvbGVIYXNSZXNvdXJjZVRhZ3Nba2V5XTtcblxuICAgICAgICBpZiAoR2l0SHViQWN0aW9uQ2xhaW1zLmluY2x1ZGVzKHZhbHVlLnRvTG93ZXJDYXNlKCkgYXMgbmV2ZXIpKSB7XG4gICAgICAgICAgdmFsdWUgPSBQb2xpY3lWYXJpYWJsZS5wcmluY2lwYWxUYWcodXRpbC50YWdOYW1lRm9yQ2xhaW0odmFsdWUudG9Mb3dlckNhc2UoKSkpLnRvU3RyaW5nKCk7XG4gICAgICAgIH1cblxuICAgICAgICBhc3N1bWVSb2xlU3RyaW5nRXF1YWxzW0dsb2JhbENvbmRpdGlvbktleS5yZXNvdXJjZVRhZyhrZXkpLnRvU3RyaW5nKCldID0gdmFsdWU7XG4gICAgICB9XG4gICAgfSBlbHNlIGlmIChyb2xlUGF0aCA9PT0gJy8nKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1Byb3ZpZGUgYSByb2xlUGF0aCBvciBhdCBsZWFzdCBvbmUgcmVzb3VyY2VUYWcgdGhhdCBpcyByZXF1aXJlZCBvbiByb2xlcyB0aGF0IHdpbGwgYmUgYXNzdW1pbmcgcm9sZXMuJyk7XG4gICAgfVxuXG4gICAgaWYgKCFyb2xlUGF0aC5lbmRzV2l0aCgnLycpIHx8ICFyb2xlUGF0aC5zdGFydHNXaXRoKCcvJykpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQSByb2xlUGF0aCBtdXN0IGJlZ2luIGFuZCBlbmQgd2l0aCBcIi9cIicpO1xuICAgIH1cblxuICAgIGNvbnN0IGFjY291bnRJZHMgPSBbXTtcblxuICAgIGlmICh0aGlzLnV0aWxpdHlTZXR0aW5ncy5pZGVudGl0eVBvb2xBY2NvdW50SWQpIHtcbiAgICAgIGFjY291bnRJZHMucHVzaCh0aGlzLnV0aWxpdHlTZXR0aW5ncy5pZGVudGl0eVBvb2xBY2NvdW50SWQpO1xuICAgIH1cblxuICAgIGlmIChzZXR0aW5ncy5leGNsdWRlQWNjb3VudElkcyAmJiBzZXR0aW5ncy5leGNsdWRlQWNjb3VudElkcy5sZW5ndGggPiAwKSB7XG4gICAgICBhY2NvdW50SWRzLnB1c2goLi4uc2V0dGluZ3MuZXhjbHVkZUFjY291bnRJZHMpO1xuICAgIH1cblxuICAgIGlmIChhY2NvdW50SWRzLmxlbmd0aCA+IDApIHtcbiAgICAgIGFzc3VtZVJvbGVTdHJpbmdOb3RFcXVhbHNbJ2F3czpSZXNvdXJjZUFjY291bnQnXSA9IGFjY291bnRJZHMubGVuZ3RoID09PSAxID8gYWNjb3VudElkc1swXSA6IGFjY291bnRJZHM7XG4gICAgfVxuXG4gICAgY29uc3QgYXNzdW1lUm9sZUdyYW50OiBpYW0uR3JhbnRPblByaW5jaXBhbE9wdGlvbnMgPSB7XG4gICAgICBncmFudGVlOiBpZGVudGl0eSxcbiAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgJ3N0czpBc3N1bWVSb2xlJyxcbiAgICAgIF0sXG4gICAgICByZXNvdXJjZUFybnM6IFtcbiAgICAgICAgcm9sZUFybnMsXG4gICAgICBdLFxuICAgICAgY29uZGl0aW9uczoge1xuICAgICAgICBTdHJpbmdFcXVhbHM6IGFzc3VtZVJvbGVTdHJpbmdFcXVhbHMsXG4gICAgICAgIFN0cmluZ05vdEVxdWFsczogYXNzdW1lUm9sZVN0cmluZ05vdEVxdWFscyxcbiAgICAgIH0sXG4gICAgfTtcblxuICAgIGlmIChzZXR0aW5ncy5yZXNvdXJjZU9yZ1BhdGhzPy5sZW5ndGgpIHtcbiAgICAgIGNvbnN0IG9wZXJhdG9yID0gc2V0dGluZ3MucmVzb3VyY2VPcmdQYXRoU3RyaW5nRXF1YWxzID8gJ0ZvckFueVZhbHVlOlN0cmluZ0VxdWFscycgOiAnRm9yQW55VmFsdWU6U3RyaW5nTGlrZSc7XG5cbiAgICAgIChhc3N1bWVSb2xlR3JhbnQuY29uZGl0aW9ucyBhcyBhbnkpW29wZXJhdG9yXSA9IHtcbiAgICAgICAgJ2F3czpSZXNvdXJjZU9yZ1BhdGhzJzogc2V0dGluZ3MucmVzb3VyY2VPcmdQYXRocyxcbiAgICAgIH07XG4gICAgfVxuXG5cbiAgICBjb25zdCB0YWdHcmFudCA9IGlhbS5HcmFudC5hZGRUb1ByaW5jaXBhbCh7XG4gICAgICBncmFudGVlOiBpZGVudGl0eSxcbiAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgJ3N0czpUYWdTZXNzaW9uJyxcbiAgICAgIF0sXG4gICAgICByZXNvdXJjZUFybnM6IFtcbiAgICAgICAgJyonLFxuICAgICAgXSxcbiAgICB9KTtcblxuICAgIHJldHVybiB0YWdHcmFudC5jb21iaW5lKGlhbS5HcmFudC5hZGRUb1ByaW5jaXBhbChhc3N1bWVSb2xlR3JhbnQpKTtcblxuICB9XG5cbn1cbiJdfQ==