import * as iam from 'aws-cdk-lib/aws-iam';
import { ClaimMapping, GhaClaim } from '../claims';
export type ChainedPrincipalConditions = {
    StringEquals: {
        [key: string]: string | string[];
    } & {
        readonly 'aws:FederatedProvider': 'cognito-identity.amazonaws.com';
    };
    StringLike?: {
        [key: string]: string | string[];
    };
    'ForAllValues:StringEquals'?: {
        'aws:tagKeys'?: string[];
        'sts:TransitiveTagKeys'?: string[];
    };
    Null?: {
        'sts:TransitiveTagKeys': 'false';
    };
};
export declare class ActionsIdentityChainedPrincipalBuilder {
    private readonly claimMapping;
    static fromClaimMapping(claimMapping: ClaimMapping): ActionsIdentityChainedPrincipalBuilder;
    private readonly passClaims;
    private readonly claimConditions;
    private readonly otherConditions;
    private constructor();
    claimEquals(claim: GhaClaim, value: string, ...additionalValues: string[]): this;
    claimLike(claim: GhaClaim, value: string, ...additionalValues: string[]): this;
    createConditions(): {
        [key: string]: unknown;
    };
    createPrincipalAssumedBy(principal: iam.IPrincipal): iam.IPrincipal;
    passesClaim(claim: GhaClaim, ...additionalClaims: GhaClaim[]): this;
    requireExternalId(externalId: string): this;
    requireIdentityPoolId(identityPoolId: string): this;
    private validateAddingCondition;
}
