"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityChainedPrincipalBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
class ActionsIdentityChainedPrincipalBuilder {
    static fromClaimMapping(claimMapping) {
        return new ActionsIdentityChainedPrincipalBuilder(claimMapping);
    }
    constructor(claimMapping) {
        this.claimMapping = claimMapping;
        this.passClaims = [];
        this.claimConditions = {};
        this.otherConditions = {};
    }
    claimEquals(claim, value, ...additionalValues) {
        this.validateAddingCondition(claim, 'StringEquals');
        this.claimConditions[claim].values.push(value, ...additionalValues);
        return this;
    }
    claimLike(claim, value, ...additionalValues) {
        this.validateAddingCondition(claim, 'StringLike');
        this.claimConditions[claim].values.push(value, ...additionalValues);
        return this;
    }
    createConditions() {
        const mappedClaims = this.claimMapping.mappedClaims;
        const conditions = {
            StringEquals: {
                'aws:FederatedProvider': 'cognito-identity.amazonaws.com',
                ...this.otherConditions,
            },
        };
        const like = {};
        for (const key of Object.keys(this.claimConditions)) {
            const condition = this.claimConditions[key];
            const tagName = mappedClaims.find(x => x.claim === condition.claim)?.tagName ?? condition.claim;
            const value = condition.values.length === 1 ? condition.values[0] : condition.values;
            if (condition.type === 'StringEquals') {
                conditions.StringEquals[`aws:principalTag/${tagName}`] = value;
            }
            else {
                like[`aws:principalTag/${tagName}`] = value;
            }
        }
        for (const passedClaim of this.passClaims) {
            const tagName = mappedClaims.find(x => x.claim === passedClaim)?.tagName ?? passedClaim;
            conditions.StringEquals[`aws:requestTag/${tagName}`] = `$\{aws:principalTag/${tagName}}`;
        }
        if (Object.keys(like).length > 0) {
            conditions.StringLike = like;
        }
        if (this.passClaims.length > 0) {
            conditions['ForAllValues:StringEquals'] = {
                'aws:tagKeys': this.passClaims.map(x => mappedClaims.find(y => y.claim === x)?.tagName ?? x),
            };
        }
        return conditions;
    }
    createPrincipalAssumedBy(principal) {
        const principalWithConditions = new iam.PrincipalWithConditions(principal, this.createConditions());
        return this.passClaims.length > 0 ? principalWithConditions.withSessionTags() : principalWithConditions;
    }
    passesClaim(claim, ...additionalClaims) {
        for (const val of [claim, ...additionalClaims]) {
            if (!this.claimMapping.mappedClaims.find(x => x.claim === val)) {
                throw new Error(`Claim of type "${val}" is not a mapped claim. Add it as part of mapped claims in order to use it in the policy.`);
            }
            if (!this.passClaims.includes(val)) {
                this.passClaims.push(val);
            }
        }
        return this;
    }
    requireExternalId(externalId) {
        this.otherConditions['sts:externalId'] = externalId;
        return this;
    }
    requireIdentityPoolId(identityPoolId) {
        this.otherConditions['cognito-identity.amazonaws.com:aud'] = identityPoolId;
        return this;
    }
    validateAddingCondition(claim, type) {
        if (this.claimConditions[claim] && this.claimConditions[claim].type !== type) {
            throw new Error('Cannot require the same claim to both be StringEquals and StringLike in the same trust policy.');
        }
        if (!this.claimMapping.mappedClaims.find(x => x.claim === claim)) {
            throw new Error(`Claim of type "${claim}" is not a mapped claim. Add it as part of mapped claims in order to use it as a condition.`);
        }
        if (!this.claimConditions[claim]) {
            this.claimConditions[claim] = {
                claim,
                type,
                values: [],
            };
        }
    }
}
exports.ActionsIdentityChainedPrincipalBuilder = ActionsIdentityChainedPrincipalBuilder;
_a = JSII_RTTI_SYMBOL_1;
ActionsIdentityChainedPrincipalBuilder[_a] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityChainedPrincipalBuilder", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,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