import { ClaimMapping, GhaClaim } from '../claims';
export declare class ActionsIdentityIamResourcePathBuilder {
    private readonly claimMapping;
    private readonly path;
    static fromClaimMapping(claimMapping: ClaimMapping): ActionsIdentityIamResourcePathBuilder;
    private constructor();
    private get mappedClaims();
    /**
     * Value must be a mapped claim.
     */
    claim(value: GhaClaim, ...additionalValues: GhaClaim[]): ActionsIdentityIamResourcePathBuilder;
    /**
     * Value can be anything. Providing a GitHub Actions Claim will not render a principalTag context key.
     */
    text(value: string, ...additionalValues: string[]): ActionsIdentityIamResourcePathBuilder;
    /**
     * Value can be anything. When value matches a known (mapped or not) GitHub Actions claim it will be treated as such.
     */
    value(value: GhaClaim | string, ...additionalValues: (GhaClaim | string)[]): ActionsIdentityIamResourcePathBuilder;
    toStringWithSeparator(separator: string): string;
    toString(): string;
}
