"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityIamResourcePathBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const claims_1 = require("../claims");
class ActionsIdentityIamResourcePathBuilder {
    static fromClaimMapping(claimMapping) {
        return new ActionsIdentityIamResourcePathBuilder(claimMapping, []);
    }
    constructor(claimMapping, path) {
        this.claimMapping = claimMapping;
        this.path = path;
    }
    get mappedClaims() {
        return this.claimMapping.mappedClaims;
    }
    /**
     * Value must be a mapped claim.
     */
    claim(value, ...additionalValues) {
        const input = [];
        for (const claim of [value, ...additionalValues]) {
            const mappedClaim = this.mappedClaims.find(x => x.claim === claim);
            if (!mappedClaim) {
                throw new Error(`Claim ${claim} is not mapped`);
            }
            input.push(`$\{aws:principalTag/${mappedClaim.tagName}}`);
        }
        return new ActionsIdentityIamResourcePathBuilder(this.claimMapping, [...this.path, ...input]);
    }
    /**
     * Value can be anything. Providing a GitHub Actions Claim will not render a principalTag context key.
     */
    text(value, ...additionalValues) {
        return new ActionsIdentityIamResourcePathBuilder(this.claimMapping, [...this.path, value, ...additionalValues]);
    }
    /**
     * Value can be anything. When value matches a known (mapped or not) GitHub Actions claim it will be treated as such.
     */
    value(value, ...additionalValues) {
        const input = [];
        for (const val of [value, ...additionalValues]) {
            const isKnownClaim = claims_1.GitHubActionClaims.includes(val);
            const mappedClaim = this.mappedClaims.find(x => x.claim === val);
            if (mappedClaim) {
                input.push(`$\{aws:principalTag/${mappedClaim.tagName}}`);
                continue;
            }
            else if (!mappedClaim && isKnownClaim) {
                throw new Error('Cannot use value() with strings that are same value as a known GitHub Actions claim. Add string with text() instead.');
            }
            input.push(val);
        }
        return new ActionsIdentityIamResourcePathBuilder(this.claimMapping, [...this.path, ...input]);
    }
    toStringWithSeparator(separator) {
        return this.path.join(separator);
    }
    toString() {
        return this.path.join('/');
    }
}
exports.ActionsIdentityIamResourcePathBuilder = ActionsIdentityIamResourcePathBuilder;
_a = JSII_RTTI_SYMBOL_1;
ActionsIdentityIamResourcePathBuilder[_a] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityIamResourcePathBuilder", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,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