import * as iam from 'aws-cdk-lib/aws-iam';
import { ClaimMapping } from '../claims';
import { AuthenticatedMethodReference, PrincipalClaimRequirements } from '../types';
export interface ActionsIdentityPoolPrincipalBuilderOptions {
    readonly amr?: AuthenticatedMethodReference;
    readonly identityPoolId: string;
    readonly claimMapping: ClaimMapping;
    readonly openIdConnectProviderArn?: string;
}
export declare class ActionsIdentityPrincipalBuilder {
    private readonly options;
    static create(claimMapping: ClaimMapping, identityPoolId: string, amr?: AuthenticatedMethodReference, openIdConnectProviderArn?: string): ActionsIdentityPrincipalBuilder;
    private constructor();
    createPrincipal(requirements: PrincipalClaimRequirements, amr?: AuthenticatedMethodReference): iam.IPrincipal;
    protected getAmrValue(amr?: AuthenticatedMethodReference): string;
}
