"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsIdentityPrincipalBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const claims_1 = require("../claims");
const types_1 = require("../types");
class ActionsIdentityPrincipalBuilder {
    // eslint-disable-next-line max-len
    static create(claimMapping, identityPoolId, amr, openIdConnectProviderArn) {
        return new ActionsIdentityPrincipalBuilder({
            claimMapping,
            identityPoolId,
            amr,
            openIdConnectProviderArn,
        });
    }
    constructor(options) {
        this.options = options;
    }
    createPrincipal(requirements, amr) {
        const conditions = {
            'StringEquals': {
                'cognito-identity.amazonaws.com:aud': this.options.identityPoolId,
            },
            'ForAnyValue:StringLike': {
                'cognito-identity.amazonaws.com:amr': this.getAmrValue(amr),
            },
        };
        let requirementsApplied = 0;
        const equalityClaims = [claims_1.GhaClaim.REPOSITORY_OWNER, claims_1.GhaClaim.ACTOR, claims_1.GhaClaim.ACTOR_ID];
        const conditionClaims = [claims_1.GhaClaim.JOB_WORKFLOW_REF, claims_1.GhaClaim.WORKFLOW_REF, claims_1.GhaClaim.REPOSITORY, claims_1.GhaClaim.ENVIRONMENT];
        const useClaims = {};
        if (requirements.runnerEnvironment) {
            if (!['github-hosted', 'self-hosted'].includes(requirements.runnerEnvironment)) {
                throw new Error('runnerEnvironment needs to be set to either "github-hosted" or "self-hosted".');
            }
            useClaims.runner_environment = {
                values: [requirements.runnerEnvironment],
                condition: 'StringEquals',
            };
        }
        for (const claim of equalityClaims) {
            const reqKey = principalClaimReqProperties[claim] ?? claim;
            if (!(reqKey in requirements)) {
                continue;
            }
            useClaims[claim] = {
                values: requirements[reqKey],
                condition: 'StringEquals',
            };
        }
        for (const claim of conditionClaims) {
            const reqKey = principalClaimReqProperties[claim] ?? claim;
            if (!(reqKey in requirements)) {
                continue;
            }
            useClaims[claim] = requirements[reqKey];
        }
        for (const claim of Object.keys(useClaims)) {
            if (!(claim in useClaims)) {
                continue;
            }
            const mappedClaim = this.options.claimMapping.mappedClaims.find(x => x.claim === claim);
            if (!mappedClaim) {
                throw new Error(`Map claim ${claim} in order to use it in the trust policy`);
            }
            const requirement = useClaims[claim];
            if (requirement.values.length === 0) {
                throw new Error(`At least one value has to be provided for required claim "${claim}".`);
            }
            if (requirement.condition === 'StringLike') {
                if (!conditions.StringLike) {
                    conditions.StringLike = {};
                }
                conditions.StringLike[`aws:requestTag/${mappedClaim.tagName}`] = requirement.values;
            }
            else {
                conditions.StringEquals[`aws:requestTag/${mappedClaim.tagName}`] = requirement.values;
            }
            requirementsApplied++;
        }
        if (requirementsApplied === 0) {
            throw new Error('Provide at least one required claim for the principal.');
        }
        return new iam.PrincipalWithConditions(new iam.FederatedPrincipal('cognito-identity.amazonaws.com', {}, 'sts:AssumeRoleWithWebIdentity'), conditions)
            .withSessionTags();
    }
    getAmrValue(amr) {
        const useAmr = amr ?? this.options.amr;
        if (!useAmr) {
            return 'token.actions.githubusercontent.com';
        }
        switch (useAmr) {
            case types_1.AuthenticatedMethodReference.AUTHENTICATED:
                return 'authenticated';
            case types_1.AuthenticatedMethodReference.ARN:
                if (!this.options.openIdConnectProviderArn) {
                    throw new Error('Cannot set arn as it has not been provided to builder');
                }
                return `${this.options.openIdConnectProviderArn}:OIDC:*`;
            default:
                return 'token.actions.githubusercontent.com';
        }
    }
}
exports.ActionsIdentityPrincipalBuilder = ActionsIdentityPrincipalBuilder;
_a = JSII_RTTI_SYMBOL_1;
ActionsIdentityPrincipalBuilder[_a] = { fqn: "@catnekaise/actions-constructs.ActionsIdentityPrincipalBuilder", version: "0.2.17" };
const principalClaimReqProperties = {
    job_workflow_ref: 'jobWorkflowRef',
    actor_id: 'actorId',
    repository_owner: 'repositoryOwner',
    runner_environment: 'runnerEnvironment',
    workflow_ref: 'workflowRef',
};
//# sourceMappingURL=data:application/json;base64,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