# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date, datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.access_times_heatmap import AccessTimesHeatmap
from iblai.models.active_users_list import ActiveUsersList
from iblai.models.active_users_per_course import ActiveUsersPerCourse
from iblai.models.activity_api import ActivityAPI
from iblai.models.analytics_overview import AnalyticsOverview
from iblai.models.average import Average
from iblai.models.average_overtime import AverageOvertime
from iblai.models.avg_course_grade_with_cutoff import AvgCourseGradeWithCutoff
from iblai.models.base_finance_response import BaseFinanceResponse
from iblai.models.chat_history_filter_data import ChatHistoryFilterData
from iblai.models.content_details_response import ContentDetailsResponse
from iblai.models.content_response import ContentResponse
from iblai.models.conversation_detail_response import ConversationDetailResponse
from iblai.models.conversation_list_response import ConversationListResponse
from iblai.models.conversation_message import ConversationMessage
from iblai.models.conversation_summary import ConversationSummary
from iblai.models.conversation_volume import ConversationVolume
from iblai.models.conversations import Conversations
from iblai.models.conversations_chart import ConversationsChart
from iblai.models.cost import Cost
from iblai.models.cost_per_tenant import CostPerTenant
from iblai.models.count import Count
from iblai.models.course_completion_per_course import CourseCompletionPerCourse
from iblai.models.course_completion_summary_overtime import CourseCompletionSummaryOvertime
from iblai.models.course_grade_summary import CourseGradeSummary
from iblai.models.course_grading_detail import CourseGradingDetail
from iblai.models.current_users_response import CurrentUsersResponse
from iblai.models.detailed_grade_view import DetailedGradeView
from iblai.models.engagement_per_course import EngagementPerCourse
from iblai.models.enrollments import Enrollments
from iblai.models.enrollments_per_user import EnrollmentsPerUser
from iblai.models.finance_details_response import FinanceDetailsResponse
from iblai.models.grading_per_user import GradingPerUser
from iblai.models.group_list import GroupList
from iblai.models.invoice_report_response import InvoiceReportResponse
from iblai.models.llm_traces_list_response import LLMTracesListResponse
from iblai.models.learner_analytics_response import LearnerAnalyticsResponse
from iblai.models.learner_details_response import LearnerDetailsResponse
from iblai.models.learner_information_api import LearnerInformationAPI
from iblai.models.learner_list_response import LearnerListResponse
from iblai.models.mentor_detail_analytics import MentorDetailAnalytics
from iblai.models.message_statistics import MessageStatistics
from iblai.models.model_cost import ModelCost
from iblai.models.new_per_learner_list import NewPerLearnerList
from iblai.models.observation import Observation
from iblai.models.over_time_with_total import OverTimeWithTotal
from iblai.models.overtime_with_change_info import OvertimeWithChangeInfo
from iblai.models.paginated_conversations_list import PaginatedConversationsList
from iblai.models.paginated_observation_list import PaginatedObservationList
from iblai.models.paginated_topic_statistics_response import PaginatedTopicStatisticsResponse
from iblai.models.paginated_trace_list import PaginatedTraceList
from iblai.models.patched_conversations import PatchedConversations
from iblai.models.per_learner_course_videos_watched import PerLearnerCourseVideosWatched
from iblai.models.per_learner_last_access import PerLearnerLastAccess
from iblai.models.per_learner_time_spent_in_course_tree import PerLearnerTimeSpentInCourseTree
from iblai.models.performance_grades_per_course import PerformanceGradesPerCourse
from iblai.models.perlearner_course_progress import PerlearnerCourseProgress
from iblai.models.perlearner_engagement_videos_watched_per_course import PerlearnerEngagementVideosWatchedPerCourse
from iblai.models.perlearner_grade_summary import PerlearnerGradeSummary
from iblai.models.perlearner_grade_with_cut_off import PerlearnerGradeWithCutOff
from iblai.models.perlearner_grading_per_course_api import PerlearnerGradingPerCourseAPI
from iblai.models.perlearner_user_list import PerlearnerUserList
from iblai.models.pie_chart_data import PieChartData
from iblai.models.rating_record import RatingRecord
from iblai.models.ratings_overtime import RatingsOvertime
from iblai.models.sentiment_summary import SentimentSummary
from iblai.models.sessions_chart import SessionsChart
from iblai.models.student_chat_message import StudentChatMessage
from iblai.models.tenant_mentor_traces import TenantMentorTraces
from iblai.models.time_detail import TimeDetail
from iblai.models.time_spent_by_users_in_course import TimeSpentByUsersInCourse
from iblai.models.time_spent_per_course import TimeSpentPerCourse
from iblai.models.time_spent_per_user_response import TimeSpentPerUserResponse
from iblai.models.time_spent_update_request import TimeSpentUpdateRequest
from iblai.models.time_spent_update_response import TimeSpentUpdateResponse
from iblai.models.topic_details import TopicDetails
from iblai.models.topic_record import TopicRecord
from iblai.models.topic_statistics_response import TopicStatisticsResponse
from iblai.models.topic_summary_view import TopicSummaryView
from iblai.models.topics_overview import TopicsOverview
from iblai.models.trace import Trace
from iblai.models.trend_entry import TrendEntry
from iblai.models.user_chat_by_period import UserChatByPeriod
from iblai.models.user_chat_feedback_count import UserChatFeedbackCount
from iblai.models.user_count_record import UserCountRecord
from iblai.models.user_detail import UserDetail
from iblai.models.user_metrics_response import UserMetricsResponse
from iblai.models.user_sentiment_count_view import UserSentimentCountView
from iblai.models.user_trend_by_period import UserTrendByPeriod
from iblai.models.value import Value
from iblai.models.video_engagement_per_course import VideoEngagementPerCourse
from iblai.models.videos_count import VideosCount
from iblai.models.videos_in_course_summary import VideosInCourseSummary
from iblai.models.videos_specific_course import VideosSpecificCourse
from iblai.models.watched_videos_per_course import WatchedVideosPerCourse
from iblai.models.watched_videos_per_user import WatchedVideosPerUser

from iblai.api_client import ApiClient, RequestSerialized
from iblai.api_response import ApiResponse
from iblai.rest import RESTResponseType


class AiAnalyticsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def ai_analytics_audience_orgs_active_users_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_active_users_over_time_retrieve

        Get active user counts over time.  This endpoint provides daily counts of active users (users with known activity) over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)  Returns:     Daily active user counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.  An active user is defined as a user with any activity within the past 30 days.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_active_users_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_active_users_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/active-users/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_active_users_per_course_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_active_users_per_course_retrieve

        Get active user counts on a per-course basis.  This endpoint provides counts of active users for each course within the specified date range.  Query Parameters:     start_date (str, optional): Start date for filtering (ISO format)     end_date (str, optional): End date for filtering (ISO format)  Returns:     A list of courses with their active user counts.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_active_users_per_course_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActiveUsersPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_active_users_per_course_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/active-users/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_active_users_users_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_active_users_users_retrieve

        Get a list of active users with activity metrics.  This endpoint provides a paginated list of users who have had activity within the specified date range.  Query Parameters:     start_date (str, optional): Start date for filtering (ISO format)     end_date (str, optional): End date for filtering (ISO format)     course_id (str, optional): Filter by course ID     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of active users with their activity metrics.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_active_users_users_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActiveUsersList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_active_users_users_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/active-users/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_enrollments_courses_over_time_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_enrollments_courses_over_time_retrieve

        Get enrollment or unenrollment counts over time.  This endpoint provides daily counts of new enrollments or unenrollments over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)     course_id (str, optional): Filter by course ID     active (bool): Get enrollments when true, unenrollments when false  Returns:     Daily counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_enrollments_courses_over_time_retrieve_serialize(
            course_id=course_id,
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_enrollments_courses_over_time_retrieve_serialize(
        self,
        course_id,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/enrollments/courses/{course_id}/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_enrollments_courses_users_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_enrollments_courses_users_retrieve

        List users enrolled in a specific course.  This endpoint provides a list of users who are enrolled or unenrolled in a specified course.  Query Parameters:     course_id (str): The course ID to get enrollments for     active (bool): Filter for active enrollments when true, inactive when false     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of users with:     - Username     - Full name     - Email     - Enrollment timestamp

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_enrollments_courses_users_retrieve_serialize(
            course_id=course_id,
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnrollmentsPerUser",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_enrollments_courses_users_retrieve_serialize(
        self,
        course_id,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/enrollments/courses/{course_id}/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_enrollments_over_time_retrieve(
        self,
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_enrollments_over_time_retrieve

        Get enrollment or unenrollment counts over time.  This endpoint provides daily counts of new enrollments or unenrollments over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)     course_id (str, optional): Filter by course ID     active (bool): Get enrollments when true, unenrollments when false  Returns:     Daily counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_enrollments_over_time_retrieve_serialize(
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_enrollments_over_time_retrieve_serialize(
        self,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/enrollments/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_enrollments_per_course_retrieve(
        self,
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_enrollments_per_course_retrieve

        List enrollment statistics on a per-course basis.  This endpoint provides enrollment counts for all courses, with options to filter for active or inactive enrollments and to include time-based data.  Query Parameters:     active (bool): Filter for active enrollments when true, inactive when false     start_date (str, optional): Start date for time-based filtering (ISO format)     end_date (str, optional): End date for time-based filtering (ISO format)     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with their enrollment counts and percentages.

        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_enrollments_per_course_retrieve_serialize(
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Enrollments",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_enrollments_per_course_retrieve_serialize(
        self,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/enrollments/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_registered_users_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_registered_users_over_time_retrieve

        Get registered user counts over time.  This endpoint provides daily counts of new user registrations over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)  Returns:     Daily registration counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_registered_users_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_registered_users_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/registered-users/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_registered_users_per_course_retrieve(
        self,
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_registered_users_per_course_retrieve

        List enrollment statistics on a per-course basis.  This endpoint provides enrollment counts for all courses, with options to filter for active or inactive enrollments and to include time-based data.  Query Parameters:     active (bool): Filter for active enrollments when true, inactive when false     start_date (str, optional): Start date for time-based filtering (ISO format)     end_date (str, optional): End date for time-based filtering (ISO format)     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with their enrollment counts and percentages.

        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_registered_users_per_course_retrieve_serialize(
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Enrollments",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_registered_users_per_course_retrieve_serialize(
        self,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/registered-users/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_audience_orgs_registered_users_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        search: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search string for learner")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_audience_orgs_registered_users_retrieve

        List all learners on the platform with aggregated metrics.  This endpoint returns a paginated list of all learners with key metrics including: - Enrollment counts - Completion counts - Time spent on platform  Query Parameters:     page (int): Page number for pagination     length (int): Number of items per page     search (str): Filter learners by username, email, or name  Returns:     A paginated list of learners with their associated metrics.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param search: Search string for learner
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_audience_orgs_registered_users_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerUserList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_audience_orgs_registered_users_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/audience/orgs/{org}/registered-users/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_costs_pertenant_list(
        self,
        end_date: datetime,
        start_date: datetime,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_costs_pertenant_list

        Retrieve paginated LLM usage costs aggregated by tenant.

        :param end_date: (required)
        :type end_date: datetime
        :param start_date: (required)
        :type start_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_costs_pertenant_list_serialize(
            end_date=end_date,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CostPerTenant]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_costs_pertenant_list_serialize(
        self,
        end_date,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/costs/pertenant/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_departments_orgs_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        departments: Annotated[Optional[List[StrictStr]], Field(description="Departments search string. Single string or list of strings. e.g 'sample_department' or `['department', 'another department']` ")] = None,
        end_date: Annotated[Optional[date], Field(description="Filter by learners date_joined. Start date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        is_enrolled: Annotated[Optional[StrictBool], Field(description="Filter for users who have at least an enro;lment")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        location: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Location search string")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        pathway: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway string")] = None,
        program: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program search string")] = None,
        start_date: Annotated[Optional[date], Field(description="Filter by learners date_joined. Start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_departments_orgs_retrieve

        Get a list of departments with metrics and filtering options.  This endpoint provides a paginated list of departments with aggregated metrics about learner performance, course completions, and skill acquisition.  Query Parameters:     page (int, optional): Page number for pagination     length (int, optional): Number of items per page     program (str, optional): Filter by program     pathway (str, optional): Filter by pathway     departments (list, optional): Filter by department ids     department_id (str, optional): Filter by department id     location (str, optional): Filter by location     is_enrolled (bool, optional): Filter for departments with enrolled users     start_date (date, optional): Filter by learner join date (start range)     end_date (date, optional): Filter by learner join date (end range)  Returns:     A paginated list of departments with comprehensive metrics.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param departments: Departments search string. Single string or list of strings. e.g 'sample_department' or `['department', 'another department']` 
        :type departments: List[str]
        :param end_date: Filter by learners date_joined. Start date. ISO 8601
        :type end_date: date
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param is_enrolled: Filter for users who have at least an enro;lment
        :type is_enrolled: bool
        :param length: Size of data to return
        :type length: int
        :param location: Location search string
        :type location: str
        :param page: Page offset
        :type page: int
        :param pathway: Pathway string
        :type pathway: str
        :param program: Program search string
        :type program: str
        :param start_date: Filter by learners date_joined. Start date. ISO 8601
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_departments_orgs_retrieve_serialize(
            org=org,
            department_id=department_id,
            departments=departments,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            is_enrolled=is_enrolled,
            length=length,
            location=location,
            page=page,
            pathway=pathway,
            program=program,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GroupList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_departments_orgs_retrieve_serialize(
        self,
        org,
        department_id,
        departments,
        end_date,
        format,
        include_main_platform,
        is_enrolled,
        length,
        location,
        page,
        pathway,
        program,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'departments': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if departments is not None:
            
            _query_params.append(('departments', departments))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if is_enrolled is not None:
            
            _query_params.append(('is_enrolled', is_enrolled))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if location is not None:
            
            _query_params.append(('location', location))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if pathway is not None:
            
            _query_params.append(('pathway', pathway))
            
        if program is not None:
            
            _query_params.append(('program', program))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/departments/orgs/{org}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_activity_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_activity_retrieve

        Get engagement metrics on a per-course basis.  This endpoint provides a paginated list of courses with engagement metrics including activity counts, time spent, and interaction data.  Query Parameters:     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with their engagement metrics.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_activity_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EngagementPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_activity_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/activity',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_course_completion_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_course_completion_over_time_retrieve

        Completion count per user per course across the platform  Query Params 1. start_date e.g 2020-10-01 2. end_date e.g 2020-10-10  Default result when no query param is added is last_7_days (today inclusive)

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_course_completion_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_course_completion_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/course_completion/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_course_completion_per_course_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_course_completion_per_course_retrieve

        List course completion metrics on a per-course basis.  This endpoint provides a paginated table of courses with enrollment and completion statistics for each course.  Returns:     A paginated list of courses with:     - Course identification (ID and name)     - Enrollment count     - Completion count     - Average completion rate

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_course_completion_per_course_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCompletionPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_course_completion_per_course_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/course_completion/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_time_average_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_time_average_retrieve

        Average time spent in secs on a per-day basis  Query Params 1. start_date e.g 2020-10-01 2. end_date e.g 2020-10-10 3. course_id <optional>  Default result when no query param is added is last_7_days (today inclusive)

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_time_average_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AverageOvertime",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_time_average_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/time/average',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_time_detail_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_time_detail_retrieve

        Time spent per course in secs in a tree like form  Kwargs course_id e.g course-v1:Org+Course4+Run  Query Params 1. start_date <optional> e.g 2020-10-01 2. end_date <optional> e.g 2020-10-10

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_time_detail_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeDetail",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_time_detail_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/time/detail',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_time_over_time_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_time_over_time_retrieve

        Time spent per course in secs on a per-day basis  Query Params 1. start_date e.g 2020-10-01 2. end_date e.g 2020-10-10 Kwargs 3. course_id  Default result when no query param is added is last_7_days (today inclusive)

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_time_over_time_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTimeWithTotal",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_time_over_time_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/time/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_time_users_detail_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_time_users_detail_retrieve

        Time spent within a course in ordered hierarchical format  Kwargs 1. course_id  e.g course-v1:Org+Course4+Run 2. user_id e.g developer@ibleducation.com or dev123 (username|email) Query Params 3. start_date <optional> e.g 2020-10-01 4. end_date <optional> e.g 2020-10-10

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_time_users_detail_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerLearnerTimeSpentInCourseTree",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_time_users_detail_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/time/users/{user_id}/detail',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_time_users_over_time_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_time_users_over_time_retrieve

        Time spent in secs on a per-day basis  Query Params 1. course_id <optional> e.g course-v1:Org+Course4+Run 2. user_id <optional> e.g developer@ibleducation.com or dev123 (username|email) 3. start_date e.g 2020-10-01 4. end_date e.g 2020-10-10  Default result when no query param is added is last_7_days (today inclusive)

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_time_users_over_time_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTimeWithTotal",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_time_users_over_time_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/time/users/{user_id}/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_time_users_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_time_users_retrieve

        Time spent by users in a course  Query Params course_id  e.g course-v1:Org+Course4+Run

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_time_users_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeSpentByUsersInCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_time_users_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/time/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_videos_over_time_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_videos_over_time_retrieve

        Get video watch counts over time.  This endpoint provides daily counts of videos watched over a specified time period, with options to filter by course or user.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)     course_id (str, optional): Filter by course ID     user_id (str, optional): Filter by username or email  Returns:     Daily video watch counts over the specified time period.  Default time range is the last 7 days if no dates are specified.  Access Control:     - Platform admins can access any video watch data     - Learners can access their own video watch data

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_videos_over_time_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTimeWithTotal",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_videos_over_time_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/videos/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_videos_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_videos_retrieve

        Get video engagement metrics for a specific course.  This endpoint provides detailed video engagement statistics for a single course, including view counts, completion rates, and time spent on videos.  Query Parameters:     course_id (str): The course ID to get video engagement data for  Returns:     Detailed video engagement metrics for the specified course.

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_videos_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VideosSpecificCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_videos_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/videos/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_videos_summary_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_videos_summary_retrieve

        Get a summary of video watch statistics for a specific course.  This endpoint provides a structured summary of video watch data for a course, organized in a tree-like format by course sections and subsections.  Query Parameters:     course_id (str): The course ID to get video summary for  Returns:     A hierarchical structure of video watch data for the course, including:     - Section and subsection organization     - Video identification and metadata     - Watch counts and completion rates

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_videos_summary_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VideosInCourseSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_videos_summary_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/videos/summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_courses_videos_users_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_courses_videos_users_retrieve

        List of users' videos completed records for a specific course  Kwargs course_id  e.g course-v1:Org+Course4+Run

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_courses_videos_users_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WatchedVideosPerUser",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_courses_videos_users_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/courses/{course_id}/videos/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_time_average_perlearner_percourse_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_time_average_perlearner_percourse_retrieve

        Average time spent by a learner in enrolled courses. Gives a rough estimate of whats the average time that would be spent by a learner in a course  Query Params 1. start_date e.g 2020-10-01 2. end_date e.g 2020-10-10

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_time_average_perlearner_percourse_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AverageOvertime",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_time_average_perlearner_percourse_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/time/average-perlearner-percourse',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_time_average_with_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_time_average_with_over_time_retrieve

        Average time spent in secs on a per-day basis  Query Params 1. start_date e.g 2020-10-01 2. end_date e.g 2020-10-10 3. course_id <optional>  Default result when no query param is added is last_7_days (today inclusive)

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_time_average_with_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AverageOvertime",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_time_average_with_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/time/average-with-over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_time_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_time_over_time_retrieve

        Get time spent on the platform over time.  This endpoint provides daily time spent values (in seconds) across the platform over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)  Returns:     Daily time spent values over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_time_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_time_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/time/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_time_per_course_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_time_per_course_retrieve

        Get time spent statistics on a per-course basis.  This endpoint provides a paginated list of courses with the total time spent by users in each course.  Query Parameters:     start_date (str, optional): Start date for filtering (ISO format)     end_date (str, optional): End date for filtering (ISO format)     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with:     - Course identification (ID and name)     - Total time spent (in seconds)     - Formatted time spent (human-readable)     - Percentage of total platform time

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_time_per_course_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeSpentPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_time_per_course_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/time/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_videos_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_videos_over_time_retrieve

        Get video watch counts over time.  This endpoint provides daily counts of videos watched over a specified time period, with options to filter by course or user.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)     course_id (str, optional): Filter by course ID     user_id (str, optional): Filter by username or email  Returns:     Daily video watch counts over the specified time period.  Default time range is the last 7 days if no dates are specified.  Access Control:     - Platform admins can access any video watch data     - Learners can access their own video watch data

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_videos_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTimeWithTotal",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_videos_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/videos/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_engagement_orgs_videos_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_engagement_orgs_videos_retrieve

        Get video engagement metrics on a per-course basis.  This endpoint provides a paginated list of courses with video engagement metrics including view counts, completion rates, and time spent on videos.  Query Parameters:     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with their video engagement metrics.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_engagement_orgs_videos_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VideoEngagementPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_engagement_orgs_videos_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/engagement/orgs/{org}/videos/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_average_messages_per_session_list(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        aggregation: Annotated[Optional[StrictStr], Field(description="Time aggregation level (hourly, daily, weekly)")] = None,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_average_messages_per_session_list

        Retrieve average message counts per session over time.  This endpoint returns data on the average number of messages exchanged in each conversation session within a specified date range, with options for filtering by mentor and aggregating by different time periods (hourly, daily, weekly).  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Time series of average message counts and session totals.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     mentor_id (str): Filter by mentor unique ID.     aggregation (str): Time aggregation level (hourly, daily, weekly) - default: daily.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param aggregation: Time aggregation level (hourly, daily, weekly)
        :type aggregation: str
        :param group_by:
        :type group_by: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_average_messages_per_session_list_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            aggregation=aggregation,
            group_by=group_by,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MessageStatistics]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_average_messages_per_session_list_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        aggregation,
        group_by,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if aggregation is not None:
            
            _query_params.append(('aggregation', aggregation))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/average-messages-per-session/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_chat_history_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        conversations: Conversations,
        end_date: Optional[date] = None,
        filter_user_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor: Optional[UUID] = None,
        sentiment: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        topics: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_chat_history_create

        API viewset for retrieving and filtering chat message history.  This viewset provides endpoints for retrieving chat message history within an organization, with extensive filtering options by date range, user, topic, mentor, and sentiment.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param conversations: (required)
        :type conversations: Conversations
        :param end_date:
        :type end_date: date
        :param filter_user_id:
        :type filter_user_id: str
        :param mentor:
        :type mentor: str
        :param sentiment:
        :type sentiment: str
        :param start_date:
        :type start_date: date
        :param topics:
        :type topics: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_chat_history_create_serialize(
            org=org,
            user_id=user_id,
            conversations=conversations,
            end_date=end_date,
            filter_user_id=filter_user_id,
            mentor=mentor,
            sentiment=sentiment,
            start_date=start_date,
            topics=topics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Conversations",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_chat_history_create_serialize(
        self,
        org,
        user_id,
        conversations,
        end_date,
        filter_user_id,
        mentor,
        sentiment,
        start_date,
        topics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if filter_user_id is not None:
            
            _query_params.append(('filter_user_id', filter_user_id))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if sentiment is not None:
            
            _query_params.append(('sentiment', sentiment))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if conversations is not None:
            _body_params = conversations


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/chat-history/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_chat_history_destroy(
        self,
        id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        end_date: Optional[date] = None,
        filter_user_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor: Optional[UUID] = None,
        sentiment: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        topics: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_chat_history_destroy

        API viewset for retrieving and filtering chat message history.  This viewset provides endpoints for retrieving chat message history within an organization, with extensive filtering options by date range, user, topic, mentor, and sentiment.  Permissions:     - Restricted to platform administrators only

        :param id: (required)
        :type id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param end_date:
        :type end_date: date
        :param filter_user_id:
        :type filter_user_id: str
        :param mentor:
        :type mentor: str
        :param sentiment:
        :type sentiment: str
        :param start_date:
        :type start_date: date
        :param topics:
        :type topics: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_chat_history_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            end_date=end_date,
            filter_user_id=filter_user_id,
            mentor=mentor,
            sentiment=sentiment,
            start_date=start_date,
            topics=topics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_chat_history_destroy_serialize(
        self,
        id,
        org,
        user_id,
        end_date,
        filter_user_id,
        mentor,
        sentiment,
        start_date,
        topics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if filter_user_id is not None:
            
            _query_params.append(('filter_user_id', filter_user_id))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if sentiment is not None:
            
            _query_params.append(('sentiment', sentiment))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/chat-history/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_chat_history_filter_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        end_date: Optional[date] = None,
        mentor_id: Optional[UUID] = None,
        monthly_range: Optional[StrictBool] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_chat_history_filter_retrieve

        Retrieve filter options for chat message history.  This endpoint returns data on available filter options for the chat message history endpoint, including topics, date ranges (weekly or monthly), sentiments, and users who have chat history.  Args:     request: The HTTP request containing query parameters.     org: Organization key identifier.  Returns:     Response: Available filter options for chat message history.  Raises:     NotFound: If the specified organization does not exist.  Query Parameters:     monthly_range (bool): Whether to return monthly or weekly date ranges.     mentor_id (str): Filter users by those who have chatted with a specific mentor.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param end_date:
        :type end_date: date
        :param mentor_id:
        :type mentor_id: str
        :param monthly_range:
        :type monthly_range: bool
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_chat_history_filter_retrieve_serialize(
            org=org,
            user_id=user_id,
            end_date=end_date,
            mentor_id=mentor_id,
            monthly_range=monthly_range,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ChatHistoryFilterData",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_chat_history_filter_retrieve_serialize(
        self,
        org,
        user_id,
        end_date,
        mentor_id,
        monthly_range,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if monthly_range is not None:
            
            _query_params.append(('monthly_range', monthly_range))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/chat-history-filter/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_chat_history_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        end_date: Optional[date] = None,
        filter_user_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor: Optional[UUID] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        sentiment: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        topics: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_chat_history_list

        API viewset for retrieving and filtering chat message history.  This viewset provides endpoints for retrieving chat message history within an organization, with extensive filtering options by date range, user, topic, mentor, and sentiment.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param end_date:
        :type end_date: date
        :param filter_user_id:
        :type filter_user_id: str
        :param mentor:
        :type mentor: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param sentiment:
        :type sentiment: str
        :param start_date:
        :type start_date: date
        :param topics:
        :type topics: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_chat_history_list_serialize(
            org=org,
            user_id=user_id,
            end_date=end_date,
            filter_user_id=filter_user_id,
            mentor=mentor,
            page=page,
            page_size=page_size,
            sentiment=sentiment,
            start_date=start_date,
            topics=topics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedConversationsList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_chat_history_list_serialize(
        self,
        org,
        user_id,
        end_date,
        filter_user_id,
        mentor,
        page,
        page_size,
        sentiment,
        start_date,
        topics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if filter_user_id is not None:
            
            _query_params.append(('filter_user_id', filter_user_id))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if sentiment is not None:
            
            _query_params.append(('sentiment', sentiment))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/chat-history/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_chat_history_partial_update(
        self,
        id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        end_date: Optional[date] = None,
        filter_user_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor: Optional[UUID] = None,
        sentiment: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        topics: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        patched_conversations: Optional[PatchedConversations] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_chat_history_partial_update

        API viewset for retrieving and filtering chat message history.  This viewset provides endpoints for retrieving chat message history within an organization, with extensive filtering options by date range, user, topic, mentor, and sentiment.  Permissions:     - Restricted to platform administrators only

        :param id: (required)
        :type id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param end_date:
        :type end_date: date
        :param filter_user_id:
        :type filter_user_id: str
        :param mentor:
        :type mentor: str
        :param sentiment:
        :type sentiment: str
        :param start_date:
        :type start_date: date
        :param topics:
        :type topics: str
        :param patched_conversations:
        :type patched_conversations: PatchedConversations
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_chat_history_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            end_date=end_date,
            filter_user_id=filter_user_id,
            mentor=mentor,
            sentiment=sentiment,
            start_date=start_date,
            topics=topics,
            patched_conversations=patched_conversations,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Conversations",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_chat_history_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        end_date,
        filter_user_id,
        mentor,
        sentiment,
        start_date,
        topics,
        patched_conversations,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if filter_user_id is not None:
            
            _query_params.append(('filter_user_id', filter_user_id))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if sentiment is not None:
            
            _query_params.append(('sentiment', sentiment))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_conversations is not None:
            _body_params = patched_conversations


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/chat-history/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_chat_history_retrieve(
        self,
        id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        end_date: Optional[date] = None,
        filter_user_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor: Optional[UUID] = None,
        sentiment: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        topics: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_chat_history_retrieve

        API viewset for retrieving and filtering chat message history.  This viewset provides endpoints for retrieving chat message history within an organization, with extensive filtering options by date range, user, topic, mentor, and sentiment.  Permissions:     - Restricted to platform administrators only

        :param id: (required)
        :type id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param end_date:
        :type end_date: date
        :param filter_user_id:
        :type filter_user_id: str
        :param mentor:
        :type mentor: str
        :param sentiment:
        :type sentiment: str
        :param start_date:
        :type start_date: date
        :param topics:
        :type topics: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_chat_history_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            end_date=end_date,
            filter_user_id=filter_user_id,
            mentor=mentor,
            sentiment=sentiment,
            start_date=start_date,
            topics=topics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Conversations",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_chat_history_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        end_date,
        filter_user_id,
        mentor,
        sentiment,
        start_date,
        topics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if filter_user_id is not None:
            
            _query_params.append(('filter_user_id', filter_user_id))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if sentiment is not None:
            
            _query_params.append(('sentiment', sentiment))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/chat-history/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_chat_history_update(
        self,
        id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        conversations: Conversations,
        end_date: Optional[date] = None,
        filter_user_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor: Optional[UUID] = None,
        sentiment: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        topics: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_chat_history_update

        API viewset for retrieving and filtering chat message history.  This viewset provides endpoints for retrieving chat message history within an organization, with extensive filtering options by date range, user, topic, mentor, and sentiment.  Permissions:     - Restricted to platform administrators only

        :param id: (required)
        :type id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param conversations: (required)
        :type conversations: Conversations
        :param end_date:
        :type end_date: date
        :param filter_user_id:
        :type filter_user_id: str
        :param mentor:
        :type mentor: str
        :param sentiment:
        :type sentiment: str
        :param start_date:
        :type start_date: date
        :param topics:
        :type topics: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_chat_history_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            conversations=conversations,
            end_date=end_date,
            filter_user_id=filter_user_id,
            mentor=mentor,
            sentiment=sentiment,
            start_date=start_date,
            topics=topics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Conversations",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_chat_history_update_serialize(
        self,
        id,
        org,
        user_id,
        conversations,
        end_date,
        filter_user_id,
        mentor,
        sentiment,
        start_date,
        topics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if filter_user_id is not None:
            
            _query_params.append(('filter_user_id', filter_user_id))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if sentiment is not None:
            
            _query_params.append(('sentiment', sentiment))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if conversations is not None:
            _body_params = conversations


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/chat-history/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_conversation_list(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        aggregation: Annotated[Optional[StrictStr], Field(description="Time aggregation level (hourly, daily, weekly)")] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_conversation_list

        Retrieve conversation volume data over time.  This endpoint returns data on the number of conversations that occurred within a specified date range, with options for different time aggregations (hourly, daily, weekly). Results can be filtered by mentor.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.     user_id: User identifier (not used in the implementation).  Returns:     Response: Time series data of conversation counts.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     mentor_id (str): Filter by mentor unique ID.     aggregation (str): Time aggregation level (hourly, daily, weekly) - default: daily.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param aggregation: Time aggregation level (hourly, daily, weekly)
        :type aggregation: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_conversation_list_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            aggregation=aggregation,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ConversationVolume]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_conversation_list_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        aggregation,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if aggregation is not None:
            
            _query_params.append(('aggregation', aggregation))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/conversation/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_conversation_summary_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_conversation_summary_retrieve

        Retrieve a summary of conversation metrics.  This endpoint returns aggregated metrics about conversations within an organization, including: - Total number of conversations - Total number of human messages - Total number of AI messages  Results can be filtered by mentor.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Summary of conversation metrics.  Raises:     NotFound: If the specified organization does not exist.  Query Parameters:     mentor_id (str): Filter by mentor unique ID.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param group_by:
        :type group_by: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_conversation_summary_retrieve_serialize(
            org=org,
            user_id=user_id,
            group_by=group_by,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConversationSummary",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_conversation_summary_retrieve_serialize(
        self,
        org,
        user_id,
        group_by,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/conversation-summary/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_costs_model_retrieve(
        self,
        end_date: datetime,
        org: StrictStr,
        start_date: datetime,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_costs_model_retrieve

        Retrieve the  model costs for a tenant  Filter parameters for period are start_date and enddate  Accessible to tenant Admins only.

        :param end_date: (required)
        :type end_date: datetime
        :param org: (required)
        :type org: str
        :param start_date: (required)
        :type start_date: datetime
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_costs_model_retrieve_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ModelCost",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_costs_model_retrieve_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/costs/model/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_costs_permentor_retrieve(
        self,
        end_date: datetime,
        org: StrictStr,
        start_date: datetime,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_costs_permentor_retrieve

        Retrieve LLM usage costs aggregated by mentor.  This endpoint returns data on the total cost of LLM usage for each mentor within a specified date range, with pagination support. The costs are calculated by summing the costs of all observations associated with traces from the mentor's sessions.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Paginated list of mentors with their total LLM usage costs.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     limit (int): Number of results per page - default: 5.     offset (int): Offset for pagination - default: 0.

        :param end_date: (required)
        :type end_date: datetime
        :param org: (required)
        :type org: str
        :param start_date: (required)
        :type start_date: datetime
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_costs_permentor_retrieve_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TenantMentorTraces",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_costs_permentor_retrieve_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/costs/permentor/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_costs_peruser_retrieve(
        self,
        end_date: datetime,
        org: StrictStr,
        start_date: datetime,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_costs_peruser_retrieve

        Retrieve LLM usage costs aggregated by user.  This endpoint returns data on the total cost of LLM usage for each user within a specified date range, with pagination support. The costs are calculated by summing the costs of all observations associated with traces from the user's sessions.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Paginated list of users with their total LLM usage costs.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     limit (int): Number of results per page - default: 10.     offset (int): Offset for pagination - default: 0.

        :param end_date: (required)
        :type end_date: datetime
        :param org: (required)
        :type org: str
        :param start_date: (required)
        :type start_date: datetime
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_costs_peruser_retrieve_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LLMTracesListResponse",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_costs_peruser_retrieve_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/costs/peruser/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_mentor_detail_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_mentor_detail_retrieve

        Retrieve summary statistics about mentors.  This endpoint returns aggregated statistics about mentors within an organization, including total mentors, active mentors (mentors with at least one session), questions answered, and ratings.  Args:     request: The HTTP request.     org: Organization key identifier.  Returns:     Response: Summary statistics about mentors.  Raises:     NotFound: If the specified organization does not exist.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_mentor_detail_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorDetailAnalytics",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_mentor_detail_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/mentor-detail/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_mentor_summary_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_mentor_summary_retrieve

        Retrieve summary statistics about mentors.  This endpoint returns aggregated statistics about mentors within an organization, including total mentors, active mentors (mentors with at least one session), questions answered, and ratings.  Args:     request: The HTTP request.     org: Organization key identifier.  Returns:     Response: Summary statistics about mentors.  Raises:     NotFound: If the specified organization does not exist.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_mentor_summary_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorDetailAnalytics",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_mentor_summary_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/mentor-summary/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_mentors_cost_retrieve(
        self,
        end_date: datetime,
        mentor_unique_id: StrictStr,
        org: StrictStr,
        start_date: datetime,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_mentors_cost_retrieve

        Retrieve LLM usage costs for a specific mentor.  This endpoint returns data on the total cost of LLM usage for a specific mentor within a specified date range. The cost is calculated by summing the costs of all observations associated with traces from the tenant's sessions.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.     mentor_unique_id: User key identifier.  Returns:     Response: Total LLM usage cost for the specified tenant.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.

        :param end_date: (required)
        :type end_date: datetime
        :param mentor_unique_id: (required)
        :type mentor_unique_id: str
        :param org: (required)
        :type org: str
        :param start_date: (required)
        :type start_date: datetime
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_mentors_cost_retrieve_serialize(
            end_date=end_date,
            mentor_unique_id=mentor_unique_id,
            org=org,
            start_date=start_date,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Cost",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_mentors_cost_retrieve_serialize(
        self,
        end_date,
        mentor_unique_id,
        org,
        start_date,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if mentor_unique_id is not None:
            _path_params['mentor_unique_id'] = mentor_unique_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/mentors/{mentor_unique_id}/cost/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_most_discussed_topics_list(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        aggregation: Annotated[Optional[StrictStr], Field(description="Time aggregation level (hourly, daily, weekly)")] = None,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_most_discussed_topics_list

        Retrieve the most discussed topics over time.  This endpoint returns data on the frequency of topics discussed in conversations within a specified date range, with options for filtering by mentor and aggregating by different time periods (hourly, daily, weekly).  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: List of topics with their conversation counts, ordered by frequency.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     mentor_id (str): Filter by mentor unique ID.     aggregation (str): Time aggregation level (hourly, daily, weekly) - default: daily.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param aggregation: Time aggregation level (hourly, daily, weekly)
        :type aggregation: str
        :param group_by:
        :type group_by: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_most_discussed_topics_list_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            aggregation=aggregation,
            group_by=group_by,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[TopicRecord]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_most_discussed_topics_list_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        aggregation,
        group_by,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if aggregation is not None:
            
            _query_params.append(('aggregation', aggregation))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/most-discussed-topics/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_observations_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_observations_list

        Viewset for retrieving and listing Langfuse observations.  This viewset provides read-only access to Langfuse observations data for platform admins. Observations represent detailed tracking of AI model interactions and responses.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param search: A search term.
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_observations_list_serialize(
            org=org,
            user_id=user_id,
            limit=limit,
            offset=offset,
            ordering=ordering,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedObservationList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_observations_list_serialize(
        self,
        org,
        user_id,
        limit,
        offset,
        ordering,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/observations/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_observations_retrieve(
        self,
        id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_observations_retrieve

        Viewset for retrieving and listing Langfuse observations.  This viewset provides read-only access to Langfuse observations data for platform admins. Observations represent detailed tracking of AI model interactions and responses.  Permissions:     - Restricted to platform administrators only

        :param id: (required)
        :type id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_observations_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Observation",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_observations_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/observations/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_overview_summary_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter analytics by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_overview_summary_retrieve

        Retrieve an overview of key analytics metrics.  This endpoint returns a comprehensive overview of key analytics metrics for an organization, including: - Conversation volume: Total sessions and month-over-month change - Users: Total unique users and month-over-month change - Topics: Total unique topics and month-over-month change - User ratings: Total ratings and month-over-month change  Results can be filtered by mentor.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.     user_id: User identifier (not used in the implementation).  Returns:     Response: Overview of key analytics metrics with month-over-month changes.  Raises:     NotFound: If the specified organization does not exist.  Query Parameters:     mentor_id (str): Filter analytics by mentor unique ID.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param group_by:
        :type group_by: str
        :param mentor_id: Filter analytics by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_overview_summary_retrieve_serialize(
            org=org,
            user_id=user_id,
            group_by=group_by,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalyticsOverview",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_overview_summary_retrieve_serialize(
        self,
        org,
        user_id,
        group_by,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/overview-summary/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_rating_summary_list(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        group_by: Annotated[Optional[StrictStr], Field(description="Aggregation level (day or hour)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_rating_summary_list

        Retrieve user rating metrics over time.  This endpoint returns data on the number of user ratings submitted within a specified date range, aggregated by day or hour.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Time series of rating counts aggregated by day or hour.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     group_by (str): Aggregation level (day or hour) - default: day.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param group_by: Aggregation level (day or hour)
        :type group_by: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_rating_summary_list_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            group_by=group_by,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RatingRecord]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_rating_summary_list_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        group_by,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/rating-summary/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_registered_users_trend_list(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        aggregation: Annotated[Optional[StrictStr], Field(description="Time aggregation level (hourly, daily, weekly, monthly)")] = None,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_registered_users_trend_list

        Retrieve trends of registered users over time.  This endpoint returns data on the number of new user registrations within a specified date range, with options for different time aggregations (hourly, daily, weekly, monthly). The data is backfilled to ensure continuous time series even for periods with zero registrations.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Time series of user registration counts.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     aggregation (str): Time aggregation level (hourly, daily, weekly, monthly) - default: daily.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param aggregation: Time aggregation level (hourly, daily, weekly, monthly)
        :type aggregation: str
        :param group_by:
        :type group_by: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_registered_users_trend_list_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            aggregation=aggregation,
            group_by=group_by,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[TrendEntry]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_registered_users_trend_list_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        aggregation,
        group_by,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if aggregation is not None:
            
            _query_params.append(('aggregation', aggregation))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/registered-users-trend/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_sentiment_count_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        period: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_sentiment_count_list

        Retrieve user sentiment counts over time.  This endpoint returns data on the number of user sentiment entries within a specified time period, aggregated by date.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.     user_id: User identifier.  Returns:     Response: Time series data of sentiment counts.  Raises:     NotFound: If the specified organization does not exist.     ValidationError: If the provided query parameters are invalid.  Query Parameters:     period (str): Time period filter (today, yesterday, 7d, 30d, 90d) - default: 7d.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param period:
        :type period: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_sentiment_count_list_serialize(
            org=org,
            user_id=user_id,
            period=period,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[UserSentimentCountView]",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_sentiment_count_list_serialize(
        self,
        org,
        user_id,
        period,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if period is not None:
            
            _query_params.append(('period', period))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/sentiment-count/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_tenant_cost_retrieve(
        self,
        end_date: datetime,
        org: StrictStr,
        start_date: datetime,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_tenant_cost_retrieve

        Retrieve LLM usage costs for a specific tenant.  This endpoint returns data on the total cost of LLM usage for a specific tenant within a specified date range. The cost is calculated by summing the costs of all observations associated with traces from the tenant's sessions.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Total LLM usage cost for the specified tenant.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.

        :param end_date: (required)
        :type end_date: datetime
        :param org: (required)
        :type org: str
        :param start_date: (required)
        :type start_date: datetime
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_tenant_cost_retrieve_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Cost",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_tenant_cost_retrieve_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/tenant-cost/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_top_students_by_chat_messages_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_top_students_by_chat_messages_list

        Retrieve the most engaged students based on chat message count.  This endpoint returns data on the top 20 students with the highest number of chat messages, with optional filtering by mentor and date range.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.     user_id: User identifier (not used in the implementation).  Returns:     Response: List of top students with their chat message counts.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     mentor_id (str): Filter by mentor unique ID.     start_date (str): Start date for filtering (YYYY-MM-DD).     end_date (str): End date for filtering (YYYY-MM-DD).

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param group_by:
        :type group_by: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_top_students_by_chat_messages_list_serialize(
            org=org,
            user_id=user_id,
            group_by=group_by,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[StudentChatMessage]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_top_students_by_chat_messages_list_serialize(
        self,
        org,
        user_id,
        group_by,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/top-students-by-chat-messages/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_topic_overview_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter statistics by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_topic_overview_retrieve

        Retrieve aggregated topic statistics.  This endpoint returns statistical information about topics within an organization, including total topics, new topics, and percentage changes compared to the previous month. Results can be filtered by mentor.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Statistical information about topics.  Raises:     NotFound: If the specified organization or mentor does not exist.  Query Parameters:     mentor_id (str): Filter statistics by mentor unique ID.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param mentor_id: Filter statistics by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_topic_overview_retrieve_serialize(
            org=org,
            user_id=user_id,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TopicStatisticsResponse",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_topic_overview_retrieve_serialize(
        self,
        org,
        user_id,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/topic-overview/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_topic_statistics_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        end_date: Annotated[Optional[StrictStr], Field(description="End date for filtering (YYYY-MM-DD)")] = None,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Start date for filtering (YYYY-MM-DD)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_topic_statistics_retrieve

        Retrieve paginated statistics about topics.  This endpoint returns detailed statistics about topics, including: - Number of conversations related to each topic - Total message count for each topic - Average sentiment of conversations about each topic - Average user rating for conversations about each topic  Results can be filtered by mentor and date range, and are paginated.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Paginated list of topic statistics.  Raises:     NotFound: If the specified organization or mentor does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD).     end_date (str): End date for filtering (YYYY-MM-DD).     mentor_id (str): Filter by mentor unique ID.     page (int): Page number for pagination - default: 1.     page_size (int): Number of results per page - default: 20.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param end_date: End date for filtering (YYYY-MM-DD)
        :type end_date: str
        :param group_by:
        :type group_by: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param start_date: Start date for filtering (YYYY-MM-DD)
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_topic_statistics_retrieve_serialize(
            org=org,
            user_id=user_id,
            end_date=end_date,
            group_by=group_by,
            mentor_id=mentor_id,
            page=page,
            page_size=page_size,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedTopicStatisticsResponse",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_topic_statistics_retrieve_serialize(
        self,
        org,
        user_id,
        end_date,
        group_by,
        mentor_id,
        page,
        page_size,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/topic-statistics/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_topics_summary_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        end_date: Optional[date] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_topics_summary_list

        Retrieve a summary of the most frequent topics.  This endpoint returns a summary of the top 10 topics discussed in chat sessions, ordered by conversation count. Results can be filtered by mentor and date range.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: A list of the top 10 topics with their conversation counts.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided date format is invalid.  Query Parameters:     mentor_id (str): Filter by mentor unique ID.     start_date (str): Start date for filtering (YYYY-MM-DD).     end_date (str): End date for filtering (YYYY-MM-DD).

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param end_date:
        :type end_date: date
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_topics_summary_list_serialize(
            org=org,
            user_id=user_id,
            end_date=end_date,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[TopicSummaryView]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_topics_summary_list_serialize(
        self,
        org,
        user_id,
        end_date,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/topics/summary/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_total_users_by_mentor_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        aggregation: Annotated[Optional[StrictStr], Field(description="Time aggregation level (hourly, daily)")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="End date for filtering (YYYY-MM-DD)")] = None,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="Start date for filtering (YYYY-MM-DD)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_total_users_by_mentor_list

        Retrieve the total number of users interacting with mentors over time.  This endpoint returns data on the number of unique users who interacted with mentors each day or hour within a specified date range, with optional filtering by specific mentor. If no date range is provided, the last 30 days are used by default.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Time series of unique user counts.  Raises:     NotFound: If the specified organization or mentor does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - defaults to 30 days ago.     end_date (str): End date for filtering (YYYY-MM-DD) - defaults to today.     aggregation (str): Time aggregation level (hourly, daily) - default: daily.     mentor_id (str): Filter by mentor unique ID.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param aggregation: Time aggregation level (hourly, daily)
        :type aggregation: str
        :param end_date: End date for filtering (YYYY-MM-DD)
        :type end_date: str
        :param group_by:
        :type group_by: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param start_date: Start date for filtering (YYYY-MM-DD)
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_total_users_by_mentor_list_serialize(
            org=org,
            user_id=user_id,
            aggregation=aggregation,
            end_date=end_date,
            group_by=group_by,
            mentor_id=mentor_id,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[UserChatByPeriod]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_total_users_by_mentor_list_serialize(
        self,
        org,
        user_id,
        aggregation,
        end_date,
        group_by,
        mentor_id,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if aggregation is not None:
            
            _query_params.append(('aggregation', aggregation))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/total-users-by-mentor/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_traces_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_traces_list

        Viewset for retrieving and listing Langfuse traces.  This viewset provides read-only access to Langfuse traces data for platform admins. Traces represent high-level tracking of user interactions and AI responses.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param search: A search term.
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_traces_list_serialize(
            org=org,
            user_id=user_id,
            limit=limit,
            offset=offset,
            ordering=ordering,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedTraceList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_traces_list_serialize(
        self,
        org,
        user_id,
        limit,
        offset,
        ordering,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/traces/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_traces_retrieve(
        self,
        id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_traces_retrieve

        Viewset for retrieving and listing Langfuse traces.  This viewset provides read-only access to Langfuse traces data for platform admins. Traces represent high-level tracking of user interactions and AI responses.  Permissions:     - Restricted to platform administrators only

        :param id: (required)
        :type id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_traces_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Trace",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_traces_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/traces/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_transcripts_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        end_date: Optional[date] = None,
        mentor: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        topics: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_transcripts_list

        Retrieve message data from conversations.  This endpoint returns data on messages within conversations, with options for filtering by date range, topics, and mentor.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.     user_id: User identifier (not used in the implementation).  Returns:     Response: A list of conversation message data.  Raises:     NotFound: If the specified organization does not exist.     ValidationError: If the provided query parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD).     end_date (str): End date for filtering (YYYY-MM-DD).     topics (str): Comma-separated list of topics to filter by.     mentor (str): Filter by mentor unique ID.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param end_date:
        :type end_date: date
        :param mentor:
        :type mentor: str
        :param start_date:
        :type start_date: date
        :param topics:
        :type topics: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_transcripts_list_serialize(
            org=org,
            user_id=user_id,
            end_date=end_date,
            mentor=mentor,
            start_date=start_date,
            topics=topics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ConversationMessage]",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_transcripts_list_serialize(
        self,
        org,
        user_id,
        end_date,
        mentor,
        start_date,
        topics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/transcripts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_usage_summary_list(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_usage_summary_list

        Retrieve daily user engagement metrics with mentors.  This endpoint returns data on the number of unique users who interact with mentors each day within a specified date range.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Daily time series of unique user counts.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param group_by:
        :type group_by: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_usage_summary_list_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            group_by=group_by,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[UserCountRecord]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_usage_summary_list_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        group_by,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/usage-summary/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_user_cohorts_over_time_retrieve(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        aggregation: Annotated[Optional[StrictStr], Field(description="Time aggregation level (hourly, daily, weekly)")] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_user_cohorts_over_time_retrieve

        Retrieve user cohort trends over time.  This endpoint returns data on the distribution of new versus veteran users over time, with options for different time aggregations and filtering by mentor. New users are those who registered within the specified date range, while veteran users are those who registered before the date range but were active during it.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Time series of new and veteran user counts.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     aggregation (str): Time aggregation level (hourly, daily, weekly) - default: daily.     mentor_id (str): Filter by mentor unique ID.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param aggregation: Time aggregation level (hourly, daily, weekly)
        :type aggregation: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_user_cohorts_over_time_retrieve_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            aggregation=aggregation,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserTrendByPeriod",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_user_cohorts_over_time_retrieve_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        aggregation,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if aggregation is not None:
            
            _query_params.append(('aggregation', aggregation))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/user-cohorts-over-time/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_user_cost_retrieve(
        self,
        end_date: datetime,
        org: StrictStr,
        start_date: datetime,
        user_id: StrictStr,
        username: Annotated[str, Field(min_length=1, strict=True)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_user_cost_retrieve

        Retrieve LLM usage costs for a specific user.  This endpoint returns data on the total cost of LLM usage for a specific user within a specified date range. The cost is calculated by summing the costs of all observations associated with traces from the tenant's sessions.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.     user_id: User key identifier.  Returns:     Response: Total LLM usage cost for the specified tenant.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.

        :param end_date: (required)
        :type end_date: datetime
        :param org: (required)
        :type org: str
        :param start_date: (required)
        :type start_date: datetime
        :param user_id: (required)
        :type user_id: str
        :param username: (required)
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_user_cost_retrieve_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Cost",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_user_cost_retrieve_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/user-cost/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_user_feedback_list(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        aggregation: Annotated[Optional[StrictStr], Field(description="Time aggregation level (hourly, daily, weekly)")] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_user_feedback_list

        Retrieve aggregated user chat feedback counts.  This endpoint returns data on the number of user chat feedback entries within a specified date range, with options for different time aggregations (hourly, daily, weekly). Results can be filtered by mentor.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Time series data of feedback counts.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     mentor_id (str): Filter by mentor unique ID.     aggregation (str): Time aggregation level (hourly, daily, weekly) - default: daily.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param aggregation: Time aggregation level (hourly, daily, weekly)
        :type aggregation: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_user_feedback_list_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            aggregation=aggregation,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[UserChatFeedbackCount]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_user_feedback_list_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        aggregation,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if aggregation is not None:
            
            _query_params.append(('aggregation', aggregation))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/user-feedback/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_user_metrics_pie_chart_retrieve(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_user_metrics_pie_chart_retrieve

        Retrieve user distribution data for pie charts.  This endpoint returns data on the distribution of new versus returning users within a specified date range, including both counts and percentages, suitable for pie chart visualization.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Distribution of new versus returning users with counts and percentages.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.     mentor_id (str): Filter by mentor unique ID.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param mentor_id: Filter by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_user_metrics_pie_chart_retrieve_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PieChartData",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_user_metrics_pie_chart_retrieve_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/user-metrics-pie-chart/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_user_metrics_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor_id: Annotated[Optional[StrictStr], Field(description="Filter metrics by mentor unique ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_user_metrics_retrieve

        Retrieve comprehensive user metrics.  This endpoint returns data on various user metrics with month-over-month change calculations: - Registered users: Total users registered on the platform - New users: Users who joined in the current month - Unique users: Distinct users who have had sessions - Veteran users: Users who have been active for at least 6 months  Results can be filtered by mentor.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Comprehensive user metrics with month-over-month changes.  Raises:     NotFound: If the specified organization does not exist.  Query Parameters:     mentor_id (str): Filter metrics by mentor unique ID.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param group_by:
        :type group_by: str
        :param mentor_id: Filter metrics by mentor unique ID
        :type mentor_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_user_metrics_retrieve_serialize(
            org=org,
            user_id=user_id,
            group_by=group_by,
            mentor_id=mentor_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserMetricsResponse",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_user_metrics_retrieve_serialize(
        self,
        org,
        user_id,
        group_by,
        mentor_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/user-metrics/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_orgs_users_user_sentiment_retrieve(
        self,
        end_date: Annotated[StrictStr, Field(description="End date for filtering (YYYY-MM-DD)")],
        org: StrictStr,
        start_date: Annotated[StrictStr, Field(description="Start date for filtering (YYYY-MM-DD)")],
        user_id: StrictStr,
        group_by: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_orgs_users_user_sentiment_retrieve

        Retrieve user sentiment distribution.  This endpoint returns data on the distribution of user sentiments (positive, negative, neutral) within a specified date range, expressed as percentages.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.  Returns:     Response: Sentiment distribution percentages and total sentiment count.  Raises:     NotFound: If the specified organization does not exist.     BadRequest: If the provided parameters are invalid.  Query Parameters:     start_date (str): Start date for filtering (YYYY-MM-DD) - required.     end_date (str): End date for filtering (YYYY-MM-DD) - required.

        :param end_date: End date for filtering (YYYY-MM-DD) (required)
        :type end_date: str
        :param org: (required)
        :type org: str
        :param start_date: Start date for filtering (YYYY-MM-DD) (required)
        :type start_date: str
        :param user_id: (required)
        :type user_id: str
        :param group_by:
        :type group_by: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_orgs_users_user_sentiment_retrieve_serialize(
            end_date=end_date,
            org=org,
            start_date=start_date,
            user_id=user_id,
            group_by=group_by,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SentimentSummary",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_orgs_users_user_sentiment_retrieve_serialize(
        self,
        end_date,
        org,
        start_date,
        user_id,
        group_by,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/orgs/{org}/users/{user_id}/user-sentiment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_overview_orgs_active_users_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_overview_orgs_active_users_retrieve

        Get active user counts over time.  This endpoint provides daily counts of active users (users with known activity) over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)  Returns:     Daily active user counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.  An active user is defined as a user with any activity within the past 30 days.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_overview_orgs_active_users_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_overview_orgs_active_users_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/overview/orgs/{org}/active-users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_overview_orgs_average_grade_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_overview_orgs_average_grade_retrieve

        Get average grade value for platform, course, or user.  This endpoint returns the average grade at different levels: - Platform level: Average grade across all courses - Course level: Average grade for a specific course - Learner level: Average grade for a specific learner - Course-learner level: Grade for a specific learner in a specific course  Query Parameters:     course_id (str, optional): Filter by course ID     learner_id (str, optional): Filter by username or email  Returns:     The average grade value based on the specified filters.  Access Control:     - Platform admins can access any grade data     - Learners can access their own grade data

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_overview_orgs_average_grade_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Average",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_overview_orgs_average_grade_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/overview/orgs/{org}/average-grade',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_overview_orgs_courses_completions_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_overview_orgs_courses_completions_retrieve

        Get course completion summary metrics over time.  This endpoint provides completion statistics across the platform over a specified time period, including daily completion counts and overall metrics.  Query Parameters:     start_date (str): Start date for the time range (ISO format)     end_date (str): End date for the time range (ISO format)  Returns:     Completion data including:     - Daily completion counts over time     - Total unique user count     - Total completion count     - Completion percentage     - Change metrics compared to previous periods  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_overview_orgs_courses_completions_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCompletionSummaryOvertime",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_overview_orgs_courses_completions_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/overview/orgs/{org}/courses/completions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_overview_orgs_learners_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        search: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search string for learner")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_overview_orgs_learners_retrieve

        List all learners on the platform with aggregated metrics.  This endpoint returns a paginated list of all learners with key metrics including: - Enrollment counts - Completion counts - Time spent on platform  Query Parameters:     page (int): Page number for pagination     length (int): Number of items per page     search (str): Filter learners by username, email, or name  Returns:     A paginated list of learners with their associated metrics.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param search: Search string for learner
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_overview_orgs_learners_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerUserList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_overview_orgs_learners_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/overview/orgs/{org}/learners',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_overview_orgs_most_active_courses_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_overview_orgs_most_active_courses_retrieve

        Get time spent statistics on a per-course basis.  This endpoint provides a paginated list of courses with the total time spent by users in each course.  Query Parameters:     start_date (str, optional): Start date for filtering (ISO format)     end_date (str, optional): End date for filtering (ISO format)     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with:     - Course identification (ID and name)     - Total time spent (in seconds)     - Formatted time spent (human-readable)     - Percentage of total platform time

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_overview_orgs_most_active_courses_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeSpentPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_overview_orgs_most_active_courses_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/overview/orgs/{org}/most-active-courses',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_overview_orgs_registered_users_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_overview_orgs_registered_users_retrieve

        Get registered user counts over time.  This endpoint provides daily counts of new user registrations over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)  Returns:     Daily registration counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_overview_orgs_registered_users_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_overview_orgs_registered_users_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/overview/orgs/{org}/registered-users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_performance_orgs_courses_grading_average_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_performance_orgs_courses_grading_average_retrieve

        Get average grade value for platform, course, or user.  This endpoint returns the average grade at different levels: - Platform level: Average grade across all courses - Course level: Average grade for a specific course - Learner level: Average grade for a specific learner - Course-learner level: Grade for a specific learner in a specific course  Query Parameters:     course_id (str, optional): Filter by course ID     learner_id (str, optional): Filter by username or email  Returns:     The average grade value based on the specified filters.  Access Control:     - Platform admins can access any grade data     - Learners can access their own grade data

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_performance_orgs_courses_grading_average_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Average",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_performance_orgs_courses_grading_average_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/performance/orgs/{org}/courses/{course_id}/grading/average',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_performance_orgs_courses_grading_average_with_cutoff_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_performance_orgs_courses_grading_average_with_cutoff_retrieve

        Returns average course grade and grade cuttoff  e.g ``` {     \"data\": {         \"grade_cutoffs\": {             \"A\": 90,             \"B\": 80,             \"C\": 70,         },         \"average_grade\": 50.0,     } } ```  Kwargs course_id

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_performance_orgs_courses_grading_average_with_cutoff_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AvgCourseGradeWithCutoff",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_performance_orgs_courses_grading_average_with_cutoff_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/performance/orgs/{org}/courses/{course_id}/grading/average-with-cutoff',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_performance_orgs_courses_grading_detail_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_performance_orgs_courses_grading_detail_retrieve

        Grading summary for the entire course overview in a tree-like format  Kwargs course_id <required>

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_performance_orgs_courses_grading_detail_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseGradingDetail",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_performance_orgs_courses_grading_detail_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/performance/orgs/{org}/courses/{course_id}/grading/detail',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_performance_orgs_courses_grading_per_learner_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_performance_orgs_courses_grading_per_learner_retrieve

        Grading information per enrolled user in a course  Kwargs course_id <required>

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_performance_orgs_courses_grading_per_learner_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GradingPerUser",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_performance_orgs_courses_grading_per_learner_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/performance/orgs/{org}/courses/{course_id}/grading/per-learner',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_performance_orgs_courses_grading_summary_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_performance_orgs_courses_grading_summary_retrieve

        Returns average grades across various assignment types in a course  Query Params course_id  Returns:     dict     {         \"data\": [             {                 \"assignment_type': <str>,                 \"weight\": <float>,                 \"average_weighted_grade\": <float>,                 \"average_section_grade\": <float>             }, ...         ]     }

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_performance_orgs_courses_grading_summary_retrieve_serialize(
            course_id=course_id,
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseGradeSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_performance_orgs_courses_grading_summary_retrieve_serialize(
        self,
        course_id,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/performance/orgs/{org}/courses/{course_id}/grading/summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_performance_orgs_grading_average_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_performance_orgs_grading_average_retrieve

        Get average grade value for platform, course, or user.  This endpoint returns the average grade at different levels: - Platform level: Average grade across all courses - Course level: Average grade for a specific course - Learner level: Average grade for a specific learner - Course-learner level: Grade for a specific learner in a specific course  Query Parameters:     course_id (str, optional): Filter by course ID     learner_id (str, optional): Filter by username or email  Returns:     The average grade value based on the specified filters.  Access Control:     - Platform admins can access any grade data     - Learners can access their own grade data

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_performance_orgs_grading_average_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Average",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_performance_orgs_grading_average_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/performance/orgs/{org}/grading/average',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_performance_orgs_grading_per_course_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_performance_orgs_grading_per_course_retrieve

        List grade-related performance data for all courses.  This endpoint provides a comprehensive view of grade performance across courses, including enrollment counts, pass rates, and average grades.  Returns:     A paginated list of courses with:     - Course identification (ID and name)     - Enrollment count     - Number of students who passed     - Average grade

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_performance_orgs_grading_per_course_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerformanceGradesPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_performance_orgs_grading_per_course_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/performance/orgs/{org}/grading/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_learners_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[date], Field(description="Learner date_joined end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        is_enrolled: Annotated[Optional[StrictBool], Field(description="Filter for users who have at least an enrollment")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        location: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Location search string")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        platform: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform search string")] = None,
        program: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program search string")] = None,
        search: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search string for learner. email, username or full name")] = None,
        start_date: Annotated[Optional[date], Field(description="Learner date_joined start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_learners_retrieve

        Enhanced API endpoint for listing learners with comprehensive filtering.  This endpoint provides a paginated list of learners with detailed metrics and supports advanced filtering options. It uses DM token authentication and respects department-based access controls.  Query Parameters:     page (int): Page number for pagination     length (int): Number of items per page     search (str): Filter by username, email, or full name     program (str): Filter by program     location (str): Filter by location     is_enrolled (bool): Filter for users with enrollments     platform (str): Filter by platform     start_date (date): Filter by join date (start range)     end_date (date): Filter by join date (end range)  Returns:     A paginated list of learners with comprehensive metrics including:     - Course enrollments and completions     - Time spent on platform     - Pathway progress     - Certificate and skill information     - Location data  Access Control:     - Platform admins can see all learners     - Department admins can only see learners in their departments

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: Learner date_joined end date. ISO 8601
        :type end_date: date
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param is_enrolled: Filter for users who have at least an enrollment
        :type is_enrolled: bool
        :param length: Size of data to return
        :type length: int
        :param location: Location search string
        :type location: str
        :param page: Page offset
        :type page: int
        :param platform: Platform search string
        :type platform: str
        :param program: Program search string
        :type program: str
        :param search: Search string for learner. email, username or full name
        :type search: str
        :param start_date: Learner date_joined start date. ISO 8601
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_learners_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            is_enrolled=is_enrolled,
            length=length,
            location=location,
            page=page,
            platform=platform,
            program=program,
            search=search,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "NewPerLearnerList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_learners_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        is_enrolled,
        length,
        location,
        page,
        platform,
        program,
        search,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if is_enrolled is not None:
            
            _query_params.append(('is_enrolled', is_enrolled))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if location is not None:
            
            _query_params.append(('location', location))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if platform is not None:
            
            _query_params.append(('platform', platform))
            
        if program is not None:
            
            _query_params.append(('program', program))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/learners',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_activity_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_activity_retrieve

        Provides information on user enrollments  Params user_id e.g developer@ibleducation.com| developer

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_activity_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActivityAPI",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_activity_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/activity/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_grading_cutoffs_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_grading_cutoffs_retrieve

        Provides about a learner current grade in a course with the course cut Kwargs 1. course_id e.g course-v1:Org+Course4+Run 2. user_id e.g developer@ibleducation.com or dev123 (username|email)

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_grading_cutoffs_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerGradeWithCutOff",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_grading_cutoffs_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/grading/cutoffs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_grading_detail_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_grading_detail_retrieve

        Mixin that includes the StudentTokenAuthentication and IsAdminUserOrStudent

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_grading_detail_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DetailedGradeView",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_grading_detail_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/grading/detail',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_grading_summary_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_grading_summary_retrieve

        Query Params 1. course_id e.g course-v1:Org+Course4+Run 2. user_id e.g developer@ibleducation.com or dev123 (username|email)

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_grading_summary_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerGradeSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_grading_summary_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/grading/summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_overview_engagement_index_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_overview_engagement_index_retrieve

        Average of days with atleast an activity within ENGAGEMENT_INDEX_PERIOD consecutive days for a learner in a course

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_overview_engagement_index_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Value",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_overview_engagement_index_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/overview/engagement-index',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_overview_grade_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_overview_grade_retrieve

        Provides about a learner current grade in a course with the course cut Kwargs 1. course_id e.g course-v1:Org+Course4+Run 2. user_id e.g developer@ibleducation.com or dev123 (username|email)

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_overview_grade_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerGradeWithCutOff",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_overview_grade_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/overview/grade',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_overview_performance_index_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_overview_performance_index_retrieve

        Evaluates performance index for platform, per course, per user and per user-per course  Query Params course_id <optional> learner_id <optional>

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_overview_performance_index_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Value",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_overview_performance_index_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/overview/performance-index',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_overview_time_over_time_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_overview_time_over_time_retrieve

        Time spent within a course in secs on a per-day basis  Kwargs 1. course_id  e.g course-v1:Org+Course4+Run 2. user_id e.g developer@ibleducation.com or dev123 (username|email) Query Params 3. start_date e.g 2020-10-01 4. end_date e.g 2020-10-10  Default result when no query param is added is last_7_days (today inclusive)

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_overview_time_over_time_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTimeWithTotal",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_overview_time_over_time_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/overview/time/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_videos_over_time_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_videos_over_time_retrieve

        Get video watch counts over time.  This endpoint provides daily counts of videos watched over a specified time period, with options to filter by course or user.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)     course_id (str, optional): Filter by course ID     user_id (str, optional): Filter by username or email  Returns:     Daily video watch counts over the specified time period.  Default time range is the last 7 days if no dates are specified.  Access Control:     - Platform admins can access any video watch data     - Learners can access their own video watch data

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_videos_over_time_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTimeWithTotal",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_videos_over_time_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/videos/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_courses_videos_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_courses_videos_retrieve

        List of videos within a course a learner has watched  Kwargs 1. course_id e.g course-v1:Org+Course4+Run 2. user_id e.g developer@ibleducation.com or dev123 (username|email)  Default result when no query param is added is [], 0

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_courses_videos_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerLearnerCourseVideosWatched",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_courses_videos_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/courses/{course_id}/videos',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_grades_per_course_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_grades_per_course_retrieve

        Summary Grading Information for a learner on a per-enrollment basis  Query Params 1. user_id e.g developer@ibleducation.com or dev123 (username|email)

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_grades_per_course_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerGradingPerCourseAPI",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_grades_per_course_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/grades/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_info_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        meta: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Include extra analytics information?  * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        search: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_info_retrieve

        Retrieve detailed information about a specific learner.  This endpoint returns personal and activity information about a learner, including profile data, activity metrics, and location information.  Path Parameters:     user_id (str): The username or email of the learner  Query Parameters:     meta (bool): Include additional analytics information when true  Returns:     Detailed learner information including:     - Profile data (username, name, email)     - Registration and activity dates     - Activity metrics (assessments, time spent, videos watched)     - Location and browser information (when available)  Access Control:     - Platform admins can access any learner     - Learners can access their own information     - Department admins can access learners in their departments

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param meta: Include extra analytics information?  * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type meta: str
        :param search:
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_info_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            meta=meta,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LearnerInformationAPI",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_info_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        format,
        include_main_platform,
        meta,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if meta is not None:
            
            _query_params.append(('meta', meta))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/info',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_last_access_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_last_access_retrieve

        Last course accessed by a learner, includes upto unit information as well

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_last_access_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerLearnerLastAccess",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_last_access_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/last-access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_overview_engagement_index_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_overview_engagement_index_retrieve

        Average of days with atleast an activity within ENGAGEMENT_INDEX_PERIOD consecutive days

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_overview_engagement_index_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Value",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_overview_engagement_index_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/overview/engagement-index',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_overview_grades_average_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_overview_grades_average_retrieve

        Get average grade value for platform, course, or user.  This endpoint returns the average grade at different levels: - Platform level: Average grade across all courses - Course level: Average grade for a specific course - Learner level: Average grade for a specific learner - Course-learner level: Grade for a specific learner in a specific course  Query Parameters:     course_id (str, optional): Filter by course ID     learner_id (str, optional): Filter by username or email  Returns:     The average grade value based on the specified filters.  Access Control:     - Platform admins can access any grade data     - Learners can access their own grade data

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_overview_grades_average_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Average",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_overview_grades_average_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        format,
        include_main_platform,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/overview/grades/average',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_overview_performance_index_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_overview_performance_index_retrieve

        Evaluates performance index for platform, per course, per user and per user-per course  Query Params course_id <optional> learner_id <optional>

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_overview_performance_index_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Value",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_overview_performance_index_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/overview/performance-index',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_overview_time_over_time_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_overview_time_over_time_retrieve

        Time spent in secs on a per-day basis  Query Params 1. course_id <optional> e.g course-v1:Org+Course4+Run 2. user_id <optional> e.g developer@ibleducation.com or dev123 (username|email) 3. start_date e.g 2020-10-01 4. end_date e.g 2020-10-10  Default result when no query param is added is last_7_days (today inclusive)

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_overview_time_over_time_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTimeWithTotal",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_overview_time_over_time_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/overview/time/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        search: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search string for learner")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_retrieve

        List all learners on the platform with aggregated metrics.  This endpoint returns a paginated list of all learners with key metrics including: - Enrollment counts - Completion counts - Time spent on platform  Query Parameters:     page (int): Page number for pagination     length (int): Number of items per page     search (str): Filter learners by username, email, or name  Returns:     A paginated list of learners with their associated metrics.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param search: Search string for learner
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerUserList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_videos_over_time_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_videos_over_time_retrieve

        Get video watch counts over time.  This endpoint provides daily counts of videos watched over a specified time period, with options to filter by course or user.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)     course_id (str, optional): Filter by course ID     user_id (str, optional): Filter by username or email  Returns:     Daily video watch counts over the specified time period.  Default time range is the last 7 days if no dates are specified.  Access Control:     - Platform admins can access any video watch data     - Learners can access their own video watch data

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_videos_over_time_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTimeWithTotal",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_videos_over_time_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/videos/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_perlearner_orgs_users_videos_per_course_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_perlearner_orgs_users_videos_per_course_retrieve

        Summary Videos watched data for a learner per enrollment  Query Params 1. user_id e.g developer@ibleducation.com or dev123 (username|email)

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_perlearner_orgs_users_videos_per_course_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerEngagementVideosWatchedPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_perlearner_orgs_users_videos_per_course_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/perlearner/orgs/{org}/users/{user_id}/videos/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_analytics_user_groups_orgs_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[date], Field(description="Filter by learners date_joined. Start date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        groups: Annotated[Optional[List[StrictStr]], Field(description="Groups search string. Single string or list of strings. e.g 'sample_group' or `['group', 'another group']` ")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        is_enrolled: Annotated[Optional[StrictBool], Field(description="Filter for users who have at least an enrollment")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        location: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Location search string")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        pathway: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway string")] = None,
        program: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program search string")] = None,
        start_date: Annotated[Optional[date], Field(description="Filter by learners date_joined. Start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_analytics_user_groups_orgs_retrieve

        Get a list of user groups with metrics and filtering options.  This endpoint provides a paginated list of user groups with aggregated metrics about learner performance, course completions, and skill acquisition.  This endpoint uses DM token authentication and respects department-based access controls.  Query Parameters:     page (int, optional): Page number for pagination     length (int, optional): Number of items per page     program (str, optional): Filter by program     pathway (str, optional): Filter by pathway     groups (list, optional): Filter by group names     location (str, optional): Filter by location     is_enrolled (bool, optional): Filter for groups with enrolled users     start_date (date, optional): Filter by learner join date (start range)     end_date (date, optional): Filter by learner join date (end range)  Returns:     A paginated list of user groups with comprehensive metrics.  Access Control:     - Platform admins can see all groups     - Department admins can only see groups in their departments

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: Filter by learners date_joined. Start date. ISO 8601
        :type end_date: date
        :param format: Format  * `json` - json
        :type format: str
        :param groups: Groups search string. Single string or list of strings. e.g 'sample_group' or `['group', 'another group']` 
        :type groups: List[str]
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param is_enrolled: Filter for users who have at least an enrollment
        :type is_enrolled: bool
        :param length: Size of data to return
        :type length: int
        :param location: Location search string
        :type location: str
        :param page: Page offset
        :type page: int
        :param pathway: Pathway string
        :type pathway: str
        :param program: Program search string
        :type program: str
        :param start_date: Filter by learners date_joined. Start date. ISO 8601
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_analytics_user_groups_orgs_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            groups=groups,
            include_main_platform=include_main_platform,
            is_enrolled=is_enrolled,
            length=length,
            location=location,
            page=page,
            pathway=pathway,
            program=program,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GroupList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_analytics_user_groups_orgs_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        groups,
        include_main_platform,
        is_enrolled,
        length,
        location,
        page,
        pathway,
        program,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'groups': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if groups is not None:
            
            _query_params.append(('groups', groups))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if is_enrolled is not None:
            
            _query_params.append(('is_enrolled', is_enrolled))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if location is not None:
            
            _query_params.append(('location', location))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if pathway is not None:
            
            _query_params.append(('pathway', pathway))
            
        if program is not None:
            
            _query_params.append(('program', program))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-analytics/user-groups/orgs/{org}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_conversations_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        mentor_unique_id: Optional[UUID] = None,
        metric: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `conversations` - Conversations over time * `headline` - Headline metrics for conversations (avg messages per conversation, avg rating)")] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_conversations_retrieve


        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param metric: * `conversations` - Conversations over time * `headline` - Headline metrics for conversations (avg messages per conversation, avg rating)
        :type metric: str
        :param platform_key:
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_conversations_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            mentor_unique_id=mentor_unique_id,
            metric=metric,
            platform_key=platform_key,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConversationsChart",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_conversations_retrieve_serialize(
        self,
        date_filter,
        end_date,
        granularity,
        mentor_unique_id,
        metric,
        platform_key,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if metric is not None:
            
            _query_params.append(('metric', metric))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/conversations/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_financial_details_retrieve(
        self,
        group_by: Annotated[str, Field(min_length=1, strict=True, description="Dimension to group by  * `provider` - Group by provider * `llm_model` - Group by LLM model * `username` - Group by username * `mentor` - Group by mentor * `platform` - Group by platform * `action` - Group by actions")],
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        llm_model: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        mentor_unique_id: Optional[UUID] = None,
        metrics: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Comma-separated list of metrics (e.g. total_cost,sessions, last_active)")] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        provider: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        search: Optional[StrictStr] = None,
        start_date: Optional[date] = None,
        username: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_financial_details_retrieve

        Financial Details Analytics API – paginated cost tables with flexible grouping.  This endpoint returns tabular cost metrics aggregated by the dimension specified via the `group_by` query parameter.  One or more KPI columns can be requested through the comma-separated `metrics` list while typical filters (date range, provider, platform_key, user, etc.) narrow the dataset.  Results are paginated with `page` / `limit`.  **Required query parameters** - group_by – provider | llm_model | username | mentor | platform - metrics – csv list of KPI names, e.g. total_cost, sessions  **Shared optional filters** - start_date, end_date   – ISO yyyy-mm-dd (ignored when all_time=true) - platform_key           – tenant isolation - mentor_unique_id       – filter to one mentor - username               – filter to a learner - provider / llm_model   – filter to LLM provider / model - all_time               – true → lifetime totals - page (default 1), limit (default 50)  **Examples** -------- 1. Cost by provider for the last week ```    GET /api/v2/analytics/financial/details?        group_by=provider&        metrics=total_cost&        start_date=2025-01-01&        end_date=2025-01-07&        page=1&limit=10 ```  2. Lifetime cost per user with extra KPIs    ```    GET /api/v2/analytics/financial/details?        group_by=username&        metrics=total_cost,sessions&        all_time=true&page=1&limit=50    ``` 3. Cost by LLM model with tenant filter ```    GET /api/v2/analytics/financial/details?        group_by=llm_model&        metrics=total_cost&        platform_key=web-app&        start_date=2025-01-01&end_date=2025-01-31 ``` Response structure ------------------- ``` {   \"page\": 1,   \"limit\": 10,   \"total_pages\": 1,   \"total_records\": 3,   \"rows\": [     {\"provider\": \"openai\", \"total_cost\": \"2.50000\"},     {\"provider\": \"anthropic\", \"total_cost\": \"1.00000\"},     {\"provider\": \"azure\",    \"total_cost\": \"0.50000\"}   ],   \"metrics\": [     {       \"name\": \"total_cost\",       \"unit\": \"$\",       \"description\": \"Cost for this entity in period\"     }   ],   \"total_cost\": \"4.00000\"   // optional grand-total when available } ``

        :param group_by: Dimension to group by  * `provider` - Group by provider * `llm_model` - Group by LLM model * `username` - Group by username * `mentor` - Group by mentor * `platform` - Group by platform * `action` - Group by actions (required)
        :type group_by: str
        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param limit:
        :type limit: int
        :param llm_model:
        :type llm_model: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param metrics: Comma-separated list of metrics (e.g. total_cost,sessions, last_active)
        :type metrics: str
        :param page:
        :type page: int
        :param platform_key:
        :type platform_key: str
        :param provider:
        :type provider: str
        :param search:
        :type search: str
        :param start_date:
        :type start_date: date
        :param username:
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_financial_details_retrieve_serialize(
            group_by=group_by,
            date_filter=date_filter,
            end_date=end_date,
            limit=limit,
            llm_model=llm_model,
            mentor_unique_id=mentor_unique_id,
            metrics=metrics,
            page=page,
            platform_key=platform_key,
            provider=provider,
            search=search,
            start_date=start_date,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinanceDetailsResponse",
            '400': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_financial_details_retrieve_serialize(
        self,
        group_by,
        date_filter,
        end_date,
        limit,
        llm_model,
        mentor_unique_id,
        metrics,
        page,
        platform_key,
        provider,
        search,
        start_date,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if group_by is not None:
            
            _query_params.append(('group_by', group_by))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if llm_model is not None:
            
            _query_params.append(('llm_model', llm_model))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if metrics is not None:
            
            _query_params.append(('metrics', metrics))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if provider is not None:
            
            _query_params.append(('provider', provider))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/financial/details/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_financial_invoice_retrieve(
        self,
        end_date: Annotated[Optional[date], Field(description="End date for billing period (defaults to today)")] = None,
        include_breakdown: Annotated[Optional[StrictBool], Field(description="Whether to include provider and mentor breakdown")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=255)]], Field(description="Platform key to filter by (optional, required for platform admins)")] = None,
        start_date: Annotated[Optional[date], Field(description="Start date for billing period (defaults to 30 days ago)")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=255)]], Field(description="Username to generate invoice for (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_financial_invoice_retrieve

        Flexible Invoice Report API – Billing summary with username and platform filtering.  This endpoint generates invoice reports with flexible filtering options: - Platform admins can view their platform's data and filter by username within their platform - Super admins can view any combination of username/platform or global summaries  **Key Features:** - Flexible filtering by username and/or platform_key - Essential metrics: total cost, sessions, usage period - Provider breakdown (OpenAI, Anthropic, etc.) - Top mentors/actions by cost - Clean, invoice-ready format  **Query Parameters:** - username: Filter by specific username (optional) - platform_key: Filter by platform (optional, but required for platform admins) - start_date, end_date: billing period (defaults to last 30 days) - include_breakdown: show provider/mentor details (default: true)  **Permission Logic:** - Platform admins: Must include platform_key matching their permission scope - Super admins: Can use any combination of filters or none (global summary)  **Examples:** ``` # Platform admin viewing their platform GET /api/analytics/financial/invoice?platform_key=web-app  # Platform admin viewing specific user in their platform GET /api/analytics/financial/invoice?platform_key=web-app&username=john.doe  # Super admin viewing specific user across all platforms GET /api/analytics/financial/invoice?username=john.doe  # Super admin viewing global summary GET /api/analytics/financial/invoice ```  **Response Structure:** ```json {   \"entity\": {     \"type\": \"user|platform|global\",     \"username\": \"john.doe\",     \"platform_key\": \"web-app\",     \"platform_name\": \"Web Application\",     \"display_name\": \"John Doe on Web Application\"   },   \"billing_period\": {     \"start_date\": \"2025-01-01\",     \"end_date\": \"2025-01-31\",     \"days\": 31   },   \"summary\": {     \"total_cost\": 245.750,     \"total_sessions\": 1250,     \"active_users\": 85,     \"cost_per_session\": 0.196   },   \"breakdown\": {     \"by_provider\": [...],     \"by_mentor\": [...],     \"by_action\": [...]   } } ```

        :param end_date: End date for billing period (defaults to today)
        :type end_date: date
        :param include_breakdown: Whether to include provider and mentor breakdown
        :type include_breakdown: bool
        :param platform_key: Platform key to filter by (optional, required for platform admins)
        :type platform_key: str
        :param start_date: Start date for billing period (defaults to 30 days ago)
        :type start_date: date
        :param username: Username to generate invoice for (optional)
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_financial_invoice_retrieve_serialize(
            end_date=end_date,
            include_breakdown=include_breakdown,
            platform_key=platform_key,
            start_date=start_date,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InvoiceReportResponse",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_financial_invoice_retrieve_serialize(
        self,
        end_date,
        include_breakdown,
        platform_key,
        start_date,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if include_breakdown is not None:
            
            _query_params.append(('include_breakdown', include_breakdown))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/financial/invoice/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_financial_retrieve(
        self,
        metric: Annotated[str, Field(min_length=1, strict=True, description="Type of financial metric to retrieve  * `total_costs` - Total costs for selected timeframe * `weekly_costs` - Costs for current/selected week * `monthly_costs` - Costs for current/selected month")],
        comparison_days: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of days for comparison period to calculate percentage change (e.g., 10 for 10-day comparison)")] = None,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        fill_method: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Method for filling missing time periods in overtime data  * `zero` - Fill missing periods with zero * `previous` - Fill missing periods with previous value")] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Time granularity for overtime series data  * `day` - Daily data points * `week` - Weekly data points * `month` - Monthly data points")] = None,
        llm_model: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by specific LLM model (e.g., gpt-4o, claude-3-5-sonnet)")] = None,
        mentor_unique_id: Optional[UUID] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        provider: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by AI provider  * `openai` - OpenAI * `anthropic` - Anthropic * `azure` - Azure * `google` - Google * `meta` - Meta * `other` - Other")] = None,
        show_overtime: Annotated[Optional[StrictBool], Field(description="Whether to include overtime series data in response")] = None,
        start_date: Optional[date] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by specific username - returns costs for this user only")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_financial_retrieve

        Financial Analytics API - Get comprehensive cost metrics with comparison analysis.  This endpoint provides period-based cost analysis (not cumulative) with support for: - Multiple time granularities and metrics - Cross-dimensional filtering - Percentage change vs comparison periods - Forward-filled time series  **Examples:**  **Basic Weekly Costs:** ``` GET /api/analytics/financial/?metric=weekly_costs&comparison_days=10 ```  **Platform & Mentor Filtered:** ``` # Get total costs for a specific platform and mentor GET /api/analytics/financial/?metric=total_costs&platform_key=web-app&mentor_unique_id=mentor-123&comparison_days=14 ```  **Monthly Costs by Provider:** ``` GET /api/analytics/financial/?metric=monthly_costs&provider=openai&granularity=month&comparison_days=30 ```  **Daily Costs for Specific User:** ``` GET /api/analytics/financial/?metric=total_costs&username=user-456&granularity=day&start_date=2025-01-15&end_date=2025-01-21&comparison_days=7 ```   **Response Structure:** ```json {     \"metric\": \"weekly_costs\",     \"value\": 12.47,     \"percentage_change\": 8.5,     \"overtime\": [         {\"date\": \"2025-01-06\", \"value\": 2.89},         {\"date\": \"2025-01-13\", \"value\": 3.12}     ],     \"period_info\": {         \"start_date\": \"2025-01-01\",         \"end_date\": \"2025-01-31\",         \"period_days\": 31     },     \"comparison_info\": {         \"previous_period_value\": 11.50,         ...     } } ```

        :param metric: Type of financial metric to retrieve  * `total_costs` - Total costs for selected timeframe * `weekly_costs` - Costs for current/selected week * `monthly_costs` - Costs for current/selected month (required)
        :type metric: str
        :param comparison_days: Number of days for comparison period to calculate percentage change (e.g., 10 for 10-day comparison)
        :type comparison_days: int
        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param fill_method: Method for filling missing time periods in overtime data  * `zero` - Fill missing periods with zero * `previous` - Fill missing periods with previous value
        :type fill_method: str
        :param granularity: Time granularity for overtime series data  * `day` - Daily data points * `week` - Weekly data points * `month` - Monthly data points
        :type granularity: str
        :param llm_model: Filter by specific LLM model (e.g., gpt-4o, claude-3-5-sonnet)
        :type llm_model: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param platform_key:
        :type platform_key: str
        :param provider: Filter by AI provider  * `openai` - OpenAI * `anthropic` - Anthropic * `azure` - Azure * `google` - Google * `meta` - Meta * `other` - Other
        :type provider: str
        :param show_overtime: Whether to include overtime series data in response
        :type show_overtime: bool
        :param start_date:
        :type start_date: date
        :param username: Filter by specific username - returns costs for this user only
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_financial_retrieve_serialize(
            metric=metric,
            comparison_days=comparison_days,
            date_filter=date_filter,
            end_date=end_date,
            fill_method=fill_method,
            granularity=granularity,
            llm_model=llm_model,
            mentor_unique_id=mentor_unique_id,
            platform_key=platform_key,
            provider=provider,
            show_overtime=show_overtime,
            start_date=start_date,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseFinanceResponse",
            '400': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_financial_retrieve_serialize(
        self,
        metric,
        comparison_days,
        date_filter,
        end_date,
        fill_method,
        granularity,
        llm_model,
        mentor_unique_id,
        platform_key,
        provider,
        show_overtime,
        start_date,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if comparison_days is not None:
            
            _query_params.append(('comparison_days', comparison_days))
            
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if fill_method is not None:
            
            _query_params.append(('fill_method', fill_method))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if llm_model is not None:
            
            _query_params.append(('llm_model', llm_model))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if metric is not None:
            
            _query_params.append(('metric', metric))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if provider is not None:
            
            _query_params.append(('provider', provider))
            
        if show_overtime is not None:
            
            _query_params.append(('show_overtime', show_overtime))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/financial/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_learner_details_retrieve(
        self,
        username: Annotated[str, Field(min_length=1, strict=True)],
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        mentor_unique_id: Optional[UUID] = None,
        metrics: Optional[StrictStr] = None,
        overtime: Annotated[Optional[StrictBool], Field(description="Include overtime metrics for time_spent data (default: false)")] = None,
        platform_key: Optional[StrictStr] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_learner_details_retrieve

                 Retrieve a holistic snapshot of a learner across catalog enrollments, mentor         engagement, skills, credentials, and time spent data. The `metrics` query parameter controls         which sections are returned and defaults to `courses` when omitted.         

        :param username: (required)
        :type username: str
        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param metrics:
        :type metrics: str
        :param overtime: Include overtime metrics for time_spent data (default: false)
        :type overtime: bool
        :param platform_key:
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_learner_details_retrieve_serialize(
            username=username,
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            mentor_unique_id=mentor_unique_id,
            metrics=metrics,
            overtime=overtime,
            platform_key=platform_key,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LearnerDetailsResponse",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_learner_details_retrieve_serialize(
        self,
        username,
        date_filter,
        end_date,
        granularity,
        mentor_unique_id,
        metrics,
        overtime,
        platform_key,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if metrics is not None:
            
            _query_params.append(('metrics', metrics))
            
        if overtime is not None:
            
            _query_params.append(('overtime', overtime))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/learner/details',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_learners_list_retrieve(
        self,
        platform_key: Annotated[str, Field(min_length=1, strict=True, description="Platform key to filter learners by platform")],
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of learners per page (default: 20, max: 100)")] = None,
        mentor_unique_id: Optional[UUID] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination (default: 1)")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search term to filter learners by username, email, or name")] = None,
        sort_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort learners by (default: last_activity)  * `username` - Username * `name` - Name * `last_activity` - Last Activity * `total_points` - Total Points * `total_time_spent_seconds` - Time Spent * `total_enrollments` - Enrollments * `total_skills_count` - Skills Count")] = None,
        sort_order: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort order (default: desc)  * `asc` - Ascending * `desc` - Descending")] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_learners_list_retrieve

                 Retrieve a paginated list of learners for a specific platform with their comprehensive         metrics from the UserPlatformSummary materialized view. This endpoint is accessible only         to platform administrators and supports search, sorting, and pagination.         

        :param platform_key: Platform key to filter learners by platform (required)
        :type platform_key: str
        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param limit: Number of learners per page (default: 20, max: 100)
        :type limit: int
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param page: Page number for pagination (default: 1)
        :type page: int
        :param search: Search term to filter learners by username, email, or name
        :type search: str
        :param sort_by: Field to sort learners by (default: last_activity)  * `username` - Username * `name` - Name * `last_activity` - Last Activity * `total_points` - Total Points * `total_time_spent_seconds` - Time Spent * `total_enrollments` - Enrollments * `total_skills_count` - Skills Count
        :type sort_by: str
        :param sort_order: Sort order (default: desc)  * `asc` - Ascending * `desc` - Descending
        :type sort_order: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_learners_list_retrieve_serialize(
            platform_key=platform_key,
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            limit=limit,
            mentor_unique_id=mentor_unique_id,
            page=page,
            search=search,
            sort_by=sort_by,
            sort_order=sort_order,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LearnerListResponse",
            '400': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_learners_list_retrieve_serialize(
        self,
        platform_key,
        date_filter,
        end_date,
        granularity,
        limit,
        mentor_unique_id,
        page,
        search,
        sort_by,
        sort_order,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if sort_by is not None:
            
            _query_params.append(('sort_by', sort_by))
            
        if sort_order is not None:
            
            _query_params.append(('sort_order', sort_order))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/learners/list/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_learners_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of records per page (default: 20, max: 100)")] = None,
        mentor_unique_id: Optional[UUID] = None,
        overtime: Annotated[Optional[StrictBool], Field(description="Include overtime metrics for the user in the platform (default: false)")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number (default: 1)")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Optional platform key - if provided, returns platform-specific detailed data")] = None,
        start_date: Optional[date] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username of the learner to get analytics for. Defaults to self if not provided.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_learners_retrieve

        Unified API endpoint for learner analytics.  This endpoint provides either: 1. Cross-platform summary (when only username is provided) 2. Platform-specific detailed data (when username + platform_key are provided)  Query params: - username (required): Username of the learner - platform_key (optional): Platform key for platform-specific data - page (optional): Page number (default: 1) - limit (optional): Records per page (default: 20, max: 100)  Returns: - If platform_key provided: Detailed platform metrics - If no platform_key: Cross-platform summary with pagination

        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param limit: Number of records per page (default: 20, max: 100)
        :type limit: int
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param overtime: Include overtime metrics for the user in the platform (default: false)
        :type overtime: bool
        :param page: Page number (default: 1)
        :type page: int
        :param platform_key: Optional platform key - if provided, returns platform-specific detailed data
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param username: Username of the learner to get analytics for. Defaults to self if not provided.
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_learners_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            limit=limit,
            mentor_unique_id=mentor_unique_id,
            overtime=overtime,
            page=page,
            platform_key=platform_key,
            start_date=start_date,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LearnerAnalyticsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_learners_retrieve_serialize(
        self,
        date_filter,
        end_date,
        granularity,
        limit,
        mentor_unique_id,
        overtime,
        page,
        platform_key,
        start_date,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if overtime is not None:
            
            _query_params.append(('overtime', overtime))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/learners/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_messages_details_retrieve(
        self,
        session_id: Annotated[str, Field(min_length=1, strict=True)],
        end_date: Optional[date] = None,
        mentor_unique_id: Optional[UUID] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_messages_details_retrieve

        Conversation detail endpoint for analytics.  Query params: - session_id (required): UUID of the session to fetch - platform_key, mentor_unique_id (optional): further scope - start_date, end_date (optional): date filter on message timestamps  Returns: summary metadata from conversation_list MV, and a list of human/ai message pairs in chronological order.

        :param session_id: (required)
        :type session_id: str
        :param end_date:
        :type end_date: date
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param platform_key:
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_messages_details_retrieve_serialize(
            session_id=session_id,
            end_date=end_date,
            mentor_unique_id=mentor_unique_id,
            platform_key=platform_key,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConversationDetailResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_messages_details_retrieve_serialize(
        self,
        session_id,
        end_date,
        mentor_unique_id,
        platform_key,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if session_id is not None:
            
            _query_params.append(('session_id', session_id))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/messages/details/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_messages_retrieve(
        self,
        end_date: Optional[date] = None,
        limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        max_messages: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        mentor_unique_id: Optional[UUID] = None,
        min_messages: Optional[Annotated[int, Field(strict=True, ge=0)]] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        search: Optional[StrictStr] = None,
        sentiment: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `positive` - positive * `negative` - negative * `neutral` - neutral")] = None,
        start_date: Optional[date] = None,
        topic: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_messages_retrieve

        Conversation list endpoint for analytics.  Query params (all optional unless specified by permissions): - platform_key: filter by platform - mentor_unique_id: filter by mentor - page: page number (default 1) - limit: page size (default 20, max 100) - search: search in user name and first user message - min_messages, max_messages: message_count range - sentiment: positive|negative|neutral - topic: topic name contains - start_date, end_date: date filter on conversation date  Returns: summary totals, results list (paginated), and pagination metadata.

        :param end_date:
        :type end_date: date
        :param limit:
        :type limit: int
        :param max_messages:
        :type max_messages: int
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param min_messages:
        :type min_messages: int
        :param page:
        :type page: int
        :param platform_key:
        :type platform_key: str
        :param search:
        :type search: str
        :param sentiment: * `positive` - positive * `negative` - negative * `neutral` - neutral
        :type sentiment: str
        :param start_date:
        :type start_date: date
        :param topic:
        :type topic: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_messages_retrieve_serialize(
            end_date=end_date,
            limit=limit,
            max_messages=max_messages,
            mentor_unique_id=mentor_unique_id,
            min_messages=min_messages,
            page=page,
            platform_key=platform_key,
            search=search,
            sentiment=sentiment,
            start_date=start_date,
            topic=topic,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConversationListResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_messages_retrieve_serialize(
        self,
        end_date,
        limit,
        max_messages,
        mentor_unique_id,
        min_messages,
        page,
        platform_key,
        search,
        sentiment,
        start_date,
        topic,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if max_messages is not None:
            
            _query_params.append(('max_messages', max_messages))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if min_messages is not None:
            
            _query_params.append(('min_messages', min_messages))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if sentiment is not None:
            
            _query_params.append(('sentiment', sentiment))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if topic is not None:
            
            _query_params.append(('topic', topic))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/messages/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_orgs_time_update_create(
        self,
        org: StrictStr,
        time_spent_update_request: TimeSpentUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_orgs_time_update_create

        Update time spent tracking data from client-side events.  This endpoint receives time spent data collected on the client side and stores it in the analytics database. It requires a valid authentication token.  Methods:     POST: Submit time spent tracking data    Returns:     A response indicating success or failure:     {         \"success\": true|false,         \"message\": \"Error message if failed\" (optional)     }  Error Responses:     400 Bad Request: If the request data is invalid or the API is disabled  Notes:     This API must be enabled via the ENABLE_TIME_SPENT_UPDATE_API setting.

        :param org: (required)
        :type org: str
        :param time_spent_update_request: (required)
        :type time_spent_update_request: TimeSpentUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_orgs_time_update_create_serialize(
            org=org,
            time_spent_update_request=time_spent_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeSpentUpdateResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_orgs_time_update_create_serialize(
        self,
        org,
        time_spent_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if time_spent_update_request is not None:
            _body_params = time_spent_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/analytics/orgs/{org}/time/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_ratings_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        mentor_unique_id: Optional[UUID] = None,
        metric: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `ratings` - Ratings over time")] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_ratings_retrieve

        Ratings overtime endpoint.  Query params: - metric: only 'ratings' is supported (default) - platform_key, mentor_unique_id: optional filters - granularity: 'day' (default) or 'hour' (hour only for today) - start_date, end_date: optional date range; defaults applied if not provided  Returns: { metric: 'ratings', points: [{date, value}, ...] }

        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param metric: * `ratings` - Ratings over time
        :type metric: str
        :param platform_key:
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_ratings_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            mentor_unique_id=mentor_unique_id,
            metric=metric,
            platform_key=platform_key,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RatingsOvertime",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_ratings_retrieve_serialize(
        self,
        date_filter,
        end_date,
        granularity,
        mentor_unique_id,
        metric,
        platform_key,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if metric is not None:
            
            _query_params.append(('metric', metric))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/ratings/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_sessions_details_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        mentor_unique_id: Optional[UUID] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search by topic name")] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_sessions_details_retrieve


        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param limit:
        :type limit: int
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param page:
        :type page: int
        :param platform_key:
        :type platform_key: str
        :param search: Search by topic name
        :type search: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_sessions_details_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            limit=limit,
            mentor_unique_id=mentor_unique_id,
            page=page,
            platform_key=platform_key,
            search=search,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TopicDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_sessions_details_retrieve_serialize(
        self,
        date_filter,
        end_date,
        limit,
        mentor_unique_id,
        page,
        platform_key,
        search,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/sessions/details/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_sessions_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        mentor_unique_id: Optional[UUID] = None,
        metric: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `sessions` - Sessions over time * `headline` - Headline metrics for sessions (avg messages per session, avg rating)")] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_sessions_retrieve


        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param metric: * `sessions` - Sessions over time * `headline` - Headline metrics for sessions (avg messages per session, avg rating)
        :type metric: str
        :param platform_key:
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_sessions_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            mentor_unique_id=mentor_unique_id,
            metric=metric,
            platform_key=platform_key,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SessionsChart",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_sessions_retrieve_serialize(
        self,
        date_filter,
        end_date,
        granularity,
        mentor_unique_id,
        metric,
        platform_key,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if metric is not None:
            
            _query_params.append(('metric', metric))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/sessions/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_time_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        mentor_unique_id: Optional[UUID] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_time_retrieve

                 Time Analytics API - User activity patterns by time of day and day of week.                  Provides heatmap data showing when users are most active, useful for:         - Understanding peak usage times         - Capacity planning and resource allocation         - User behavior analysis         - Support scheduling optimization                  **Key Features:**         - Day of week patterns (0=Sunday through 6=Saturday)         - Hour of day activity levels (0-23)         - Flexible date range filtering         - Platform and mentor-specific filtering         - Message count aggregation                  **Data Structure:**         - `day_of_week`: 0-6 (Sunday-Saturday)         - `hour`: 0-23 (24-hour format)         - `value`: Message count for that time slot         

        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param platform_key:
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_time_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            mentor_unique_id=mentor_unique_id,
            platform_key=platform_key,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccessTimesHeatmap",
            '400': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_time_retrieve_serialize(
        self,
        date_filter,
        end_date,
        granularity,
        mentor_unique_id,
        platform_key,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/time/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_time_spent_user_retrieve(
        self,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Course ID to filter by (can be partial)")] = None,
        end_date: Annotated[Optional[date], Field(description="End date for time range (YYYY-MM-DD)")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Whether to include main platform data")] = None,
        learner_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username to get data for (admin users only)")] = None,
        mentor_uuid: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Mentor UUID to filter by")] = None,
        platform: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform name or key to filter by")] = None,
        session_uuid: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Session UUID to filter by")] = None,
        start_date: Annotated[Optional[date], Field(description="Start date for time range (YYYY-MM-DD)")] = None,
        url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="URL to filter by (can be partial)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get total time spent for current user

                 Returns the total time spent (in seconds) for the current authenticated user.         Can be filtered by platform, date range, course ID, URL, mentor UUID, and session UUID.         

        :param course_id: Course ID to filter by (can be partial)
        :type course_id: str
        :param end_date: End date for time range (YYYY-MM-DD)
        :type end_date: date
        :param include_main_platform: Whether to include main platform data
        :type include_main_platform: bool
        :param learner_id: Username to get data for (admin users only)
        :type learner_id: str
        :param mentor_uuid: Mentor UUID to filter by
        :type mentor_uuid: str
        :param platform: Platform name or key to filter by
        :type platform: str
        :param session_uuid: Session UUID to filter by
        :type session_uuid: str
        :param start_date: Start date for time range (YYYY-MM-DD)
        :type start_date: date
        :param url: URL to filter by (can be partial)
        :type url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_time_spent_user_retrieve_serialize(
            course_id=course_id,
            end_date=end_date,
            include_main_platform=include_main_platform,
            learner_id=learner_id,
            mentor_uuid=mentor_uuid,
            platform=platform,
            session_uuid=session_uuid,
            start_date=start_date,
            url=url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimeSpentPerUserResponse",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_time_spent_user_retrieve_serialize(
        self,
        course_id,
        end_date,
        include_main_platform,
        learner_id,
        mentor_uuid,
        platform,
        session_uuid,
        start_date,
        url,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if learner_id is not None:
            
            _query_params.append(('learner_id', learner_id))
            
        if mentor_uuid is not None:
            
            _query_params.append(('mentor_uuid', mentor_uuid))
            
        if platform is not None:
            
            _query_params.append(('platform', platform))
            
        if session_uuid is not None:
            
            _query_params.append(('session_uuid', session_uuid))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if url is not None:
            
            _query_params.append(('url', url))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/time-spent/user/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_topics_details_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        mentor_unique_id: Optional[UUID] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search by topic name")] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_topics_details_retrieve


        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param limit:
        :type limit: int
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param page:
        :type page: int
        :param platform_key:
        :type platform_key: str
        :param search: Search by topic name
        :type search: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_topics_details_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            limit=limit,
            mentor_unique_id=mentor_unique_id,
            page=page,
            platform_key=platform_key,
            search=search,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TopicDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_topics_details_retrieve_serialize(
        self,
        date_filter,
        end_date,
        limit,
        mentor_unique_id,
        page,
        platform_key,
        search,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/topics/details/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_topics_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        mentor_unique_id: Optional[UUID] = None,
        metric: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `overview` - Overall topic metrics * `sessions` - Sessions over time * `ratings` - Ratings over time * `highlighted` - Highlighted topics")] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_topics_retrieve


        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param metric: * `overview` - Overall topic metrics * `sessions` - Sessions over time * `ratings` - Ratings over time * `highlighted` - Highlighted topics
        :type metric: str
        :param platform_key:
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_topics_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            mentor_unique_id=mentor_unique_id,
            metric=metric,
            platform_key=platform_key,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TopicsOverview",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_topics_retrieve_serialize(
        self,
        date_filter,
        end_date,
        granularity,
        mentor_unique_id,
        metric,
        platform_key,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if metric is not None:
            
            _query_params.append(('metric', metric))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/topics/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_users_details_retrieve(
        self,
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        mentor_unique_id: Optional[UUID] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search by email, full name, or user ID")] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_users_details_retrieve

                 User Details API - Comprehensive user activity details with search and filtering.                  Provides detailed user information including:         - User contact information (email, full name)         - Activity metrics (message count, last activity)         - Search functionality across multiple fields         - Flexible date range filtering         - CSV export capability                  **Key Features:**         - Full-text search across email, name, and user ID         - Date range filtering for activity periods         - Platform and mentor-specific filtering         - Comprehensive pagination with metadata         - CSV export for data analysis         - User aggregation across platforms/mentors                  **Search Capabilities:**         - Email address matching         - Full name search         - User ID lookup         - Partial string matching (case-insensitive)                  **Export Options:**         - JSON response (default)         - CSV export (?export=csv)         - Includes all user fields in export         

        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param limit:
        :type limit: int
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param page:
        :type page: int
        :param platform_key:
        :type platform_key: str
        :param search: Search by email, full name, or user ID
        :type search: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_users_details_retrieve_serialize(
            date_filter=date_filter,
            end_date=end_date,
            limit=limit,
            mentor_unique_id=mentor_unique_id,
            page=page,
            platform_key=platform_key,
            search=search,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserDetail",
            '400': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_users_details_retrieve_serialize(
        self,
        date_filter,
        end_date,
        limit,
        mentor_unique_id,
        page,
        platform_key,
        search,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/users/details/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analytics_users_retrieve(
        self,
        metric: Annotated[str, Field(min_length=1, strict=True, description="* `currently_active` - Users logged in right now * `active_users` - Active users in a period * `registered_users` - Registered users * `active_users_last_30d` - Active users in the last 30 days")],
        date_filter: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range")] = None,
        end_date: Optional[date] = None,
        granularity: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="* `day` - day * `hour` - hour * `week` - week * `month` - month")] = None,
        mentor_unique_id: Optional[UUID] = None,
        platform_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        start_date: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """analytics_users_retrieve

                 User Analytics API - Comprehensive user activity metrics and trends.                  Provides real-time and historical user analytics including:         - Currently active users (last hour)         - Active users over time periods (7d, 30d, 90d)         - Registered user counts and growth         - Time series charts with customizable granularity                  **Key Features:**         - Real-time active user counting         - Percentage change calculations vs previous periods         - Flexible date filtering and granularity         - Platform and mentor-specific filtering         - Forward-filled time series data                  **Supported Metrics:**         - `currently_active`: Users active in last hour         - `active_users`: Unique users in specified period         - `registered_users`: Total and new user counts         

        :param metric: * `currently_active` - Users logged in right now * `active_users` - Active users in a period * `registered_users` - Registered users * `active_users_last_30d` - Active users in the last 30 days (required)
        :type metric: str
        :param date_filter: * `today` - Today only * `7d` - Last 7 days * `30d` - Last 30 days * `90d` - Last 90 days * `all_time` - All time * `custom` - Custom date range
        :type date_filter: str
        :param end_date:
        :type end_date: date
        :param granularity: * `day` - day * `hour` - hour * `week` - week * `month` - month
        :type granularity: str
        :param mentor_unique_id:
        :type mentor_unique_id: str
        :param platform_key:
        :type platform_key: str
        :param start_date:
        :type start_date: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analytics_users_retrieve_serialize(
            metric=metric,
            date_filter=date_filter,
            end_date=end_date,
            granularity=granularity,
            mentor_unique_id=mentor_unique_id,
            platform_key=platform_key,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CurrentUsersResponse",
            '400': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analytics_users_retrieve_serialize(
        self,
        metric,
        date_filter,
        end_date,
        granularity,
        mentor_unique_id,
        platform_key,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if date_filter is not None:
            
            _query_params.append(('date_filter', date_filter))
            
        if end_date is not None:
            if isinstance(end_date, date):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if granularity is not None:
            
            _query_params.append(('granularity', granularity))
            
        if mentor_unique_id is not None:
            
            _query_params.append(('mentor_unique_id', mentor_unique_id))
            
        if metric is not None:
            
            _query_params.append(('metric', metric))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if start_date is not None:
            if isinstance(start_date, date):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/analytics/users/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_active_users_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_active_users_over_time_retrieve

        Get active user counts over time.  This endpoint provides daily counts of active users (users with known activity) over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)  Returns:     Daily active user counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.  An active user is defined as a user with any activity within the past 30 days.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_active_users_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_active_users_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/active-users/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_active_users_per_course_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_active_users_per_course_retrieve

        Get active user counts on a per-course basis.  This endpoint provides counts of active users for each course within the specified date range.  Query Parameters:     start_date (str, optional): Start date for filtering (ISO format)     end_date (str, optional): End date for filtering (ISO format)  Returns:     A list of courses with their active user counts.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_active_users_per_course_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActiveUsersPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_active_users_per_course_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/active-users/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_active_users_users_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_active_users_users_retrieve

        Get a list of active users with activity metrics.  This endpoint provides a paginated list of users who have had activity within the specified date range.  Query Parameters:     start_date (str, optional): Start date for filtering (ISO format)     end_date (str, optional): End date for filtering (ISO format)     course_id (str, optional): Filter by course ID     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of active users with their activity metrics.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_active_users_users_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActiveUsersList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_active_users_users_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/active-users/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_enrollments_courses_over_time_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_enrollments_courses_over_time_retrieve

        Get enrollment or unenrollment counts over time.  This endpoint provides daily counts of new enrollments or unenrollments over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)     course_id (str, optional): Filter by course ID     active (bool): Get enrollments when true, unenrollments when false  Returns:     Daily counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_enrollments_courses_over_time_retrieve_serialize(
            course_id=course_id,
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_enrollments_courses_over_time_retrieve_serialize(
        self,
        course_id,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/enrollments/courses/{course_id}/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_enrollments_courses_users_retrieve(
        self,
        course_id: Annotated[str, Field(strict=True)],
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_enrollments_courses_users_retrieve

        List users enrolled in a specific course.  This endpoint provides a list of users who are enrolled or unenrolled in a specified course.  Query Parameters:     course_id (str): The course ID to get enrollments for     active (bool): Filter for active enrollments when true, inactive when false     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of users with:     - Username     - Full name     - Email     - Enrollment timestamp

        :param course_id: (required)
        :type course_id: str
        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_enrollments_courses_users_retrieve_serialize(
            course_id=course_id,
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnrollmentsPerUser",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_enrollments_courses_users_retrieve_serialize(
        self,
        course_id,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/enrollments/courses/{course_id}/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_enrollments_over_time_retrieve(
        self,
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_enrollments_over_time_retrieve

        Get enrollment or unenrollment counts over time.  This endpoint provides daily counts of new enrollments or unenrollments over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)     course_id (str, optional): Filter by course ID     active (bool): Get enrollments when true, unenrollments when false  Returns:     Daily counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_enrollments_over_time_retrieve_serialize(
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_enrollments_over_time_retrieve_serialize(
        self,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/enrollments/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_enrollments_per_course_retrieve(
        self,
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_enrollments_per_course_retrieve

        List enrollment statistics on a per-course basis.  This endpoint provides enrollment counts for all courses, with options to filter for active or inactive enrollments and to include time-based data.  Query Parameters:     active (bool): Filter for active enrollments when true, inactive when false     start_date (str, optional): Start date for time-based filtering (ISO format)     end_date (str, optional): End date for time-based filtering (ISO format)     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with their enrollment counts and percentages.

        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_enrollments_per_course_retrieve_serialize(
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Enrollments",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_enrollments_per_course_retrieve_serialize(
        self,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/enrollments/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_registered_users_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_registered_users_over_time_retrieve

        Get registered user counts over time.  This endpoint provides daily counts of new user registrations over a specified time period.  Query Parameters:     start_date (str, optional): Start date for the time range (ISO format)     end_date (str, optional): End date for the time range (ISO format)  Returns:     Daily registration counts over the specified time period, with change metrics     compared to previous periods.  Default time range is the last 7 days if no dates are specified.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_registered_users_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_registered_users_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/registered-users/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_registered_users_per_course_retrieve(
        self,
        org: StrictStr,
        active: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False")] = None,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_registered_users_per_course_retrieve

        List enrollment statistics on a per-course basis.  This endpoint provides enrollment counts for all courses, with options to filter for active or inactive enrollments and to include time-based data.  Query Parameters:     active (bool): Filter for active enrollments when true, inactive when false     start_date (str, optional): Start date for time-based filtering (ISO format)     end_date (str, optional): End date for time-based filtering (ISO format)     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with their enrollment counts and percentages.

        :param org: (required)
        :type org: str
        :param active: Any of `y`, `yes`, `true`. set to false or no for unenrollments   * `y` - y * `yes` - yes * `true` - true * `True` - True * `n` - n * `no` - no * `false` - false * `False` - False
        :type active: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_registered_users_per_course_retrieve_serialize(
            org=org,
            active=active,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Enrollments",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_registered_users_per_course_retrieve_serialize(
        self,
        org,
        active,
        department_id,
        end_date,
        format,
        include_main_platform,
        length,
        page,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/registered-users/per-course',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def audience_orgs_registered_users_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        search: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search string for learner")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """audience_orgs_registered_users_retrieve

        List all learners on the platform with aggregated metrics.  This endpoint returns a paginated list of all learners with key metrics including: - Enrollment counts - Completion counts - Time spent on platform  Query Parameters:     page (int): Page number for pagination     length (int): Number of items per page     search (str): Filter learners by username, email, or name  Returns:     A paginated list of learners with their associated metrics.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param search: Search string for learner
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._audience_orgs_registered_users_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PerlearnerUserList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _audience_orgs_registered_users_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/audience/orgs/{org}/registered-users/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def engagement_orgs_activity_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """engagement_orgs_activity_retrieve

        Get engagement metrics on a per-course basis.  This endpoint provides a paginated list of courses with engagement metrics including activity counts, time spent, and interaction data.  Query Parameters:     page (int, optional): Page number for pagination     length (int, optional): Number of items per page  Returns:     A paginated list of courses with their engagement metrics.

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._engagement_orgs_activity_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EngagementPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _engagement_orgs_activity_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if length is not None:
            
            _query_params.append(('length', length))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/engagement/orgs/{org}/activity',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def engagement_orgs_course_completion_over_time_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """engagement_orgs_course_completion_over_time_retrieve

        Completion count per user per course across the platform  Query Params 1. start_date e.g 2020-10-01 2. end_date e.g 2020-10-10  Default result when no query param is added is last_7_days (today inclusive)

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._engagement_orgs_course_completion_over_time_retrieve_serialize(
            org=org,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _engagement_orgs_course_completion_over_time_retrieve_serialize(
        self,
        org,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/engagement/orgs/{org}/course_completion/over-time',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def engagement_orgs_course_completion_per_course_retrieve(
        self,
        org: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        length: Annotated[Optional[StrictInt], Field(description="Size of data to return")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page offset")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """engagement_orgs_course_completion_per_course_retrieve

        List course completion metrics on a per-course basis.  This endpoint provides a paginated table of courses with enrollment and completion statistics for each course.  Returns:     A paginated list of courses with:     - Course identification (ID and name)     - Enrollment count     - Completion count     - Average completion rate

        :param org: (required)
        :type org: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param length: Size of data to return
        :type length: int
        :param page: Page offset
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._engagement_orgs_course_completion_per_course_retrieve_serialize(
            org=org,
            department_id=department_id,
            format=format,
            include_main_platform=include_main_platform,
            length=length,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCompletionPerCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _engagement_orgs_course_completion_per_course_retrieve_serialize(
        self,
        org,
        department_id,
        format,
        include_main_platform,
        length,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if format is not None:
            
           